/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.KommaZahlMaske;
import de.statspez.pleditor.generator.masken.MaskeException;
import de.statspez.pleditor.generator.masken.MaskenParserFaktory;
import de.statspez.pleditor.generator.masken.MaskenParserInterface;
import de.statspez.pleditor.generator.masken.ZahlMaske;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ObjectContextParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PropertiesParser;
import de.statspez.pleditor.generator.parser.ReplacementUtil;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.speclanguage.SpecLangParseException;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MerkmalParser
extends SubParser
implements SuperParser {
    private MetaCustomMerkmal currentMerkmal = null;
    private String valueSpaceClassName = null;
    private String missingValuesClassName = null;
    private ParserChain parserChain = new ParserChain();
    private PropertiesParser propertiesParser = null;
    private ObjectContextParser objectContextParser = null;

    public MerkmalParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.propertiesParser = new PropertiesParser(this, resolver);
        this.parserChain.addParser(this.propertiesParser);
        this.objectContextParser = new ObjectContextParser(this, resolver);
        this.parserChain.addParser(this.objectContextParser);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "statisticVariable".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("statisticVariable".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentMerkmal = new MetaCustomMerkmal();
            this.propertiesParser.setCurrentElement(this.currentMerkmal);
            this.objectContextParser.setCurrentElement(this.currentMerkmal);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("statisticVariable".equalsIgnoreCase(localName)) {
            this.createMerkmalCheckProgram();
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentMerkmal;
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("statisticVariable".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer das Merkmal ist kein Name definiert!");
            }
            this.currentMerkmal.setName(name.trim());
            String str = atts.getValue("id");
            if (MerkmalParser.isNotEmpty(str) && this.resolver().isUseIDasRef()) {
                this.currentMerkmal.setId(str.trim());
            } else {
                this.currentMerkmal.setId(name);
            }
            String type = atts.getValue("type");
            if (type == null) {
                throw new ILParseException("Fuer das Merkmal " + name + " ist kein Typ definiert");
            }
            this.currentMerkmal.setTyp(Helper.typeByName(type.trim()));
            String length = atts.getValue("length");
            if (length == null) {
                throw new ILParseException("Fuer das Merkmal " + name + " ist keine Laenge angegeben!");
            }
            this.currentMerkmal.setLaenge(Long.parseLong(length));
            String mask = atts.getValue("mask");
            MerkmalParser.setValuesFromMaske(this.currentMerkmal, mask);
            String empty = atts.getValue("empty_allowed");
            if (empty != null) {
                this.currentMerkmal.setLeer(Helper.toBoolean(empty.trim()));
            } else {
                this.currentMerkmal.setLeer(true);
            }
            String resist = atts.getValue("resist_allowed");
            if (resist != null) {
                this.currentMerkmal.setVerweigerung(Helper.toBoolean(resist.trim()));
            } else {
                this.currentMerkmal.setVerweigerung(false);
            }
            String unknown = atts.getValue("uncnown_allowed");
            if (unknown != null) {
                this.currentMerkmal.setNichtWissen(Helper.toBoolean(unknown.trim()));
            } else {
                this.currentMerkmal.setNichtWissen(false);
            }
            this.valueSpaceClassName = atts.getValue("classifikation-class");
            String classifClass_id = atts.getValue("classifikation-class-id");
            if (MerkmalParser.isNotEmpty(classifClass_id) && this.resolver().isUseIDasRef()) {
                this.resolver().registerForResolve(this.currentMerkmal, classifClass_id, this.valueSpaceClassName, MetaAuspraegungsgruppe.class, Resolver.USAGE_APG, true);
            } else if (MerkmalParser.isNotEmpty(this.valueSpaceClassName)) {
                this.resolver().registerForResolve(this.currentMerkmal, this.valueSpaceClassName, this.valueSpaceClassName, MetaAuspraegungsgruppe.class, Resolver.USAGE_APG, true);
            }
            this.missingValuesClassName = atts.getValue("missing-values-class");
            String misClass_id = atts.getValue("missing-values-class-id");
            if (MerkmalParser.isNotEmpty(misClass_id) && this.resolver().isUseIDasRef()) {
                this.resolver().registerForResolve(this.currentMerkmal, misClass_id, this.missingValuesClassName, MetaAuspraegungsgruppe.class, Resolver.USAGE_MISSING_VALUES, true);
            } else if (MerkmalParser.isNotEmpty(this.missingValuesClassName)) {
                this.resolver().registerForResolve(this.currentMerkmal, this.missingValuesClassName, this.missingValuesClassName, MetaAuspraegungsgruppe.class, Resolver.USAGE_MISSING_VALUES, true);
            }
            String state = atts.getValue("state");
            if (state != null && state.trim().equals("approved")) {
                this.currentMerkmal.setFreigabeStatus((short)1);
            }
        }
    }

    public static void setValuesFromMaske(MetaCustomMerkmal metaMerkmal, String mask) {
        if (MerkmalParser.isNotEmpty(mask)) {
            int typ = -1;
            switch (metaMerkmal.getTyp()) {
                case 1: {
                    typ = 4;
                    break;
                }
                case 5: {
                    typ = 1;
                    break;
                }
                case 3: {
                    typ = 2;
                    break;
                }
                case 4: {
                    typ = 3;
                    break;
                }
                case 2: {
                    typ = 6;
                    break;
                }
                default: {
                    typ = -1;
                }
            }
            if (typ != -1) {
                try {
                    MaskenParserFaktory faktory = MaskenParserFaktory.getInstance();
                    MaskenParserInterface parser = faktory.getMaskenParserFuerTyp(typ);
                    try {
                        AbstractMaske maske = parser.parse(mask);
                        metaMerkmal.setMaske(mask);
                        if (maske instanceof ZahlMaske) {
                            metaMerkmal.setFuehrendeNullen(((ZahlMaske)maske).hatFuehrendeNullen());
                            metaMerkmal.setVorzeichen(((ZahlMaske)maske).hatVorzeichen());
                            if (maske instanceof KommaZahlMaske) {
                                metaMerkmal.setVorkommastellen((short)((KommaZahlMaske)maske).getVorkommastellen());
                                metaMerkmal.setNachkommastellen((short)((KommaZahlMaske)maske).getNachkommastellen());
                            }
                        }
                    }
                    catch (MaskeException e) {
                        throw new ILParseException("Maske '" + mask + "' konnte nicht interpretiert werden! " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws ILParseException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("displayName".equalsIgnoreCase(localName)) {
            this.currentMerkmal.setBezeichnung(chars);
            if (this.superParser().getParserKontext().getVersion() < 3.6) {
                this.currentMerkmal.setTooltip(chars);
            }
        } else if ("values".equalsIgnoreCase(localName)) {
            if (MerkmalParser.isEmpty(this.valueSpaceClassName)) {
                ReplacementUtil util = ReplacementUtil.getInstance();
                if (util.sollErsetztWerden(this.superParser().getParserKontext().getVersion())) {
                    chars = util.replace(chars);
                }
                this.currentMerkmal.setWertebereich(chars);
            }
        } else if ("question".equalsIgnoreCase(localName)) {
            this.currentMerkmal.setFrage(chars);
        } else if ("tooltip".equalsIgnoreCase(localName)) {
            this.currentMerkmal.setTooltip(chars);
        } else if ("errorShort".equalsIgnoreCase(localName)) {
            this.currentMerkmal.setFehlertextKurz(chars);
            MetaProgram program = Helper.getFehlerTextAlsMetaProgram(chars, this.getMessageContext("(Fehlertext kurz)"));
            if (program != null) {
                program.setCanHaveSelfAccess(true);
                program.setCanHaveIndexOperator(false);
                this.currentMerkmal.setFehlerTextKurzProgram(program);
            }
        } else if ("errorLong".equalsIgnoreCase(localName)) {
            this.currentMerkmal.setFehlertextLang(chars);
            MetaProgram program = Helper.getFehlerTextAlsMetaProgram(chars, this.getMessageContext("(Fehlertext lang)"));
            if (program != null) {
                program.setCanHaveSelfAccess(true);
                program.setCanHaveIndexOperator(false);
                this.currentMerkmal.setFehlerTextLangProgram(program);
            }
        } else if ("correctionDescription".equalsIgnoreCase(localName)) {
            this.currentMerkmal.setKorrekturhinweis(chars);
            MetaProgram program = Helper.getFehlerTextAlsMetaProgram(chars, this.getMessageContext("(Korrekturhinweis)"));
            if (program != null) {
                program.setCanHaveSelfAccess(true);
                program.setCanHaveIndexOperator(false);
                this.currentMerkmal.setKorrekturhinweisProgram(program);
            }
        } else if ("explanation".equalsIgnoreCase(localName)) {
            chars = this.superParser().charData().toString();
            this.currentMerkmal.setBeschreibung(chars);
        } else {
            handled = false;
        }
        return handled;
    }

    private void createMerkmalCheckProgram() throws ILParseException {
        MetaProgram prg;
        StringBuffer code = new StringBuffer();
        if (!this.currentMerkmal.getLeer()) {
            code.append("WENN feld = LEER DANN FEHLER ");
            code.append(1);
            code.append(" ENDE");
        } else {
            code.append("WENN feld /= LEER DANN");
        }
        if (MerkmalParser.isNotEmpty(this.missingValuesClassName)) {
            code.append("\nWENN NICHT feld IN ");
            code.append("#");
            code.append(this.missingValuesClassName);
            code.append(" DANN");
        }
        if (this.currentMerkmal.getLaenge() > 0L) {
            code.append("\nWENN &WERTLAENGE(feld) > ");
            code.append(this.currentMerkmal.getLaenge());
            code.append(" DANN FEHLER ");
            code.append(3);
            code.append(" ENDE");
        }
        code.append("\nWENN NICHT feld HAT TYP ");
        code.append(this.getConstantForType(this.currentMerkmal.getTyp()));
        if (MerkmalParser.isNotEmpty(this.currentMerkmal.getMaske())) {
            code.append("('");
            code.append(this.currentMerkmal.getMaske().replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'"));
            code.append("')");
        }
        code.append(" DANN FEHLER ");
        code.append(2);
        code.append(" ENDE");
        if (MerkmalParser.isNotEmpty(this.valueSpaceClassName)) {
            code.append("\nWENN NICHT feld IN ");
            code.append("#");
            code.append(this.valueSpaceClassName);
            code.append(" DANN FEHLER ");
            code.append(4);
            code.append(" ENDE");
        } else if (MerkmalParser.isNotEmpty(this.currentMerkmal.getWertebereich())) {
            code.append("\nWENN NICHT feld IN {");
            code.append(this.currentMerkmal.getWertebereich());
            code.append("} DANN FEHLER ");
            code.append(4);
            code.append(" ENDE");
        }
        if (MerkmalParser.isNotEmpty(this.missingValuesClassName)) {
            code.append("\nENDE");
        }
        if (this.currentMerkmal.getLeer()) {
            code.append("\nENDE");
        }
        try {
            prg = Helper.metaStructureFor(this.getMessageContext(null), code.toString());
        }
        catch (SpecLangParseException e) {
            Iterator mit = e.messageIterator();
            while (mit.hasNext()) {
                AbstractMessage aMsg = (AbstractMessage)mit.next();
                this.error(aMsg);
            }
            prg = new MetaProgram("", new MetaStatementSequence());
        }
        prg.setName("Merkmal_" + this.currentMerkmal.getName());
        prg.setContextInfos(this.getMessageContext(null));
        MetaProgramParameter feldParam = new MetaProgramParameter(new MetaIdentifier("feld"), true);
        prg.addParameter(feldParam);
        this.currentMerkmal.setPLSpezifikation(code.toString());
        this.currentMerkmal.setMetaSpezifikation(prg);
    }

    private String getConstantForType(int type) throws ILParseException {
        String constant = null;
        switch (type) {
            case 1: {
                constant = "KOMMAZAHL";
                break;
            }
            case 2: {
                constant = "ZEICHENKETTE";
                break;
            }
            case 3: {
                constant = "DATUM";
                break;
            }
            case 4: {
                constant = "DATUM";
                break;
            }
            case 5: {
                constant = "GANZZAHL";
                break;
            }
            case 6: {
                constant = "KATEGORIE";
                break;
            }
            case 7: {
                constant = "WAHRHEITSWERT";
                break;
            }
            default: {
                throw new ILParseException("Der Typ " + type + " hat keine Entsprechung in der Zwischensprache");
            }
        }
        return constant;
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        return "http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && ("values".equalsIgnoreCase(tag) || "question".equalsIgnoreCase(tag) || "tooltip".equalsIgnoreCase(tag) || "displayName".equalsIgnoreCase(tag) || "explanation".equalsIgnoreCase(tag) || "errorShort".equalsIgnoreCase(tag) || "errorLong".equalsIgnoreCase(tag) || "correctionDescription".equalsIgnoreCase(tag));
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }

    protected MessageContextInterface getMessageContext(String hint) {
        return new ElementMessageContext(5, this.currentMerkmal.getId(), this.currentMerkmal.getName(), hint);
    }

    private static boolean isEmpty(String string) {
        return !MerkmalParser.isNotEmpty(string);
    }

    private static boolean isNotEmpty(String string) {
        return string != null && string.trim().length() > 0;
    }
}

