/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.SurveyParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ContextParser
extends SubParser
implements SuperParser {
    private MetaElement currentElement = null;
    private ParserChain parserChain = new ParserChain();
    private SurveyParser surveyParser = null;

    public ContextParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.surveyParser = new SurveyParser(this, resolver);
        this.parserChain.addParser(this.surveyParser);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "context".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("context".equalsIgnoreCase(localName)) {
            this.enable();
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("context".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentElement;
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String str;
        if (!"context".equalsIgnoreCase(localName) || (str = atts.getValue("id")) != null) {
            // empty if block
        }
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void setCurrentElement(MetaCustomPlausibilisierung objekt) {
        this.currentElement = objekt;
        this.surveyParser.setCurrentElement(this.currentElement);
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

