/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.AddressParser;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PersonParser;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ContactParser
extends SubParser
implements SuperParser {
    private MetaStatspezObjekt currentElement = null;
    private ParserChain parserChain = new ParserChain();
    private PersonParser personParser = null;
    private AddressParser adressParser = null;

    public ContactParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.personParser = new PersonParser(this, resolver);
        this.parserChain.addParser(this.personParser);
        this.adressParser = new AddressParser(this, resolver);
        this.parserChain.addParser(this.adressParser);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "contact".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("contact".equalsIgnoreCase(localName)) {
            this.enable();
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("contact".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentElement;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String str;
        if (!"contact".equalsIgnoreCase(localName) || (str = atts.getValue("id")) != null) {
            // empty if block
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if (!("contactPerson".equalsIgnoreCase(localName) || "organization".equalsIgnoreCase(localName) || "eMail".equalsIgnoreCase(localName) || "phone".equalsIgnoreCase(localName) || "url".equalsIgnoreCase(localName) || "fax".equalsIgnoreCase(localName))) {
            handled = false;
        }
        return handled;
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void setCurrentElement(MetaStatspezObjekt objekt) {
        this.currentElement = objekt;
        this.personParser.setCurrentElement(this.currentElement);
        this.adressParser.setCurrentElement(this.currentElement);
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private boolean canHandleTag(String namespaceURI, String localName) {
        return "http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && ("contactPerson".equalsIgnoreCase(localName) || "organization".equalsIgnoreCase(localName) || "eMail".equalsIgnoreCase(localName) || "phone".equalsIgnoreCase(localName) || "url".equalsIgnoreCase(localName) || "fax".equalsIgnoreCase(localName));
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

