/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.meta;

import de.statspez.pleditor.generator.meta.MetaCanBeFactor;
import de.statspez.pleditor.generator.meta.MetaElementVisitor;
import de.statspez.pleditor.generator.meta.MetaValue;

public class MetaNumber
extends MetaValue
implements MetaCanBeFactor {
    private Double myValue = null;
    private String myStringValue = null;

    public MetaNumber(String aValue) throws NumberFormatException {
        this.myValue = new Double(aValue);
        if (this.myValue.isNaN()) {
            throw new NumberFormatException(aValue + " ist keine Zahl.");
        }
        if (this.myValue.isInfinite()) {
            throw new NumberFormatException("Die Zahl ist zu lang: " + aValue);
        }
        if (this.myValue > 9.223372036854776E18 || this.myValue < -9.223372036854776E18) {
            throw new NumberFormatException("Die Zahl ist zu lang: " + aValue);
        }
        this.myStringValue = aValue;
    }

    public Double value() {
        return this.myValue;
    }

    @Override
    public void accept(MetaElementVisitor aVisitor) {
        aVisitor.visitNumber(this);
    }

    @Override
    public void delegateAcceptOnFactor(MetaElementVisitor aVisitor) {
        this.accept(aVisitor);
    }

    @Override
    public String toString() {
        return "number '" + this.value().toString() + "'";
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof MetaNumber)) {
            return false;
        }
        return this.value().equals(((MetaNumber)anObject).value());
    }

    public int hashCode() {
        return this.value().hashCode() * 10;
    }

    public String getMyStringValue() {
        return this.myStringValue;
    }
}

