/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.masken;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.AbstractMaskenParser;
import de.statspez.pleditor.generator.masken.MaskeException;
import de.statspez.pleditor.generator.masken.MaskenParserInterface;
import de.statspez.pleditor.generator.masken.ZeichenketteAusdruckList;
import de.statspez.pleditor.generator.masken.ZeichenketteMaske;
import java.util.regex.Pattern;

public class ZeichenketteMaskenParser
extends AbstractMaskenParser
implements MaskenParserInterface {
    @Override
    public AbstractMaske parse(String maske) throws MaskeException {
        ZeichenketteMaske zMaske = new ZeichenketteMaske();
        zMaske.setzeMaskeAlsString(maske);
        if (maske == null || maske.length() == 0) {
            throw new MaskeException("Maske soll angegeben werden");
        }
        StringBuffer message = new StringBuffer();
        if (this.isSegmentGueltig(maske, message)) {
            maske = this.parseAusrichtung(zMaske, maske);
            if ((maske = this.leseFuellzeichenAus(zMaske, maske)).length() == 0) {
                throw new MaskeException("Maske fuer Zeichenkette ist unvollst\u00e4ndig.");
            }
        } else {
            throw new MaskeException("Maske fuer Zeichenkette ist falsch beschrieben. " + message.toString());
        }
        String str = this.erzeugePatternString(zMaske, maske);
        Pattern p = Pattern.compile(str);
        zMaske.setzePattern(p);
        return zMaske;
    }

    @Override
    public boolean isSegmentGueltig(String segment) {
        return this.isSegmentGueltig(segment, null);
    }

    private boolean isSegmentGueltig(String segment, StringBuffer message) {
        boolean ausrichtungAngegeben = false;
        boolean hatFuellzeichen = false;
        boolean hatTrennzeichen = false;
        boolean maskiert = false;
        boolean isAusrichtungL = segment.length() > 0 && segment.charAt(0) != 'R' && segment.charAt(0) != 'M';
        boolean ok = true;
        block5: for (int i = 0; ok && i < segment.length(); ++i) {
            char ch = segment.charAt(i);
            if (!isAusrichtungL && hatFuellzeichen) {
                boolean bl = ok = ch == 'c';
                if (!ok && message != null) {
                    message.append("Ein F\u00fcllzeichen mit 'R'-oder 'M'-Ausrichtungsangabe wurde gefunden. Dann d\u00fcrfen nur 99-Symbole verwendet werden.");
                }
            } else if (hatFuellzeichen) {
                boolean bl = ok = ch == 'Z' || ch == 'z' || ch == 'c';
                if (!ok && message != null) {
                    message.append("Ein F\u00fcllzeichen wurde gefunden. Dann d\u00fcrfen nur Z-, z- und c-Symbole verwendet werden.");
                }
            }
            if (this.istSymbol(ch)) {
                switch (ch) {
                    case 'L': 
                    case 'M': 
                    case 'R': {
                        if (i == 0) {
                            ausrichtungAngegeben = true;
                            break;
                        }
                        ok = maskiert;
                        if (!ok && message != null) {
                            message.append("Angabe der Ausrichtung ist falsch.");
                        }
                        maskiert = false;
                        break;
                    }
                    case '.': {
                        if (!maskiert) {
                            if (hatTrennzeichen) {
                                ok = false;
                                if (message == null) continue block5;
                                message.append("Maskendefinition kann nur ein Trennzeichen enthalten.");
                                break;
                            }
                            hatTrennzeichen = true;
                            break;
                        }
                        maskiert = !maskiert;
                        break;
                    }
                    case '\\': {
                        if (i == 0 || i == 1 && ausrichtungAngegeben) {
                            hatFuellzeichen = false;
                            if (i + 1 >= segment.length() || !this.istSymbol(segment.charAt(i + 1))) continue block5;
                            maskiert = !maskiert;
                            break;
                        }
                        maskiert = !maskiert;
                        break;
                    }
                    default: {
                        if (!maskiert) continue block5;
                        maskiert = !maskiert;
                        break;
                    }
                }
                continue;
            }
            if (i == 0 || i == 1 && ausrichtungAngegeben) {
                hatFuellzeichen = true;
            } else if (maskiert) {
                if ('@' == ch) {
                    maskiert = false;
                } else {
                    ok = false;
                    if (message != null) {
                        message.append("Ung\u00fcltiges Zeichen '\\" + ch + "'.");
                    }
                }
            }
            if (ch != ' ') continue;
            ok = false;
            if (message == null) continue;
            message.append("Es darf kein Leerzeichen in der Maskendefinition verwendet werden.");
        }
        return ok;
    }

    private String leseFuellzeichenAus(ZeichenketteMaske zeichenketteMaske, String maske) {
        if (maske != null && maske.length() > 0) {
            char ch0 = maske.charAt(0);
            if (this.istSymbol(ch0)) {
                char ch1;
                if (ch0 == '\\' && !this.istSymbol(ch1 = maske.charAt(1))) {
                    maske = maske.substring(1);
                }
            } else {
                zeichenketteMaske.setzeFuellzeichen(ch0);
                maske = maske.substring(1);
            }
        }
        return maske;
    }

    private String erzeugePatternString(ZeichenketteMaske zeichenketteMaske, String maske) throws MaskeException {
        int min = 0;
        int max = 0;
        boolean negation = false;
        ZeichenketteAusdruckList list = new ZeichenketteAusdruckList();
        for (int i = 0; i < maske.length(); ++i) {
            char ch = maske.charAt(i);
            if (this.istSymbol(ch) || ch == '@') {
                if (negation) {
                    list.fuegeAusdruckHinzu(this.maskierePatternSymbol(ch));
                    negation = !negation;
                    ++max;
                    continue;
                }
                if (ch == '.') {
                    min = max;
                    continue;
                }
                if (ch == '\\') {
                    negation = !negation;
                    continue;
                }
                list.fuegeAusdruckHinzu(this.gibAusdruckFuerSymbol(ch));
                ++max;
                continue;
            }
            list.fuegeAusdruckHinzu(this.maskierePatternSymbol(ch));
            ++max;
        }
        if (zeichenketteMaske.istFuellZeichenGesetzt()) {
            min = max;
        }
        zeichenketteMaske.setzeMaxLaenge(max);
        zeichenketteMaske.setzeMinLaenge(min);
        return list.gibPattern(min, max);
    }

    @Override
    protected void initSymbole() {
        this.symbole = new char[]{'L', 'M', 'R', 'z', 'Z', 'c', '\\', '.'};
    }
}

