/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.masken;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.GanzZahlMaskenParser;
import de.statspez.pleditor.generator.masken.KommaZahlMaske;
import de.statspez.pleditor.generator.masken.KommazahlAusdruckList;
import de.statspez.pleditor.generator.masken.MaskeException;
import java.util.regex.Pattern;

public class KommaZahlMaskenParser
extends GanzZahlMaskenParser {
    @Override
    public AbstractMaske parse(String maske) throws MaskeException {
        KommaZahlMaske zahlMaske = new KommaZahlMaske();
        zahlMaske.setzeMaskeAlsString(maske);
        if (maske == null || maske.length() == 0) {
            throw new MaskeException("Maske soll angegeben werden");
        }
        StringBuffer message = new StringBuffer();
        if (!this.isSegmentGueltig(maske, message) || !this.maskeVollstaendig(maske)) {
            throw new MaskeException("Maske fuer Kommazahl ist falsch beschrieben. " + message.toString());
        }
        maske = this.parseVorzeichen(zahlMaske, maske);
        maske = this.parseAusrichtung(zahlMaske, maske);
        String str = this.erzeugePatternString(zahlMaske, maske);
        Pattern p = Pattern.compile(str);
        zahlMaske.setzePattern(p);
        return zahlMaske;
    }

    @Override
    protected void initSymbole() {
        this.symbole = new char[]{'L', 'M', 'R', '-', '+', '0', '\\', '#', '.'};
    }

    @Override
    protected boolean pruefeZahlDefinition(String segment, StringBuffer message) {
        boolean hatMinMaxTrennzeichen = false;
        boolean maskiert = false;
        boolean hatDezimaltrennzeichen = false;
        boolean mit0abgeschlossen = false;
        boolean maskeVollstaendig = false;
        boolean ok = true;
        block6: for (int i = 0; ok && i < segment.length(); ++i) {
            if (hatDezimaltrennzeichen && mit0abgeschlossen) {
                ok = false;
                if (message == null) break;
                message.append("Das 0-Symbol darf nur am Ende der Definition des Nachkommabereichs vorkommen.");
                break;
            }
            char ch = segment.charAt(i);
            switch (ch) {
                case '0': {
                    if (!maskiert) {
                        if (!hatDezimaltrennzeichen) {
                            if (hatMinMaxTrennzeichen) {
                                ok = false;
                                if (message == null) continue block6;
                                message.append("Zweites 0-Symbol im Vorkommabereich.");
                                continue block6;
                            }
                            hatMinMaxTrennzeichen = true;
                            maskeVollstaendig = false;
                            continue block6;
                        }
                        ok = maskeVollstaendig;
                        if (!ok && message != null) {
                            if (maskeVollstaendig) continue block6;
                            message.append("Nach dem Dezimalpunkt kann nur eine Ziffer definiert werden.");
                            continue block6;
                        }
                        mit0abgeschlossen = true;
                        continue block6;
                    }
                    maskiert = false;
                    maskeVollstaendig = true;
                    continue block6;
                }
                case '\\': {
                    if (maskiert) {
                        ok = false;
                        continue block6;
                    }
                    maskiert = true;
                    continue block6;
                }
                case '#': {
                    if (maskiert) {
                        ok = false;
                        if (message == null) continue block6;
                        message.append("Ung\u00fcltiges Zeichen'\\" + ch + "'.");
                        continue block6;
                    }
                    maskeVollstaendig = true;
                    continue block6;
                }
                case '.': {
                    if (hatDezimaltrennzeichen) {
                        ok = false;
                        if (message == null) continue block6;
                        message.append("Maskendefinition darf nur einen Dezimalpunkt enthalten.");
                        continue block6;
                    }
                    hatDezimaltrennzeichen = true;
                    if (!maskeVollstaendig) {
                        ok = false;
                        if (message == null) continue block6;
                        message.append("Vor und nach dem Dezimalpunkt muss eine Ziffer definiert werden.");
                        continue block6;
                    }
                    maskeVollstaendig = false;
                    continue block6;
                }
                default: {
                    ok = Character.isDigit(ch);
                    if (!ok && message != null) {
                        message.append("Ung\u00fcltiges Zeichen '" + ch + "'.");
                        continue block6;
                    }
                    maskeVollstaendig = true;
                }
            }
        }
        return ok;
    }

    protected String erzeugePatternString(KommaZahlMaske zahlMaske, String maske) throws MaskeException {
        int minLaenge;
        ParserZustand zustand;
        StringBuffer buf;
        block16: {
            block15: {
                buf = new StringBuffer();
                zustand = new ParserZustand();
                for (int i = 0; i < maske.length(); ++i) {
                    char ch = maske.charAt(i);
                    if (zustand.negation) {
                        if (ch == '0') {
                            zustand.addZeichen(new String(new char[]{ch}));
                            zustand.negation = false;
                            continue;
                        }
                        throw new MaskeException("Ung\u00fcltiges Zeichen '\\" + ch + "'.");
                    }
                    if ('0' == ch) {
                        zustand.schalter0();
                        continue;
                    }
                    if ('.' == ch) {
                        zustand.punkt();
                        continue;
                    }
                    if ('\\' == ch) {
                        if (zustand.negation) {
                            throw new MaskeException("Ung\u00fcltiges Zeichen '\\" + ch + "'.");
                        }
                        zustand.negation = true;
                        continue;
                    }
                    if ('#' == ch || Character.isDigit(ch)) {
                        String regularExpression = '#' == ch ? this.gibAusdruckFuerSymbol(ch) : new String(new char[]{ch});
                        zustand.addZeichen(regularExpression);
                        continue;
                    }
                    throw new MaskeException("Ung\u00fcltiges Zeichen '" + ch + "'.");
                }
                zahlMaske.setVorkommastellenMax(zustand.vor_max);
                zahlMaske.setVorkommastellenMin(zustand.vor_min);
                zahlMaske.setNachkommastellen(zustand.nach_max);
                int maxLaenge = zustand.vor_max + zustand.nach_max;
                if (zahlMaske.hatVorzeichen()) {
                    ++maxLaenge;
                }
                if (zustand.nach_max > 0) {
                    ++maxLaenge;
                }
                zahlMaske.setzeMaxLaenge(maxLaenge);
                minLaenge = 0;
                this.getClass();
                if (this.vorzeichenTyp == 1) break block15;
                this.getClass();
                if (this.vorzeichenTyp == 3) break block15;
                this.getClass();
                if (this.vorzeichenTyp != 4) break block16;
            }
            ++minLaenge;
        }
        minLaenge += zustand.vor_min;
        if (zustand.nach_min > 0) {
            ++minLaenge;
        }
        zahlMaske.setzeMinLaenge(minLaenge += zustand.nach_min);
        if (zustand.vorkommaMinAn) {
            zahlMaske.setzeFuellzeichen('0');
        }
        zahlMaske.setNachkommaFest(zustand.nach_min == zustand.nach_max);
        buf.append(zustand.list.gibPattern(zustand.vor_min, zustand.vor_max, zustand.nach_min, zustand.nach_max));
        return buf.toString();
    }

    @Override
    protected boolean maskeVollstaendig(String maske) {
        boolean erg = false;
        if (maske != null && maske.length() > 0) {
            char lastChar = maske.charAt(maske.length() - 1);
            if (lastChar == '#') {
                erg = true;
            } else if (Character.isDigit(lastChar)) {
                boolean hatDezimalpunkt;
                boolean bl = hatDezimalpunkt = maske.indexOf(new String(new char[]{'.'})) != -1;
                erg = lastChar == '0' && !hatDezimalpunkt ? maske.charAt(maske.length() - 2) == '\\' : true;
            } else {
                erg = false;
            }
        }
        return erg;
    }

    class ParserZustand {
        KommazahlAusdruckList list;
        boolean negation = false;
        boolean vorkommaMinAn = false;
        boolean vorkommaBereich = true;
        boolean kommaAnhaengen = true;
        int vor_min;
        int vor_max;
        int nach_min;
        int nach_max;

        private ParserZustand() {
            this.list = new KommazahlAusdruckList(KommaZahlMaskenParser.this.erzeugeVorzeichenRegularExpression());
            this.negation = false;
            this.vorkommaMinAn = false;
            this.vorkommaBereich = true;
            this.kommaAnhaengen = true;
            this.vor_min = 0;
            this.vor_max = 0;
            this.nach_min = 0;
            this.nach_max = 0;
        }

        private void addZeichen(String regularExpression) {
            if (this.negation) {
                this.negation = false;
            }
            if (!this.vorkommaBereich && this.kommaAnhaengen) {
                String kommaRegAusdruk = KommaZahlMaskenParser.this.maskierePatternSymbol('.');
                regularExpression = "(" + kommaRegAusdruk + regularExpression + ")";
                this.kommaAnhaengen = false;
            }
            this.list.fuegeAusdruckHinzu(regularExpression, this.vorkommaBereich);
            if (this.vorkommaBereich) {
                ++this.vor_max;
                if (this.vorkommaMinAn) {
                    ++this.vor_min;
                }
            } else {
                ++this.nach_max;
            }
        }

        private void schalter0() {
            if (this.vorkommaBereich) {
                this.vorkommaMinAn = true;
            } else {
                this.nach_min = this.nach_max;
            }
        }

        private void punkt() {
            this.vorkommaBereich = false;
            if (this.vor_min == 0) {
                this.vor_min = 1;
            }
        }
    }
}

