/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.js.JavaScriptCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;

public class MehrfachantwortProgramCodeGenerator
extends JavaScriptCodeGenerator {
    public void generate(MetaMerkmal merkmal) {
        String merkmalProgramName = "Merkmal_" + StringHelper.getEscapedName(merkmal.getName());
        String programName = "MA_" + merkmalProgramName;
        MetaAuspraegungsgruppe values = merkmal.getKlasseWertebereich();
        int count = CodegenUtil.getAuspraegungenCount(values);
        MetaAuspraegungsgruppe missingValues = merkmal.getKlasseFehlwerte();
        this.indentNewLine();
        this.print("function ");
        this.print("prg_");
        this.print(programName);
        this.print("(array)");
        this.openBlock();
        this.indentNewLine();
        this.print("var ");
        this.print("e");
        this.print(" = new Array();");
        if (!merkmal.getLeer()) {
            this.indentNewLine();
            this.print("var empty = true;");
        }
        if (missingValues != null) {
            this.indentNewLine();
            this.print("var missingValue = false;");
        }
        this.indentNewLine();
        this.print("for (var i = 0; i < ");
        this.print(count);
        this.print("; i++)");
        this.openBlock();
        this.indentNewLine();
        this.print("var field = array + \"[\" + i + \"]\";");
        this.indentNewLine();
        this.print("var value = getValue");
        switch (merkmal.getTyp()) {
            case 5: {
                this.print("Integer");
                break;
            }
            case 1: {
                this.print("Real");
                break;
            }
            case 3: {
                this.print("Date");
                if (merkmal.getMaske() == null || merkmal.getMaske().length() <= 0) break;
                this.print("Mask");
                break;
            }
            default: {
                this.print("String");
            }
        }
        this.print("(field);");
        this.indentNewLine();
        this.print("if (ne(value, null))");
        this.openBlock();
        if (!merkmal.getLeer()) {
            this.indentNewLine();
            this.print("empty = false;");
        }
        this.indentNewLine();
        this.print("e");
        this.print(".concat(");
        this.print("prg_");
        this.print(merkmalProgramName);
        this.print("(field));");
        this.indentNewLine();
        this.print("if (");
        this.print("e");
        this.print(".length > 0)");
        this.openBlock();
        this.indentNewLine();
        this.print("return ");
        this.print("e");
        this.print(";");
        this.closeBlock();
        this.indentNewLine();
        this.print("else");
        this.openBlock();
        this.indentNewLine();
        if (missingValues != null) {
            this.print("if (i == 0)");
            this.openBlock();
            this.indentNewLine();
            this.print("if (containsClassification(value, ");
            this.print("cls_");
            this.print(StringHelper.getEscapedStringValue(missingValues.getName()));
            this.print("))");
            this.openBlock();
            this.indentNewLine();
            this.print("missingValue = true;");
            this.closeBlock();
            this.closeBlock();
            this.indentNewLine();
            this.print("else");
        } else {
            this.print("if (i > 0)");
        }
        this.openBlock();
        if (missingValues != null) {
            this.indentNewLine();
            this.print("if (missingValue || containsClassification(value, ");
            this.print("cls_");
            this.print(StringHelper.getEscapedStringValue(missingValues.getName()));
            this.print("))");
            this.openBlock();
            this.error(merkmalProgramName, 6);
            this.closeBlock();
            this.indentNewLine();
            this.print("else");
            this.openBlock();
        }
        this.indentNewLine();
        this.print("for (var j = 0; j < i; j++)");
        this.openBlock();
        this.indentNewLine();
        this.print("var prevValue = getValue");
        switch (merkmal.getTyp()) {
            case 5: {
                this.print("Integer");
                break;
            }
            case 1: {
                this.print("Real");
                break;
            }
            case 3: {
                this.print("Date");
                if (merkmal.getMaske() == null || merkmal.getMaske().length() <= 0) break;
                this.print("Mask");
                break;
            }
            default: {
                this.print("String");
            }
        }
        this.print("(array + \"[\" + j + \"]\");");
        this.indentNewLine();
        this.print("if (ne(prevValue, null) && eq(value, prevValue))");
        this.openBlock();
        this.error(merkmalProgramName, 5);
        this.closeBlock();
        this.closeBlock();
        if (missingValues != null) {
            this.closeBlock();
        }
        this.closeBlock();
        this.closeBlock();
        this.closeBlock();
        this.closeBlock();
        if (!merkmal.getLeer()) {
            this.indentNewLine();
            this.print("if (empty)");
            this.openBlock();
            this.indentNewLine();
            this.print("var field = array + \"[0]\";");
            this.error(merkmalProgramName, 1);
            this.closeBlock();
        }
        this.indentNewLine();
        this.print("return ");
        this.print("e");
        this.print(";");
        this.closeBlock();
    }

    private void error(String programName, int errorType) {
        this.indentNewLine();
        this.print("referencedFields = [field];");
        this.indentNewLine();
        this.print("e");
        this.print("[0] = ");
        this.print("err_");
        this.print(programName);
        this.print("(field, ");
        this.print(errorType);
        this.print(");");
        this.indentNewLine();
        this.print("return ");
        this.print("e");
        this.print(";");
    }
}

