/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.js.CodegenContext;
import de.statspez.pleditor.generator.codegen.js.JavaScriptCodeGenerator;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLParameter;
import java.util.Iterator;

public class ExternalFunctionProgramCodeGenerator
extends JavaScriptCodeGenerator {
    public ExternalFunctionProgramCodeGenerator(CodegenContext context) {
        this.setCodegenContext(context);
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        if (!"extern".equals(funktion.getArt())) {
            throw new IllegalStateException("Externe Funktion erwartet.");
        }
        MetaCustomFunktion referenceFunction = (MetaCustomFunktion)funktion;
        this.indentNewLine();
        this.print("function ");
        this.print("prg_");
        this.printContextAsPrefix();
        this.print(StringHelper.getEscapedName(referenceFunction.getName()));
        this.print("(");
        this.print("ns");
        this.visitElements(referenceFunction.getParameter());
        this.print(")");
        this.openBlock();
        this.indentNewLine();
        this.print("return externalFunctions[\"");
        this.print(StringHelper.getEscapedStringValue(referenceFunction.getName()));
        this.print("\"](");
        Iterator parameter = referenceFunction.getParameter();
        while (parameter.hasNext()) {
            MetaPLParameter aParam = (MetaPLParameter)parameter.next();
            this.print(StringHelper.getEscapedName(aParam.getName()));
            if (!parameter.hasNext()) continue;
            this.print(", ");
        }
        this.print(");");
        this.closeBlock();
    }
}

