/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.js.CodegenContext;
import de.statspez.pleditor.generator.codegen.support.DefaultTextResource;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.TbScopeBuilder;
import de.statspez.pleditor.generator.codegen.support.TextResource;
import de.statspez.pleditor.generator.common.DefaultMessageContext;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;

public class DefaultCodegenContext
implements CodegenContext {
    private MetaPlausibilisierung plausi;
    private Writer writer;
    private TextResource textResource;
    private MessageContextInterface messageContext;
    private Scope plausiScope;
    private Hashtable topicScopes;
    private HashMap contextInfos;

    public DefaultCodegenContext(MetaPlausibilisierung plausi, Writer writer) {
        if (plausi == null) {
            throw new IllegalArgumentException("Keine Plausibilisierung angegeben.");
        }
        if (plausi.getPLName() == null || plausi.getPLName().length() == 0) {
            throw new IllegalArgumentException("Kein Name der Plausibilisierung angegeben.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("Kein Writer angegeben.");
        }
        this.plausi = plausi;
        this.writer = writer;
        this.textResource = new DefaultTextResource();
        this.messageContext = new DefaultMessageContext("Plausibilsierung " + plausi.getName());
        this.topicScopes = new Hashtable();
        TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
        this.plausiScope = scopeBuilder.createScopes(plausi, this.topicScopes);
        this.contextInfos = new HashMap();
    }

    public void setTextResource(TextResource textResource) {
        this.textResource = textResource;
    }

    public void setMessageContext(MessageContextInterface messageContext) {
        this.messageContext = messageContext;
    }

    @Override
    public MetaPlausibilisierung getPlausi() {
        return this.plausi;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public TextResource getTextResource() {
        return this.textResource;
    }

    @Override
    public MessageContextInterface getMessageContext() {
        return this.messageContext;
    }

    @Override
    public Scope getPlausiScope() {
        return this.plausiScope;
    }

    @Override
    public Hashtable getTopicScopes() {
        return this.topicScopes;
    }

    @Override
    public void putContextInfo(Object key, Object info) {
        this.contextInfos.put(key, info);
    }

    @Override
    public Object getContextInfo(Object key) {
        return this.contextInfos.get(key);
    }

    @Override
    public String getContextNameFor(MetaThemenbereich themenbereich) {
        String contextName = ((MetaCustomPlausibilisierung)this.plausi).rootThemenbereich() != themenbereich ? themenbereich.getName() : null;
        return contextName;
    }
}

