/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.analysis.CrossReferenceBuilder;
import de.statspez.pleditor.generator.codegen.analysis.ErhebungsTBReferenceBuilder;
import de.statspez.pleditor.generator.codegen.js.CodegenContext;
import de.statspez.pleditor.generator.codegen.js.DefaultCodegenContext;
import de.statspez.pleditor.generator.codegen.js.PlausiCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import de.statspez.pleditor.generator.parser.speclanguage.SpecLangParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.Writer;

public class CodegenFacade {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File src;
        if (args == null || args.length < 2) {
            System.err.println("Das Quellverzeichnis und/oder das Zielverzeichnis wurde nicht angegeben.");
            System.err.println("Usage: CppCodegenFacade <Quellverzeichnis|Datei> <Zielverzeichnis>");
            System.exit(-1);
        }
        File[] files = (src = new File(args[0])).isDirectory() ? src.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.startsWith("Plausi_") && name.endsWith(".xml");
            }
        }) : new File[]{src};
        for (File file : files) {
            System.out.println(file.getName());
            try (FileReader reader = new FileReader(file);){
                IntermediateLanguageParser parser = new IntermediateLanguageParser();
                MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)parser.parse(reader);
                String plausiName = file.getName().substring(0, file.getName().length() - 4);
                try (FileWriter writer = new FileWriter(new File(args[1], plausiName + ".js"));){
                    CodegenFacade codegen = new CodegenFacade();
                    codegen.generate(plausi, writer);
                }
            }
            catch (CodegenException e) {
                if (e.hasErrors()) {
                    System.err.println("FEHLER BEI DER GENERIERUNG:");
                    System.err.println(e.errorsAsText());
                }
                if (!e.hasWarnings()) continue;
                System.err.println("WARNUNGEN BEI DER GENERIERUNG:");
                System.err.println(e.warningsAsText());
            }
            catch (SpecLangParseException e) {
                System.err.println("FEHLER BEI DER GENERIERUNG:");
                System.err.println(e.messagesAsText());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void generate(MetaPlausibilisierung plausi, Writer writer) {
        this.generate(new DefaultCodegenContext(plausi, writer));
    }

    public void generate(CodegenContext context) {
        ErhebungsTBReferenceBuilder erhebungRefBuilder = new ErhebungsTBReferenceBuilder();
        erhebungRefBuilder.buildErhebungsTBReferences(context.getPlausi());
        CrossReferenceBuilder crefBuilder = new CrossReferenceBuilder();
        crefBuilder.buildCrossReference(context.getPlausi(), context.getPlausiScope(), context.getTopicScopes());
        PlausiCodeGenerator codeGen = new PlausiCodeGenerator();
        codeGen.generate(context);
    }

    public void generate(MetaPlausibilisierung plausi, MetaThemenbereich topic, MetaProgram program, Writer writer) {
        this.generate(new DefaultCodegenContext(plausi, writer), topic, program);
    }

    public void generate(CodegenContext context, MetaThemenbereich topic, MetaProgram program) {
        ProgramCodeGenerator codeGen = new ProgramCodeGenerator();
        codeGen.setOutput(context.getWriter());
        context.putContextInfo("contextKey", context.getContextNameFor(topic));
        Scope topicScope = (Scope)context.getTopicScopes().get(topic.getName());
        CrossReferenceBuilder crefBuilder = new CrossReferenceBuilder();
        crefBuilder.buildCrossReference(program, topicScope, context.getTopicScopes());
        codeGen.generate(context, program, topicScope);
        context.putContextInfo("contextKey", null);
    }
}

