/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java.mapping.util;

import de.statspez.pleditor.generator.codegen.java.JavaCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.mapping.MappingUtil;

public abstract class ConstructorGenerator
extends JavaCodeGenerator {
    public static final int MAX_STATEMENTS = 500;
    protected String prefix;
    protected boolean parent = true;
    private String structurePrefix = "";
    private int statementsGenerated = 0;
    private int segmentNum = 0;

    protected void printConstructor(String className, String visible) {
        this.defineMethod(visible, "", className, "FeldDeskriptorInterface parent, FeldDeskriptor feldDeskriptor, int[] indices");
        this.indentNewLine();
        this.out.print("super(parent,feldDeskriptor,indices);");
        this.indentNewLine();
        this.out.print("Hashtable mappings=new Hashtable();");
        this.indentNewLine();
        this.out.print("if(parent!=null)");
        this.indentNewLine();
        this.out.print("{");
        this.increaseIndentLevel();
        this.indentNewLine();
        this.out.print("mappings=feldDeskriptor.getMappings();");
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.println("}");
    }

    protected void printFieldInitialization(String fieldType, String fieldname, int typ) {
        this.startSegmentIfNecessary();
        String parentString = "this";
        if (!this.parent) {
            parentString = "null";
        }
        String variablename = StringHelper.getEscapedName(MappingUtil.encodeName(fieldname));
        String fieldTypeEscaped = StringHelper.getEscapedName(MappingUtil.encodeName(fieldType));
        this.indent();
        this.out.println("this." + variablename + " = new " + fieldTypeEscaped + "(" + parentString + ", new FeldDeskriptorExt(mappings, \"" + fieldname + "\", feldDeskriptor, " + typ + ", null, \"" + fieldname + "\"), null);");
    }

    protected void structurInitilization(String name, int type, int[] dimension) {
        this.startSegmentIfNecessary();
        this.indent();
        String encodedAndEscapedName = StringHelper.getEscapedName(MappingUtil.encodeName(name));
        String parentString = "this";
        if (!this.parent) {
            parentString = "null";
        }
        this.out.print("this." + encodedAndEscapedName + "=new TopicArray(new int[]{");
        this.out.print(dimension[0] + "},");
        this.out.print("new " + this.prefix + this.getStructurePrefix() + encodedAndEscapedName);
        this.out.print("(" + parentString + ", new FeldDeskriptorExt(mappings, \"");
        this.out.print(name);
        this.out.print("\",feldDeskriptor," + type + ", null, \"");
        this.out.print(name);
        this.out.println("\"), null));");
    }

    public abstract void generate(Object var1, String var2);

    public void setNoParent() {
        this.parent = false;
    }

    public void setStructurePrefix(String structurePrefix) {
        this.structurePrefix = structurePrefix;
    }

    public String getStructurePrefix() {
        return this.structurePrefix;
    }

    private void startSegmentIfNecessary() {
        if (this.statementsGenerated == 500) {
            this.statementsGenerated = 0;
            ++this.segmentNum;
            this.indent();
            this.out.println("initSegment" + this.segmentNum + "(parent, feldDeskriptor, indices, mappings);");
            this.closeBlock();
            this.defineMethod("private", "void", "initSegment" + this.segmentNum, "FeldDeskriptorInterface parent, FeldDeskriptor feldDeskriptor, int[] indices, Hashtable mappings");
            this.newLine();
        } else {
            ++this.statementsGenerated;
        }
    }
}

