/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.ExternalProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.JavaCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.java.ThemenbereichCodeGenerator;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLParameter;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;

public class ReferenceFunctionProgramCodeGenerator
extends JavaCodeGenerator {
    private final CodegenContext context;

    public ReferenceFunctionProgramCodeGenerator(CodegenContext context) {
        this.context = context;
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        int i;
        int len;
        if (!"ref".equals(funktion.getArt())) {
            throw new IllegalStateException("Referenzfunktion erwartet.");
        }
        MetaCustomFunktion referenceFunction = (MetaCustomFunktion)funktion;
        this.indentNewLine();
        ExternalProgramCodeGenerator.defineFunctionMethodSignature(this.out, referenceFunction);
        this.openBlock();
        MetaThemenbereich themenbereich = referenceFunction.getThemenbereich();
        String parentIfcName = ThemenbereichCodeGenerator.getParentInterfaceNameFor(themenbereich);
        this.indentNewLine();
        this.out.print("final FeldDeskriptorInterface parent = getVorgaenger();");
        this.indentNewLine();
        this.out.print("if (parent == null)");
        String functionName = referenceFunction.getName();
        String escapedName = StringHelper.getEscapedName(functionName);
        String programName = "prg_" + escapedName;
        this.openBlock();
        this.indentNewLine();
        this.out.print("return ((" + parentIfcName + ")" + this.context.getPlausiClassName() + ".this." + "themenbereich" + ")." + programName + "(context");
        if (referenceFunction.sizeOfParameter() > 0) {
            len = referenceFunction.sizeOfParameter();
            for (i = 0; i < len; ++i) {
                this.out.print(", ");
                referenceFunction.getFromParameter(i).accept(this);
            }
        }
        this.out.print(");");
        this.closeBlock();
        this.indentNewLine();
        this.out.print("else");
        this.openBlock();
        this.indentNewLine();
        this.out.print("return ((" + parentIfcName + ")parent)." + programName + "(context");
        if (referenceFunction.sizeOfParameter() > 0) {
            len = referenceFunction.sizeOfParameter();
            for (i = 0; i < len; ++i) {
                this.out.print(", ");
                referenceFunction.getFromParameter(i).accept(this);
            }
        }
        this.out.print(");");
        this.closeBlock();
        this.closeBlock();
    }

    @Override
    public void visitPLParameter(MetaPLParameter aParam) {
        String paramName = StringHelper.getEscapedName(aParam.getName());
        this.out.print("param_" + paramName);
    }
}

