/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.analysis.CrossReferenceBuilder;
import de.statspez.pleditor.generator.codegen.java.ClassificationCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.ErrorTextProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.LiteralCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.MappingsCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.MaterialCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.MehrfachantwortProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.PlausiElementCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.PlausiFehlerFactoryGenerator;
import de.statspez.pleditor.generator.codegen.java.PlausiFehlerIdsGenerator;
import de.statspez.pleditor.generator.codegen.java.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.ReferenceFunctionProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.Settings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.java.ThemenbereichCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.LiteralManager;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PlausiCodeGenerator
extends PlausiElementCodeGenerator {
    public static final int MAX_NESTED_TB = 1000;
    private CodegenContext context = null;
    private LiteralManager literalManager = null;

    public synchronized void generate(CodegenContext aContext) {
        this.context = aContext;
        this.literalManager = new LiteralManager(true, this.context.getMaxElementsInSegment(0), new LiteralManager.SegmentPrefixGiver(){

            @Override
            public String getNextSegmentPrefix() {
                return PlausiCodeGenerator.this.context.getNextPlausiSegmentClassName() + ".";
            }
        });
        this.setErrorContext(this.context.getMessageContext());
        CrossReferenceBuilder crefBuilder = new CrossReferenceBuilder();
        crefBuilder.buildCrossReference(this.context.getPlausi(), this.context.getPlausiScope(), this.context.getTopicScopes());
        this.context.getPlausi().accept(this);
        this.checkForErrors(this.context.isIgnoreWarnings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        String plausiFilename = this.context.getPlausiClassName() + ".java";
        Writer writer = this.context.createWriter(plausiFilename);
        this.setOutput(writer);
        try {
            this.out.print("package ");
            this.out.print(this.context.getPlausiPackage());
            this.out.print(";");
            this.indentNewLine();
            this.indentNewLine();
            this.out.print("import ");
            this.out.print("de.statspez.pleditor.generator.runtime.");
            this.out.print("*;");
            this.indentNewLine();
            this.out.print("import ");
            this.out.print("de.statspez.pleditor.generator.runtime.plausi.");
            this.out.print("*;");
            this.indentNewLine();
            this.defineClass(this.context.getPlausiClassName(), "public", "BasePlausi");
            this.indentNewLine();
            this.out.print("public double getPlausiSystemVersion() { return 4.0; }");
            this.indentNewLine();
            String genDateStr = "";
            Date genDate = ((MetaCustomPlausibilisierung)plausi).getGenDate();
            if (genDate != null) {
                SimpleDateFormat time_formatter = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.GERMANY);
                genDateStr = time_formatter.format(genDate);
            }
            this.out.print("public String getPlausiVersionString() { return \"" + genDateStr + "\"; }");
            this.indentNewLine();
            this.processPlausiElements(plausi);
            LiteralCodeGenerator litGen = new LiteralCodeGenerator();
            litGen.setOutput(this.out);
            litGen.setIndentLevel(this.indentLevel());
            litGen.setErrorContext(this.context.getMessageContext());
            litGen.generate(this.context, this.literalManager);
            MetaThemenbereich rootTb = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich();
            this.indentNewLine();
            this.out.print("public ");
            this.out.print(this.getTbClass(rootTb));
            this.out.print(" ");
            this.out.print("themenbereich");
            this.out.print(";");
            MetaPLMaterial[] usedMaterials = CodegenUtil.getUsedMaterials(plausi);
            if (usedMaterials != null && usedMaterials.length > 0) {
                for (int i = 0; i < usedMaterials.length; ++i) {
                    this.indentNewLine();
                    this.out.print("public ");
                    this.out.print("Material");
                    this.out.print(this.getTbClass(usedMaterials[i].getThemenbereich()));
                    this.out.print(" ");
                    this.out.print("__material_");
                    this.out.print(StringHelper.getEscapedName(usedMaterials[i].getName()));
                    this.out.print(";");
                }
            }
            this.indentNewLine();
            this.createPlausiConstructor(plausi);
            this.indentNewLine();
            this.createPlausiInitMethod(plausi);
            this.indentNewLine();
            this.createAblaufInvocationMethod(plausi);
            this.indentNewLine();
            this.createPlausiFehlerFactoryMethod();
            this.indentNewLine();
            this.createPlausiFehlerIdsMethod();
            if (CodegenUtil.containsMissingValues(rootTb)) {
                this.indentNewLine();
                this.createAddFehlwerteMethod(plausi);
            }
            this.endClassDefinition();
        }
        finally {
            this.context.destroyWriter(plausiFilename, writer);
        }
    }

    @Override
    public void visitMerkmal(MetaMerkmal aMerkmal) {
        MetaCustomMerkmal merkmal = (MetaCustomMerkmal)aMerkmal;
        if (merkmal.referencedByErhebung()) {
            ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            prgGen.setLiteralManager(this.literalManager);
            prgGen.setErrorContext(new ElementMessageContext(5, merkmal.getId(), merkmal.getName()));
            this.context.putContextInfo("PROGRAM_CHECKS_FIELD_KEY", Boolean.TRUE);
            prgGen.generate(this.context, merkmal.getMetaSpezifikation(), new ScopeImpl(this.context.getPlausiScope()), false, true);
            this.context.putContextInfo("PROGRAM_CHECKS_FIELD_KEY", null);
            if (CodegenUtil.containsMehrfachantwortTbFieldForMerkmal(this.context.getPlausi(), merkmal)) {
                this.indentNewLine();
                MehrfachantwortProgramCodeGenerator gen = new MehrfachantwortProgramCodeGenerator();
                gen.setOutput(this.out);
                gen.setIndentLevel(this.indentLevel());
                gen.generate(merkmal);
            }
            this.indentNewLine();
            this.createMerkmalFehlerMethod(merkmal);
            this.indentNewLine();
        }
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion aFunktion) {
        MetaCustomFunktion funktion = (MetaCustomFunktion)aFunktion;
        String art = funktion.getArt();
        if ("extern".equals(art)) {
            if (this.context == null) {
                throw new IllegalStateException("context ist null.");
            }
            ReferenceFunctionProgramCodeGenerator refFunctionProgramGenerator = new ReferenceFunctionProgramCodeGenerator(this.context);
            refFunctionProgramGenerator.setOutput(this.out);
            refFunctionProgramGenerator.setIndentLevel(this.indentLevel());
            funktion.accept(refFunctionProgramGenerator);
        } else {
            if ("ref".equals(art)) {
                throw new IllegalStateException("Allgemeine Referenzfunktionen werden nicht unterst\u00fctzt.");
            }
            ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            prgGen.setLiteralManager(this.literalManager);
            prgGen.setErrorContext(new ElementMessageContext(4, funktion.getId(), funktion.getName()));
            prgGen.generate(this.context, funktion.getMetaSpezifikation(), new ScopeImpl(this.context.getPlausiScope()), true);
            this.indentNewLine();
        }
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        ThemenbereichCodeGenerator tbGen = new ThemenbereichCodeGenerator();
        tbGen.setOutput(this.out);
        tbGen.setIndentLevel(this.indentLevel());
        tbGen.setLiteralManager(this.literalManager);
        tbGen.setErrorContext(new ElementMessageContext(6, tb.getId(), tb.getName()));
        tbGen.generate(this.context, tb, (Scope)this.context.getTopicScopes().get(tb.getName()));
        if (CodegenUtil.referencedByUsedMaterial(this.context.getPlausi(), tb)) {
            this.indentNewLine();
            MaterialCodeGenerator matGen = new MaterialCodeGenerator();
            matGen.setOutput(this.out);
            matGen.setIndentLevel(this.indentLevel());
            matGen.setErrorContext(new ElementMessageContext(7, tb.getId(), tb.getName()));
            matGen.generate(this.context, tb);
        }
        this.indentNewLine();
    }

    private void createPlausiConstructor(MetaPlausibilisierung aPlausi) {
        MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)aPlausi;
        this.defineMethod("public", "", this.context.getPlausiClassName(), "");
        this.indentNewLine();
        this.out.print("plausiDescriptor()");
        this.out.print(".setName(\"");
        this.out.print(plausi.getPLName());
        this.out.print("\");");
        this.indentNewLine();
        this.declareAblaufRuntimeInfos(plausi);
        this.declareStandardAblauf(plausi);
        this.indentNewLine();
        this.declareClassifications();
        this.indentNewLine();
        this.declareMappings();
        this.indentNewLine();
        this.declareMaterialAttributes(plausi);
        this.indentNewLine();
        this.out.print("themenbereich");
        this.out.print(" = new ");
        this.out.print(this.getTbClass(plausi.rootThemenbereich()));
        this.out.print("(null, new ");
        this.out.print("FeldDeskriptor");
        this.out.print("(plausiMappings(), ");
        this.out.print("\"__root_tb__\", ");
        this.out.print("null, RuntimeSettings.RT_TYPE_CUSTOM), ");
        this.out.print("null);");
        this.endMethodDefinition();
    }

    private void createPlausiInitMethod(MetaPlausibilisierung plausi) {
        this.defineMethod("public", "void", "init", "PlausiRuntimeContext context");
        this.endMethodDefinition();
    }

    private void declareAblaufRuntimeInfos(MetaPlausibilisierung plausi) {
        Iterator it = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich().getAblaeufe();
        while (it.hasNext()) {
            MetaCustomAblauf ablauf = (MetaCustomAblauf)it.next();
            this.indentNewLine();
            this.out.print("plausiDescriptor()");
            this.out.print(".addFlow(new ");
            this.out.print("PlausiDescriptor.FlowInfo");
            this.out.print("(\"");
            this.out.print(ablauf.getName());
            this.out.print("\"");
            this.out.print(", new Class[] {");
            Iterator initwerteIt = ablauf.getThemenbereich().getInitialisierungswerte();
            while (initwerteIt.hasNext()) {
                MetaPLInitwert anInitwert = (MetaPLInitwert)initwerteIt.next();
                this.out.print(Settings.NATIVE_TYPES[anInitwert.getTyp()]);
                this.out.print(".class");
                if (!initwerteIt.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print("}");
            this.out.print("));");
        }
    }

    private void declareStandardAblauf(MetaPlausibilisierung plausi) {
        MetaPLAblauf stdAblauf = ((MetaCustomPlausibilisierung)plausi).standardAblauf();
        if (stdAblauf != null) {
            this.indentNewLine();
            this.out.print("plausiDescriptor()");
            this.out.print(".setStandardFlow(");
            this.out.print("plausiDescriptor()");
            this.out.print(".flow(\"");
            this.out.print(StringHelper.getEscapedName(stdAblauf.getName()));
            this.out.print("\"));");
        } else {
            this.warning(plausi, "es konnte kein Standard-Ablauf ermittelt werden");
        }
    }

    private void declareClassifications() {
        ClassificationCodeGenerator codeGen = new ClassificationCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(this.context);
    }

    private void declareMappings() {
        MappingsCodeGenerator codeGen = new MappingsCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(this.context);
    }

    private void declareMaterialAttributes(MetaPlausibilisierung plausi) {
        MaterialCodeGenerator codeGen = new MaterialCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(plausi);
    }

    private void createAblaufInvocationMethod(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        this.defineMethod("protected", "void", "doAblauf", "PlausiDescriptor.FlowInfo ablaufInfo, PlausiRuntimeContext context, Object[] initWerte");
        MetaThemenbereich rootTb = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich();
        Iterator it = rootTb.getAblaeufe();
        boolean firstIf = true;
        while (it.hasNext()) {
            MetaPLAblauf ablauf = (MetaPLAblauf)it.next();
            this.indentNewLine();
            if (!firstIf) {
                this.out.print("else ");
            } else {
                firstIf = false;
            }
            this.out.print("if (ablaufInfo.name.equals(\"");
            this.out.print(ablauf.getName());
            this.out.print("\"))");
            this.openBlock();
            if (rootTb.sizeOfInitialisierungswerte() > 0) {
                MetaPLInitwert initwert;
                int i;
                this.indentNewLine();
                this.out.print("ValueFactory");
                this.out.print(" vf = ");
                this.out.print("ValueFactory.instance()");
                this.out.print(";");
                for (i = 0; i < rootTb.sizeOfInitialisierungswerte(); ++i) {
                    initwert = (MetaCustomInitwert)rootTb.getFromInitialisierungswerte(i);
                    String initwertName = StringHelper.getEscapedName(initwert.getName());
                    this.indentNewLine();
                    if (initwert.getListe()) {
                        int[] dimensions = ((MetaCustomInitwert)initwert).dimensions();
                        this.out.print("LocalArray ");
                        this.out.print(initwertName);
                        this.out.print(" = new LocalArray(");
                        this.createArrayDimensions(dimensions);
                        this.out.print(");");
                        StringBuffer template = new StringBuffer();
                        template.append("((Variable)");
                        template.append(initwertName);
                        template.append(".getElement(context, @@indexarray)).set(context, vf.valueFor(((");
                        template.append(Settings.NATIVE_TYPES[initwert.getTyp()]);
                        for (int j = 0; j < dimensions.length; ++j) {
                            template.append("[]");
                        }
                        template.append(")initWerte[");
                        template.append(Integer.toString(i));
                        template.append("])@@index));");
                        this.iterateArray(template.toString(), dimensions);
                        continue;
                    }
                    this.out.print("Value ");
                    this.out.print(initwertName);
                    this.out.print(" = ");
                    this.out.print("vf.valueFor((");
                    this.out.print(Settings.NATIVE_TYPES[initwert.getTyp()]);
                    this.out.print(")initWerte[");
                    this.out.print(Integer.toString(i));
                    this.out.print("]);");
                }
                this.indentNewLine();
                this.out.print("themenbereich");
                this.out.print(".");
                this.out.print("setInitValues");
                this.out.print("(context");
                for (i = 0; i < rootTb.sizeOfInitialisierungswerte(); ++i) {
                    initwert = rootTb.getFromInitialisierungswerte(i);
                    this.out.print(", ");
                    this.out.print(StringHelper.getEscapedName(initwert.getName()));
                }
                this.out.print(");");
            }
            this.indentNewLine();
            this.out.print("themenbereich");
            this.out.print(".");
            this.out.print("prg_");
            this.out.print(StringHelper.getEscapedName(ablauf.getName()));
            this.out.print("(context);");
            this.closeBlock();
        }
        this.endMethodDefinition();
    }

    private void createPlausiFehlerFactoryMethod() {
        PlausiFehlerFactoryGenerator codeGen = new PlausiFehlerFactoryGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(this.context);
    }

    private void createPlausiFehlerIdsMethod() {
        PlausiFehlerIdsGenerator codeGen = new PlausiFehlerIdsGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(this.context);
    }

    private void processPlausiElements(MetaPlausibilisierung plausi) {
        this.visitElements(plausi.getMerkmale());
        this.visitElements(plausi.getFunktionen());
        this.visitElements(plausi.getThemenbereiche());
    }

    private void createMerkmalFehlerMethod(MetaCustomMerkmal merkmal) {
        this.defineMethod("protected", "void", "fehler_" + merkmal.getMetaSpezifikation().name(), "PlausiRuntimeContext context, int errorNum, Throwable thr");
        this.indentNewLine();
        this.out.print("final FeldDeskriptorImpl field = context.getCurrentField();");
        this.indentNewLine();
        this.out.print("final String hierarchy = field.getFeldDeskriptor().hierarchyAsString();");
        this.indentNewLine();
        this.out.print("PlausiFehler");
        this.out.print(" fehler = createPlausiFehler(\"");
        this.out.print(merkmal.getName());
        this.out.print("\", hierarchy);");
        this.indentNewLine();
        this.out.print("fehler.setFehlerInfoTyp(errorNum);");
        this.indentNewLine();
        this.out.print("context.writeSectionInfosToError(fehler);");
        List<MetaCustomTBFeld> fields = CodegenUtil.getFieldsForMerkmal(this.context.getPlausi(), merkmal);
        HashMap<MetaThemenbereich, List<MetaTBFeld>> fieldsWithErrorShortProgram = new HashMap<MetaThemenbereich, List<MetaTBFeld>>();
        HashMap<MetaThemenbereich, List<MetaTBFeld>> fieldsWithErrorLongProgram = new HashMap<MetaThemenbereich, List<MetaTBFeld>>();
        HashMap<MetaThemenbereich, List<MetaTBFeld>> fieldsWithCorrectionAdviceProgram = new HashMap<MetaThemenbereich, List<MetaTBFeld>>();
        for (MetaCustomTBFeld field : fields) {
            List<MetaCustomTBFeld> tbFiels;
            if (this.context.getTextResource().getFehlertextKurzProgram(field) != null) {
                tbFiels = (ArrayList)fieldsWithErrorShortProgram.get(field.getThemenbereich());
                if (tbFiels == null) {
                    tbFiels = new ArrayList();
                    fieldsWithErrorShortProgram.put(field.getThemenbereich(), tbFiels);
                }
                if (!tbFiels.contains(field)) {
                    tbFiels.add(field);
                }
            }
            if (this.context.getTextResource().getFehlertextLangProgram(field) != null) {
                tbFiels = (List)fieldsWithErrorLongProgram.get(field.getThemenbereich());
                if (tbFiels == null) {
                    tbFiels = new ArrayList();
                    fieldsWithErrorLongProgram.put(field.getThemenbereich(), tbFiels);
                }
                if (!tbFiels.contains(field)) {
                    tbFiels.add(field);
                }
            }
            if (this.context.getTextResource().getKorrekturhinweisProgram(field) == null) continue;
            tbFiels = (List)fieldsWithCorrectionAdviceProgram.get(field.getThemenbereich());
            if (tbFiels == null) {
                tbFiels = new ArrayList();
                fieldsWithCorrectionAdviceProgram.put(field.getThemenbereich(), tbFiels);
            }
            if (tbFiels.contains(field)) continue;
            tbFiels.add(field);
        }
        MetaProgram errorTextShortProgram = this.context.getTextResource().getFehlertextKurzProgram(merkmal);
        MetaProgram errorTextLongProgram = this.context.getTextResource().getFehlertextLangProgram(merkmal);
        MetaProgram correctionAdviceProgram = this.context.getTextResource().getKorrekturhinweisProgram(merkmal);
        if (!(fieldsWithErrorShortProgram.isEmpty() && fieldsWithErrorLongProgram.isEmpty() && fieldsWithCorrectionAdviceProgram.isEmpty())) {
            this.indentNewLine();
            this.print("final FeldDeskriptorInterface parent = field.getVorgaenger();");
        }
        this.printErrorTextPrograms("setFehlertextKurz", errorTextShortProgram, fieldsWithErrorShortProgram, "errShort_");
        this.printErrorTextPrograms("setFehlertextLang", errorTextLongProgram, fieldsWithErrorLongProgram, "errLong_");
        this.printErrorTextPrograms("setFehlerKorrekturhinweis", correctionAdviceProgram, fieldsWithCorrectionAdviceProgram, "corrAdv_");
        this.indentNewLine();
        this.out.print("fehler.setFehlerId(field.hierarchyAsString() + \"#" + merkmal.getName() + "\");");
        this.indentNewLine();
        this.out.print("fehler.setReferenzFeld(field);");
        this.indentNewLine();
        this.out.print("fehler.setLaufzeitFehlerAufgetreten(thr != null);");
        this.indentNewLine();
        this.out.print("fehler.setLaufzeitException(thr);");
        this.indentNewLine();
        this.out.print("context.getLogger().trace(\"FehlerID angeschrieben: \" + fehler.getFehlerId());");
        this.indentNewLine();
        this.out.print("context.getPlausiKontext().setFehler(fehler);");
        this.endMethodDefinition();
    }

    private void printErrorTextPrograms(String setMethodName, MetaProgram defaultProgram, Map<MetaThemenbereich, List<MetaTBFeld>> fieldsWithErrorTextProgram, String errorTextMethodPrefix) {
        if (defaultProgram != null || !fieldsWithErrorTextProgram.isEmpty()) {
            this.indentNewLine();
            this.print("try");
            this.openBlock();
            if (!fieldsWithErrorTextProgram.isEmpty()) {
                this.indentNewLine();
                this.print("boolean handled = false;");
                boolean firstTb = true;
                for (MetaThemenbereich tb : fieldsWithErrorTextProgram.keySet()) {
                    boolean isRootTb;
                    String tbClass = this.getTbClass(tb);
                    boolean bl = isRootTb = tb == ((MetaCustomPlausibilisierung)this.context.getPlausi()).rootThemenbereich();
                    if (firstTb) {
                        firstTb = false;
                        this.indentNewLine();
                    } else {
                        this.indentNewLine();
                        this.print("else ");
                    }
                    this.print("if (parent ");
                    if (isRootTb) {
                        this.print("== null");
                    } else {
                        this.print("instanceof ");
                        this.print(tbClass);
                    }
                    this.print(")");
                    this.openBlock();
                    boolean firstField = true;
                    for (MetaTBFeld field : fieldsWithErrorTextProgram.get(tb)) {
                        if (firstField) {
                            firstField = false;
                            this.indentNewLine();
                        } else {
                            this.indentNewLine();
                            this.print("else ");
                        }
                        this.print("if (\"");
                        this.print(StringHelper.getEscapedStringValue(field.getName()));
                        this.print("\".equals(field.getFeldNameTB())");
                        this.print(")");
                        this.openBlock();
                        this.indentNewLine();
                        this.print("fehler.");
                        this.print(setMethodName);
                        this.print("(");
                        if (isRootTb) {
                            this.print("this.");
                            this.print("themenbereich");
                        } else {
                            this.print("((");
                            this.print(tbClass);
                            this.print(")parent)");
                        }
                        this.print(".");
                        this.print(errorTextMethodPrefix);
                        this.print(StringHelper.getEscapedName(field.getName()));
                        this.print("(context));");
                        this.indentNewLine();
                        this.print("handled = true;");
                        this.closeBlock();
                    }
                    this.closeBlock();
                }
            }
            if (defaultProgram != null) {
                if (!fieldsWithErrorTextProgram.isEmpty()) {
                    this.indentNewLine();
                    this.print("if (!handled)");
                    this.openBlock();
                }
                ErrorTextProgramCodeGenerator prgGen = new ErrorTextProgramCodeGenerator();
                prgGen.setOutput(this.out);
                prgGen.setIndentLevel(this.indentLevel());
                prgGen.setLiteralManager(this.literalManager);
                prgGen.preGenerate();
                this.indentNewLine();
                this.print("fehler.");
                this.print(setMethodName);
                this.print("(");
                prgGen.generate(this.context, defaultProgram, this.context.getPlausiScope(), false);
                this.print(");");
                if (!fieldsWithErrorTextProgram.isEmpty()) {
                    this.closeBlock();
                }
            }
            this.closeBlock();
            this.indentNewLine();
            this.print("catch (Exception ex)");
            this.openBlock();
            this.closeBlock();
        }
    }

    private void createAddFehlwerteMethod(MetaPlausibilisierung plausi) {
        this.defineMethod("public", "void", "addFehlwerte", "PlausiRuntimeContext context, java.util.Vector fehlwerte");
        this.indentNewLine();
        this.out.print("themenbereich");
        this.out.print(".addFehlwerte(context, fehlwerte);");
        this.endMethodDefinition();
    }
}

