/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.JavaCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.Settings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomParameter;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLParameter;
import java.io.PrintWriter;

public class ExternalProgramCodeGenerator
extends JavaCodeGenerator {
    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        if (!"extern".equals(funktion.getArt())) {
            throw new IllegalStateException("Externe Funktion erwartet.");
        }
        this.indentNewLine();
        ExternalProgramCodeGenerator.defineFunctionMethodSignature(this.out, funktion);
        this.openBlock();
        this.startNewSection(ElementMessageContext.stringForType(4) + " " + funktion.getName());
        this.indentNewLine();
        this.out.print("try");
        this.openBlock();
        this.indentNewLine();
        this.out.print("return ValueFactory.instance().valueFor((");
        this.out.print(Settings.NATIVE_TYPES[funktion.getRueckgabeTyp()]);
        this.out.print(")invokeExternalFunction(context, \"" + funktion.getName() + "\", new ValueInterface[]{");
        if (funktion.sizeOfParameter() > 0) {
            int len = funktion.sizeOfParameter();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.out.print(", ");
                }
                funktion.getFromParameter(i).accept(this);
            }
        }
        this.out.print("}));");
        this.closeBlock();
        this.indentNewLine();
        this.out.print("catch (Exception ex)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("context.getLogger().error(\"Fehler beim Ansprechen der externen Funktion: " + funktion.getName() + "\",ex);");
        this.closeBlock();
        this.indentNewLine();
        this.out.print("finally");
        this.openBlock();
        this.leaveCurrentSection();
        this.closeBlock();
        this.indentNewLine();
        this.out.print("return InvalidValue.instance();");
        this.closeBlock();
    }

    @Override
    public void visitPLParameter(MetaPLParameter aParam) {
        String paramName = StringHelper.getEscapedName(aParam.getName());
        this.out.print("param_" + paramName);
    }

    public static void defineFunctionMethodSignature(PrintWriter out, MetaPLFunktion function) {
        String escapedProgramName = StringHelper.getEscapedName(function.getName());
        out.print("public Value ");
        out.print("prg_");
        out.print(escapedProgramName);
        out.print("(");
        out.print("PlausiRuntimeContext");
        out.print(" context");
        int len = function.sizeOfParameter();
        for (int i = 0; i < len; ++i) {
            MetaCustomParameter aParam = (MetaCustomParameter)function.getFromParameter(i);
            if (!aParam.getListe()) {
                out.print(", ");
                out.print("Value ");
                out.print("param_");
                out.print(StringHelper.getEscapedName(aParam.getName()));
                continue;
            }
            out.print(", Array ");
            out.print("param_");
            out.print(StringHelper.getEscapedName(aParam.getName()));
        }
        out.print(")");
    }
}

