/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.Settings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.DefaultTextResource;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.TbScopeBuilder;
import de.statspez.pleditor.generator.codegen.support.TextResource;
import de.statspez.pleditor.generator.common.DefaultMessageContext;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import java.util.HashMap;
import java.util.Hashtable;

public abstract class AbstractCodegenContext
implements CodegenContext {
    private MetaPlausibilisierung plausi;
    private TextResource textResource;
    private String plausiPackage;
    private String plausiClassName;
    private String plausiSegmentClassNameSuffix;
    private MessageContextInterface messageContext;
    private Scope plausiScope;
    private Hashtable topicScopes;
    private HashMap contextInfos;
    private int[] maxElementsInSegment;
    private int numOfSegments;
    private boolean generateRAWMapping = false;
    private boolean generateDSBMapping = false;
    private boolean ignoreWarnings = false;
    private static final String[] TYPES_MAX_ELEMENTS_IN_SEGMENT = new String[]{"max_literal", "max_apg", "max_mapping", "max_fehlererzeugung", "max_fehlerids", "max_felder", "max_anweisungen", "max_reihe"};

    public AbstractCodegenContext(MetaPlausibilisierung plausi) {
        if (plausi == null) {
            throw new IllegalArgumentException("Keine Plausibilisierung angegeben.");
        }
        if (plausi.getPLName() == null || plausi.getPLName().length() == 0) {
            throw new IllegalArgumentException("Kein Name der Plausibilisierung angegeben.");
        }
        this.plausi = plausi;
        this.textResource = new DefaultTextResource();
        this.plausiPackage = "de.statspez.plausi.generated";
        this.plausiClassName = "Plausi_" + StringHelper.getEscapedName(plausi.getPLName());
        this.plausiSegmentClassNameSuffix = "_Segment";
        this.messageContext = new DefaultMessageContext("Plausibilsierung " + plausi.getName());
        this.topicScopes = new Hashtable();
        TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
        this.plausiScope = scopeBuilder.createScopes(plausi, this.topicScopes);
        this.contextInfos = new HashMap();
        this.maxElementsInSegment = new int[Settings.DEFAULT_MAX_ELEMENTS_IN_SEGMENT.length];
        for (int i = 0; i < this.maxElementsInSegment.length; ++i) {
            this.maxElementsInSegment[i] = this.getDefinedMaxElementInSegment(i);
        }
    }

    public void setTextResource(TextResource textResource) {
        this.textResource = textResource;
    }

    public void setPlausiPackage(String plausiPackage) {
        this.plausiPackage = plausiPackage;
    }

    public void setPlausiClassName(String plausiClassName) {
        this.plausiClassName = StringHelper.getEscapedName(plausiClassName);
    }

    public void setPlausiSegmentClassNameSuffix(String plausiSegmentClassNameSuffix) {
        this.plausiSegmentClassNameSuffix = plausiSegmentClassNameSuffix;
    }

    public void setMessageContext(MessageContextInterface messageContext) {
        this.messageContext = messageContext;
    }

    public void setMaxElementsInSegment(int type, int maxElementsInSegment) {
        if (type < 0 || type >= this.maxElementsInSegment.length) {
            throw new IllegalArgumentException("Typ nicht definiert: " + type);
        }
        if (maxElementsInSegment < 1) {
            throw new IllegalArgumentException("Maximale Anzahl ist ung\u00fcltig: " + maxElementsInSegment);
        }
        this.maxElementsInSegment[type] = maxElementsInSegment;
    }

    @Override
    public boolean isGenerateRAWMapping() {
        return this.generateRAWMapping;
    }

    public void setGenerateRAWMapping(boolean generateRAWMapping) {
        this.generateRAWMapping = generateRAWMapping;
    }

    @Override
    public boolean isGenerateDSBMapping() {
        return this.generateDSBMapping;
    }

    public void setGenerateDSBMapping(boolean generateDSBMapping) {
        this.generateDSBMapping = generateDSBMapping;
    }

    @Override
    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    @Override
    public MetaPlausibilisierung getPlausi() {
        return this.plausi;
    }

    @Override
    public TextResource getTextResource() {
        return this.textResource;
    }

    @Override
    public String getPlausiPackage() {
        return this.plausiPackage;
    }

    @Override
    public String getPlausiClassName() {
        return this.plausiClassName;
    }

    @Override
    public String getNextPlausiSegmentClassName() {
        ++this.numOfSegments;
        return this.getPlausiClassName() + this.plausiSegmentClassNameSuffix + this.numOfSegments;
    }

    @Override
    public MessageContextInterface getMessageContext() {
        return this.messageContext;
    }

    @Override
    public Scope getPlausiScope() {
        return this.plausiScope;
    }

    @Override
    public Hashtable getTopicScopes() {
        return this.topicScopes;
    }

    @Override
    public void putContextInfo(Object key, Object info) {
        this.contextInfos.put(key, info);
    }

    @Override
    public Object getContextInfo(Object key) {
        return this.contextInfos.get(key);
    }

    @Override
    public int getMaxElementsInSegment(int type) {
        return this.maxElementsInSegment[type];
    }

    protected int getDefinedMaxElementInSegment(int type) {
        int result = Settings.DEFAULT_MAX_ELEMENTS_IN_SEGMENT[type];
        if (this.plausi.getKommentar() != null && this.plausi.getKommentar().length() > 0) {
            String keyword = TYPES_MAX_ELEMENTS_IN_SEGMENT[type] + ":";
            int index = this.plausi.getKommentar().indexOf(keyword);
            if (index >= 0) {
                int i;
                StringBuffer number = new StringBuffer();
                for (i = index + keyword.length(); i < this.plausi.getKommentar().length() && this.plausi.getKommentar().charAt(i) == ' '; ++i) {
                }
                if (i < this.plausi.getKommentar().length()) {
                    while (i < this.plausi.getKommentar().length() && Character.isDigit(this.plausi.getKommentar().charAt(i))) {
                        number.append(this.plausi.getKommentar().charAt(i));
                        ++i;
                    }
                    if (number.length() > 0) {
                        result = Integer.parseInt(number.toString());
                    }
                }
            }
        }
        return result;
    }
}

