/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.html;

import de.statspez.pleditor.generator.codegen.html.AssignmentNameExtractor;
import de.statspez.pleditor.generator.codegen.html.HtmlGeneratorUtil;
import de.statspez.pleditor.generator.codegen.html.Precondition;
import de.statspez.pleditor.generator.codegen.support.AbstractCodeTraverser;
import de.statspez.pleditor.generator.meta.MetaAssignment;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import java.util.Collection;

public class Assignment {
    private final MetaAssignment metaAssignment;
    private final Collection<Precondition> preconditions;
    private final MetaCustomAblauf ablauf;
    private final String namespace;
    private MetaElement referredElement;
    private String field;

    public Assignment(MetaAssignment assignment, Collection<Precondition> preconditions, final MetaCustomAblauf ablauf, String namespace, final int position) {
        this.metaAssignment = assignment;
        this.preconditions = preconditions;
        this.ablauf = ablauf;
        this.namespace = namespace;
        assignment.accept(new AbstractCodeTraverser(){

            @Override
            public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
                this.initField(anAssignment.leftValue());
                anAssignment.leftValue().accept(this);
            }

            @Override
            public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
                this.initField(anAssignment.leftValueAt(position));
                anAssignment.leftValueAt(position).accept(this);
            }

            @Override
            public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
                Assignment.this.referredElement = aFieldAccess.referredElement();
            }

            private void initField(MetaValueAccess metaValueAccess) {
                AssignmentNameExtractor setzungNameGenerator = new AssignmentNameExtractor();
                Assignment.this.field = setzungNameGenerator.getAssignmentName(metaValueAccess, ablauf.getSpezifikation());
            }
        });
    }

    public String getField() {
        return this.field;
    }

    public MetaElement getReferredElement() {
        return this.referredElement;
    }

    public MetaAssignment getAssignment() {
        return this.metaAssignment;
    }

    public Collection<Precondition> getPreconditions() {
        return this.preconditions;
    }

    public String getCode() {
        return HtmlGeneratorUtil.getCodeSegment(this.ablauf.getSpezifikation(), this.metaAssignment);
    }

    public MetaCustomAblauf getAblauf() {
        return this.ablauf;
    }

    public String getFieldWithNamespace() {
        String fieldWithNamespace = "";
        if (this.namespace != null && this.namespace.length() > 0) {
            fieldWithNamespace = this.namespace + ".";
        }
        fieldWithNamespace = fieldWithNamespace + this.field;
        if (this.getReferredElement() == null) {
            fieldWithNamespace = fieldWithNamespace + "@" + this.ablauf.getName();
        }
        return fieldWithNamespace;
    }
}

