/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.AbstractStat;
import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.Helper;
import java.util.ArrayList;
import java.util.Collections;

public class FunktionStat
extends AbstractStat {
    @Override
    public void add(MetaStatspezObjekt funktion) {
        MetaCustomFunktion mcf = (MetaCustomFunktion)funktion;
        if (!this.idElementTable.containsKey(mcf.getId())) {
            DokuElement de = new DokuElement(mcf.getId(), mcf.getThemenbereich().getName() + "." + mcf.getName());
            de.setElement(mcf);
            de.setTbId(mcf.getThemenbereich().getId());
            if (!this.istKompilierbar(mcf)) {
                this.fehlerHafteElemente.add(de);
                de.setZusatz("fehlerhaft");
            }
            this.idElementTable.put(de.getId(), de);
        }
    }

    public ArrayList getEigenschften(boolean sortiere) {
        ArrayList<DokuElement> result = new ArrayList<DokuElement>();
        for (DokuElement de : this.idElementTable.values()) {
            MetaCustomFunktion mcf = (MetaCustomFunktion)de.getElement();
            if (mcf.getFunctionType() != 1) continue;
            result.add(de);
        }
        if (sortiere) {
            Collections.sort(result);
        }
        return result;
    }

    public ArrayList getFunktionen(boolean sortiere) {
        ArrayList<DokuElement> result = new ArrayList<DokuElement>();
        for (DokuElement de : this.idElementTable.values()) {
            MetaCustomFunktion mcf = (MetaCustomFunktion)de.getElement();
            if (mcf.getFunctionType() != 0) continue;
            result.add(de);
        }
        if (sortiere) {
            Collections.sort(result);
        }
        return result;
    }

    public boolean istKompilierbar(MetaCustomFunktion mcf) {
        boolean result;
        try {
            Helper.metaStructureFor(mcf.getAnweisungen());
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public String getCondition(String conditionalStatement) {
        String cs = conditionalStatement.toUpperCase();
        if (!(cs = cs.replaceAll("\n", " ")).trim().startsWith("WENN") || cs.indexOf("DANN") == -1) {
            return null;
        }
        return conditionalStatement.substring("WENN".length() + 1, cs.indexOf("DANN"));
    }
}

