/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff.dialog;

import de.statspez.pleditor.generator.codegen.diff.DiffConfig;
import de.statspez.pleditor.generator.codegen.diff.dialog.DiffConfigComponent;
import de.statspez.pleditor.generator.codegen.diff.dialog.DiffConfigElementsPanel;
import de.statspez.pleditor.generator.codegen.diff.dialog.DiffUIConfigChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DiffUIConfigDialog
extends JDialog {
    private static final long serialVersionUID = -3746462926433185612L;
    private JRadioButton sortTypeRB;
    private JRadioButton sortNameRB;
    private JCheckBox hideCB;
    private DiffConfigComponent diffConfigComponent;
    private boolean initialNameSorting = true;
    private boolean initialHideNoError = false;
    private DiffConfig diffConfig = new DiffConfig();
    private boolean initMode = false;
    private List diffUIConfigChangeListeners;

    public DiffUIConfigDialog() {
        this.init();
    }

    public DiffUIConfigDialog(JDialog owner) {
        super(owner);
        this.init();
    }

    public DiffUIConfigDialog(JFrame owner) {
        super(owner);
        this.init();
    }

    public void setInitialNameSorting(boolean initialNameSorting) {
        this.initialNameSorting = initialNameSorting;
    }

    public void setInitialHideNoError(boolean initialHideNoError) {
        this.initialHideNoError = initialHideNoError;
    }

    public void setDiffConfig(DiffConfig diffConfig) {
        this.diffConfig = diffConfig;
    }

    public void addDiffUIConfigListener(DiffUIConfigChangeListener li) {
        if (li != null && !this.diffUIConfigChangeListeners.contains(li)) {
            this.diffUIConfigChangeListeners.add(li);
        }
    }

    public void start() {
        this.initMode = true;
        this.sortNameRB.setSelected(this.initialNameSorting);
        this.sortTypeRB.setSelected(!this.initialNameSorting);
        this.hideCB.setSelected(this.initialHideNoError);
        this.diffConfigComponent.setDataFromDiffConfig(this.diffConfig);
        this.diffConfigComponent.setEnabled(this.initialHideNoError);
        this.initMode = false;
        this.setVisible(true);
    }

    private void init() {
        this.diffUIConfigChangeListeners = new ArrayList();
        this.setModal(true);
        this.setSize(300, 700);
        this.setDefaultCloseOperation(1);
        this.setTitle("Einstellungen");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel sortPanel = this.createSortPanel();
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel2.add((Component)sortPanel, "West");
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.add((Component)panel2, "North");
        this.setTitleBorder("Sortierung", panel3);
        JPanel hidePanel = this.createHidePanel();
        this.setTitleBorder("Ausblenden", hidePanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)panel3, "North");
        panel.add((Component)hidePanel, "Center");
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private JPanel createButtonsPanel() {
        JButton okButton = new JButton("\u00dcbernehmen");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffUIConfigDialog.this.onOk();
            }
        });
        JButton cancelButton = new JButton("Abbrechen");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffUIConfigDialog.this.setVisible(false);
            }
        });
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel.add(okButton);
        panel.add(cancelButton);
        JPanel ostPanel = new JPanel(new BorderLayout());
        ostPanel.add((Component)panel, "East");
        return ostPanel;
    }

    private JPanel createSortPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.sortNameRB = new JRadioButton("Nach Name");
        this.sortTypeRB = new JRadioButton("Nach Typ");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sortTypeRB);
        buttonGroup.add(this.sortNameRB);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        panel.add((Component)this.sortTypeRB, gbc);
        ++gbc.gridy;
        panel.add((Component)this.sortNameRB, gbc);
        return panel;
    }

    private JPanel createHidePanel() {
        this.hideCB = new JCheckBox("Unver\u00e4nderte Elemente und");
        this.hideCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DiffUIConfigDialog.this.initMode) {
                    DiffUIConfigDialog.this.diffConfigComponent.setEnabled(DiffUIConfigDialog.this.hideCB.isSelected());
                }
            }
        });
        DiffConfigElementsPanel diffCriteriaPanel = new DiffConfigElementsPanel();
        this.diffConfigComponent = diffCriteriaPanel;
        JPanel westLayoutPanel = new JPanel(new BorderLayout());
        westLayoutPanel.add((Component)diffCriteriaPanel, "West");
        westLayoutPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        JPanel northLayoutPanel = new JPanel(new BorderLayout());
        northLayoutPanel.add((Component)westLayoutPanel, "North");
        northLayoutPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JScrollPane scrollPane = new JScrollPane(northLayoutPanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.hideCB, "North");
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private void setTitleBorder(String title, JPanel panel) {
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(border, title);
        panel.setBorder(titleBorder);
    }

    private void onOk() {
        this.diffConfigComponent.setDataToDiffConfig(this.diffConfig);
        if (this.initialNameSorting != this.sortNameRB.isSelected()) {
            this.initialNameSorting = this.sortNameRB.isSelected();
            this.fireSortingChanged(this.initialNameSorting);
        }
        if (this.initialHideNoError != this.hideCB.isSelected()) {
            this.initialHideNoError = this.hideCB.isSelected();
            this.fireHidingChanged(this.initialHideNoError);
        }
        if (this.diffConfigComponent.isDataChanged()) {
            this.diffConfigComponent.setDataToDiffConfig(this.diffConfig);
            this.fireDiffConfigChanged();
        }
        this.setVisible(false);
    }

    private void fireSortingChanged(boolean isNameSorting) {
        for (int i = 0; i < this.diffUIConfigChangeListeners.size(); ++i) {
            DiffUIConfigChangeListener li = (DiffUIConfigChangeListener)this.diffUIConfigChangeListeners.get(i);
            li.sortingChanged(isNameSorting);
        }
    }

    private void fireHidingChanged(boolean hide) {
        for (int i = 0; i < this.diffUIConfigChangeListeners.size(); ++i) {
            DiffUIConfigChangeListener li = (DiffUIConfigChangeListener)this.diffUIConfigChangeListeners.get(i);
            li.hidingChanged(hide);
        }
    }

    private void fireDiffConfigChanged() {
        for (int i = 0; i < this.diffUIConfigChangeListeners.size(); ++i) {
            DiffUIConfigChangeListener li = (DiffUIConfigChangeListener)this.diffUIConfigChangeListeners.get(i);
            li.diffConfigChanged(this.diffConfig);
        }
    }
}

