/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffStructure;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLParameter;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Iterator;
import java.util.Stack;

public class GlobalDiffStructureBuilder
extends Traverser {
    public static final short TYP_TOPICS = 0;
    public static final short TYP_CLASSIFICATIONS = 1;
    public static final short TYP_FUNCTIONS = 2;
    private DiffStructure diffStructure = null;
    private Stack tbHierarchieStack = null;

    public static DiffStructure build(MetaPlausibilisierung plausibilisierung, short globaltype) {
        GlobalDiffStructureBuilder builder = new GlobalDiffStructureBuilder();
        return builder.buildIntern(plausibilisierung, globaltype);
    }

    private GlobalDiffStructureBuilder() {
    }

    private synchronized DiffStructure buildIntern(MetaPlausibilisierung plausibilisierung, short globaltype) {
        if (plausibilisierung == null) {
            throw new NullPointerException();
        }
        this.tbHierarchieStack = new Stack();
        this.diffStructure = new DiffStructure();
        MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)plausibilisierung;
        this.diffStructure.setMetaPlausibilisierung(plausi);
        switch (globaltype) {
            case 1: {
                this.visitElements(plausi.getAuspraegungsgruppen());
                break;
            }
            case 2: {
                this.visitElements(plausi.getFunktionen());
                break;
            }
            default: {
                this.visitElements(plausi.getThemenbereiche());
            }
        }
        return this.diffStructure;
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich anObject) {
        MetaCustomThemenbereich tb = (MetaCustomThemenbereich)anObject;
        this.tbHierarchieStack.push(tb);
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), tb);
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion anObject) {
        this.tbHierarchieStack.push(anObject);
        MetaCustomFunktion funktion = (MetaCustomFunktion)anObject;
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), funktion);
        this.visitElements(funktion.getParameter());
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitPLParameter(MetaPLParameter anObject) {
        this.tbHierarchieStack.push(anObject);
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), anObject);
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe anObject) {
        this.tbHierarchieStack.push(anObject);
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), anObject);
        Iterator it = anObject.getAuspraegungsComps().getAuspraegungen();
        while (it.hasNext()) {
            ((MetaAuspraegung)it.next()).accept(this);
        }
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitPLAuspraegung(MetaPLAuspraegung anObject) {
        this.tbHierarchieStack.push(anObject);
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), anObject);
        for (int i = 0; i < anObject.sizeOfAuspraegungen(); ++i) {
            anObject.getFromAuspraegungen(i).accept(this);
        }
        this.tbHierarchieStack.pop();
    }

    private String getTbHierarchyString() {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.tbHierarchieStack.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            String name = null;
            if (object instanceof MetaStatspezObjekt) {
                name = ((MetaStatspezObjekt)object).getName();
            } else if (object instanceof MetaPLInitwert) {
                name = ((MetaPLInitwert)object).getName();
            } else if (object instanceof MetaPLVariable) {
                name = ((MetaPLVariable)object).getName();
            } else if (object instanceof MetaTBMaterialReferenz) {
                name = ((MetaTBMaterialReferenz)object).getName();
            } else if (object instanceof MetaPLAuspraegung) {
                name = ((MetaPLAuspraegung)object).getName();
            } else if (object instanceof MetaPLParameter) {
                name = ((MetaPLParameter)object).getName();
            }
            buffer.append(name);
            if (!iterator.hasNext()) continue;
            buffer.append("___PKT___");
        }
        return buffer.toString();
    }
}

