/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.analysis.CrossReferenceBuilder;
import de.statspez.pleditor.generator.codegen.cpp.CppClassificationCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppErrorTextProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppExternalProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppMappingsCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppMehrfachantwortProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppPlausiElementCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppThemenbereichCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.DefaultTextResource;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.NamespaceHelper;
import de.statspez.pleditor.generator.codegen.support.PruefungIterator;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.codegen.support.TbScopeBuilder;
import de.statspez.pleditor.generator.codegen.support.TextResource;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLParameter;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class CppPlausiCodeGenerator
extends CppPlausiElementCodeGenerator {
    public static final int MAX_NESTED_TB = 1000;
    private MetaPlausibilisierung plausi = null;
    private Scope scope = null;
    private Hashtable scopes = null;
    private TextResource textResource = new DefaultTextResource();
    private String classNameSuffix = null;
    private Vector generatedTopics = new Vector();

    public void setTextResource(TextResource textResource) {
        if (textResource != null) {
            this.textResource = textResource;
        }
    }

    public void setClassNameSuffix(String classNameSuffix) {
        this.classNameSuffix = classNameSuffix;
    }

    public synchronized void generate(MetaPlausibilisierung aPlausi) {
        this.plausi = aPlausi;
        TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
        this.scopes = new Hashtable();
        this.scope = scopeBuilder.createScopes(aPlausi, this.scopes);
        if (!((MetaCustomPlausibilisierung)aPlausi).hasUsedMappings()) {
            this.warning(aPlausi, "keine Mappings definiert");
        }
        aPlausi.accept(this);
        this.checkForErrors();
        this.out.flush();
    }

    public synchronized void generate(MetaPlausibilisierung aPlausi, Scope plausiScope, Hashtable tbScopes) {
        this.plausi = aPlausi;
        this.scopes = tbScopes;
        this.scope = plausiScope;
        CrossReferenceBuilder crefBuilder = new CrossReferenceBuilder();
        crefBuilder.buildCrossReference(aPlausi, this.scope, this.scopes);
        aPlausi.accept(this);
        this.checkForErrors();
        this.out.flush();
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        this.print("#include \"Plausi.h\"");
        this.indentNewLine();
        this.indentNewLine();
        this.print("using namespace pl;");
        this.indentNewLine();
        this.indentNewLine();
        this.print("namespace ");
        this.print(this.namespaceForPlausi(plausi));
        this.openBlock();
        this.createPlausiFehlerFactoryMethod(plausi);
        this.indentNewLine();
        this.processPlausiElements(plausi);
        this.createMerkmalFehlerMethods(plausi);
        this.defineClass(this.classForPlausi(plausi), "Plausi");
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.print("public:");
        this.increaseIndentLevel();
        MetaThemenbereich rootTb = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich();
        this.indentNewLine();
        this.print(this.getTbClass(rootTb));
        this.print("* ");
        this.print("root");
        this.print(";");
        this.indentNewLine();
        this.createPlausiConstructor(plausi);
        this.indentNewLine();
        this.indentNewLine();
        this.print("const PL_STRING getName()");
        this.openBlock();
        this.indentNewLine();
        this.print("return \"");
        this.print(plausi.getName());
        this.print("\";");
        this.closeBlock();
        this.indentNewLine();
        this.indentNewLine();
        this.print("PL_REAL getSystemVersion()");
        this.openBlock();
        this.indentNewLine();
        this.print("return 1.0;");
        this.closeBlock();
        this.indentNewLine();
        String genDateStr = "";
        Date genDate = ((MetaCustomPlausibilisierung)plausi).getGenDate();
        if (genDate != null) {
            SimpleDateFormat time_formatter = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.GERMANY);
            genDateStr = time_formatter.format(genDate);
        }
        this.indentNewLine();
        this.print("const PL_STRING getVersionString()");
        this.openBlock();
        this.indentNewLine();
        this.print("return \"");
        this.print(genDateStr);
        this.print("\";");
        this.closeBlock();
        this.indentNewLine();
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.print("protected:");
        this.increaseIndentLevel();
        this.createAblaufInvocationMethod(plausi);
        this.indentNewLine();
        this.createFunctionInvocationMethod(plausi);
        this.endClassDefinition();
        this.closeBlock();
        this.indentNewLine();
        this.indentNewLine();
        this.print("extern \"C\"");
        this.openBlock();
        this.indentNewLine();
        this.print("__declspec(dllexport) ");
        this.print("Plausi");
        this.print("* loadPlausi");
        this.print(this.namespaceForPlausi(plausi));
        this.print("()");
        this.openBlock();
        this.indentNewLine();
        this.print("return new ");
        this.print(this.namespaceForPlausi(plausi));
        this.print("::");
        this.print(this.classForPlausi(plausi));
        this.print("();");
        this.closeBlock();
        this.indentNewLine();
        this.indentNewLine();
        this.print("__declspec(dllexport) void unloadPlausi");
        this.print(this.namespaceForPlausi(plausi));
        this.print("(");
        this.print("Plausi");
        this.print("* plausi)");
        this.openBlock();
        this.indentNewLine();
        this.print("delete plausi;");
        this.closeBlock();
        this.closeBlock();
    }

    @Override
    public void visitMerkmal(MetaMerkmal aMerkmal) {
        MetaCustomMerkmal merkmal = (MetaCustomMerkmal)aMerkmal;
        if (merkmal.referencedByErhebung()) {
            String programName = merkmal.getMetaSpezifikation().name();
            this.defineMethod("PL_VOID", "prb_" + programName, "RuntimeContext* context, ProblemInfoType infoType, const PL_STRING exception = PL_NULL");
            this.print(";");
            this.indentNewLine();
            CppProgramCodeGenerator prgGen = new CppProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            prgGen.setErrorContext(new ElementMessageContext(5, merkmal.getId(), merkmal.getName()));
            prgGen.generate(merkmal.getMetaSpezifikation(), new ScopeImpl(this.scope), true);
            if (CodegenUtil.containsMehrfachantwortTbFieldForMerkmal(this.plausi, merkmal)) {
                this.indentNewLine();
                CppMehrfachantwortProgramCodeGenerator gen = new CppMehrfachantwortProgramCodeGenerator();
                gen.setOutput(this.out);
                gen.setIndentLevel(this.indentLevel());
                gen.generate(merkmal);
            }
        }
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion aFunktion) {
        MetaCustomFunktion funktion = (MetaCustomFunktion)aFunktion;
        String art = funktion.getArt();
        if ("extern".equals(art)) {
            CppExternalProgramCodeGenerator externalProgramGenerator = new CppExternalProgramCodeGenerator();
            externalProgramGenerator.setOutput(this.out);
            externalProgramGenerator.setIndentLevel(this.indentLevel());
            funktion.accept(externalProgramGenerator);
        } else {
            if ("ref".equals(art)) {
                throw new IllegalStateException("Allgemeine Referenzfunktionen werden nicht unterst\u00fctzt.");
            }
            CppProgramCodeGenerator prgGen = new CppProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            prgGen.setErrorContext(new ElementMessageContext(4, funktion.getId(), funktion.getName()));
            prgGen.generate(funktion.getMetaSpezifikation(), new ScopeImpl(this.scope), false);
        }
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        if (this.generatedTopics.contains(tb)) {
            return;
        }
        this.generatedTopics.add(tb);
        Iterator iter = tb.getFelder();
        while (iter.hasNext()) {
            MetaTBFeld feld = (MetaTBFeld)iter.next();
            if (!(feld.getKlasse() instanceof MetaThemenbereich)) continue;
            feld.getKlasse().accept(this);
        }
        CppThemenbereichCodeGenerator tbGen = new CppThemenbereichCodeGenerator();
        tbGen.setOutput(this.out);
        tbGen.setIndentLevel(this.indentLevel());
        tbGen.setTextResource(this.textResource);
        tbGen.setErrorContext(new ElementMessageContext(6, tb.getId(), tb.getName()));
        tbGen.generate(tb, (Scope)this.scopes.get(tb.getName()), (MetaCustomPlausibilisierung)this.plausi);
        this.indentNewLine();
    }

    private void createPlausiConstructor(MetaPlausibilisierung aPlausi) {
        MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)aPlausi;
        this.defineMethod("", this.classForPlausi(plausi), "");
        this.openBlock();
        this.declareClassifications(plausi);
        this.declareMappings(plausi);
        this.declareFeatures(plausi);
        this.declareMaterials(plausi);
        this.indentNewLine();
        this.print("root");
        this.print(" = new ");
        this.print(this.getTbClass(plausi.rootThemenbereich()));
        this.print("(new ");
        this.print("TypeDescriptor");
        this.print("(PL_NULL, getMapping(), \"");
        this.print("__root_tb__");
        this.print("\", PL_NULL, fieldTypeStructure, PL_NULL, 0), PL_NULL, this);");
        this.indentNewLine();
        this.print("setRootTopic(");
        this.print("root");
        this.print(");");
        this.closeBlock();
    }

    private void declareClassifications(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        CppClassificationCodeGenerator codeGen = new CppClassificationCodeGenerator(this);
        codeGen.preGeneration();
        Iterator it = plausi.getAuspraegungsgruppen();
        while (it.hasNext()) {
            ((MetaAuspraegungsgruppe)it.next()).accept(codeGen);
        }
    }

    private void declareMappings(MetaPlausibilisierung plausi) {
        CppMappingsCodeGenerator codeGen = new CppMappingsCodeGenerator(this);
        codeGen.preGeneration();
        plausi.accept(codeGen);
    }

    private void declareMaterials(MetaPlausibilisierung plausi) {
        MetaPLMaterial[] materials = CodegenUtil.getUsedMaterials(plausi);
        if (materials != null && materials.length > 0) {
            this.indentNewLine();
            this.print("Topic");
            this.print("* material;");
            this.indentNewLine();
            for (int i = 0; i < materials.length; ++i) {
                this.indentNewLine();
                this.print("material = new ");
                this.print(this.getTbClass(materials[i].getThemenbereich()));
                this.print("(new ");
                this.print("TypeDescriptor");
                this.print("(PL_NULL, getMappingForMaterial(\"");
                this.print(materials[i].getName());
                this.print("\"), \"");
                this.print(materials[i].getMapping().getThemenbereich().getName());
                this.print("\", PL_NULL, fieldTypeStructure, PL_NULL, 0), PL_NULL, this);");
                this.indentNewLine();
                this.print("material->setMaterialName(\"");
                this.print(materials[i].getName());
                this.print("\");");
                this.indentNewLine();
                this.print("material->setMaterialNameDataset(\"");
                this.print(materials[i].getDSB().getName());
                this.print("\");");
                this.indentNewLine();
                this.print("setMaterial(\"");
                this.print(materials[i].getName());
                this.print("\", material);");
                this.indentNewLine();
            }
        }
    }

    private void declareFeatures(MetaPlausibilisierung plausi) {
        ((MetaCustomPlausibilisierung)plausi).rootThemenbereich().accept(new Traverser(){
            private NamespaceHelper helper = new NamespaceHelper();

            @Override
            public void visitTBFeld(MetaTBFeld anObject) {
                this.helper.enterSubNamespace(anObject.getName());
                if (anObject.getKlasse() instanceof MetaThemenbereich) {
                    anObject.getKlasse().accept(this);
                } else {
                    MetaCustomMerkmal merkmal = (MetaCustomMerkmal)anObject.getKlasse();
                    CppPlausiCodeGenerator.this.indentNewLine();
                    CppPlausiCodeGenerator.this.out.print("setFieldCheckProc(\"");
                    CppPlausiCodeGenerator.this.out.print(this.helper.prettyNamespace());
                    CppPlausiCodeGenerator.this.out.print("\", ");
                    CppPlausiCodeGenerator.this.out.print("prg_");
                    CppPlausiCodeGenerator.this.out.print(StringHelper.getEscapedName(merkmal.getMetaSpezifikation().name()));
                    CppPlausiCodeGenerator.this.out.print(");");
                }
                this.helper.leaveSubNamespace();
            }
        });
        this.indentNewLine();
    }

    private void createAblaufInvocationMethod(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        this.defineMethod("PL_VOID", "performFlow", "RuntimeContext* context, const PL_STRING flow");
        this.openBlock();
        MetaThemenbereich rootTb = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich();
        MetaPLAblauf stdAblauf = ((MetaCustomPlausibilisierung)plausi).standardAblauf();
        this.indentNewLine();
        this.print("if (flow == PL_NULL)");
        this.openBlock();
        if (stdAblauf != null) {
            if (rootTb.sizeOfInitialisierungswerte() > 0) {
                this.indentNewLine();
                this.print("root");
                this.print("->");
                this.print("init");
                this.print("(context");
                Iterator iter = rootTb.getInitialisierungswerte();
                while (iter.hasNext()) {
                    MetaCustomInitwert initwert = (MetaCustomInitwert)iter.next();
                    this.print(", context->getInitParam(\"");
                    this.print(initwert.getName());
                    this.print("\")");
                }
                this.print(");");
            }
            this.indentNewLine();
            this.print("root");
            this.print("->");
            this.print("prg_");
            this.print(StringHelper.getEscapedName(stdAblauf.getName()));
            this.print("(context);");
        } else {
            this.indentNewLine();
            this.print("throw PlausiException(exceptionTypeNoSuchProc, \"Es wurde kein Ablauf vorgegeben und es konnte kein Standard-Ablauf ermittelt werden.\");");
            this.warning(plausi, "es konnte kein Standard-Ablauf ermittelt werden");
        }
        this.closeBlock();
        this.indentNewLine();
        this.print("else");
        this.openBlock();
        Iterator it = rootTb.getAblaeufe();
        boolean firstIf = true;
        while (it.hasNext()) {
            MetaPLAblauf ablauf = (MetaPLAblauf)it.next();
            this.indentNewLine();
            if (!firstIf) {
                this.print("else ");
            } else {
                firstIf = false;
            }
            this.print("if (strcmp(flow, \"");
            this.print(ablauf.getName());
            this.print("\") == 0)");
            this.openBlock();
            if (rootTb.sizeOfInitialisierungswerte() > 0) {
                this.indentNewLine();
                this.print("root");
                this.print("->");
                this.print("init");
                this.print("(context");
                Iterator iter = rootTb.getInitialisierungswerte();
                while (iter.hasNext()) {
                    MetaCustomInitwert initwert = (MetaCustomInitwert)iter.next();
                    this.print(", context->getInitParam(\"");
                    this.print(initwert.getName());
                    this.print("\")");
                }
                this.print(");");
            }
            this.indentNewLine();
            this.print("root");
            this.print("->");
            this.print("prg_");
            this.print(StringHelper.getEscapedName(ablauf.getName()));
            this.print("(context);");
            this.closeBlock();
        }
        this.indentNewLine();
        this.print("else");
        this.openBlock();
        this.indentNewLine();
        this.print("throw PlausiException(exceptionTypeNoSuchProc, flow);");
        this.closeBlock();
        this.closeBlock();
        this.closeBlock();
    }

    private void createPlausiFehlerFactoryMethod(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        this.defineMethod("PlausiProblem*", "createPlausiProblem", "RuntimeContext* context, const PL_STRING key, const PL_STRING field = PL_NULL");
        this.openBlock();
        PruefungIterator pruefungIt = new PruefungIterator(plausi);
        pruefungIt.eachPruefung(new PruefungIterator.CodeBlock(){
            private HashSet definierteSchluessel = new HashSet();

            @Override
            public void doForPruefung(MetaCustomPruefung pruefung, MetaCustomThemenbereich tb) {
                CppPlausiCodeGenerator.this.setErrorContext(new ElementMessageContext(6, tb.getId(), tb.getName()));
                if (this.definierteSchluessel.contains(pruefung.getPruefschluessel())) {
                    CppPlausiCodeGenerator.this.error(pruefung, "Der Pruefschluessel " + pruefung.getPruefschluessel() + " wird in dieser Plausibilisierung bereits verwendet");
                } else {
                    this.definierteSchluessel.add(pruefung.getPruefschluessel());
                }
                CppPlausiCodeGenerator.this.indentNewLine();
                CppPlausiCodeGenerator.this.out.print("if (strcmp(\"");
                CppPlausiCodeGenerator.this.out.print(pruefung.getPruefschluessel());
                CppPlausiCodeGenerator.this.out.print("\", key) == 0)");
                CppPlausiCodeGenerator.this.openBlock();
                CppPlausiCodeGenerator.this.createPlausiFehlerErzeugung(pruefung.getPruefschluessel(), CppPlausiCodeGenerator.this.textResource.getFehlertextKurz(pruefung), CppPlausiCodeGenerator.this.textResource.getFehlertextLang(pruefung), CppPlausiCodeGenerator.this.textResource.getKorrekturhinweis(pruefung), pruefung.getThemenbereich().getName(), pruefung.getFehlergewicht(), pruefung.getPruefungsart(), pruefung.hauptbezugsfeldIndex(), (short)0, null, 0L, null, null);
                CppPlausiCodeGenerator.this.indentNewLine();
                CppPlausiCodeGenerator.this.out.print("return problem;");
                CppPlausiCodeGenerator.this.closeBlock();
            }
        });
        this.setErrorContext((MessageContextInterface)null);
        this.indentNewLine();
        Iterator merkmalIt = plausi.getMerkmale();
        while (merkmalIt.hasNext()) {
            MetaCustomMerkmal merkmal = (MetaCustomMerkmal)merkmalIt.next();
            this.print("if (strcmp(\"");
            this.print(merkmal.getName());
            this.print("\", key) == 0)");
            this.openBlock();
            this.createPlausiFehlerErzeugung(merkmal.getName(), this.textResource.getFehlertextKurz(merkmal), this.textResource.getFehlertextLang(merkmal), this.textResource.getKorrekturhinweis(merkmal), "Merkmalpruefung", (short)9, (short)1, null, merkmal.getTyp(), merkmal.getMaske(), merkmal.getLaenge(), CodegenUtil.getValueSpaceAsString(merkmal), CodegenUtil.getDisplayName(this.textResource, merkmal));
            Map fields = CodegenUtil.getFieldsForMerkmalWithHierarchy(plausi, merkmal);
            if (fields != null && !fields.isEmpty()) {
                boolean generateElse = false;
                for (Map.Entry entry : fields.entrySet()) {
                    String fieldHierarchy = (String)entry.getKey();
                    MetaCustomTBFeld field = (MetaCustomTBFeld)entry.getValue();
                    String errorTextShort = this.textResource.getFehlertextKurz(field);
                    String errorTextLong = this.textResource.getFehlertextLang(field);
                    String correctionAdvice = this.textResource.getKorrekturhinweis(field);
                    if (!(errorTextShort != null && errorTextShort.length() > 0 || errorTextLong != null && errorTextLong.length() > 0) && (correctionAdvice == null || correctionAdvice.length() <= 0)) continue;
                    this.indentNewLine();
                    if (generateElse) {
                        this.print("else ");
                    } else {
                        generateElse = true;
                    }
                    this.print("if (field != PL_NULL && strcmp(\"");
                    this.print(fieldHierarchy);
                    this.print("\", field) == 0)");
                    this.openBlock();
                    if (errorTextShort != null && errorTextShort.length() > 0) {
                        this.indentNewLine();
                        this.print("problem->setShortDescription(\"");
                        this.print(StringHelper.getEscapedStringValue(errorTextShort));
                        this.print("\");");
                    }
                    if (errorTextLong != null && errorTextLong.length() > 0) {
                        this.indentNewLine();
                        this.print("problem->setLongDescription(\"");
                        this.print(StringHelper.getEscapedStringValue(errorTextLong));
                        this.print("\");");
                    }
                    if (correctionAdvice != null && correctionAdvice.length() > 0) {
                        this.indentNewLine();
                        this.print("problem->setCorrectionInfo(\"");
                        this.print(StringHelper.getEscapedStringValue(correctionAdvice));
                        this.print("\");");
                    }
                    this.closeBlock();
                }
            }
            this.indentNewLine();
            this.print("return problem;");
            this.closeBlock();
            if (!merkmalIt.hasNext()) continue;
            this.indentNewLine();
        }
        this.indentNewLine();
        this.out.print("throw PlausiException(exceptionTypeWrongParameter, \"Ungueltiger Pruefschluessel.\");");
        this.closeBlock();
    }

    private void createFunctionInvocationMethod(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        this.defineMethod("Value*", "performFunction", "RuntimeContext* context, const PL_STRING function");
        this.openBlock();
        this.indentNewLine();
        this.print("if (function == PL_NULL)");
        this.openBlock();
        this.indentNewLine();
        this.print("throw PlausiException(exceptionTypeWrongParameter, \"Kein Funktionsname angegeben.\");");
        this.closeBlock();
        MetaThemenbereich rootTb = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich();
        Iterator it = rootTb.getFunktionen();
        while (it.hasNext()) {
            MetaPLFunktion funktion = (MetaPLFunktion)it.next();
            this.indentNewLine();
            this.print("if (strcmp(function, \"");
            this.print(funktion.getName());
            this.print("\") == 0)");
            this.openBlock();
            this.indentNewLine();
            this.print("return ");
            this.print("root");
            this.print("->");
            this.print("prg_");
            this.print(StringHelper.getEscapedName(funktion.getName()));
            this.print("(context");
            if (funktion.sizeOfParameter() > 0) {
                Iterator params = funktion.getParameter();
                while (params.hasNext()) {
                    MetaPLParameter param = (MetaPLParameter)params.next();
                    this.print(", context->getInitParam(\"");
                    this.print(param.getName());
                    this.print("\")");
                }
            }
            this.print(");");
            this.closeBlock();
        }
        this.indentNewLine();
        this.print("throw PlausiException(exceptionTypeNoSuchProc, function);");
        this.closeBlock();
    }

    private void createMerkmalFehlerMethods(MetaPlausibilisierung plausi) {
        Iterator iter = plausi.getMerkmale();
        while (iter.hasNext()) {
            MetaCustomMerkmal merkmal = (MetaCustomMerkmal)iter.next();
            this.createMerkmalFehlerMethod(merkmal);
            this.indentNewLine();
        }
    }

    protected void createMerkmalFehlerMethod(MetaCustomMerkmal merkmal) {
        String programName = merkmal.getMetaSpezifikation().name();
        String checkKey = merkmal.getName();
        this.defineMethod("PL_VOID", "prb_" + programName, "RuntimeContext* context, ProblemInfoType infoType, const PL_STRING exception");
        this.openBlock();
        this.indentNewLine();
        this.print("PL_CHAR hierarchy[MAX_FIELD_NAME_LENGTH];");
        this.indentNewLine();
        this.print("context->getCurrentField()->getTypeDescriptor()->getHierarchyAsString(hierarchy);");
        this.indentNewLine();
        this.print("PlausiProblem");
        this.print("* problem = createPlausiProblem(context, \"");
        this.print(checkKey);
        this.print("\", hierarchy);");
        this.indentNewLine();
        this.print("problem->setInfoType(infoType);");
        this.indentNewLine();
        this.print("context->setSectionInfosToProblem(problem);");
        List<MetaCustomTBFeld> fields = CodegenUtil.getFieldsForMerkmal(this.plausi, merkmal);
        HashMap<MetaThemenbereich, List<MetaTBFeld>> fieldsWithErrorShortProgram = new HashMap<MetaThemenbereich, List<MetaTBFeld>>();
        HashMap<MetaThemenbereich, List<MetaTBFeld>> fieldsWithErrorLongProgram = new HashMap<MetaThemenbereich, List<MetaTBFeld>>();
        HashMap<MetaThemenbereich, List<MetaTBFeld>> fieldsWithCorrectionAdviceProgram = new HashMap<MetaThemenbereich, List<MetaTBFeld>>();
        for (MetaCustomTBFeld field : fields) {
            List<MetaCustomTBFeld> tbFiels;
            if (field.getFehlerTextKurzProgram() != null) {
                tbFiels = (ArrayList)fieldsWithErrorShortProgram.get(field.getThemenbereich());
                if (tbFiels == null) {
                    tbFiels = new ArrayList();
                    fieldsWithErrorShortProgram.put(field.getThemenbereich(), tbFiels);
                }
                if (!tbFiels.contains(field)) {
                    tbFiels.add(field);
                }
            }
            if (field.getFehlerTextLangProgram() != null) {
                tbFiels = (List)fieldsWithErrorLongProgram.get(field.getThemenbereich());
                if (tbFiels == null) {
                    tbFiels = new ArrayList();
                    fieldsWithErrorLongProgram.put(field.getThemenbereich(), tbFiels);
                }
                if (!tbFiels.contains(field)) {
                    tbFiels.add(field);
                }
            }
            if (field.getKorrekturhinweisProgram() == null) continue;
            tbFiels = (List)fieldsWithCorrectionAdviceProgram.get(field.getThemenbereich());
            if (tbFiels == null) {
                tbFiels = new ArrayList();
                fieldsWithCorrectionAdviceProgram.put(field.getThemenbereich(), tbFiels);
            }
            if (tbFiels.contains(field)) continue;
            tbFiels.add(field);
        }
        MetaProgram errorTextShortProgram = this.textResource.getFehlertextKurzProgram(merkmal);
        MetaProgram errorTextLongProgram = this.textResource.getFehlertextLangProgram(merkmal);
        MetaProgram correctionAdviceProgram = this.textResource.getKorrekturhinweisProgram(merkmal);
        if (!(fieldsWithErrorShortProgram.isEmpty() && fieldsWithErrorLongProgram.isEmpty() && fieldsWithCorrectionAdviceProgram.isEmpty())) {
            this.indentNewLine();
            this.print("FieldDescriptor* parent = context->getCurrentField()->getParent();");
        }
        this.printErrorTextPrograms("setShortDescription", errorTextShortProgram, fieldsWithErrorShortProgram, "prbShort_");
        this.printErrorTextPrograms("setLongDescription", errorTextLongProgram, fieldsWithErrorLongProgram, "prbLong_");
        this.printErrorTextPrograms("setCorrectionInfo", correctionAdviceProgram, fieldsWithCorrectionAdviceProgram, "corrInf_");
        this.indentNewLine();
        this.print("PL_CHAR problemId[MAX_FIELD_NAME_LENGTH];");
        this.indentNewLine();
        this.print("context->getCurrentField()->getHierarchyAsString(problemId);");
        this.indentNewLine();
        this.print("strcat(problemId, \"#");
        this.print(checkKey);
        this.print("\");");
        this.indentNewLine();
        this.print("problem->setId(problemId);");
        this.indentNewLine();
        this.print("problem->setReferenceField(context->getCurrentField());");
        this.indentNewLine();
        this.print("problem->setException(exception);");
        this.indentNewLine();
        this.print("context->getLogger()->trace() << \"FehlerID angeschrieben: \" << problem->getId();");
        this.closeBlock();
    }

    private void printErrorTextPrograms(String setMethodName, MetaProgram defaultProgram, Map<MetaThemenbereich, List<MetaTBFeld>> fieldsWithErrorTextProgram, String errorTextMethodPrefix) {
        if (defaultProgram != null || !fieldsWithErrorTextProgram.isEmpty()) {
            this.indentNewLine();
            this.print("try");
            this.openBlock();
            this.indentNewLine();
            this.print("PL_CHAR problemText[MAX_PROBLEM_TEXT_LENGTH];");
            this.indentNewLine();
            this.print("std::ostrstream problemTextOut(problemText, MAX_PROBLEM_TEXT_LENGTH);");
            CppErrorTextProgramCodeGenerator prgGen = new CppErrorTextProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            if (!fieldsWithErrorTextProgram.isEmpty()) {
                this.indentNewLine();
                this.print("PL_BOOL handled = PL_FALSE;");
                boolean firstTb = true;
                for (MetaThemenbereich tb : fieldsWithErrorTextProgram.keySet()) {
                    boolean isRootTb;
                    String tbClass = this.getTbClass(tb);
                    boolean bl = isRootTb = tb == ((MetaCustomPlausibilisierung)this.plausi).rootThemenbereich();
                    if (firstTb) {
                        firstTb = false;
                        this.indentNewLine();
                    } else {
                        this.indentNewLine();
                        this.print("else ");
                    }
                    this.print("if (");
                    if (isRootTb) {
                        this.print("parent == PL_NULL");
                    } else {
                        this.print("dynamic_cast<");
                        this.print(tbClass);
                        this.print("*>(parent) != PL_NULL");
                    }
                    this.print(")");
                    this.openBlock();
                    boolean firstField = true;
                    for (MetaTBFeld field : fieldsWithErrorTextProgram.get(tb)) {
                        if (firstField) {
                            firstField = false;
                            this.indentNewLine();
                        } else {
                            this.indentNewLine();
                            this.print("else ");
                        }
                        this.print("if (strcmp(\"");
                        this.print(StringHelper.getEscapedStringValue(field.getName()));
                        this.print("\", context->getCurrentField()->getTypeDescriptor()->getFieldNameTopic()) == 0)");
                        this.openBlock();
                        this.indentNewLine();
                        if (isRootTb) {
                            this.print("((");
                            this.print(tbClass);
                            this.print("*)((RootField*)context->getCurrentField())->getRoot())");
                        } else {
                            this.print("((");
                            this.print(tbClass);
                            this.print("*)parent)");
                        }
                        this.print("->");
                        this.print(errorTextMethodPrefix);
                        this.print(StringHelper.getEscapedName(field.getName()));
                        this.print("(context, problemTextOut);");
                        this.indentNewLine();
                        this.print("handled = PL_TRUE;");
                        this.closeBlock();
                    }
                    this.closeBlock();
                }
            }
            if (defaultProgram != null) {
                if (!fieldsWithErrorTextProgram.isEmpty()) {
                    this.indentNewLine();
                    this.print("if (!handled)");
                    this.openBlock();
                }
                this.indentNewLine();
                this.print("problemTextOut << ");
                prgGen.generate(defaultProgram, this.scope, false);
                this.print(" << std::ends;");
                if (!fieldsWithErrorTextProgram.isEmpty()) {
                    this.closeBlock();
                }
            }
            this.indentNewLine();
            this.print("problem->");
            this.print(setMethodName);
            this.print("(problemText);");
            this.closeBlock();
            this.indentNewLine();
            this.print("catch (...)");
            this.openBlock();
            this.closeBlock();
        }
    }

    private String namespaceForPlausi(MetaPlausibilisierung plausi) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(StringHelper.getEscapedName(plausi.getPLName()));
        return buffer.toString();
    }

    private String classForPlausi(MetaPlausibilisierung plausi) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Plausi_");
        buffer.append(StringHelper.getEscapedName(plausi.getPLName()));
        if (this.classNameSuffix != null && this.classNameSuffix.length() > 0) {
            buffer.append('_');
            buffer.append(this.classNameSuffix);
        }
        return buffer.toString();
    }

    private void processPlausiElements(MetaPlausibilisierung plausi) {
        Iterator it = plausi.getMerkmale();
        while (it.hasNext()) {
            MetaMerkmal aMerkmal = (MetaMerkmal)it.next();
            aMerkmal.accept(this);
            this.indentNewLine();
        }
        it = plausi.getFunktionen();
        while (it.hasNext()) {
            MetaPLFunktion aFunktion = (MetaPLFunktion)it.next();
            aFunktion.accept(this);
            this.indentNewLine();
        }
        this.generatedTopics.clear();
        ((MetaCustomPlausibilisierung)plausi).rootThemenbereich().accept(this);
    }
}

