/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis;

import de.statspez.pleditor.generator.codegen.pl.HierarchicalCodeConverter;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.Helper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ReferencedFieldsResolver {
    public String[] getReferencedFields(MetaThemenbereich tb, MetaElement element) {
        ArrayList<String> referencedFields = new ArrayList<String>();
        element.accept(new Resolver(tb, null, referencedFields));
        return referencedFields.toArray(new String[referencedFields.size()]);
    }

    private class StructureElement {
        private final MetaTBFeld field;
        private final String indices;

        private StructureElement(MetaTBFeld field) {
            this(field, (String)null);
        }

        private StructureElement(MetaTBFeld field, String indices) {
            this.field = field;
            this.indices = indices;
        }

        public String getAccess() {
            return this.field.getName() + (this.indices != null ? this.indices : "");
        }

        public MetaThemenbereich getTopic() {
            return (MetaThemenbereich)this.field.getKlasse();
        }
    }

    private class Resolver
    extends Traverser {
        private MetaThemenbereich tb;
        private List<String> referencedFields;
        private Stack<StructureElement> structure;
        private String prefix;

        public Resolver(MetaThemenbereich tb, String prefix, List<String> referencedFields) {
            this.tb = tb;
            this.referencedFields = referencedFields;
            this.prefix = prefix;
            this.structure = new Stack();
        }

        private MetaThemenbereich getCurrentTopic() {
            if (this.structure.isEmpty()) {
                return this.tb;
            }
            return this.structure.peek().getTopic();
        }

        private String getCurrentPrefix() {
            StringBuilder builder = new StringBuilder();
            if (this.prefix != null) {
                builder.append(this.prefix);
            }
            for (int i = 0; i < this.structure.size(); ++i) {
                builder.append(((StructureElement)this.structure.get(i)).getAccess());
                builder.append(".");
            }
            return builder.toString();
        }

        private MetaTBFeld getField(String name) {
            Iterator topicFields = this.getCurrentTopic().getFelder();
            while (topicFields.hasNext()) {
                MetaTBFeld topicField = (MetaTBFeld)topicFields.next();
                if (!topicField.getName().equals(name)) continue;
                return topicField;
            }
            return null;
        }

        private MetaPLFunktion getFunction(String name) {
            Iterator iter = this.getCurrentTopic().getFunktionen();
            while (iter.hasNext()) {
                MetaPLFunktion function = (MetaPLFunktion)iter.next();
                if (!function.getName().equals(name)) continue;
                return function;
            }
            return null;
        }

        private MetaPLAblauf getFlow(String name) {
            Iterator iter = this.getCurrentTopic().getAblaeufe();
            while (iter.hasNext()) {
                MetaPLAblauf flow = (MetaPLAblauf)iter.next();
                if (!flow.getName().equals(name)) continue;
                return flow;
            }
            return null;
        }

        private MetaPLPruefung getCheck(String name) {
            Iterator iter = this.getCurrentTopic().getPruefungen();
            while (iter.hasNext()) {
                MetaPLPruefung check = (MetaPLPruefung)iter.next();
                if (!check.getName().equals(name)) continue;
                return check;
            }
            return null;
        }

        private void enterStructure(MetaValueAccess structure) {
            structure.accept(new Traverser(){

                @Override
                public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
                    Resolver.this.visitElements(anArrayAccess.indices());
                }
            });
            structure.accept(new Traverser(){

                @Override
                public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
                    Resolver.this.structure.push(new StructureElement(Resolver.this.getField(aFieldAccess.accessedField().value())));
                }

                @Override
                public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
                    Resolver.this.structure.push(new StructureElement(Resolver.this.getField(anArrayAccess.accessedArray().value()), Resolver.this.getArrayIndices(anArrayAccess)));
                }
            });
        }

        private void leaveStructure(MetaValueAccess structure) {
            structure.accept(new Traverser(){

                @Override
                public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
                    Resolver.this.structure.pop();
                }

                @Override
                public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
                    Resolver.this.structure.pop();
                }
            });
        }

        private void addField(String field, String indices) {
            MetaTBFeld topicField = this.getField(field);
            if (topicField != null && topicField.getKlasse() instanceof MetaMerkmal) {
                String name = this.getCurrentPrefix() + field;
                if (indices != null) {
                    name = name + indices;
                }
                if (!this.referencedFields.contains(name) && !name.contains("[?]")) {
                    this.referencedFields.add(name);
                }
            }
        }

        @Override
        public void visitProgram(MetaProgram aProgram) {
            if (aProgram.containsHierarchicalFunction()) {
                HierarchicalCodeConverter converter = new HierarchicalCodeConverter();
                String simpleProgramCode = converter.generate(aProgram);
                MetaProgram simpleProgram = Helper.metaStructureFor(simpleProgramCode);
                simpleProgram.statements().accept(this);
            } else {
                super.visitProgram(aProgram);
            }
        }

        @Override
        public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
            this.addField(aFieldAccess.accessedField().value(), null);
        }

        @Override
        public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
            this.addField(anArrayAccess.accessedArray().value(), this.getArrayIndices(anArrayAccess));
            super.visitArrayAccess(anArrayAccess);
        }

        @Override
        public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
            this.enterStructure(aStructureAccess.structureAccess());
            aStructureAccess.selectedElement().accept(this);
            this.leaveStructure(aStructureAccess.structureAccess());
        }

        @Override
        public void visitFunctionCall(MetaFunctionCall aStatement) {
            if (aStatement.function().adaptedObject() instanceof MetaIdentifier) {
                MetaIdentifier identifier = (MetaIdentifier)aStatement.function().adaptedObject();
                String name = identifier.value();
                if (!InternalFunctions.instance().isInternalFunction(name)) {
                    this.getFunction(name).accept(new Resolver(this.getCurrentTopic(), this.getCurrentPrefix(), this.referencedFields));
                }
            } else {
                MetaStructureAccess structureAccess = (MetaStructureAccess)aStatement.function().adaptedObject();
                MetaFieldAccess fieldAccess = (MetaFieldAccess)structureAccess.selectedElement();
                String name = fieldAccess.accessedField().value();
                this.enterStructure(structureAccess.structureAccess());
                this.getFunction(name).accept(new Resolver(this.getCurrentTopic(), this.getCurrentPrefix(), this.referencedFields));
                this.leaveStructure(structureAccess.structureAccess());
            }
            this.visitElements(aStatement.parameters());
        }

        @Override
        public void visitAblaufStatement(MetaAblaufStatement aStatement) {
            if (aStatement.function().adaptedObject() instanceof MetaIdentifier) {
                MetaIdentifier identifier = (MetaIdentifier)aStatement.function().adaptedObject();
                String name = identifier.value();
                this.getFlow(name).accept(new Resolver(this.getCurrentTopic(), this.getCurrentPrefix(), this.referencedFields));
            } else {
                MetaStructureAccess structureAccess = (MetaStructureAccess)aStatement.function().adaptedObject();
                MetaFieldAccess fieldAccess = (MetaFieldAccess)structureAccess.selectedElement();
                String name = fieldAccess.accessedField().value();
                this.enterStructure(structureAccess.structureAccess());
                this.getFlow(name).accept(new Resolver(this.getCurrentTopic(), this.getCurrentPrefix(), this.referencedFields));
                this.leaveStructure(structureAccess.structureAccess());
            }
        }

        @Override
        public void visitPruefeStatement(MetaPruefeStatement aStatement) {
            if (aStatement.function().adaptedObject() instanceof MetaIdentifier) {
                MetaIdentifier identifier = (MetaIdentifier)aStatement.function().adaptedObject();
                String name = identifier.value();
                this.getCheck(name).accept(new Resolver(this.getCurrentTopic(), this.getCurrentPrefix(), this.referencedFields));
            } else {
                MetaStructureAccess structureAccess = (MetaStructureAccess)aStatement.function().adaptedObject();
                MetaFieldAccess fieldAccess = (MetaFieldAccess)structureAccess.selectedElement();
                String name = fieldAccess.accessedField().value();
                this.enterStructure(structureAccess.structureAccess());
                this.getCheck(name).accept(new Resolver(this.getCurrentTopic(), this.getCurrentPrefix(), this.referencedFields));
                this.leaveStructure(structureAccess.structureAccess());
            }
        }

        @Override
        public void visitMaterialAccess(MetaMaterialAccess anAccess) {
            this.visitElements(anAccess.selectionConditions());
        }

        @Override
        public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
            anAssignment.rightValue().accept(this);
        }

        @Override
        public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
            anAssignment.rightValue().accept(this);
        }

        private String getArrayIndices(MetaArrayAccess anArrayAccess) {
            StringBuilder indices = new StringBuilder();
            Iterator iter = anArrayAccess.indices();
            while (iter.hasNext()) {
                MetaLiteralAccess literalAccess;
                MetaFactor factor;
                String index = "?";
                MetaElement element = (MetaElement)iter.next();
                if (element instanceof MetaFactor && (factor = (MetaFactor)element).adaptedObject() instanceof MetaLiteralAccess && (literalAccess = (MetaLiteralAccess)factor.adaptedObject()).accessedLiteral() instanceof MetaNumber) {
                    MetaNumber number = (MetaNumber)literalAccess.accessedLiteral();
                    index = "" + number.value().intValue();
                }
                indices.append("[");
                indices.append(index);
                indices.append("]");
            }
            return indices.toString();
        }
    }
}

