/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx.parser.impl;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.olap4j.Axis;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.DrillThroughNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.mdx.KeySegment;
import org.olap4j.mdx.LiteralNode;
import org.olap4j.mdx.NameSegment;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.PropertyValueNode;
import org.olap4j.mdx.Quoting;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.Syntax;
import org.olap4j.mdx.WithMemberNode;
import org.olap4j.mdx.WithSetNode;
import org.olap4j.mdx.parser.MdxParseException;
import org.olap4j.mdx.parser.impl.DefaultMdxParserImpl;
import org.olap4j.mdx.parser.impl.MdxParserImplConstants;
import org.olap4j.mdx.parser.impl.MdxParserImplTokenManager;
import org.olap4j.mdx.parser.impl.ParseException;
import org.olap4j.mdx.parser.impl.SimpleCharStream;
import org.olap4j.mdx.parser.impl.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdxParserImpl
implements MdxParserImplConstants {
    private DefaultMdxParserImpl.FunTable funTable;
    private boolean strictValidation;
    private static final Comparator<AxisNode> AXIS_NODE_COMPARATOR = new Comparator<AxisNode>(){

        @Override
        public int compare(AxisNode o1, AxisNode o2) {
            return o1.getAxis().axisOrdinal() - o2.getAxis().axisOrdinal();
        }
    };
    private static final String DQ = "\"";
    private static final String DQDQ = "\"\"";
    public MdxParserImplTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[55];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[8];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public MdxParserImpl(String queryString, boolean debug, DefaultMdxParserImpl.FunTable funTable, boolean strictValidation) {
        this(new StringReader(MdxParserImpl.term(queryString)));
        this.funTable = funTable;
        this.strictValidation = strictValidation;
    }

    private static String term(String s) {
        return s.endsWith("\n") ? s : s + "\n";
    }

    public void setTabSize(int tabSize) {
        this.jj_input_stream.setTabSize(tabSize);
    }

    ParseTreeNode recursivelyParseExp(String s) throws ParseException {
        MdxParserImpl parser = new MdxParserImpl(s, false, this.funTable, this.strictValidation);
        return parser.expression();
    }

    private ParseRegion region(Token token) {
        return new ParseRegion(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
    }

    ParseRegion region(ParseTreeNode node, List<ParseTreeNode> nodes) {
        return node.getRegion().plus(nodes);
    }

    private List<ParseRegion> regionList(final List<ParseTreeNode> nodes) {
        return new AbstractList<ParseRegion>(){

            @Override
            public ParseRegion get(int index) {
                return ((ParseTreeNode)nodes.get(index)).getRegion();
            }

            @Override
            public int size() {
                return nodes.size();
            }
        };
    }

    ParseRegion region(final ParseTreeNode ... nodes) {
        return ParseRegion.sum((Iterable<ParseRegion>)new AbstractList<ParseRegion>(){

            @Override
            public ParseRegion get(int index) {
                return nodes[index].getRegion();
            }

            @Override
            public int size() {
                return nodes.length;
            }
        });
    }

    private static String stripQuotes(String s, String prefix, String suffix, String quoted) {
        assert (s.startsWith(prefix) && s.endsWith(suffix));
        s = s.substring(prefix.length(), s.length() - suffix.length());
        s = Olap4jUtil.replace(s, quoted, suffix);
        return s;
    }

    private ParseTreeNode createCall(ParseTreeNode left, IdentifierSegment segment, List<ParseTreeNode> argList) {
        Syntax syntax;
        if (argList != null) {
            if (left != null) {
                argList.add(0, left);
                return new CallNode(segment.getRegion().plus(argList), segment.getName(), Syntax.Method, argList);
            }
            return new CallNode(segment.getRegion().plus(argList), segment.getName(), Syntax.Function, argList);
        }
        boolean call = false;
        switch (segment.getQuoting()) {
            case UNQUOTED: {
                syntax = Syntax.Property;
                call = this.funTable.isProperty(segment.getName());
                break;
            }
            case QUOTED: {
                syntax = Syntax.QuotedProperty;
                break;
            }
            default: {
                syntax = Syntax.AmpersandQuotedProperty;
            }
        }
        if (left instanceof IdentifierNode && !call) {
            return ((IdentifierNode)left).append(segment);
        }
        if (left == null) {
            return new IdentifierNode(segment);
        }
        return new CallNode(segment.getRegion().plusAll(Arrays.asList(left.getRegion())), segment.getName(), syntax, left);
    }

    public final ParseTreeNode statementEof() throws ParseException {
        ParseTreeNode qp = this.statement();
        this.jj_consume_token(0);
        return qp;
    }

    public final ParseTreeNode expressionEof() throws ParseException {
        ParseTreeNode e = this.expression();
        this.jj_consume_token(0);
        return e;
    }

    public final IdentifierSegment identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 29: {
                String id = this.keyword();
                return new NameSegment(null, id, Quoting.UNQUOTED);
            }
            case 79: {
                this.jj_consume_token(79);
                return new NameSegment(this.region(this.token), this.token.image, Quoting.UNQUOTED);
            }
            case 80: {
                this.jj_consume_token(80);
                return new NameSegment(this.region(this.token), MdxParserImpl.stripQuotes(this.token.image, "[", "]", "]]"), Quoting.QUOTED);
            }
            case 81: 
            case 82: {
                KeySegment keyId = this.keyIdentifier();
                return keyId;
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final KeySegment keyIdentifier() throws ParseException {
        ArrayList<NameSegment> list = new ArrayList<NameSegment>();
        block3: while (true) {
            NameSegment key = this.ampId();
            list.add(key);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: 
                case 82: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[1] = this.jj_gen;
        return new KeySegment(list);
    }

    public final NameSegment ampId() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 81: {
                this.jj_consume_token(81);
                return new NameSegment(this.region(this.token), MdxParserImpl.stripQuotes(this.token.image, "&[", "]", "]]"), Quoting.QUOTED);
            }
            case 82: {
                this.jj_consume_token(82);
                return new NameSegment(this.region(this.token), this.token.image.substring(1), Quoting.UNQUOTED);
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String keyword() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                return "Dimension";
            }
            case 29: {
                this.jj_consume_token(29);
                return "Properties";
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final IdentifierNode compoundId() throws ParseException {
        ArrayList<IdentifierSegment> list = new ArrayList<IdentifierSegment>();
        IdentifierSegment i = this.identifier();
        list.add(i);
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(58);
            i = this.identifier();
            list.add(i);
        }
        return new IdentifierNode(list);
    }

    public final ParseTreeNode unaliasedExpression() throws ParseException {
        ParseTreeNode x;
        block9: {
            x = this.term5();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: 
                    case 38: 
                    case 55: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        this.jj_consume_token(26);
                        ParseTreeNode y = this.term5();
                        x = new CallNode(this.region(x, y), "OR", Syntax.Infix, x, y);
                        continue block8;
                    }
                    case 38: {
                        this.jj_consume_token(38);
                        ParseTreeNode y = this.term5();
                        x = new CallNode(this.region(x, y), "XOR", Syntax.Infix, x, y);
                        continue block8;
                    }
                    case 55: {
                        this.jj_consume_token(55);
                        ParseTreeNode y = this.term5();
                        x = new CallNode(this.region(x, y), ":", Syntax.Infix, x, y);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[5] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return x;
    }

    public final ParseTreeNode term5() throws ParseException {
        ParseTreeNode x = this.term4();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(1);
            ParseTreeNode y = this.term4();
            x = new CallNode(this.region(x, y), "AND", Syntax.Infix, x, y);
        }
        return x;
    }

    public final ParseTreeNode term4() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 9: 
            case 24: 
            case 29: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                ParseTreeNode x = this.term3();
                return x;
            }
            case 23: {
                this.jj_consume_token(23);
                Token op = this.token;
                ParseTreeNode x = this.term4();
                return new CallNode(this.region(op).plus(x), "NOT", Syntax.Prefix, x);
            }
        }
        this.jj_la1[7] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ParseTreeNode term3() throws ParseException {
        ParseTreeNode x;
        block26: {
            x = this.term2();
            block22: while (true) {
                ParseTreeNode y;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: 
                    case 18: 
                    case 19: 
                    case 23: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 63: 
                    case 65: 
                    case 67: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block26;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 59: 
                    case 60: 
                    case 61: 
                    case 63: 
                    case 65: 
                    case 67: {
                        Token op;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 59: {
                                this.jj_consume_token(59);
                                op = this.token;
                                break;
                            }
                            case 67: {
                                this.jj_consume_token(67);
                                op = this.token;
                                break;
                            }
                            case 65: {
                                this.jj_consume_token(65);
                                op = this.token;
                                break;
                            }
                            case 61: {
                                this.jj_consume_token(61);
                                op = this.token;
                                break;
                            }
                            case 63: {
                                this.jj_consume_token(63);
                                op = this.token;
                                break;
                            }
                            case 60: {
                                this.jj_consume_token(60);
                                op = this.token;
                                break;
                            }
                            default: {
                                this.jj_la1[9] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        y = this.term2();
                        x = new CallNode(this.region(x, y), op.image, Syntax.Infix, x, y);
                        continue block22;
                    }
                }
                this.jj_la1[10] = this.jj_gen;
                if (this.jj_2_2(2)) {
                    this.jj_consume_token(18);
                    this.jj_consume_token(24);
                    x = new CallNode(x.getRegion(), "IS NULL", Syntax.Postfix, x);
                    continue;
                }
                if (this.jj_2_3(2)) {
                    this.jj_consume_token(18);
                    y = this.term2();
                    x = new CallNode(this.region(x, y), "IS", Syntax.Infix, x, y);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        this.jj_consume_token(18);
                        this.jj_consume_token(12);
                        x = new CallNode(x.getRegion(), "IS EMPTY", Syntax.Postfix, x);
                        continue block22;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        y = this.term2();
                        x = new CallNode(this.region(x, y), "MATCHES", Syntax.Infix, x, y);
                        continue block22;
                    }
                }
                this.jj_la1[11] = this.jj_gen;
                if (this.jj_2_4(2)) {
                    this.jj_consume_token(23);
                    this.jj_consume_token(19);
                    y = this.term2();
                    x = new CallNode(this.region(x, y), "NOT", Syntax.Prefix, new CallNode(this.region(x, y), "MATCHES", Syntax.Infix, x, y));
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        this.jj_consume_token(17);
                        y = this.term2();
                        x = new CallNode(this.region(x, y), "IN", Syntax.Infix, x, y);
                        continue block22;
                    }
                    case 23: {
                        this.jj_consume_token(23);
                        this.jj_consume_token(17);
                        y = this.term2();
                        x = new CallNode(this.region(x, y), "NOT", Syntax.Prefix, new CallNode(this.region(x, y), "IN", Syntax.Infix, x, y));
                        continue block22;
                    }
                }
                break;
            }
            this.jj_la1[12] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return x;
    }

    public final ParseTreeNode term2() throws ParseException {
        ParseTreeNode x;
        block9: {
            x = this.term();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 57: 
                    case 66: 
                    case 68: {
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 68: {
                        this.jj_consume_token(68);
                        ParseTreeNode y = this.term();
                        x = new CallNode(this.region(x, y), "+", Syntax.Infix, x, y);
                        continue block8;
                    }
                    case 66: {
                        this.jj_consume_token(66);
                        ParseTreeNode y = this.term();
                        x = new CallNode(this.region(x, y), "-", Syntax.Infix, x, y);
                        continue block8;
                    }
                    case 57: {
                        this.jj_consume_token(57);
                        ParseTreeNode y = this.term();
                        x = new CallNode(this.region(x, y), "||", Syntax.Infix, x, y);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[14] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return x;
    }

    public final ParseTreeNode term() throws ParseException {
        ParseTreeNode x;
        block8: {
            x = this.factor();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 53: 
                    case 71: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 53: {
                        this.jj_consume_token(53);
                        ParseTreeNode y = this.factor();
                        x = new CallNode(this.region(x, y), "*", Syntax.Infix, x, y);
                        continue block7;
                    }
                    case 71: {
                        this.jj_consume_token(71);
                        ParseTreeNode y = this.factor();
                        x = new CallNode(this.region(x, y), "/", Syntax.Infix, x, y);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[16] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return x;
    }

    public final ParseTreeNode factor() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 9: 
            case 24: 
            case 29: 
            case 62: 
            case 64: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                ParseTreeNode p = this.primary();
                return p;
            }
            case 68: {
                this.jj_consume_token(68);
                ParseTreeNode p = this.primary();
                return p;
            }
            case 66: {
                this.jj_consume_token(66);
                Token op = this.token;
                ParseTreeNode p = this.primary();
                return new CallNode(this.region(op).plus(p), "-", Syntax.Prefix, p);
            }
        }
        this.jj_la1[17] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ParseTreeNode primary() throws ParseException {
        ParseTreeNode e = this.atom();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(58);
            e = this.segmentOrFuncall(e);
        }
        return e;
    }

    public final ParseTreeNode segmentOrFuncall(ParseTreeNode left) throws ParseException {
        List<ParseTreeNode> argList = null;
        IdentifierSegment segment = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                argList = this.jj_2_5(Integer.MAX_VALUE) ? Collections.emptyList() : this.expOrEmptyList();
                this.jj_consume_token(70);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        return this.createCall(left, segment, argList);
    }

    public final LiteralNode numericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: {
                this.jj_consume_token(74);
                return LiteralNode.createNumeric(this.region(this.token), new BigDecimal(this.token.image), false);
            }
            case 72: {
                this.jj_consume_token(72);
                return LiteralNode.createNumeric(this.region(this.token), new BigDecimal(this.token.image), false);
            }
            case 73: {
                this.jj_consume_token(73);
                return LiteralNode.createNumeric(this.region(this.token), new BigDecimal(this.token.image), true);
            }
        }
        this.jj_la1[20] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ParseTreeNode atom() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 76: {
                this.jj_consume_token(76);
                return LiteralNode.createString(this.region(this.token), MdxParserImpl.stripQuotes(this.token.image, "'", "'", "''"));
            }
            case 77: {
                this.jj_consume_token(77);
                return LiteralNode.createString(this.region(this.token), MdxParserImpl.stripQuotes(this.token.image, DQ, DQ, DQDQ));
            }
            case 72: 
            case 73: 
            case 74: {
                LiteralNode e = this.numericLiteral();
                return e;
            }
            case 24: {
                this.jj_consume_token(24);
                return LiteralNode.createNull(this.region(this.token));
            }
            case 5: {
                this.jj_consume_token(5);
                Token op = this.token;
                this.jj_consume_token(64);
                ParseTreeNode e = this.unaliasedExpression();
                this.jj_consume_token(2);
                IdentifierSegment segment = this.identifier();
                this.jj_consume_token(70);
                return new CallNode(this.region(op).plus(this.region(this.token)), "CAST", Syntax.Cast, e, LiteralNode.createSymbol(segment.getRegion(), segment.getName()));
            }
            case 64: {
                this.jj_consume_token(64);
                Token op = this.token;
                List<ParseTreeNode> lis = this.expList();
                this.jj_consume_token(70);
                return new CallNode(this.region(op).plus(this.region(this.token)), "()", Syntax.Parentheses, lis);
            }
            case 62: {
                List<ParseTreeNode> lis;
                this.jj_consume_token(62);
                Token op = this.token;
                if (this.jj_2_6(Integer.MAX_VALUE)) {
                    lis = Collections.emptyList();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 4: 
                        case 5: 
                        case 9: 
                        case 23: 
                        case 24: 
                        case 29: 
                        case 62: 
                        case 64: 
                        case 66: 
                        case 68: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 76: 
                        case 77: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: {
                            lis = this.expList();
                            break;
                        }
                        default: {
                            this.jj_la1[21] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                this.jj_consume_token(69);
                return new CallNode(this.region(op).plus(this.region(this.token)), "{}", Syntax.Braces, lis);
            }
            case 4: {
                ParseTreeNode e = this.caseExpression();
                return e;
            }
            case 9: 
            case 29: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                List<Object> lis;
                IdentifierSegment segment = this.identifier();
                ParseRegion region = segment.getRegion();
                block20: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 54: {
                            break;
                        }
                        default: {
                            this.jj_la1[22] = this.jj_gen;
                            break block20;
                        }
                    }
                    this.jj_consume_token(54);
                    segment = this.identifier();
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 64: {
                        this.jj_consume_token(64);
                        lis = this.jj_2_7(Integer.MAX_VALUE) ? Collections.emptyList() : this.expOrEmptyList();
                        this.jj_consume_token(70);
                        region = region.plus(this.region(this.token));
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                        lis = null;
                    }
                }
                if (lis == null) {
                    return new IdentifierNode(segment);
                }
                return new CallNode(region.plus(lis), segment.getName(), Syntax.Function, lis);
            }
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ParseTreeNode caseExpression() throws ParseException {
        ParseTreeNode e;
        ArrayList<ParseTreeNode> list = new ArrayList<ParseTreeNode>();
        boolean match = false;
        this.jj_consume_token(4);
        ParseRegion region = this.region(this.token);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 9: 
            case 23: 
            case 24: 
            case 29: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                e = this.expression();
                match = true;
                list.add(e);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(36);
            e = this.expression();
            this.jj_consume_token(35);
            ParseTreeNode e2 = this.expression();
            list.add(e);
            list.add(e2);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                e = this.expression();
                list.add(e);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        this.jj_consume_token(13);
        if (match) {
            return new CallNode(region.plus(this.region(this.token)), "_CaseMatch", Syntax.Case, list);
        }
        return new CallNode(region.plus(this.region(this.token)), "_CaseTest", Syntax.Case, list);
    }

    public final ParseTreeNode expression() throws ParseException {
        ParseTreeNode e = this.unaliasedExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(2);
            IdentifierSegment i = this.identifier();
            IdentifierNode id = new IdentifierNode(i);
            e = new CallNode(this.region(e, id), "AS", Syntax.Infix, e, id);
        }
        return e;
    }

    public final ParseTreeNode expressionOrEmpty() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 9: 
            case 23: 
            case 24: 
            case 29: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                ParseTreeNode e = this.expression();
                return e;
            }
        }
        this.jj_la1[29] = this.jj_gen;
        return new CallNode(this.region(this.token), "", Syntax.Empty, new ParseTreeNode[0]);
    }

    public final List<ParseTreeNode> expOrEmptyList() throws ParseException {
        LinkedList<ParseTreeNode> list = new LinkedList<ParseTreeNode>();
        ParseTreeNode e = this.expressionOrEmpty();
        list.add(e);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 56: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(56);
            e = this.expressionOrEmpty();
            list.add(e);
        }
        return list;
    }

    public final List<ParseTreeNode> expList() throws ParseException {
        LinkedList<ParseTreeNode> list = new LinkedList<ParseTreeNode>();
        ParseTreeNode e = this.expression();
        list.add(e);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 56: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(56);
            e = this.expression();
            list.add(e);
        }
        return list;
    }

    public final ParseTreeNode statement() throws ParseException {
        ParseTreeNode qp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: 
            case 39: {
                qp = this.selectStatement();
                break;
            }
            case 10: {
                qp = this.drillthroughStatement();
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return qp;
    }

    public final ParseTreeNode selectOrDrillthroughStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: 
            case 39: {
                SelectNode qp = this.selectStatement();
                return qp;
            }
            case 10: {
                ParseTreeNode qp = this.drillthroughStatement();
                return qp;
            }
        }
        this.jj_la1[33] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SelectNode selectStatement() throws ParseException {
        ArrayList<ParseTreeNode> f = new ArrayList<ParseTreeNode>();
        ParseTreeNode w = null;
        ArrayList<AxisNode> a = new ArrayList<AxisNode>();
        ArrayList<IdentifierNode> cellPropList = new ArrayList<IdentifierNode>();
        ParseRegion region = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                this.jj_consume_token(39);
                region = this.region(this.token);
                block28: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            ParseTreeNode e = this.memberSpecification();
                            f.add(e);
                            break;
                        }
                        case 34: {
                            ParseTreeNode e = this.setSpecification();
                            f.add(e);
                            break;
                        }
                        default: {
                            this.jj_la1[34] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: 
                        case 34: {
                            continue block28;
                        }
                    }
                    break;
                }
                this.jj_la1[35] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        this.jj_consume_token(33);
        if (region == null) {
            region = this.region(this.token);
        }
        block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 9: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                AxisNode i = this.axisSpecification();
                a.add(i);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 56: {
                            break;
                        }
                        default: {
                            this.jj_la1[37] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(56);
                    i = this.axisSpecification();
                    a.add(i);
                }
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        this.jj_consume_token(16);
        ParseTreeNode c = this.cubeOrSelect();
        region = region.plus(c);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                w = this.expression();
                region = region.plus(w);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        block19 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 29: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        this.jj_consume_token(6);
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                    }
                }
                this.jj_consume_token(29);
                IdentifierNode p = this.compoundId();
                cellPropList.add(p);
                region = region.plus(w);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 56: {
                            break;
                        }
                        default: {
                            this.jj_la1[41] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(56);
                    p = this.compoundId();
                    cellPropList.add(p);
                    region = region.plus(w);
                }
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        Collections.sort(a, AXIS_NODE_COMPARATOR);
        return new SelectNode(region, f, a, c, w == null ? null : new AxisNode(w.getRegion(), false, Axis.FILTER, null, w), cellPropList);
    }

    public final ParseTreeNode cubeOrSelect() throws ParseException {
        ParseTreeNode c;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 29: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                c = this.compoundId();
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                c = this.selectStatement();
                this.jj_consume_token(70);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return c;
    }

    public final WithMemberNode memberSpecification() throws ParseException {
        ArrayList<PropertyValueNode> l = new ArrayList<PropertyValueNode>();
        this.jj_consume_token(21);
        ParseRegion region = this.region(this.token);
        IdentifierNode m = this.compoundId();
        this.jj_consume_token(2);
        ParseTreeNode e = this.formulaExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 56: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(56);
            PropertyValueNode mp = this.memberPropertyDefinition();
            l.add(mp);
        }
        return new WithMemberNode(region.plus(e).plus(l), m, e, l);
    }

    public final ParseTreeNode formulaExpression() throws ParseException {
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            this.jj_consume_token(76);
            return this.recursivelyParseExp(MdxParserImpl.stripQuotes(this.token.image, "'", "'", "''"));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 9: 
            case 23: 
            case 24: 
            case 29: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                ParseTreeNode e = this.unaliasedExpression();
                return e;
            }
        }
        this.jj_la1[45] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final PropertyValueNode memberPropertyDefinition() throws ParseException {
        IdentifierSegment i = this.identifier();
        this.jj_consume_token(59);
        ParseTreeNode e = this.expression();
        return new PropertyValueNode(i.getRegion().plus(e), i.getName(), e);
    }

    public final WithSetNode setSpecification() throws ParseException {
        this.jj_consume_token(34);
        IdentifierNode n = this.compoundId();
        this.jj_consume_token(2);
        ParseTreeNode e = this.formulaExpression();
        return new WithSetNode(n.getRegion().plus(e), n, e);
    }

    public final AxisNode axisSpecification() throws ParseException {
        Axis axis;
        boolean nonEmpty = false;
        ArrayList<IdentifierNode> dp = new ArrayList<IdentifierNode>();
        ParseRegion region = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                region = this.region(this.token);
                this.jj_consume_token(12);
                nonEmpty = true;
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
            }
        }
        ParseTreeNode e = this.expression();
        if (region == null) {
            region = e.getRegion();
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 29: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.jj_consume_token(9);
                        break;
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                    }
                }
                this.jj_consume_token(29);
                IdentifierNode p = this.compoundId();
                dp.add(p);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 56: {
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(56);
                    p = this.compoundId();
                    dp.add(p);
                }
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        this.jj_consume_token(25);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                axis = Axis.COLUMNS;
                region = region.plus(this.region(this.token));
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                axis = Axis.ROWS;
                region = region.plus(this.region(this.token));
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                axis = Axis.PAGES;
                region = region.plus(this.region(this.token));
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                axis = Axis.SECTIONS;
                region = region.plus(this.region(this.token));
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                axis = Axis.CHAPTERS;
                region = region.plus(this.region(this.token));
                break;
            }
            case 3: 
            case 72: 
            case 73: 
            case 74: {
                ParseRegion axisRegion;
                LiteralNode n;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 72: 
                    case 73: 
                    case 74: {
                        n = this.numericLiteral();
                        axisRegion = this.region(this.token);
                        region = region.plus(axisRegion);
                        break;
                    }
                    case 3: {
                        this.jj_consume_token(3);
                        axisRegion = this.region(this.token);
                        this.jj_consume_token(64);
                        n = this.numericLiteral();
                        this.jj_consume_token(70);
                        axisRegion = axisRegion.plus(this.region(this.token));
                        region = region.plus(axisRegion);
                        break;
                    }
                    default: {
                        this.jj_la1[50] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Number number = (Number)n.getValue();
                if (number.doubleValue() < 0.0 || number.doubleValue() != (double)number.intValue()) {
                    throw new MdxParseException(axisRegion, "Invalid axis specification. The axis number must be a non-negative integer, but it was " + number + ".");
                }
                axis = Axis.Factory.forOrdinal(number.intValue());
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new AxisNode(region, nonEmpty, axis, dp, e);
    }

    public final ParseTreeNode drillthroughStatement() throws ParseException {
        int m = 0;
        int f = 0;
        List<ParseTreeNode> rl = null;
        this.jj_consume_token(10);
        ParseRegion region = this.region(this.token);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                this.jj_consume_token(72);
                m = Integer.valueOf(this.token.image);
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                this.jj_consume_token(72);
                f = Integer.valueOf(this.token.image);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
            }
        }
        SelectNode s = this.selectStatement();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                rl = this.returnItemList();
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        return new DrillThroughNode(region.plus(s).plus(rl), s, m, f, rl);
    }

    public final List<ParseTreeNode> returnItemList() throws ParseException {
        ArrayList<ParseTreeNode> list = new ArrayList<ParseTreeNode>();
        IdentifierNode i = this.returnItem();
        list.add(i);
        this.jj_consume_token(56);
        i = this.returnItem();
        list.add(i);
        return list;
    }

    public final IdentifierNode returnItem() throws ParseException {
        IdentifierNode i = this.compoundId();
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    private boolean jj_3R_41() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3_7() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_50() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_40() {
        return this.jj_scan_token(72);
    }

    private boolean jj_3R_47() {
        Token xsp;
        if (this.jj_3R_50()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_50());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_19() {
        return this.jj_3R_20();
    }

    private boolean jj_3_5() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_36() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_40()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_41()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_39() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_45() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(80);
    }

    private boolean jj_3R_43() {
        return this.jj_scan_token(79);
    }

    private boolean jj_3R_35() {
        return this.jj_3R_38();
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(69);
    }

    private boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_43()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_44()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_45()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_42() {
        return this.jj_3R_46();
    }

    private boolean jj_3_1() {
        return this.jj_scan_token(58);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_34() {
        return this.jj_3R_37();
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_19();
    }

    private boolean jj_3R_25() {
        return this.jj_3R_26();
    }

    private boolean jj_3R_33() {
        return this.jj_scan_token(62);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_24() {
        return this.jj_scan_token(66);
    }

    private boolean jj_3R_32() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_23() {
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_22() {
        return this.jj_3R_25();
    }

    private boolean jj_3R_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_22()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_23()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_24()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_49() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_48() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_49()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_31() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_30() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_29() {
        return this.jj_3R_36();
    }

    private boolean jj_3_8() {
        return this.jj_scan_token(76);
    }

    private boolean jj_3R_28() {
        return this.jj_scan_token(77);
    }

    private boolean jj_3R_53() {
        return this.jj_scan_token(82);
    }

    private boolean jj_3R_20() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_27() {
        return this.jj_scan_token(76);
    }

    private boolean jj_3R_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_28()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_29()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_30()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_31()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_32()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_33()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_34()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_35()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_52() {
        return this.jj_scan_token(81);
    }

    private boolean jj_3R_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_53()) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x20000200, 0, 0, 0x20000200, 0x4000000, 0x4000000, 2, 562037296, 0x8E0000, 0, 0, 786432, 0x820000, 0, 0, 0, 0, 553648688, 0, 0, 0, 562037296, 0, 0, 553648688, 562037296, 0, 2048, 4, 562037296, 0, 0, 1024, 1024, 0x200000, 0x200000, 0, 0, 566231600, 0, 64, 0, 0x20000040, 0x20000200, 0, 562037296, 0x400000, 512, 0, 0x20000200, 8, -2013265528, 0x100000, 16384, 0x40000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0x800040, 0x800040, 0, 0x40000000, -1207959552, -1207959552, -1207959552, 0, 0, 0x2000000, 0x2000000, 0x200000, 0x200000, 0x40000000, 0x4000000, 0, 0, 0x40000000, 0x400000, 0, 0x40000000, 0x40000000, 16, 0, 0, 0x40000000, 0x1000000, 0x1000000, 130, 130, 4, 4, 128, 0x1000000, 0x40000000, 32, 0, 0x1000000, 0, 0, 0x1000000, 0x40000000, 0, 0, 0x1000000, 0, 0, 1, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{491520, 393216, 393216, 0, 0, 0, 0, 505621, 10, 10, 10, 0, 0, 20, 20, 128, 128, 505621, 0, 1, 1792, 505621, 0, 1, 505601, 505621, 0, 0, 0, 505621, 0, 0, 0, 0, 0, 0, 0, 0, 505621, 0, 0, 0, 0, 491521, 0, 505621, 0, 0, 0, 0, 1792, 1792, 0, 0, 0};
    }

    public MdxParserImpl(InputStream stream) {
        this(stream, null);
    }

    public MdxParserImpl(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new MdxParserImplTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 55; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 55; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public MdxParserImpl(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new MdxParserImplTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 55; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 55; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public MdxParserImpl(MdxParserImplTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 55; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(MdxParserImplTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 55; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[85];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 55; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 85; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 8; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        MdxParserImpl.jj_la1_init_0();
        MdxParserImpl.jj_la1_init_1();
        MdxParserImpl.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

