/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.util.List;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.Quoting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameSegment
implements IdentifierSegment {
    final String name;
    final Quoting quoting;
    private final ParseRegion region;

    public NameSegment(ParseRegion region, String name, Quoting quoting) {
        this.region = region;
        this.name = name;
        this.quoting = quoting;
        if (name == null) {
            throw new NullPointerException();
        }
        if (quoting != Quoting.QUOTED && quoting != Quoting.UNQUOTED) {
            throw new IllegalArgumentException();
        }
    }

    public NameSegment(String name) {
        this(null, name, Quoting.QUOTED);
    }

    @Override
    public String toString() {
        switch (this.quoting) {
            case UNQUOTED: {
                return this.name;
            }
            case QUOTED: {
                return IdentifierNode.quoteMdxIdentifier(this.name);
            }
        }
        throw Olap4jUtil.unexpected(this.quoting);
    }

    @Override
    public void toString(StringBuilder buf) {
        switch (this.quoting) {
            case UNQUOTED: {
                buf.append(this.name);
                return;
            }
            case QUOTED: {
                IdentifierNode.quoteMdxIdentifier(this.name, buf);
                return;
            }
        }
        throw Olap4jUtil.unexpected(this.quoting);
    }

    @Override
    public ParseRegion getRegion() {
        return this.region;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Quoting getQuoting() {
        return this.quoting;
    }

    @Override
    public List<NameSegment> getKeyParts() {
        return null;
    }
}

