/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedGraph<N, E extends Edge<N>> {
    private final List<E> edges = new ArrayList();
    private final Map<N, List<E>> linksFrom = new HashMap<N, List<E>>();
    private final Map<N, List<Pair<E, Boolean>>> linksToAndFrom = new HashMap<N, List<Pair<E, Boolean>>>();

    public void addEdge(E edge) {
        this.edges.add(edge);
        List<E> list = this.linksFrom.get(edge.getFrom());
        if (list == null) {
            list = new ArrayList();
            this.linksFrom.put(edge.getFrom(), list);
        }
        list.add(edge);
        List<Pair<Pair<E, Boolean>, Boolean>> list2 = this.linksToAndFrom.get(edge.getFrom());
        if (list2 == null) {
            list2 = new ArrayList<Pair<E, Boolean>>();
            this.linksToAndFrom.put(edge.getFrom(), list2);
        }
        list2.add(Pair.of(edge, Boolean.TRUE));
        List<Pair<Pair<E, Boolean>, Boolean>> list3 = this.linksToAndFrom.get(edge.getTo());
        if (list3 == null) {
            list3 = new ArrayList<Pair<E, Boolean>>();
            this.linksToAndFrom.put(edge.getTo(), list3);
        }
        list3.add(Pair.of(edge, Boolean.FALSE));
    }

    public List<List<E>> findAllPaths(N from, N to) {
        if (from.equals(to)) {
            return Collections.singletonList(Collections.emptyList());
        }
        ArrayList path = new ArrayList();
        HashSet activeNodes = new HashSet();
        ArrayList<List<E>> pathList = new ArrayList<List<E>>();
        this.findSuccessorPaths(pathList, path, activeNodes, from, to);
        return pathList;
    }

    public List<List<Pair<E, Boolean>>> findAllPathsUndirected(N from, N to) {
        if (from.equals(to)) {
            return Collections.singletonList(Collections.emptyList());
        }
        ArrayList<Pair<E, Boolean>> path = new ArrayList<Pair<E, Boolean>>();
        HashSet activeNodes = new HashSet();
        ArrayList<List<Pair<E, Boolean>>> pathList = new ArrayList<List<Pair<E, Boolean>>>();
        this.findSuccessorPathsUndirected(pathList, path, activeNodes, from, to);
        return pathList;
    }

    private void findSuccessorPaths(List<List<E>> pathList, List<E> path, Set<N> activeNodes, N from, N to) {
        List<E> successors = this.linksFrom.get(from);
        if (successors == null) {
            return;
        }
        if (!activeNodes.add(from)) {
            throw new RuntimeException("Graph contains cycle: " + path);
        }
        for (Edge edge : successors) {
            path.add(edge);
            if (edge.getTo().equals(to)) {
                pathList.add(new ArrayList<E>(path));
            }
            this.findSuccessorPaths(pathList, path, activeNodes, edge.getTo(), to);
            path.remove(path.size() - 1);
        }
        activeNodes.remove(from);
    }

    private void findSuccessorPathsUndirected(List<List<Pair<E, Boolean>>> pathList, List<Pair<E, Boolean>> path, Set<N> activeNodes, N from, N to) {
        List<Pair<E, Boolean>> successors = this.linksToAndFrom.get(from);
        if (successors == null) {
            return;
        }
        if (!activeNodes.add(from)) {
            return;
        }
        for (Pair<E, Boolean> edge : successors) {
            Object edgeTo;
            path.add(edge);
            Object e = edgeTo = (Boolean)edge.right != false ? ((Edge)edge.left).getTo() : ((Edge)edge.left).getFrom();
            if (edgeTo.equals(to)) {
                pathList.add(new ArrayList<Pair<E, Boolean>>(path));
            } else {
                this.findSuccessorPathsUndirected(pathList, path, activeNodes, edgeTo, to);
            }
            path.remove(path.size() - 1);
        }
        activeNodes.remove(from);
    }

    public List<E> edgeList() {
        return this.edges;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Edge<E> {
        public E getFrom();

        public E getTo();
    }
}

