/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CsvLoader {
    protected static final Logger LOGGER = Logger.getLogger(CsvLoader.class);
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char SINGLE_QUOTE = '\'';
    public static final char BRACKET_START = '[';
    public static final char BRACKET_END = '[';
    public static final char PAREN_START = '(';
    public static final char PAREN_END = ')';
    public static final char BRACES_START = '{';
    public static final char BRACES_END = '}';
    public static final char CHEVRON_START = '<';
    public static final char CHEVRON_END = '>';
    private BufferedReader bufReader;
    private final char separator;
    private final boolean includesHeader;
    private int nextSet;
    private boolean inComment;
    private String[] columnNames;
    private String[] columns;

    public CsvLoader(InputStream in, String charset) throws UnsupportedEncodingException {
        this(new InputStreamReader(in, charset));
    }

    public CsvLoader(InputStream in, char separator, boolean includesHeader, String charset) throws UnsupportedEncodingException {
        this(new InputStreamReader(in, charset), separator, includesHeader);
    }

    public CsvLoader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public CsvLoader(InputStream in, char separator, boolean includesHeader) {
        this(new InputStreamReader(in), separator, includesHeader);
    }

    public CsvLoader(String filename) throws FileNotFoundException {
        this(new FileReader(filename));
    }

    public CsvLoader(String filename, char separator, boolean includesHeader) throws FileNotFoundException {
        this(new FileReader(filename), separator, includesHeader);
    }

    public CsvLoader(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public CsvLoader(File file, char separator, boolean includesHeader) throws FileNotFoundException {
        this(new FileReader(file), separator, includesHeader);
    }

    public CsvLoader(Reader reader) {
        this(reader, ',', false);
    }

    public CsvLoader(Reader reader, char separator, boolean includesHeader) {
        this.bufReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.separator = separator;
        this.includesHeader = includesHeader;
    }

    protected void initialize() throws IOException {
        if (this.columnNames == null) {
            if (this.columns == null) {
                this.columns = this.nextColumns();
            }
            if (this.columns == null) {
                if (this.nextSet > 0) {
                    return;
                }
                throw new IOException("No columns can be read");
            }
            if (!this.inComment) {
                if (this.includesHeader) {
                    this.columnNames = this.columns;
                    this.columns = null;
                } else {
                    this.columnNames = new String[this.columns.length];
                    for (int i = 0; i < this.columns.length; ++i) {
                        this.columnNames[i] = "Column" + i;
                    }
                }
            }
        }
    }

    public String[] getColumnNames() throws IOException {
        this.initialize();
        return this.columnNames;
    }

    public boolean inComment() {
        return this.inComment;
    }

    public boolean hasNextLine() throws IOException {
        this.initialize();
        if (this.bufReader == null) {
            return false;
        }
        if (this.columns != null) {
            return true;
        }
        this.columns = this.nextColumns();
        return this.columns != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] nextLine() {
        if (this.bufReader == null) {
            return null;
        }
        try {
            String[] stringArray = this.columns;
            return stringArray;
        }
        finally {
            this.columns = null;
        }
    }

    public int getNextSetCount() {
        return this.nextSet;
    }

    public void nextSet() {
        ++this.nextSet;
        this.columns = null;
        this.columnNames = null;
    }

    public void putBack(String[] columns) {
        this.columns = columns;
    }

    public void close() throws IOException {
        if (this.bufReader != null) {
            this.bufReader.close();
            this.bufReader = null;
        }
    }

    protected String[] nextColumns() throws IOException {
        StringBuilder buf = new StringBuilder();
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        boolean inBracket = false;
        boolean inParen = false;
        boolean inBraces = false;
        boolean inChevrons = false;
        String[] columns = null;
        ArrayList<String> list = null;
        if (this.columnNames == null) {
            list = new ArrayList<String>();
        } else {
            columns = new String[this.columnNames.length];
        }
        int columnCount = 0;
        do {
            String line;
            if ((line = this.bufReader.readLine()) == null) {
                return null;
            }
            this.recordInCommentLine(line);
            int pos = 0;
            while (pos < line.length()) {
                char c = line.charAt(pos++);
                if (inDoubleQuote) {
                    if (c == '\"') {
                        inDoubleQuote = false;
                    }
                } else if (inSingleQuote) {
                    if (c == '\'') {
                        inSingleQuote = false;
                    }
                } else if (inParen) {
                    if (c == ')') {
                        inParen = false;
                    }
                } else if (inBracket) {
                    if (c == '[') {
                        inBracket = false;
                    }
                } else if (inBraces) {
                    if (c == '}') {
                        inBraces = false;
                    }
                } else if (inChevrons) {
                    if (c == '>') {
                        inChevrons = false;
                    }
                } else if (c == '\"') {
                    inDoubleQuote = true;
                } else if (c == '\'') {
                    inSingleQuote = true;
                } else if (c == '[') {
                    inBracket = true;
                } else if (c == '(') {
                    inParen = true;
                } else if (c == '{') {
                    inBraces = true;
                } else if (c == '<') {
                    inChevrons = true;
                }
                if (inDoubleQuote || inSingleQuote || inParen || inBracket || inBraces || inChevrons) {
                    buf.append(c);
                    continue;
                }
                if (c == this.separator) {
                    String data = buf.toString();
                    if (list != null) {
                        list.add(data);
                    } else {
                        columns[columnCount++] = data;
                    }
                    buf.setLength(0);
                    continue;
                }
                buf.append(c);
            }
        } while (inDoubleQuote || inSingleQuote);
        String data = buf.toString();
        if (list != null) {
            list.add(data);
        } else {
            columns[columnCount++] = data;
        }
        if (list != null) {
            int size = list.size();
            columns = list.toArray(new String[size]);
        }
        if (LOGGER.isDebugEnabled()) {
            buf.setLength(0);
            buf.append("Columns: ");
            if (this.inComment) {
                buf.append("comment=true: ");
            }
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(column);
            }
            LOGGER.debug((Object)buf.toString());
        }
        return columns;
    }

    protected void recordInCommentLine(String line) {
        this.inComment = line.charAt(0) == '#';
    }

    public static void main(String[] args) throws Exception {
        char separator = ',';
        for (int cnt = 0; cnt < args.length; ++cnt) {
            String filename = args[cnt];
            System.out.println("FileName:" + filename);
            CsvLoader csvLoader = new CsvLoader(filename);
            String[] columnNames = csvLoader.getColumnNames();
            System.out.println("Column Names:");
            System.out.print("  ");
            for (int i = 0; i < columnNames.length; ++i) {
                System.out.print(columnNames[i]);
                if (i + 1 >= columnNames.length) continue;
                System.out.print(separator);
            }
            System.out.println();
            System.out.println("Data:");
            while (csvLoader.hasNextLine()) {
                System.out.print("  ");
                String[] columns = csvLoader.nextLine();
                for (int i = 0; i < columns.length; ++i) {
                    System.out.print(columns[i]);
                    if (i + 1 >= columns.length) continue;
                    System.out.print(separator);
                }
                System.out.println();
            }
        }
    }
}

