/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test.loader;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import mondrian.olap.Schema;
import mondrian.spi.Dialect;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;
import mondrian.test.loader.CsvDBLoader;
import mondrian.test.loader.DBLoader;

public abstract class CsvDBTestCase
extends FoodMartTestCase {
    private CsvDBLoader loader;
    private DBLoader.Table[] tables;
    private TestContext testContext;

    public CsvDBTestCase() {
    }

    public CsvDBTestCase(String name) {
        super(name);
    }

    protected final boolean isApplicable() {
        Dialect dialect = this.getTestContext().getDialect();
        return dialect.allowsDdl() && dialect.getDatabaseProduct() != Dialect.DatabaseProduct.INFOBRIGHT;
    }

    protected void setUp() throws Exception {
        if (!this.isApplicable()) {
            return;
        }
        super.setUp();
        Connection connection = this.getSqlConnection();
        String dirName = this.getDirectoryName();
        String fileName = this.getFileName();
        File inputFile = new File(dirName, fileName);
        this.loader = new CsvDBLoader();
        this.loader.setConnection(connection);
        this.loader.initialize();
        this.loader.setInputFile(inputFile);
        this.tables = this.loader.getTables();
        this.loader.generateStatements(this.tables);
        this.loader.executeStatements(this.tables);
        String parameterDefs = this.getParameterDescription();
        String cubeDefs = this.getCubeDescription();
        String virtualCubeDefs = this.getVirtualCubeDescription();
        String namedSetDefs = this.getNamedSetDescription();
        String udfDefs = this.getUdfDescription();
        String roleDefs = this.getRoleDescription();
        this.testContext = TestContext.instance().legacy().create(parameterDefs, cubeDefs, virtualCubeDefs, namedSetDefs, udfDefs, roleDefs);
    }

    protected void tearDown() throws Exception {
        if (!this.isApplicable()) {
            return;
        }
        try {
            this.loader.dropTables(this.tables);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.loader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tables = null;
        this.testContext = null;
        this.loader = null;
        super.tearDown();
    }

    protected Connection getSqlConnection() throws SQLException {
        return this.getConnection().getDataSource().getConnection();
    }

    protected Schema getSchema() {
        return this.getConnection().getSchema();
    }

    protected TestContext getCubeTestContext() {
        return this.testContext;
    }

    protected abstract String getDirectoryName();

    protected abstract String getFileName();

    protected String getParameterDescription() {
        return null;
    }

    protected abstract String getCubeDescription();

    protected String getVirtualCubeDescription() {
        return null;
    }

    protected String getNamedSetDescription() {
        return null;
    }

    protected String getUdfDescription() {
        return null;
    }

    protected String getRoleDescription() {
        return null;
    }
}

