/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Collection;
import java.util.List;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.MinusStarPredicate;
import mondrian.rolap.agg.PredicateColumn;
import mondrian.spi.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralColumnPredicate
extends AbstractColumnPredicate {
    private final boolean value;

    public LiteralColumnPredicate(PredicateColumn column, boolean value) {
        super(column);
        this.value = value;
    }

    public int hashCode() {
        return this.value ? 2 : 1;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof LiteralColumnPredicate && this.constrainedColumn == ((LiteralColumnPredicate)obj).constrainedColumn && this.value == ((LiteralColumnPredicate)obj).value;
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        return this.value;
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        return this.equals(that) || that == (this.value ? LiteralStarPredicate.TRUE : LiteralStarPredicate.FALSE);
    }

    @Override
    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public void toSql(Dialect dialect, StringBuilder buf) {
        buf.append(this.value);
    }

    @Override
    public void values(Collection<Object> collection) {
        collection.add(this.value);
    }

    @Override
    public boolean evaluate(Object value) {
        return this.value;
    }

    @Override
    public void describe(StringBuilder buf) {
        buf.append("=any");
    }

    @Override
    public StarColumnPredicate.Overlap intersect(StarColumnPredicate predicate) {
        return new StarColumnPredicate.Overlap(this.value, null, 0.0f);
    }

    @Override
    public boolean mightIntersect(StarPredicate other) {
        if (!this.value) {
            return false;
        }
        if (other instanceof LiteralColumnPredicate) {
            return ((LiteralColumnPredicate)other).value;
        }
        return true;
    }

    @Override
    public StarColumnPredicate minus(StarPredicate predicate) {
        assert (predicate != null);
        if (this.value) {
            return new MinusStarPredicate(this, (StarColumnPredicate)predicate);
        }
        return this;
    }

    public boolean getValue() {
        return this.value;
    }
}

