/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.SortedSet;
import mondrian.rolap.agg.AbstractSegmentBody;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DenseDoubleSegmentBody
extends AbstractSegmentBody {
    private static final long serialVersionUID = 5775717165497921144L;
    private final double[] values;
    private final BitSet nullValues;

    DenseDoubleSegmentBody(BitSet nullValues, double[] values, List<Pair<SortedSet<Comparable>, Boolean>> axes) {
        super(axes);
        this.values = values;
        this.nullValues = nullValues;
    }

    @Override
    public Object getValueArray() {
        return this.values;
    }

    @Override
    public BitSet getNullValueIndicators() {
        return this.nullValues;
    }

    @Override
    protected int getSize() {
        return this.values.length;
    }

    @Override
    protected Object getObject(int i) {
        double value = this.values[i];
        if (value == 0.0 && this.nullValues.get(i)) {
            return null;
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DenseDoubleSegmentBody(size=");
        sb.append(this.values.length);
        sb.append(", data=");
        sb.append(Arrays.toString(this.values));
        sb.append(", nullValues=").append(this.nullValues);
        sb.append(", axisValueSets=");
        sb.append(Arrays.toString(this.getAxisValueSets()));
        sb.append(", nullAxisFlags=");
        sb.append(Arrays.toString(this.getNullAxisFlags()));
        if (this.getAxisValueSets().length > 0 && this.getAxisValueSets()[0].iterator().hasNext()) {
            sb.append(", aVS[0]=");
            sb.append(this.getAxisValueSets()[0].getClass());
            sb.append(", aVS[0][0]=");
            sb.append(((Comparable)this.getAxisValueSets()[0].iterator().next()).getClass());
        }
        sb.append(")");
        return sb.toString();
    }
}

