/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.CalculatedMember;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStarSet;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.SqlQueryBuilder;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlContextConstraint
implements MemberChildrenConstraint,
TupleConstraint {
    private final List<Object> cacheKey;
    private final RolapEvaluator evaluator;
    private final boolean strict;
    private final List<RolapMeasureGroup> measureGroupList;

    public static boolean checkValidContext(RolapEvaluator context, boolean disallowVirtualCube, List<RolapCubeLevel> levels, boolean strict, List<RolapMeasureGroup> measureGroupList) {
        LinkedHashSet<RolapMeasureGroup> measureGroupSet;
        LinkedHashSet<RolapCube> baseCubes;
        Query query;
        if (context == null) {
            return false;
        }
        RolapCube cube = context.getCube();
        if (cube.isVirtual()) {
            if (disallowVirtualCube) {
                return false;
            }
            query = context.getQuery();
            baseCubes = new LinkedHashSet<RolapCube>();
            assert (measureGroupList.isEmpty());
            measureGroupSet = new LinkedHashSet<RolapMeasureGroup>();
            if (!SqlContextConstraint.findVirtualCubeStars(query, baseCubes, measureGroupSet)) {
                return false;
            }
            assert (levels != null);
            measureGroupList.addAll(measureGroupSet);
            query.setMeasureGroups(measureGroupList);
        } else {
            Util.deprecated("review following code, pasted from above", false);
            query = context.getQuery();
            baseCubes = new LinkedHashSet();
            assert (measureGroupList.isEmpty());
            measureGroupSet = new LinkedHashSet();
            if (!SqlContextConstraint.findVirtualCubeStars(query, baseCubes, measureGroupSet)) {
                return false;
            }
            assert (levels != null);
            measureGroupList.addAll(measureGroupSet);
        }
        if (!strict) {
            return true;
        }
        if (SqlConstraintUtils.hasMultiPositionSlicer(context)) {
            return false;
        }
        RolapMember[] members = context.getMembers();
        for (int i = 1; i < members.length; ++i) {
            if (!members[i].isCalculated()) continue;
            return false;
        }
        return true;
    }

    private static boolean findVirtualCubeStars(Query query, Collection<RolapCube> baseCubes, Set<RolapMeasureGroup> measureGroupSet) {
        Set<Member> measureMembers = query.getMeasuresMembers();
        if (measureMembers.isEmpty()) {
            Cube cube = query.getCube();
            Dimension dimension = cube.getDimensionList().get(0);
            query.addMeasuresMembers(dimension.getHierarchy().getDefaultMember());
        }
        for (Member member : query.getMeasuresMembers()) {
            if (member instanceof RolapStoredMeasure) {
                SqlContextConstraint.addMeasure((RolapStoredMeasure)member, baseCubes, measureGroupSet);
                continue;
            }
            if (!(member instanceof CalculatedMember)) continue;
            SqlContextConstraint.findMeasures(member.getExpression(), baseCubes, measureGroupSet);
        }
        return !baseCubes.isEmpty();
    }

    private static void addMeasure(RolapStoredMeasure measure, Collection<RolapCube> baseCubes, Set<RolapMeasureGroup> stars) {
        RolapCube baseCube = measure.getCube();
        baseCubes.add(baseCube);
        stars.add(measure.getMeasureGroup());
    }

    private static void findMeasures(Exp exp, Collection<RolapCube> baseCubes, Set<RolapMeasureGroup> measureGroupSet) {
        block4: {
            block2: {
                Member member;
                block3: {
                    if (!(exp instanceof MemberExpr)) break block2;
                    MemberExpr memberExpr = (MemberExpr)exp;
                    member = memberExpr.getMember();
                    if (!(member instanceof RolapStoredMeasure)) break block3;
                    SqlContextConstraint.addMeasure((RolapStoredMeasure)member, baseCubes, measureGroupSet);
                    break block4;
                }
                if (!(member instanceof CalculatedMember)) break block4;
                SqlContextConstraint.findMeasures(member.getExpression(), baseCubes, measureGroupSet);
                break block4;
            }
            if (exp instanceof ResolvedFunCall) {
                Exp[] args;
                ResolvedFunCall funCall = (ResolvedFunCall)exp;
                for (Exp arg : args = funCall.getArgs()) {
                    SqlContextConstraint.findMeasures(arg, baseCubes, measureGroupSet);
                }
            }
        }
    }

    SqlContextConstraint(RolapEvaluator evaluator, List<RolapMeasureGroup> measureGroupList, boolean strict) {
        this.evaluator = evaluator.push();
        this.strict = strict;
        this.cacheKey = new ArrayList<Object>();
        this.cacheKey.add(this.getClass());
        this.cacheKey.add(strict);
        ArrayList<RolapMember> memberList = new ArrayList<RolapMember>(Arrays.asList(evaluator.getMembers()));
        SqlConstraintUtils.removeMultiPositionSlicerMembers(memberList, evaluator);
        this.cacheKey.addAll(memberList);
        Map<Level, List<RolapMember>> roleMembers = SqlConstraintUtils.getRoleConstraintMembers(this.getEvaluator().getSchemaReader(), this.getEvaluator().getMembers());
        for (List<RolapMember> list : roleMembers.values()) {
            this.cacheKey.addAll(list);
        }
        assert (measureGroupList != null);
        this.cacheKey.addAll(measureGroupList);
        assert (Util.isDistinct(measureGroupList)) : measureGroupList;
        this.measureGroupList = measureGroupList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMemberConstraint(SqlQueryBuilder queryBuilder, RolapStarSet starSet, RolapMember parent) {
        if (parent.isCalculated()) {
            throw Util.newInternal("cannot restrict SQL to calculated member");
        }
        int savepoint = this.evaluator.savepoint();
        try {
            this.evaluator.setContext(parent);
            SqlConstraintUtils.addContextConstraint(queryBuilder, starSet, this.evaluator, this.strict);
        }
        finally {
            this.evaluator.restore(savepoint);
        }
    }

    @Override
    public void addMemberConstraint(SqlQueryBuilder queryBuilder, RolapStarSet starSet, List<RolapMember> parents) {
        SqlConstraintUtils.addContextConstraint(queryBuilder, starSet, this.evaluator, this.strict);
        boolean exclude = false;
        SqlConstraintUtils.addMemberConstraint(queryBuilder, starSet, parents, true, false, exclude);
    }

    @Override
    public void addConstraint(SqlQueryBuilder queryBuilder, RolapStarSet starSet) {
        SqlConstraintUtils.addContextConstraint(queryBuilder, starSet, this.evaluator, this.strict);
    }

    @Override
    public boolean isJoinRequired() {
        RolapMember[] members = this.evaluator.getMembers();
        for (int i = 1; i < members.length; ++i) {
            if (members[i].isAll()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RolapStarSet createStarSet(RolapMeasureGroup aggMeasureGroup) {
        RolapMeasureGroup measureGroup;
        RolapStar star;
        RolapMember measure = this.evaluator.getMembers()[0];
        if (measure instanceof RolapStoredMeasure) {
            RolapStoredMeasure storedMeasure = (RolapStoredMeasure)((Object)measure);
            star = storedMeasure.getStarMeasure().getStar();
            measureGroup = storedMeasure.getMeasureGroup();
        } else {
            star = null;
            measureGroup = null;
        }
        return new RolapStarSet(star, measureGroup, aggMeasureGroup);
    }

    @Override
    public void addLevelConstraint(SqlQuery sqlQuery, RolapStarSet starSet, RolapCubeLevel level) {
        if (!this.isJoinRequired()) {
            return;
        }
        SqlConstraintUtils.joinLevelTableToFactTable(sqlQuery, starSet, this.evaluator, level);
    }

    @Override
    public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
        return this;
    }

    @Override
    public Object getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public List<RolapMeasureGroup> getMeasureGroupList() {
        return this.measureGroupList;
    }
}

