/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mondrian.olap.Id;
import mondrian.olap.MondrianProperties;
import mondrian.rolap.ChildByNameConstraint;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.DefaultTupleConstraint;
import mondrian.rolap.DescendantsConstraint;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNativeCrossJoin;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.CrossJoinArgFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlConstraintFactory {
    static boolean enabled;
    private static final SqlConstraintFactory instance;

    private SqlConstraintFactory() {
    }

    public static SqlConstraintFactory instance() {
        SqlConstraintFactory.setNativeNonEmptyValue();
        return instance;
    }

    public static void setNativeNonEmptyValue() {
        enabled = MondrianProperties.instance().EnableNativeNonEmpty.get();
    }

    public MemberChildrenConstraint getMemberChildrenConstraint(RolapEvaluator context) {
        if (!enabled) {
            return DefaultMemberChildrenConstraint.instance();
        }
        ArrayList<RolapMeasureGroup> measureGroupList = new ArrayList<RolapMeasureGroup>();
        if (!SqlContextConstraint.checkValidContext(context, true, Collections.<RolapCubeLevel>emptyList(), false, measureGroupList)) {
            return DefaultMemberChildrenConstraint.instance();
        }
        return new SqlContextConstraint(context, measureGroupList, false);
    }

    public TupleConstraint getLevelMembersConstraint(RolapEvaluator context) {
        return this.getLevelMembersConstraint(context, Collections.<RolapCubeLevel>emptyList());
    }

    public TupleConstraint getLevelMembersConstraint(RolapEvaluator context, List<RolapCubeLevel> levels) {
        Set<CrossJoinArg> joinArgs;
        assert (levels != null);
        if (context == null || !enabled) {
            return DefaultTupleConstraint.instance();
        }
        ArrayList<RolapMeasureGroup> measureGroupList = new ArrayList<RolapMeasureGroup>();
        if (!SqlContextConstraint.checkValidContext(context, false, levels, false, measureGroupList)) {
            return DefaultTupleConstraint.instance();
        }
        if (context.isNonEmpty() && (joinArgs = new CrossJoinArgFactory(false).buildConstraintFromAllAxes(context)).size() > 0) {
            return new RolapNativeCrossJoin.NonEmptyCrossJoinConstraint(joinArgs.toArray(new CrossJoinArg[joinArgs.size()]), context, measureGroupList);
        }
        return new SqlContextConstraint(context, measureGroupList, false);
    }

    public MemberChildrenConstraint getChildByNameConstraint(RolapMember parent, Id.NameSegment childName) {
        if (!enabled || parent.getHierarchy().isRagged()) {
            return DefaultMemberChildrenConstraint.instance();
        }
        return new ChildByNameConstraint(childName);
    }

    public TupleConstraint getDescendantsConstraint(List<RolapMember> parentMembers, MemberChildrenConstraint mcc) {
        return new DescendantsConstraint(parentMembers, mcc);
    }

    static {
        instance = new SqlConstraintFactory();
    }
}

