/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import mondrian.olap.Larder;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.RolapCalculation;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RolapMember
extends Member,
RolapCalculation {
    public Comparable getKey();

    public List<Comparable> getKeyAsList();

    public Object[] getKeyAsArray();

    public Comparable getKeyCompact();

    @Override
    public RolapMember getParentMember();

    @Override
    public RolapCubeHierarchy getHierarchy();

    @Override
    public RolapCubeLevel getLevel();

    public Larder getLarder();

    public RolapCube getCube();

    @Override
    public RolapCubeDimension getDimension();

    @Override
    public RolapMember getDataMember();

    public static class Key {
        private static final Class<? extends List> LIST2_TYPE = Util.flatList("a", "b").getClass();
        private static final Class<? extends List> LIST3_TYPE = Util.flatList("a", "b", "c").getClass();
        private static final Class<? extends List> LISTN_TYPE = Util.flatList("a", "b", "c", "d").getClass();

        public static Comparable create(Comparable[] values) {
            if (values.length == 1) {
                return values[0];
            }
            return (Comparable)((Object)Util.flatList(values));
        }

        public static boolean isValid(Object key, RolapCubeLevel level, Member.MemberType memberType) {
            if (memberType == Member.MemberType.FORMULA) {
                return key == null;
            }
            if (level.isAll()) {
                return key.equals(Util.COMPARABLE_EMPTY_LIST);
            }
            int keyCount = level.attribute.getKeyList().size();
            if (key instanceof String || key instanceof Number || key instanceof Boolean || key instanceof Timestamp || key instanceof Date || key == RolapUtil.sqlNullValue) {
                return keyCount == 1 || level.isMeasure() && keyCount == 0;
            }
            if (key instanceof List) {
                List list = (List)key;
                int arity = list.size();
                if (keyCount != arity) {
                    return false;
                }
                switch (arity) {
                    case 0: {
                        return key == Util.COMPARABLE_EMPTY_LIST;
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        return key.getClass() == LIST2_TYPE;
                    }
                    case 3: {
                        return key.getClass() == LIST3_TYPE;
                    }
                }
                return key.getClass() == LISTN_TYPE;
            }
            return false;
        }

        public static Object quick(Comparable[] keyValues) {
            return keyValues.length == 1 ? keyValues[0] : Arrays.asList(keyValues);
        }
    }
}

