/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Larder;
import mondrian.olap.Larders;
import mondrian.olap.MatchType;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapAttribute;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapSchema;
import mondrian.spi.Dialect;
import mondrian.spi.MemberFormatter;
import mondrian.util.CompositeList;
import org.apache.log4j.Logger;
import org.olap4j.metadata.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RolapAttributeImpl
extends OlapElementBase
implements RolapAttribute {
    private static final List<RolapProperty> INTRINSIC_PROPERTIES = Collections.emptyList();
    final String name;
    private final Larder larder;
    public final List<RolapSchema.PhysColumn> keyList;
    protected final RolapSchema.PhysColumn nameExp;
    protected final List<RolapSchema.PhysColumn> orderByList;
    protected final RolapSchema.PhysColumn captionExp;
    private final List<RolapProperty> properties = new ArrayList<RolapProperty>();
    final Level.Type levelType;
    private final int approxRowCount;
    final MemberFormatter memberFormatter;

    public RolapAttributeImpl(String name, boolean visible, List<RolapSchema.PhysColumn> keyList, RolapSchema.PhysColumn nameExp, RolapSchema.PhysColumn captionExp, List<RolapSchema.PhysColumn> orderByList, MemberFormatter memberFormatter, Level.Type levelType, int approxRowCount, Larder larder) {
        this.visible = visible;
        assert (levelType != null);
        assert (name != null);
        switch (levelType) {
            case NULL: 
            case ALL: {
                break;
            }
            default: {
                if (name.equals("Measures")) break;
                assert (keyList != null);
                assert (nameExp != null);
                break;
            }
        }
        this.name = name;
        this.larder = larder;
        this.keyList = keyList;
        this.nameExp = nameExp;
        this.captionExp = captionExp;
        this.memberFormatter = memberFormatter;
        this.levelType = levelType;
        this.approxRowCount = approxRowCount;
        this.orderByList = orderByList;
        assert (orderByList != null);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public List<RolapSchema.PhysColumn> getKeyList() {
        return this.keyList;
    }

    @Override
    public RolapSchema.PhysColumn getNameExp() {
        return this.nameExp;
    }

    @Override
    public RolapSchema.PhysColumn getCaptionExp() {
        return this.captionExp;
    }

    @Override
    public List<RolapSchema.PhysColumn> getOrderByList() {
        return this.orderByList;
    }

    @Override
    public Level.Type getLevelType() {
        return this.levelType;
    }

    @Override
    public MemberFormatter getMemberFormatter() {
        return this.memberFormatter;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getUniqueName() {
        return Util.makeFqName(this.getDimension(), this.name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return Larders.getDescription(this.larder);
    }

    @Override
    public Larder getLarder() {
        return this.larder;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getQualifiedName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Hierarchy getHierarchy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RolapProperty> getExplicitProperties() {
        return this.properties;
    }

    @Override
    public List<RolapProperty> getProperties() {
        return CompositeList.of(INTRINSIC_PROPERTIES, this.properties);
    }

    @Override
    public Property.Datatype getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Dialect.Datatype getDatatype() {
        Util.deprecated("obsolete method - use keyExpList types", false);
        return this.keyList.get((int)0).datatype;
    }

    @Override
    public int getApproxRowCount() {
        return this.approxRowCount;
    }
}

