/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;

class StrToMemberFunDef
extends FunDefBase {
    public static final FunDef INSTANCE = new StrToMemberFunDef();

    private StrToMemberFunDef() {
        super("StrToMember", "Returns a member from a unique name String in MDX format.", "fmS");
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final StringCalc memberNameCalc = compiler.compileString(call.getArg(0));
        return new AbstractMemberCalc(call, new Calc[]{memberNameCalc}){

            public Member evaluateMember(Evaluator evaluator) {
                String memberName = memberNameCalc.evaluateString(evaluator);
                if (memberName == null) {
                    throw FunUtil.newEvalException(MondrianResource.instance().NullValue.ex());
                }
                return FunUtil.parseMember(evaluator, memberName, null);
            }
        };
    }
}

