/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.AbstractBooleanCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;

class IsFunDef
extends FunDefBase {
    private static final String[] SIGNATURES = new String[]{"ibmm", "ibll", "ibhh", "ibdd", "ibtt"};

    public static void define(FunTable.Builder builder) {
        for (String signature : SIGNATURES) {
            builder.define(new ReflectiveMultiResolver("IS", "<Expression> IS <Expression>", "Returns whether two objects are the same", new String[]{signature}, IsFunDef.class));
        }
    }

    public IsFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        int category = this.parameterCategories[0];
        switch (category) {
            case 10: {
                final TupleCalc tupleCalc0 = compiler.compileTuple(call.getArg(0));
                final TupleCalc tupleCalc1 = compiler.compileTuple(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{tupleCalc0, tupleCalc1}){

                    public boolean evaluateBoolean(Evaluator evaluator) {
                        Member[] o0 = tupleCalc0.evaluateTuple(evaluator);
                        Member[] o1 = tupleCalc1.evaluateTuple(evaluator);
                        return FunUtil.equalTuple(o0, o1);
                    }
                };
            }
        }
        final Calc calc0 = IsFunDef.compileCategory(compiler, category, call.getArg(0));
        final Calc calc1 = IsFunDef.compileCategory(compiler, category, call.getArg(1));
        return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

            public boolean evaluateBoolean(Evaluator evaluator) {
                Object o0 = calc0.evaluate(evaluator);
                Object o1 = calc1.evaluate(evaluator);
                return o0.equals(o1);
            }
        };
    }

    private static Calc compileCategory(ExpCompiler compiler, int category, Exp exp) {
        switch (category) {
            case 6: {
                return compiler.compileMember(exp);
            }
            case 4: {
                return compiler.compileLevel(exp);
            }
            case 3: {
                return compiler.compileHierarchy(exp);
            }
            case 2: {
                return compiler.compileDimension(exp);
            }
        }
        throw new AssertionError(category);
    }
}

