/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Larder;
import mondrian.olap.Larders;
import mondrian.olap.MatchType;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Validator;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import org.apache.log4j.Logger;

public class SetBase
extends OlapElementBase
implements NamedSet {
    private static final Logger LOGGER = Logger.getLogger(SetBase.class);
    private String name;
    private Larder larder;
    private final String uniqueName;
    private Exp exp;
    private boolean validated;

    SetBase(String name, Exp exp, boolean validated, Larder larder) {
        this.name = name;
        this.larder = larder;
        this.exp = exp;
        this.validated = validated;
        this.uniqueName = "[" + name + "]";
    }

    public Larder getLarder() {
        return this.larder;
    }

    public String getNameUniqueWithinQuery() {
        return System.identityHashCode(this) + "";
    }

    public boolean isDynamic() {
        return false;
    }

    public Object clone() {
        return new SetBase(this.name, this.exp.clone(), this.validated, this.larder);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return null;
    }

    public String getDescription() {
        return Larders.getDescription(this.larder);
    }

    public Hierarchy getHierarchy() {
        return this.exp.getType().getHierarchy();
    }

    public Dimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLarder(Larder larder) {
        this.larder = larder;
    }

    public Exp getExp() {
        return this.exp;
    }

    public NamedSet validate(Validator validator) {
        if (!this.validated) {
            this.exp = validator.validate(this.exp, false);
            this.validated = true;
        }
        return this;
    }

    public Type getType() {
        Type type = this.exp.getType();
        if (type instanceof MemberType || type instanceof TupleType) {
            type = new SetType(type);
        }
        return type;
    }
}

