/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.Util;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;
import org.eigenbase.xom.Any;
import org.eigenbase.xom.DOMElementParser;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.TextDef;
import org.eigenbase.xom.XMLAttrVector;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XOMException;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MondrianDef {
    public static String[] _elements = new String[]{"CubeElement", "LevelElement", "MeasureElement", "CalculatedMemberElement", "NamedSetElement", "DimensionElement", "PropertyElement", "NamedElement", "SchemaElement", "MeasureGroupElement", "TableElement", "InlineTableElement", "RoleElement", "Holder", "Schema", "Dimension", "Dimensions", "Cube", "Hierarchies", "Attributes", "Attribute", "AttributeElement", "Hierarchy", "HierarchyElement", "Level", "Closure", "Property", "MeasureOrRef", "MeasureRef", "Measure", "CalculatedMembers", "CalculatedMember", "CalculatedMemberProperty", "NamedSets", "NamedSet", "Formula", "PhysicalSchemaElement", "Relation", "Query", "QueryElement", "SQL", "Table", "Hints", "Hint", "InlineTable", "AutoGeneratedDateTable", "ColumnDefs", "RealOrCalcColumnDef", "ColumnDef", "TimeDomain", "CalculatedColumnDef", "Rows", "Row", "Value", "AggTable", "AggName", "AggPattern", "AggExclude", "AggColumnName", "AggFactCount", "AggIgnoreColumn", "AggForeignKey", "AggLevel", "AggMeasure", "Columns", "Key", "Name", "OrderBy", "Caption", "ForeignKey", "Arguments", "Expression", "Column", "ExpressionView", "Role", "Grant", "SchemaGrant", "CubeGrant", "DimensionGrant", "HierarchyGrant", "MemberGrant", "Union", "RoleUsage", "UserDefinedFunction", "Parameter", "Annotations", "Annotation", "Script", "CellFormatter", "MemberFormatter", "PropertyFormatter", "Localization", "LocalizationElement", "Locales", "Locale", "Translations", "Translation", "PhysicalSchema", "Link", "MeasureGroups", "MeasureGroup", "Measures", "DimensionLinks", "DimensionLink", "ForeignKeyLink", "FactLink", "ReferenceLink", "NoLink", "CopyLink"};

    public static Class getXMLDefClass() {
        return MondrianDef.class;
    }

    private static String first(String s0, String s1) {
        if (s0 != null) {
            return s0;
        }
        return s1;
    }

    private static <T> T only(Object[] os, Class<T> clazz) {
        T t = null;
        for (Object o : os) {
            if (!clazz.isInstance(o)) continue;
            if (t != null) {
                Handler.THREAD_LOCAL.get().error("More than one " + clazz.getSimpleName() + " element found; ignoring all but first", (NodeDef)o, null);
            }
            t = clazz.cast(o);
        }
        return t;
    }

    private static <T extends Holder> T onlyDeflt(Object[] os, Class<T> clazz, T dflt) {
        Holder t = null;
        for (Object o : os) {
            if (!clazz.isInstance(o)) continue;
            if (t != null) {
                Handler.THREAD_LOCAL.get().error("More than one " + clazz.getSimpleName() + " element found; ignoring all but first", (NodeDef)o, null);
            }
            t = (Holder)clazz.cast(o);
        }
        return (T)(t == null ? dflt.copy() : t);
    }

    private static <T> List<T> list(Object[] os, Class<T> clazz) {
        if (os == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Object o : os) {
            if (!clazz.isInstance(o)) continue;
            list.add(clazz.cast(o));
        }
        return list;
    }

    private static <T extends NamedElement> NamedList<T> namedList(Object[] os, Class<T> clazz) {
        if (os == null) {
            return Olap4jUtil.emptyNamedList();
        }
        return new NamedListImpl<T>(MondrianDef.list(os, clazz));
    }

    private static <T> List<T> list(T[] ts) {
        return Arrays.asList(ts);
    }

    private static <T extends NamedElement> NamedList<T> namedList(T[] ts) {
        if (ts.length == 0) {
            return Olap4jUtil.emptyNamedList();
        }
        return new NamedListImpl<T>(MondrianDef.list(ts));
    }

    public static class CopyLink
    extends DimensionLink {
        public DOMWrapper _def;
        public Column[] columnRefs;

        public CopyLink() {
        }

        public CopyLink(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.dimension = (String)_parser.getAttribute("dimension", "String", null, null, true);
                NodeDef[] _tempArray = _parser.getArray(Column.class, 0, 0);
                this.columnRefs = new Column[_tempArray.length];
                for (int _i = 0; _i < this.columnRefs.length; ++_i) {
                    this.columnRefs[_i] = (Column)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CopyLink";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CopyLink.displayAttribute((PrintWriter)_out, (String)"dimension", (Object)this.dimension, (int)(_indent + 1));
            CopyLink.displayElementArray((PrintWriter)_out, (String)"columnRefs", (NodeDef[])this.columnRefs, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CopyLink", new XMLAttrVector().add("dimension", (Object)this.dimension));
            CopyLink.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.columnRefs);
            _out.endTag("CopyLink");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CopyLink _cother = (CopyLink)_other;
            boolean _diff = CopyLink.displayElementArrayDiff((String)"columnRefs", (NodeDef[])this.columnRefs, (NodeDef[])_cother.columnRefs, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class NoLink
    extends DimensionLink {
        public DOMWrapper _def;

        public NoLink() {
        }

        public NoLink(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.dimension = (String)_parser.getAttribute("dimension", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "NoLink";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            NoLink.displayAttribute((PrintWriter)_out, (String)"dimension", (Object)this.dimension, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("NoLink", new XMLAttrVector().add("dimension", (Object)this.dimension));
            _out.endTag("NoLink");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            NoLink _cother = (NoLink)_other;
            return true;
        }
    }

    public static class ReferenceLink
    extends DimensionLink {
        public String viaAttribute;
        public String viaDimension;
        public DOMWrapper _def;

        public ReferenceLink() {
        }

        public ReferenceLink(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.viaAttribute = (String)_parser.getAttribute("viaAttribute", "String", null, null, false);
                this.viaDimension = (String)_parser.getAttribute("viaDimension", "String", null, null, false);
                this.dimension = (String)_parser.getAttribute("dimension", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "ReferenceLink";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            ReferenceLink.displayAttribute((PrintWriter)_out, (String)"viaAttribute", (Object)this.viaAttribute, (int)(_indent + 1));
            ReferenceLink.displayAttribute((PrintWriter)_out, (String)"viaDimension", (Object)this.viaDimension, (int)(_indent + 1));
            ReferenceLink.displayAttribute((PrintWriter)_out, (String)"dimension", (Object)this.dimension, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("ReferenceLink", new XMLAttrVector().add("viaAttribute", (Object)this.viaAttribute).add("viaDimension", (Object)this.viaDimension).add("dimension", (Object)this.dimension));
            _out.endTag("ReferenceLink");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            ReferenceLink _cother = (ReferenceLink)_other;
            boolean _diff = ReferenceLink.displayAttributeDiff((String)"viaAttribute", (Object)this.viaAttribute, (Object)_cother.viaAttribute, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && ReferenceLink.displayAttributeDiff((String)"viaDimension", (Object)this.viaDimension, (Object)_cother.viaDimension, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class FactLink
    extends DimensionLink {
        public DOMWrapper _def;

        public FactLink() {
        }

        public FactLink(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.dimension = (String)_parser.getAttribute("dimension", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "FactLink";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            FactLink.displayAttribute((PrintWriter)_out, (String)"dimension", (Object)this.dimension, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("FactLink", new XMLAttrVector().add("dimension", (Object)this.dimension));
            _out.endTag("FactLink");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            FactLink _cother = (FactLink)_other;
            return true;
        }
    }

    public static class ForeignKeyLink
    extends DimensionLink {
        public String foreignKeyColumn;
        public String attribute;
        public DOMWrapper _def;
        public ForeignKey foreignKey;

        public ForeignKeyLink() {
        }

        public ForeignKeyLink(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.foreignKeyColumn = (String)_parser.getAttribute("foreignKeyColumn", "String", null, null, false);
                this.attribute = (String)_parser.getAttribute("attribute", "String", null, null, false);
                this.dimension = (String)_parser.getAttribute("dimension", "String", null, null, true);
                this.foreignKey = (ForeignKey)_parser.getElement(ForeignKey.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "ForeignKeyLink";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            ForeignKeyLink.displayAttribute((PrintWriter)_out, (String)"foreignKeyColumn", (Object)this.foreignKeyColumn, (int)(_indent + 1));
            ForeignKeyLink.displayAttribute((PrintWriter)_out, (String)"attribute", (Object)this.attribute, (int)(_indent + 1));
            ForeignKeyLink.displayAttribute((PrintWriter)_out, (String)"dimension", (Object)this.dimension, (int)(_indent + 1));
            ForeignKeyLink.displayElement((PrintWriter)_out, (String)"foreignKey", (ElementDef)this.foreignKey, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("ForeignKeyLink", new XMLAttrVector().add("foreignKeyColumn", (Object)this.foreignKeyColumn).add("attribute", (Object)this.attribute).add("dimension", (Object)this.dimension));
            ForeignKeyLink.displayXMLElement((XMLOutput)_out, (ElementDef)this.foreignKey);
            _out.endTag("ForeignKeyLink");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            ForeignKeyLink _cother = (ForeignKeyLink)_other;
            boolean _diff = ForeignKeyLink.displayAttributeDiff((String)"foreignKeyColumn", (Object)this.foreignKeyColumn, (Object)_cother.foreignKeyColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && ForeignKeyLink.displayAttributeDiff((String)"attribute", (Object)this.attribute, (Object)_cother.attribute, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && ForeignKeyLink.displayElementDiff((String)"foreignKey", (NodeDef)this.foreignKey, (NodeDef)_cother.foreignKey, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static abstract class DimensionLink
    extends ElementDef {
        public String dimension;
        public DOMWrapper _def;

        public DimensionLink() {
        }

        public DimensionLink(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.dimension = (String)_parser.getAttribute("dimension", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "DimensionLink";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            DimensionLink.displayAttribute((PrintWriter)_out, (String)"dimension", (Object)this.dimension, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("DimensionLink", new XMLAttrVector().add("dimension", (Object)this.dimension));
            _out.endTag("DimensionLink");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            DimensionLink _cother = (DimensionLink)_other;
            boolean _diff = DimensionLink.displayAttributeDiff((String)"dimension", (Object)this.dimension, (Object)_cother.dimension, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DimensionLinks
    extends ElementDef
    implements Holder,
    MeasureGroupElement {
        public DOMWrapper _def;
        public DimensionLink[] array;
        private static final DimensionLinks EMPTY = new DimensionLinks();

        public DimensionLinks() {
        }

        public DimensionLinks(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(DimensionLink.class, 0, 0);
                this.array = new DimensionLink[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (DimensionLink)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "DimensionLinks";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            DimensionLinks.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("DimensionLinks", new XMLAttrVector());
            DimensionLinks.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("DimensionLinks");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            DimensionLinks _cother = (DimensionLinks)_other;
            boolean _diff = DimensionLinks.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public DimensionLinks copy() {
            DimensionLinks c = new DimensionLinks();
            c.array = (DimensionLink[])this.array.clone();
            return c;
        }

        public List<DimensionLink> list() {
            return new MutableArrayList<DimensionLink>(){

                protected DimensionLink[] getArray() {
                    return DimensionLinks.this.array == null ? EMPTY.array : DimensionLinks.this.array;
                }

                protected void setArray(DimensionLink[] ts) {
                    DimensionLinks.this.array = ts;
                }
            };
        }

        static {
            DimensionLinks.EMPTY.array = new DimensionLink[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Measures
    extends ElementDef
    implements Holder,
    MeasureGroupElement {
        public DOMWrapper _def;
        public MeasureOrRef[] array;
        private static final Measures EMPTY = new Measures();

        public Measures() {
        }

        public Measures(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(MeasureOrRef.class, 0, 0);
                this.array = new MeasureOrRef[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (MeasureOrRef)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Measures";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Measures.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Measures", new XMLAttrVector());
            Measures.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Measures");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Measures _cother = (Measures)_other;
            boolean _diff = Measures.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public Measures copy() {
            Measures c = new Measures();
            c.array = (MeasureOrRef[])this.array.clone();
            return c;
        }

        public NamedList<MeasureOrRef> list() {
            return new NamedListImpl<MeasureOrRef>(new MutableArrayList<MeasureOrRef>(){

                protected MeasureOrRef[] getArray() {
                    return Measures.this.array == null ? EMPTY.array : Measures.this.array;
                }

                protected void setArray(MeasureOrRef[] ts) {
                    Measures.this.array = ts;
                }
            });
        }

        static {
            Measures.EMPTY.array = new MeasureOrRef[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MeasureGroup
    extends ElementDef
    implements NamedElement {
        public String name;
        public static final String[] _type_values = new String[]{"fact", "aggregate"};
        public String type;
        public String table;
        public Boolean ignoreUnrelatedDimensions;
        public String approxRowCount;
        public DOMWrapper _def;
        public MeasureGroupElement[] childArray;
        private static final MeasureGroupElement[] EMPTY = new MeasureGroupElement[0];
        public final Children<MeasureGroupElement> children = new Children<MeasureGroupElement>(MeasureGroupElement.class, new Class[]{Measures.class, DimensionLinks.class}){

            MeasureGroupElement[] getArray() {
                return MeasureGroup.this.childArray == null ? EMPTY : MeasureGroup.this.childArray;
            }

            void setArray(MeasureGroupElement[] ts) {
                MeasureGroup.this.childArray = ts;
            }
        };

        public MeasureGroup() {
        }

        public MeasureGroup(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.type = (String)_parser.getAttribute("type", "String", "fact", _type_values, false);
                this.table = (String)_parser.getAttribute("table", "String", null, null, true);
                this.ignoreUnrelatedDimensions = (Boolean)_parser.getAttribute("ignoreUnrelatedDimensions", "Boolean", "false", null, false);
                this.approxRowCount = (String)_parser.getAttribute("approxRowCount", "String", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(MeasureGroupElement.class, 0, 0);
                this.childArray = new MeasureGroupElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (MeasureGroupElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "MeasureGroup";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            MeasureGroup.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            MeasureGroup.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
            MeasureGroup.displayAttribute((PrintWriter)_out, (String)"table", (Object)this.table, (int)(_indent + 1));
            MeasureGroup.displayAttribute((PrintWriter)_out, (String)"ignoreUnrelatedDimensions", (Object)this.ignoreUnrelatedDimensions, (int)(_indent + 1));
            MeasureGroup.displayAttribute((PrintWriter)_out, (String)"approxRowCount", (Object)this.approxRowCount, (int)(_indent + 1));
            MeasureGroup.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("MeasureGroup", new XMLAttrVector().add("name", (Object)this.name).add("type", (Object)this.type).add("table", (Object)this.table).add("ignoreUnrelatedDimensions", (Object)this.ignoreUnrelatedDimensions).add("approxRowCount", (Object)this.approxRowCount));
            MeasureGroup.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("MeasureGroup");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            MeasureGroup _cother = (MeasureGroup)_other;
            boolean _diff = MeasureGroup.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && MeasureGroup.displayAttributeDiff((String)"type", (Object)this.type, (Object)_cother.type, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && MeasureGroup.displayAttributeDiff((String)"table", (Object)this.table, (Object)_cother.table, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && MeasureGroup.displayAttributeDiff((String)"ignoreUnrelatedDimensions", (Object)this.ignoreUnrelatedDimensions, (Object)_cother.ignoreUnrelatedDimensions, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && MeasureGroup.displayAttributeDiff((String)"approxRowCount", (Object)this.approxRowCount, (Object)_cother.approxRowCount, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && MeasureGroup.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public boolean isAggregate() {
            assert (this.type == null || this.type.equals("aggregate") || this.type.equals("fact"));
            return "aggregate".equals(this.type);
        }

        @Override
        public String getNameAttribute() {
            return MondrianDef.first(this.name, this.table);
        }

        public List<DimensionLink> getDimensionLinks() {
            return this.children.only(DimensionLinks.EMPTY).list();
        }

        public NamedList<MeasureOrRef> getMeasures() {
            return this.children.only(Measures.EMPTY).list();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MeasureGroups
    extends ElementDef
    implements Holder,
    CubeElement {
        public DOMWrapper _def;
        public MeasureGroup[] array;
        private static final MeasureGroups EMPTY = new MeasureGroups();

        public MeasureGroups() {
        }

        public MeasureGroups(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(MeasureGroup.class, 0, 0);
                this.array = new MeasureGroup[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (MeasureGroup)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "MeasureGroups";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            MeasureGroups.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("MeasureGroups", new XMLAttrVector());
            MeasureGroups.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("MeasureGroups");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            MeasureGroups _cother = (MeasureGroups)_other;
            boolean _diff = MeasureGroups.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public MeasureGroups copy() {
            MeasureGroups c = new MeasureGroups();
            c.array = (MeasureGroup[])this.array.clone();
            return c;
        }

        public NamedList<MeasureGroup> list() {
            return new NamedListImpl<MeasureGroup>(new MutableArrayList<MeasureGroup>(){

                protected MeasureGroup[] getArray() {
                    return MeasureGroups.this.array == null ? EMPTY.array : MeasureGroups.this.array;
                }

                protected void setArray(MeasureGroup[] ts) {
                    MeasureGroups.this.array = ts;
                }
            });
        }

        static {
            MeasureGroups.EMPTY.array = new MeasureGroup[0];
        }
    }

    public static class Link
    extends ElementDef
    implements PhysicalSchemaElement {
        public String source;
        public String target;
        public String key;
        public String foreignKeyColumn;
        public DOMWrapper _def;
        public ForeignKey foreignKey;

        public Link() {
        }

        public Link(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.source = (String)_parser.getAttribute("source", "String", null, null, true);
                this.target = (String)_parser.getAttribute("target", "String", null, null, true);
                this.key = (String)_parser.getAttribute("key", "String", null, null, false);
                this.foreignKeyColumn = (String)_parser.getAttribute("foreignKeyColumn", "String", null, null, false);
                this.foreignKey = (ForeignKey)_parser.getElement(ForeignKey.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Link";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Link.displayAttribute((PrintWriter)_out, (String)"source", (Object)this.source, (int)(_indent + 1));
            Link.displayAttribute((PrintWriter)_out, (String)"target", (Object)this.target, (int)(_indent + 1));
            Link.displayAttribute((PrintWriter)_out, (String)"key", (Object)this.key, (int)(_indent + 1));
            Link.displayAttribute((PrintWriter)_out, (String)"foreignKeyColumn", (Object)this.foreignKeyColumn, (int)(_indent + 1));
            Link.displayElement((PrintWriter)_out, (String)"foreignKey", (ElementDef)this.foreignKey, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Link", new XMLAttrVector().add("source", (Object)this.source).add("target", (Object)this.target).add("key", (Object)this.key).add("foreignKeyColumn", (Object)this.foreignKeyColumn));
            Link.displayXMLElement((XMLOutput)_out, (ElementDef)this.foreignKey);
            _out.endTag("Link");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Link _cother = (Link)_other;
            boolean _diff = Link.displayAttributeDiff((String)"source", (Object)this.source, (Object)_cother.source, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Link.displayAttributeDiff((String)"target", (Object)this.target, (Object)_cother.target, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Link.displayAttributeDiff((String)"key", (Object)this.key, (Object)_cother.key, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Link.displayAttributeDiff((String)"foreignKeyColumn", (Object)this.foreignKeyColumn, (Object)_cother.foreignKeyColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Link.displayElementDiff((String)"foreignKey", (NodeDef)this.foreignKey, (NodeDef)_cother.foreignKey, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class PhysicalSchema
    extends ElementDef
    implements SchemaElement {
        public DOMWrapper _def;
        public PhysicalSchemaElement[] childArray;
        private static final PhysicalSchemaElement[] EMPTY = new PhysicalSchemaElement[0];
        public final Children<PhysicalSchemaElement> children = new Children<PhysicalSchemaElement>(PhysicalSchemaElement.class, new Class[0]){

            PhysicalSchemaElement[] getArray() {
                return PhysicalSchema.this.childArray == null ? EMPTY : PhysicalSchema.this.childArray;
            }

            void setArray(PhysicalSchemaElement[] ts) {
                PhysicalSchema.this.childArray = ts;
            }
        };

        public PhysicalSchema() {
        }

        public PhysicalSchema(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(PhysicalSchemaElement.class, 0, 0);
                this.childArray = new PhysicalSchemaElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (PhysicalSchemaElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "PhysicalSchema";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            PhysicalSchema.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("PhysicalSchema", new XMLAttrVector());
            PhysicalSchema.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("PhysicalSchema");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            PhysicalSchema _cother = (PhysicalSchema)_other;
            boolean _diff = PhysicalSchema.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Translation
    extends ElementDef
    implements NamedElement {
        public String path;
        public DOMWrapper _def;

        public Translation() {
        }

        public Translation(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.path = (String)_parser.getAttribute("path", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Translation";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Translation.displayAttribute((PrintWriter)_out, (String)"path", (Object)this.path, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Translation", new XMLAttrVector().add("path", (Object)this.path));
            _out.endTag("Translation");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Translation _cother = (Translation)_other;
            boolean _diff = Translation.displayAttributeDiff((String)"path", (Object)this.path, (Object)_cother.path, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.path;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Translations
    extends ElementDef
    implements Holder,
    LocalizationElement {
        public DOMWrapper _def;
        public Translation[] array;
        private static final Translations EMPTY = new Translations();

        public Translations() {
        }

        public Translations(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Translation.class, 0, 0);
                this.array = new Translation[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Translation)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Translations";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Translations.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Translations", new XMLAttrVector());
            Translations.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Translations");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Translations _cother = (Translations)_other;
            boolean _diff = Translations.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public Translations copy() {
            Translations c = new Translations();
            c.array = (Translation[])this.array.clone();
            return c;
        }

        public NamedList<Translation> list() {
            return new NamedListImpl<Translation>(new MutableArrayList<Translation>(){

                protected Translation[] getArray() {
                    return Translations.this.array == null ? EMPTY.array : Translations.this.array;
                }

                protected void setArray(Translation[] ts) {
                    Translations.this.array = ts;
                }
            });
        }

        static {
            Translations.EMPTY.array = new Translation[0];
        }
    }

    public static class Locale
    extends ElementDef
    implements NamedElement {
        public String locale;
        public DOMWrapper _def;

        public Locale() {
        }

        public Locale(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.locale = (String)_parser.getAttribute("locale", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Locale";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Locale.displayAttribute((PrintWriter)_out, (String)"locale", (Object)this.locale, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Locale", new XMLAttrVector().add("locale", (Object)this.locale));
            _out.endTag("Locale");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Locale _cother = (Locale)_other;
            boolean _diff = Locale.displayAttributeDiff((String)"locale", (Object)this.locale, (Object)_cother.locale, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.locale;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Locales
    extends ElementDef
    implements Holder,
    LocalizationElement {
        public DOMWrapper _def;
        public Locale[] array;
        private static final Locales EMPTY = new Locales();

        public Locales() {
        }

        public Locales(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Locale.class, 0, 0);
                this.array = new Locale[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Locale)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Locales";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Locales.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Locales", new XMLAttrVector());
            Locales.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Locales");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Locales _cother = (Locales)_other;
            boolean _diff = Locales.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public Locales copy() {
            Locales c = new Locales();
            c.array = (Locale[])this.array.clone();
            return c;
        }

        public NamedList<Locale> list() {
            return new NamedListImpl<Locale>(new MutableArrayList<Locale>(){

                protected Locale[] getArray() {
                    return Locales.this.array == null ? EMPTY.array : Locales.this.array;
                }

                protected void setArray(Locale[] ts) {
                    Locales.this.array = ts;
                }
            });
        }

        static {
            Locales.EMPTY.array = new Locale[0];
        }
    }

    public static interface LocalizationElement
    extends NodeDef {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Localization
    extends ElementDef
    implements SchemaElement {
        public DOMWrapper _def;
        public LocalizationElement[] childArray;
        private static final LocalizationElement[] EMPTY = new LocalizationElement[0];
        public final Children<LocalizationElement> children = new Children<LocalizationElement>(LocalizationElement.class, new Class[]{Locales.class, Translations.class}){

            LocalizationElement[] getArray() {
                return Localization.this.childArray == null ? EMPTY : Localization.this.childArray;
            }

            void setArray(LocalizationElement[] ts) {
                Localization.this.childArray = ts;
            }
        };

        public Localization() {
        }

        public Localization(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(LocalizationElement.class, 0, 0);
                this.childArray = new LocalizationElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (LocalizationElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Localization";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Localization.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Localization", new XMLAttrVector());
            Localization.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("Localization");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Localization _cother = (Localization)_other;
            boolean _diff = Localization.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public List<Locale> getLocales() {
            return this.children.only(Locales.EMPTY).list();
        }

        public List<Translation> getTranslations() {
            return this.children.only(Translations.EMPTY).list();
        }
    }

    public static class PropertyFormatter
    extends ElementDef
    implements PropertyElement {
        public String className;
        public DOMWrapper _def;
        public Script script;

        public PropertyFormatter() {
        }

        public PropertyFormatter(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.className = (String)_parser.getAttribute("className", "String", null, null, false);
                this.script = (Script)_parser.getElement(Script.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "PropertyFormatter";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            PropertyFormatter.displayAttribute((PrintWriter)_out, (String)"className", (Object)this.className, (int)(_indent + 1));
            PropertyFormatter.displayElement((PrintWriter)_out, (String)"script", (ElementDef)this.script, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("PropertyFormatter", new XMLAttrVector().add("className", (Object)this.className));
            PropertyFormatter.displayXMLElement((XMLOutput)_out, (ElementDef)this.script);
            _out.endTag("PropertyFormatter");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            PropertyFormatter _cother = (PropertyFormatter)_other;
            boolean _diff = PropertyFormatter.displayAttributeDiff((String)"className", (Object)this.className, (Object)_cother.className, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && PropertyFormatter.displayElementDiff((String)"script", (NodeDef)this.script, (NodeDef)_cother.script, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class MemberFormatter
    extends ElementDef
    implements AttributeElement {
        public String className;
        public DOMWrapper _def;
        public Script script;

        public MemberFormatter() {
        }

        public MemberFormatter(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.className = (String)_parser.getAttribute("className", "String", null, null, false);
                this.script = (Script)_parser.getElement(Script.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "MemberFormatter";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            MemberFormatter.displayAttribute((PrintWriter)_out, (String)"className", (Object)this.className, (int)(_indent + 1));
            MemberFormatter.displayElement((PrintWriter)_out, (String)"script", (ElementDef)this.script, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("MemberFormatter", new XMLAttrVector().add("className", (Object)this.className));
            MemberFormatter.displayXMLElement((XMLOutput)_out, (ElementDef)this.script);
            _out.endTag("MemberFormatter");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            MemberFormatter _cother = (MemberFormatter)_other;
            boolean _diff = MemberFormatter.displayAttributeDiff((String)"className", (Object)this.className, (Object)_cother.className, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && MemberFormatter.displayElementDiff((String)"script", (NodeDef)this.script, (NodeDef)_cother.script, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class CellFormatter
    extends ElementDef
    implements CalculatedMemberElement,
    MeasureElement {
        public String className;
        public DOMWrapper _def;
        public Script script;

        public CellFormatter() {
        }

        public CellFormatter(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.className = (String)_parser.getAttribute("className", "String", null, null, false);
                this.script = (Script)_parser.getElement(Script.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CellFormatter";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CellFormatter.displayAttribute((PrintWriter)_out, (String)"className", (Object)this.className, (int)(_indent + 1));
            CellFormatter.displayElement((PrintWriter)_out, (String)"script", (ElementDef)this.script, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CellFormatter", new XMLAttrVector().add("className", (Object)this.className));
            CellFormatter.displayXMLElement((XMLOutput)_out, (ElementDef)this.script);
            _out.endTag("CellFormatter");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CellFormatter _cother = (CellFormatter)_other;
            boolean _diff = CellFormatter.displayAttributeDiff((String)"className", (Object)this.className, (Object)_cother.className, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CellFormatter.displayElementDiff((String)"script", (NodeDef)this.script, (NodeDef)_cother.script, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Script
    extends ElementDef
    implements RoleElement {
        public String language;
        public DOMWrapper _def;
        public String cdata;

        public Script() {
        }

        public Script(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.language = (String)_parser.getAttribute("language", "String", "JavaScript", null, false);
                this.cdata = _parser.getText();
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Script";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Script.displayAttribute((PrintWriter)_out, (String)"language", (Object)this.language, (int)(_indent + 1));
            Script.displayString((PrintWriter)_out, (String)"cdata", (String)this.cdata, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Script", new XMLAttrVector().add("language", (Object)this.language));
            _out.cdata(this.cdata);
            _out.endTag("Script");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Script _cother = (Script)_other;
            boolean _diff = Script.displayAttributeDiff((String)"language", (Object)this.language, (Object)_cother.language, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Script.displayStringDiff((String)"cdata", (String)this.cdata, (String)_cother.cdata, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Annotation
    extends ElementDef
    implements NamedElement {
        public String name;
        public DOMWrapper _def;
        public String cdata;

        public Annotation() {
        }

        public Annotation(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.cdata = _parser.getText();
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Annotation";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Annotation.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Annotation.displayString((PrintWriter)_out, (String)"cdata", (String)this.cdata, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Annotation", new XMLAttrVector().add("name", (Object)this.name));
            _out.cdata(this.cdata);
            _out.endTag("Annotation");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Annotation _cother = (Annotation)_other;
            boolean _diff = Annotation.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Annotation.displayStringDiff((String)"cdata", (String)this.cdata, (String)_cother.cdata, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Annotations
    extends ElementDef
    implements Holder,
    SchemaElement,
    CubeElement,
    DimensionElement,
    HierarchyElement,
    LevelElement,
    AttributeElement,
    MeasureElement,
    QueryElement,
    CalculatedMemberElement,
    RoleElement,
    PropertyElement {
        public DOMWrapper _def;
        public Annotation[] array;
        private static final Annotations EMPTY = new Annotations();

        public Annotations() {
        }

        public Annotations(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Annotation.class, 0, 0);
                this.array = new Annotation[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Annotation)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Annotations";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Annotations.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Annotations", new XMLAttrVector());
            Annotations.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Annotations");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Annotations _cother = (Annotations)_other;
            boolean _diff = Annotations.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public Annotations copy() {
            Annotations c = new Annotations();
            c.array = (Annotation[])this.array.clone();
            return c;
        }

        public NamedList<Annotation> list() {
            return new NamedListImpl<Annotation>(new MutableArrayList<Annotation>(){

                protected Annotation[] getArray() {
                    return Annotations.this.array == null ? EMPTY.array : Annotations.this.array;
                }

                protected void setArray(Annotation[] ts) {
                    Annotations.this.array = ts;
                }
            });
        }

        static {
            Annotations.EMPTY.array = new Annotation[0];
        }
    }

    public static class Parameter
    extends ElementDef
    implements NamedElement,
    SchemaElement {
        public String name;
        public String description;
        public static final String[] _type_values = new String[]{"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp", "Member"};
        public String type;
        public Boolean modifiable;
        public String defaultValue;
        public DOMWrapper _def;

        public Parameter() {
        }

        public Parameter(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.type = (String)_parser.getAttribute("type", "String", "String", _type_values, true);
                this.modifiable = (Boolean)_parser.getAttribute("modifiable", "Boolean", "true", null, false);
                this.defaultValue = (String)_parser.getAttribute("defaultValue", "String", null, null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Parameter";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Parameter.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Parameter.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Parameter.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
            Parameter.displayAttribute((PrintWriter)_out, (String)"modifiable", (Object)this.modifiable, (int)(_indent + 1));
            Parameter.displayAttribute((PrintWriter)_out, (String)"defaultValue", (Object)this.defaultValue, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Parameter", new XMLAttrVector().add("name", (Object)this.name).add("description", (Object)this.description).add("type", (Object)this.type).add("modifiable", (Object)this.modifiable).add("defaultValue", (Object)this.defaultValue));
            _out.endTag("Parameter");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Parameter _cother = (Parameter)_other;
            boolean _diff = Parameter.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Parameter.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Parameter.displayAttributeDiff((String)"type", (Object)this.type, (Object)_cother.type, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Parameter.displayAttributeDiff((String)"modifiable", (Object)this.modifiable, (Object)_cother.modifiable, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Parameter.displayAttributeDiff((String)"defaultValue", (Object)this.defaultValue, (Object)_cother.defaultValue, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }
    }

    public static class UserDefinedFunction
    extends ElementDef
    implements NamedElement,
    SchemaElement {
        public String name;
        public String className;
        public DOMWrapper _def;
        public Script script;

        public UserDefinedFunction() {
        }

        public UserDefinedFunction(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.className = (String)_parser.getAttribute("className", "String", null, null, false);
                this.script = (Script)_parser.getElement(Script.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "UserDefinedFunction";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            UserDefinedFunction.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            UserDefinedFunction.displayAttribute((PrintWriter)_out, (String)"className", (Object)this.className, (int)(_indent + 1));
            UserDefinedFunction.displayElement((PrintWriter)_out, (String)"script", (ElementDef)this.script, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("UserDefinedFunction", new XMLAttrVector().add("name", (Object)this.name).add("className", (Object)this.className));
            UserDefinedFunction.displayXMLElement((XMLOutput)_out, (ElementDef)this.script);
            _out.endTag("UserDefinedFunction");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            UserDefinedFunction _cother = (UserDefinedFunction)_other;
            boolean _diff = UserDefinedFunction.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && UserDefinedFunction.displayAttributeDiff((String)"className", (Object)this.className, (Object)_cother.className, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && UserDefinedFunction.displayElementDiff((String)"script", (NodeDef)this.script, (NodeDef)_cother.script, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }
    }

    public static class RoleUsage
    extends ElementDef {
        public String roleName;
        public DOMWrapper _def;

        public RoleUsage() {
        }

        public RoleUsage(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.roleName = (String)_parser.getAttribute("roleName", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "RoleUsage";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            RoleUsage.displayAttribute((PrintWriter)_out, (String)"roleName", (Object)this.roleName, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("RoleUsage", new XMLAttrVector().add("roleName", (Object)this.roleName));
            _out.endTag("RoleUsage");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            RoleUsage _cother = (RoleUsage)_other;
            boolean _diff = RoleUsage.displayAttributeDiff((String)"roleName", (Object)this.roleName, (Object)_cother.roleName, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Union
    extends ElementDef
    implements Holder,
    RoleElement {
        public DOMWrapper _def;
        public RoleUsage[] array;
        private static final Union EMPTY = new Union();

        public Union() {
        }

        public Union(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(RoleUsage.class, 0, 0);
                this.array = new RoleUsage[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (RoleUsage)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Union";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Union.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Union", new XMLAttrVector());
            Union.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Union");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Union _cother = (Union)_other;
            boolean _diff = Union.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public Union copy() {
            Union c = new Union();
            c.array = (RoleUsage[])this.array.clone();
            return c;
        }

        public List<RoleUsage> list() {
            return new MutableArrayList<RoleUsage>(){

                protected RoleUsage[] getArray() {
                    return Union.this.array == null ? EMPTY.array : Union.this.array;
                }

                protected void setArray(RoleUsage[] ts) {
                    Union.this.array = ts;
                }
            };
        }

        static {
            Union.EMPTY.array = new RoleUsage[0];
        }
    }

    public static class MemberGrant
    extends ElementDef {
        public String member;
        public static final String[] _access_values = new String[]{"all", "none"};
        public String access;
        public DOMWrapper _def;

        public MemberGrant() {
        }

        public MemberGrant(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.member = (String)_parser.getAttribute("member", "String", null, null, true);
                this.access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "MemberGrant";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            MemberGrant.displayAttribute((PrintWriter)_out, (String)"member", (Object)this.member, (int)(_indent + 1));
            MemberGrant.displayAttribute((PrintWriter)_out, (String)"access", (Object)this.access, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("MemberGrant", new XMLAttrVector().add("member", (Object)this.member).add("access", (Object)this.access));
            _out.endTag("MemberGrant");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            MemberGrant _cother = (MemberGrant)_other;
            boolean _diff = MemberGrant.displayAttributeDiff((String)"member", (Object)this.member, (Object)_cother.member, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && MemberGrant.displayAttributeDiff((String)"access", (Object)this.access, (Object)_cother.access, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class HierarchyGrant
    extends ElementDef
    implements Grant {
        public static final String[] _access_values = new String[]{"all", "custom", "none", "all_dimensions"};
        public String access;
        public String hierarchy;
        public String topLevel;
        public String bottomLevel;
        public String rollupPolicy;
        public DOMWrapper _def;
        public MemberGrant[] memberGrants;

        public HierarchyGrant() {
        }

        public HierarchyGrant(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.hierarchy = (String)_parser.getAttribute("hierarchy", "String", null, null, true);
                this.topLevel = (String)_parser.getAttribute("topLevel", "String", null, null, false);
                this.bottomLevel = (String)_parser.getAttribute("bottomLevel", "String", null, null, false);
                this.rollupPolicy = (String)_parser.getAttribute("rollupPolicy", "String", null, null, false);
                this.access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
                NodeDef[] _tempArray = _parser.getArray(MemberGrant.class, 0, 0);
                this.memberGrants = new MemberGrant[_tempArray.length];
                for (int _i = 0; _i < this.memberGrants.length; ++_i) {
                    this.memberGrants[_i] = (MemberGrant)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "HierarchyGrant";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            HierarchyGrant.displayAttribute((PrintWriter)_out, (String)"hierarchy", (Object)this.hierarchy, (int)(_indent + 1));
            HierarchyGrant.displayAttribute((PrintWriter)_out, (String)"topLevel", (Object)this.topLevel, (int)(_indent + 1));
            HierarchyGrant.displayAttribute((PrintWriter)_out, (String)"bottomLevel", (Object)this.bottomLevel, (int)(_indent + 1));
            HierarchyGrant.displayAttribute((PrintWriter)_out, (String)"rollupPolicy", (Object)this.rollupPolicy, (int)(_indent + 1));
            HierarchyGrant.displayAttribute((PrintWriter)_out, (String)"access", (Object)this.access, (int)(_indent + 1));
            HierarchyGrant.displayElementArray((PrintWriter)_out, (String)"memberGrants", (NodeDef[])this.memberGrants, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("HierarchyGrant", new XMLAttrVector().add("hierarchy", (Object)this.hierarchy).add("topLevel", (Object)this.topLevel).add("bottomLevel", (Object)this.bottomLevel).add("rollupPolicy", (Object)this.rollupPolicy).add("access", (Object)this.access));
            HierarchyGrant.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.memberGrants);
            _out.endTag("HierarchyGrant");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            HierarchyGrant _cother = (HierarchyGrant)_other;
            boolean _diff = HierarchyGrant.displayAttributeDiff((String)"hierarchy", (Object)this.hierarchy, (Object)_cother.hierarchy, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && HierarchyGrant.displayAttributeDiff((String)"topLevel", (Object)this.topLevel, (Object)_cother.topLevel, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && HierarchyGrant.displayAttributeDiff((String)"bottomLevel", (Object)this.bottomLevel, (Object)_cother.bottomLevel, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && HierarchyGrant.displayAttributeDiff((String)"rollupPolicy", (Object)this.rollupPolicy, (Object)_cother.rollupPolicy, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && HierarchyGrant.displayElementArrayDiff((String)"memberGrants", (NodeDef[])this.memberGrants, (NodeDef[])_cother.memberGrants, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class DimensionGrant
    extends ElementDef
    implements Grant {
        public static final String[] _access_values = new String[]{"all", "custom", "none", "all_dimensions"};
        public String access;
        public String dimension;
        public DOMWrapper _def;

        public DimensionGrant() {
        }

        public DimensionGrant(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.dimension = (String)_parser.getAttribute("dimension", "String", null, null, true);
                this.access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "DimensionGrant";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            DimensionGrant.displayAttribute((PrintWriter)_out, (String)"dimension", (Object)this.dimension, (int)(_indent + 1));
            DimensionGrant.displayAttribute((PrintWriter)_out, (String)"access", (Object)this.access, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("DimensionGrant", new XMLAttrVector().add("dimension", (Object)this.dimension).add("access", (Object)this.access));
            _out.endTag("DimensionGrant");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            DimensionGrant _cother = (DimensionGrant)_other;
            boolean _diff = DimensionGrant.displayAttributeDiff((String)"dimension", (Object)this.dimension, (Object)_cother.dimension, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class CubeGrant
    extends ElementDef
    implements Grant {
        public static final String[] _access_values = new String[]{"all", "custom", "none", "all_dimensions"};
        public String access;
        public String cube;
        public DOMWrapper _def;
        public DimensionGrant[] dimensionGrants;
        public HierarchyGrant[] hierarchyGrants;

        public CubeGrant() {
        }

        public CubeGrant(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                int _i;
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.cube = (String)_parser.getAttribute("cube", "String", null, null, true);
                this.access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
                NodeDef[] _tempArray = _parser.getArray(DimensionGrant.class, 0, 0);
                this.dimensionGrants = new DimensionGrant[_tempArray.length];
                for (_i = 0; _i < this.dimensionGrants.length; ++_i) {
                    this.dimensionGrants[_i] = (DimensionGrant)_tempArray[_i];
                }
                _tempArray = _parser.getArray(HierarchyGrant.class, 0, 0);
                this.hierarchyGrants = new HierarchyGrant[_tempArray.length];
                for (_i = 0; _i < this.hierarchyGrants.length; ++_i) {
                    this.hierarchyGrants[_i] = (HierarchyGrant)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CubeGrant";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CubeGrant.displayAttribute((PrintWriter)_out, (String)"cube", (Object)this.cube, (int)(_indent + 1));
            CubeGrant.displayAttribute((PrintWriter)_out, (String)"access", (Object)this.access, (int)(_indent + 1));
            CubeGrant.displayElementArray((PrintWriter)_out, (String)"dimensionGrants", (NodeDef[])this.dimensionGrants, (int)(_indent + 1));
            CubeGrant.displayElementArray((PrintWriter)_out, (String)"hierarchyGrants", (NodeDef[])this.hierarchyGrants, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CubeGrant", new XMLAttrVector().add("cube", (Object)this.cube).add("access", (Object)this.access));
            CubeGrant.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.dimensionGrants);
            CubeGrant.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.hierarchyGrants);
            _out.endTag("CubeGrant");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CubeGrant _cother = (CubeGrant)_other;
            boolean _diff = CubeGrant.displayAttributeDiff((String)"cube", (Object)this.cube, (Object)_cother.cube, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CubeGrant.displayElementArrayDiff((String)"dimensionGrants", (NodeDef[])this.dimensionGrants, (NodeDef[])_cother.dimensionGrants, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CubeGrant.displayElementArrayDiff((String)"hierarchyGrants", (NodeDef[])this.hierarchyGrants, (NodeDef[])_cother.hierarchyGrants, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class SchemaGrant
    extends ElementDef
    implements Grant,
    RoleElement {
        public static final String[] _access_values = new String[]{"all", "custom", "none", "all_dimensions"};
        public String access;
        public DOMWrapper _def;
        public CubeGrant[] cubeGrants;

        public SchemaGrant() {
        }

        public SchemaGrant(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
                NodeDef[] _tempArray = _parser.getArray(CubeGrant.class, 0, 0);
                this.cubeGrants = new CubeGrant[_tempArray.length];
                for (int _i = 0; _i < this.cubeGrants.length; ++_i) {
                    this.cubeGrants[_i] = (CubeGrant)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "SchemaGrant";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            SchemaGrant.displayAttribute((PrintWriter)_out, (String)"access", (Object)this.access, (int)(_indent + 1));
            SchemaGrant.displayElementArray((PrintWriter)_out, (String)"cubeGrants", (NodeDef[])this.cubeGrants, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("SchemaGrant", new XMLAttrVector().add("access", (Object)this.access));
            SchemaGrant.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.cubeGrants);
            _out.endTag("SchemaGrant");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            SchemaGrant _cother = (SchemaGrant)_other;
            boolean _diff = SchemaGrant.displayElementArrayDiff((String)"cubeGrants", (NodeDef[])this.cubeGrants, (NodeDef[])_cother.cubeGrants, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static interface Grant
    extends NodeDef {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Role
    extends ElementDef
    implements SchemaElement,
    NamedElement {
        public String name;
        public String className;
        public DOMWrapper _def;
        public RoleElement[] childArray;
        private static final RoleElement[] EMPTY = new RoleElement[0];
        public final Children<RoleElement> children = new Children<RoleElement>(RoleElement.class, new Class[]{Annotations.class, SchemaGrant.class, Union.class}){

            RoleElement[] getArray() {
                return Role.this.childArray == null ? EMPTY : Role.this.childArray;
            }

            void setArray(RoleElement[] ts) {
                Role.this.childArray = ts;
            }
        };

        public Role() {
        }

        public Role(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.className = (String)_parser.getAttribute("className", "String", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(RoleElement.class, 0, 0);
                this.childArray = new RoleElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (RoleElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Role";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Role.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Role.displayAttribute((PrintWriter)_out, (String)"className", (Object)this.className, (int)(_indent + 1));
            Role.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Role", new XMLAttrVector().add("name", (Object)this.name).add("className", (Object)this.className));
            Role.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("Role");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Role _cother = (Role)_other;
            boolean _diff = Role.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Role.displayAttributeDiff((String)"className", (Object)this.className, (Object)_cother.className, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Role.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getNameAttribute() {
            return this.name;
        }

        public List<SchemaGrant> getSchemaGrants() {
            return this.children.filter(SchemaGrant.class);
        }

        public Union getUnion() {
            return this.children.singleton(Union.class);
        }

        public Script getScript() {
            return this.children.singleton(Script.class);
        }

        public NamedList<Annotation> getAnnotations() {
            return this.children.only(Annotations.EMPTY).list();
        }
    }

    public static class ExpressionView
    extends ElementDef
    implements Expression,
    QueryElement {
        public DOMWrapper _def;
        public SQL[] expressions;

        public ExpressionView() {
        }

        public ExpressionView(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(SQL.class, 1, 0);
                this.expressions = new SQL[_tempArray.length];
                for (int _i = 0; _i < this.expressions.length; ++_i) {
                    this.expressions[_i] = (SQL)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "ExpressionView";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            ExpressionView.displayElementArray((PrintWriter)_out, (String)"expressions", (NodeDef[])this.expressions, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("ExpressionView", new XMLAttrVector());
            ExpressionView.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.expressions);
            _out.endTag("ExpressionView");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            ExpressionView _cother = (ExpressionView)_other;
            boolean _diff = ExpressionView.displayElementArrayDiff((String)"expressions", (NodeDef[])this.expressions, (NodeDef[])_cother.expressions, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Column
    extends ElementDef
    implements Expression {
        public String table;
        public String name;
        public String aggColumn;
        public DOMWrapper _def;

        public Column() {
        }

        public Column(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.table = (String)_parser.getAttribute("table", "String", null, null, false);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.aggColumn = (String)_parser.getAttribute("aggColumn", "String", null, null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Column";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Column.displayAttribute((PrintWriter)_out, (String)"table", (Object)this.table, (int)(_indent + 1));
            Column.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Column.displayAttribute((PrintWriter)_out, (String)"aggColumn", (Object)this.aggColumn, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Column", new XMLAttrVector().add("table", (Object)this.table).add("name", (Object)this.name).add("aggColumn", (Object)this.aggColumn));
            _out.endTag("Column");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Column _cother = (Column)_other;
            boolean _diff = Column.displayAttributeDiff((String)"table", (Object)this.table, (Object)_cother.table, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Column.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Column.displayAttributeDiff((String)"aggColumn", (Object)this.aggColumn, (Object)_cother.aggColumn, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public Column(String table, String name) {
            this();
            Util.assertTrue(name != null);
            this.table = table;
            this.name = name;
        }
    }

    public static interface Expression
    extends NodeDef {
    }

    public static class Arguments
    extends Columns
    implements MeasureElement {
        public DOMWrapper _def;

        public Arguments() {
        }

        public Arguments(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Column.class, 0, 0);
                this.array = new Column[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Column)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Arguments";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Arguments.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Arguments", new XMLAttrVector());
            Arguments.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Arguments");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Arguments _cother = (Arguments)_other;
            boolean _diff = Arguments.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class ForeignKey
    extends Columns {
        public DOMWrapper _def;

        public ForeignKey() {
        }

        public ForeignKey(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Column.class, 0, 0);
                this.array = new Column[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Column)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "ForeignKey";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            ForeignKey.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("ForeignKey", new XMLAttrVector());
            ForeignKey.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("ForeignKey");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            ForeignKey _cother = (ForeignKey)_other;
            boolean _diff = ForeignKey.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Caption
    extends Columns
    implements AttributeElement {
        public DOMWrapper _def;

        public Caption() {
        }

        public Caption(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Column.class, 0, 0);
                this.array = new Column[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Column)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Caption";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Caption.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Caption", new XMLAttrVector());
            Caption.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Caption");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Caption _cother = (Caption)_other;
            boolean _diff = Caption.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public static Caption of(String column, String table, Caption caption) {
            Column[] columns = Caption.foo(column, table, caption);
            if (columns == null) {
                return null;
            }
            Caption copy = new Caption();
            copy.array = columns;
            return copy;
        }
    }

    public static class OrderBy
    extends Columns
    implements AttributeElement {
        public DOMWrapper _def;

        public OrderBy() {
        }

        public OrderBy(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Column.class, 0, 0);
                this.array = new Column[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Column)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "OrderBy";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            OrderBy.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("OrderBy", new XMLAttrVector());
            OrderBy.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("OrderBy");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            OrderBy _cother = (OrderBy)_other;
            boolean _diff = OrderBy.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public static OrderBy of(String column, String table, OrderBy orderBy) {
            Column[] columns = OrderBy.foo(column, table, orderBy);
            if (columns == null) {
                return null;
            }
            OrderBy copy = new OrderBy();
            copy.array = columns;
            return copy;
        }
    }

    public static class Name
    extends Columns
    implements AttributeElement {
        public DOMWrapper _def;

        public Name() {
        }

        public Name(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Column.class, 0, 0);
                this.array = new Column[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Column)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Name";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Name.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Name", new XMLAttrVector());
            Name.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Name");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Name _cother = (Name)_other;
            boolean _diff = Name.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public static Name of(String column, String table, Name name) {
            Column[] columns = Name.foo(column, table, name);
            if (columns == null) {
                return null;
            }
            Name copy = new Name();
            copy.array = columns;
            return copy;
        }
    }

    public static class Key
    extends Columns
    implements TableElement,
    InlineTableElement,
    AttributeElement,
    QueryElement {
        public String name;
        public DOMWrapper _def;

        public Key() {
        }

        public Key(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(Column.class, 0, 0);
                this.array = new Column[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Column)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Key";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Key.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Key.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Key", new XMLAttrVector().add("name", (Object)this.name));
            Key.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Key");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Key _cother = (Key)_other;
            boolean _diff = Key.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Key.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Columns
    extends ElementDef
    implements Holder {
        public DOMWrapper _def;
        public Column[] array;
        private static final Columns EMPTY = new Columns();

        public Columns() {
        }

        public Columns(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Column.class, 0, 0);
                this.array = new Column[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Column)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Columns";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Columns.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Columns", new XMLAttrVector());
            Columns.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Columns");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Columns _cother = (Columns)_other;
            boolean _diff = Columns.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public Columns copy() {
            Columns c = new Columns();
            c.array = (Column[])this.array.clone();
            return c;
        }

        public List<Column> list() {
            return new MutableArrayList<Column>(){

                protected Column[] getArray() {
                    return Columns.this.array == null ? EMPTY.array : Columns.this.array;
                }

                protected void setArray(Column[] ts) {
                    Columns.this.array = ts;
                }
            };
        }

        protected static Column[] foo(String column, String table, Columns columns) {
            Column[] columnArray;
            if (columns != null) {
                columnArray = (Column[])columns.array.clone();
            } else if (column != null) {
                Column[] columnArray2 = new Column[1];
                columnArray = columnArray2;
                columnArray2[0] = new Column(table, column);
            } else {
                columnArray = null;
            }
            return columnArray;
        }

        static {
            Columns.EMPTY.array = new Column[0];
        }
    }

    public static class AggMeasure
    extends ElementDef
    implements NamedElement {
        public String column;
        public String name;
        public DOMWrapper _def;

        public AggMeasure() {
        }

        public AggMeasure(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.column = (String)_parser.getAttribute("column", "String", null, null, true);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggMeasure";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggMeasure.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
            AggMeasure.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggMeasure", new XMLAttrVector().add("column", (Object)this.column).add("name", (Object)this.name));
            _out.endTag("AggMeasure");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggMeasure _cother = (AggMeasure)_other;
            boolean _diff = AggMeasure.displayAttributeDiff((String)"column", (Object)this.column, (Object)_cother.column, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggMeasure.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }

        public String getColumn() {
            return this.column;
        }
    }

    public static class AggLevel
    extends ElementDef
    implements NamedElement {
        public String column;
        public String name;
        public DOMWrapper _def;

        public AggLevel() {
        }

        public AggLevel(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.column = (String)_parser.getAttribute("column", "String", null, null, true);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggLevel";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggLevel.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
            AggLevel.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggLevel", new XMLAttrVector().add("column", (Object)this.column).add("name", (Object)this.name));
            _out.endTag("AggLevel");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggLevel _cother = (AggLevel)_other;
            boolean _diff = AggLevel.displayAttributeDiff((String)"column", (Object)this.column, (Object)_cother.column, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggLevel.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }

        public String getColumnName() {
            return this.column;
        }
    }

    public static class AggForeignKey
    extends ElementDef {
        public String factColumn;
        public String aggColumn;
        public DOMWrapper _def;

        public AggForeignKey() {
        }

        public AggForeignKey(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.factColumn = (String)_parser.getAttribute("factColumn", "String", null, null, true);
                this.aggColumn = (String)_parser.getAttribute("aggColumn", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggForeignKey";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggForeignKey.displayAttribute((PrintWriter)_out, (String)"factColumn", (Object)this.factColumn, (int)(_indent + 1));
            AggForeignKey.displayAttribute((PrintWriter)_out, (String)"aggColumn", (Object)this.aggColumn, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggForeignKey", new XMLAttrVector().add("factColumn", (Object)this.factColumn).add("aggColumn", (Object)this.aggColumn));
            _out.endTag("AggForeignKey");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggForeignKey _cother = (AggForeignKey)_other;
            boolean _diff = AggForeignKey.displayAttributeDiff((String)"factColumn", (Object)this.factColumn, (Object)_cother.factColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggForeignKey.displayAttributeDiff((String)"aggColumn", (Object)this.aggColumn, (Object)_cother.aggColumn, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getFactFKColumnName() {
            return this.factColumn;
        }

        public String getAggregateFKColumnName() {
            return this.aggColumn;
        }
    }

    public static class AggIgnoreColumn
    extends ElementDef {
        public DOMWrapper _def;

        public AggIgnoreColumn() {
        }

        public AggIgnoreColumn(DOMWrapper _def) throws XOMException {
        }

        public String getName() {
            return "AggIgnoreColumn";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggIgnoreColumn", new XMLAttrVector());
            _out.endTag("AggIgnoreColumn");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            return true;
        }
    }

    public static class AggFactCount
    extends AggColumnName {
        public DOMWrapper _def;

        public AggFactCount() {
        }

        public AggFactCount(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.column = (String)_parser.getAttribute("column", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggFactCount";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggFactCount.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggFactCount", new XMLAttrVector().add("column", (Object)this.column));
            _out.endTag("AggFactCount");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggFactCount _cother = (AggFactCount)_other;
            return true;
        }
    }

    public static abstract class AggColumnName
    extends ElementDef {
        public String column;
        public DOMWrapper _def;

        public AggColumnName() {
        }

        public AggColumnName(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.column = (String)_parser.getAttribute("column", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggColumnName";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggColumnName.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggColumnName", new XMLAttrVector().add("column", (Object)this.column));
            _out.endTag("AggColumnName");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggColumnName _cother = (AggColumnName)_other;
            boolean _diff = AggColumnName.displayAttributeDiff((String)"column", (Object)this.column, (Object)_cother.column, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getColumnName() {
            return this.column;
        }
    }

    public static class AggExclude
    extends ElementDef
    implements NamedElement {
        public String pattern;
        public String name;
        public Boolean ignorecase;
        public DOMWrapper _def;

        public AggExclude() {
        }

        public AggExclude(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.pattern = (String)_parser.getAttribute("pattern", "String", null, null, false);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.ignorecase = (Boolean)_parser.getAttribute("ignorecase", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggExclude";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggExclude.displayAttribute((PrintWriter)_out, (String)"pattern", (Object)this.pattern, (int)(_indent + 1));
            AggExclude.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            AggExclude.displayAttribute((PrintWriter)_out, (String)"ignorecase", (Object)this.ignorecase, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggExclude", new XMLAttrVector().add("pattern", (Object)this.pattern).add("name", (Object)this.name).add("ignorecase", (Object)this.ignorecase));
            _out.endTag("AggExclude");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggExclude _cother = (AggExclude)_other;
            boolean _diff = AggExclude.displayAttributeDiff((String)"pattern", (Object)this.pattern, (Object)_cother.pattern, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggExclude.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggExclude.displayAttributeDiff((String)"ignorecase", (Object)this.ignorecase, (Object)_cother.ignorecase, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }

        public String getPattern() {
            return this.pattern;
        }

        public boolean isIgnoreCase() {
            return this.ignorecase;
        }
    }

    public static class AggPattern
    extends ElementDef {
        public String pattern;
        public DOMWrapper _def;
        public AggExclude[] excludes;

        public AggPattern() {
        }

        public AggPattern(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.pattern = (String)_parser.getAttribute("pattern", "String", null, null, true);
                NodeDef[] _tempArray = _parser.getArray(AggExclude.class, 0, 0);
                this.excludes = new AggExclude[_tempArray.length];
                for (int _i = 0; _i < this.excludes.length; ++_i) {
                    this.excludes[_i] = (AggExclude)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggPattern";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggPattern.displayAttribute((PrintWriter)_out, (String)"pattern", (Object)this.pattern, (int)(_indent + 1));
            AggPattern.displayElementArray((PrintWriter)_out, (String)"excludes", (NodeDef[])this.excludes, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggPattern", new XMLAttrVector().add("pattern", (Object)this.pattern));
            AggPattern.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.excludes);
            _out.endTag("AggPattern");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggPattern _cother = (AggPattern)_other;
            boolean _diff = AggPattern.displayAttributeDiff((String)"pattern", (Object)this.pattern, (Object)_cother.pattern, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggPattern.displayElementArrayDiff((String)"excludes", (NodeDef[])this.excludes, (NodeDef[])_cother.excludes, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getPattern() {
            return this.pattern;
        }

        public AggExclude[] getAggExcludes() {
            return this.excludes;
        }
    }

    public static class AggName
    extends ElementDef
    implements NamedElement {
        public String name;
        public DOMWrapper _def;

        public AggName() {
        }

        public AggName(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggName";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggName.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggName", new XMLAttrVector().add("name", (Object)this.name));
            _out.endTag("AggName");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggName _cother = (AggName)_other;
            boolean _diff = AggName.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }
    }

    public static class AggTable
    extends ElementDef {
        public Boolean ignorecase;
        public DOMWrapper _def;
        public AggFactCount factcount;
        public AggIgnoreColumn[] ignoreColumns;
        public AggForeignKey[] foreignKeys;
        public AggMeasure[] measures;
        public AggLevel[] levels;

        public AggTable() {
        }

        public AggTable(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                int _i;
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.ignorecase = (Boolean)_parser.getAttribute("ignorecase", "Boolean", "true", null, false);
                this.factcount = (AggFactCount)_parser.getElement(AggFactCount.class, true);
                NodeDef[] _tempArray = _parser.getArray(AggIgnoreColumn.class, 0, 0);
                this.ignoreColumns = new AggIgnoreColumn[_tempArray.length];
                for (_i = 0; _i < this.ignoreColumns.length; ++_i) {
                    this.ignoreColumns[_i] = (AggIgnoreColumn)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggForeignKey.class, 0, 0);
                this.foreignKeys = new AggForeignKey[_tempArray.length];
                for (_i = 0; _i < this.foreignKeys.length; ++_i) {
                    this.foreignKeys[_i] = (AggForeignKey)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggMeasure.class, 0, 0);
                this.measures = new AggMeasure[_tempArray.length];
                for (_i = 0; _i < this.measures.length; ++_i) {
                    this.measures[_i] = (AggMeasure)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggLevel.class, 0, 0);
                this.levels = new AggLevel[_tempArray.length];
                for (_i = 0; _i < this.levels.length; ++_i) {
                    this.levels[_i] = (AggLevel)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggTable";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggTable.displayAttribute((PrintWriter)_out, (String)"ignorecase", (Object)this.ignorecase, (int)(_indent + 1));
            AggTable.displayElement((PrintWriter)_out, (String)"factcount", (ElementDef)this.factcount, (int)(_indent + 1));
            AggTable.displayElementArray((PrintWriter)_out, (String)"ignoreColumns", (NodeDef[])this.ignoreColumns, (int)(_indent + 1));
            AggTable.displayElementArray((PrintWriter)_out, (String)"foreignKeys", (NodeDef[])this.foreignKeys, (int)(_indent + 1));
            AggTable.displayElementArray((PrintWriter)_out, (String)"measures", (NodeDef[])this.measures, (int)(_indent + 1));
            AggTable.displayElementArray((PrintWriter)_out, (String)"levels", (NodeDef[])this.levels, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggTable", new XMLAttrVector().add("ignorecase", (Object)this.ignorecase));
            AggTable.displayXMLElement((XMLOutput)_out, (ElementDef)this.factcount);
            AggTable.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.ignoreColumns);
            AggTable.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.foreignKeys);
            AggTable.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.measures);
            AggTable.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.levels);
            _out.endTag("AggTable");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggTable _cother = (AggTable)_other;
            boolean _diff = AggTable.displayAttributeDiff((String)"ignorecase", (Object)this.ignorecase, (Object)_cother.ignorecase, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggTable.displayElementDiff((String)"factcount", (NodeDef)this.factcount, (NodeDef)_cother.factcount, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggTable.displayElementArrayDiff((String)"ignoreColumns", (NodeDef[])this.ignoreColumns, (NodeDef[])_cother.ignoreColumns, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggTable.displayElementArrayDiff((String)"foreignKeys", (NodeDef[])this.foreignKeys, (NodeDef[])_cother.foreignKeys, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggTable.displayElementArrayDiff((String)"measures", (NodeDef[])this.measures, (NodeDef[])_cother.measures, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggTable.displayElementArrayDiff((String)"levels", (NodeDef[])this.levels, (NodeDef[])_cother.levels, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public boolean isIgnoreCase() {
            return this.ignorecase;
        }

        public AggFactCount getAggFactCount() {
            return this.factcount;
        }

        public AggIgnoreColumn[] getAggIgnoreColumns() {
            return this.ignoreColumns;
        }

        public AggForeignKey[] getAggForeignKeys() {
            return this.foreignKeys;
        }

        public AggMeasure[] getAggMeasures() {
            return this.measures;
        }

        public AggLevel[] getAggLevels() {
            return this.levels;
        }
    }

    public static class Value
    extends ElementDef {
        public String column;
        public DOMWrapper _def;
        public String cdata;

        public Value() {
        }

        public Value(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.column = (String)_parser.getAttribute("column", "String", null, null, true);
                this.cdata = _parser.getText();
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Value";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Value.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
            Value.displayString((PrintWriter)_out, (String)"cdata", (String)this.cdata, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Value", new XMLAttrVector().add("column", (Object)this.column));
            _out.cdata(this.cdata);
            _out.endTag("Value");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Value _cother = (Value)_other;
            boolean _diff = Value.displayAttributeDiff((String)"column", (Object)this.column, (Object)_cother.column, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Value.displayStringDiff((String)"cdata", (String)this.cdata, (String)_cother.cdata, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Row
    extends ElementDef {
        public DOMWrapper _def;
        public Value[] values;

        public Row() {
        }

        public Row(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Value.class, 0, 0);
                this.values = new Value[_tempArray.length];
                for (int _i = 0; _i < this.values.length; ++_i) {
                    this.values[_i] = (Value)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Row";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Row.displayElementArray((PrintWriter)_out, (String)"values", (NodeDef[])this.values, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Row", new XMLAttrVector());
            Row.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.values);
            _out.endTag("Row");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Row _cother = (Row)_other;
            boolean _diff = Row.displayElementArrayDiff((String)"values", (NodeDef[])this.values, (NodeDef[])_cother.values, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Rows
    extends ElementDef
    implements Holder,
    InlineTableElement {
        public DOMWrapper _def;
        public Row[] array;
        private static final Rows EMPTY = new Rows();

        public Rows() {
        }

        public Rows(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Row.class, 0, 0);
                this.array = new Row[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Row)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Rows";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Rows.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Rows", new XMLAttrVector());
            Rows.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Rows");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Rows _cother = (Rows)_other;
            boolean _diff = Rows.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public Rows copy() {
            Rows c = new Rows();
            c.array = (Row[])this.array.clone();
            return c;
        }

        public List<Row> list() {
            return new MutableArrayList<Row>(){

                protected Row[] getArray() {
                    return Rows.this.array == null ? EMPTY.array : Rows.this.array;
                }

                protected void setArray(Row[] ts) {
                    Rows.this.array = ts;
                }
            };
        }

        static {
            Rows.EMPTY.array = new Row[0];
        }
    }

    public static class CalculatedColumnDef
    extends RealOrCalcColumnDef {
        public DOMWrapper _def;
        public Expression expression;

        public CalculatedColumnDef() {
        }

        public CalculatedColumnDef(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.type = (String)_parser.getAttribute("type", "String", null, _type_values, false);
                this.internalType = (String)_parser.getAttribute("internalType", "String", null, null, false);
                this.expression = (Expression)_parser.getElement(Expression.class, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CalculatedColumnDef";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CalculatedColumnDef.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            CalculatedColumnDef.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
            CalculatedColumnDef.displayAttribute((PrintWriter)_out, (String)"internalType", (Object)this.internalType, (int)(_indent + 1));
            CalculatedColumnDef.displayElement((PrintWriter)_out, (String)"expression", (ElementDef)((ElementDef)this.expression), (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CalculatedColumnDef", new XMLAttrVector().add("name", (Object)this.name).add("type", (Object)this.type).add("internalType", (Object)this.internalType));
            CalculatedColumnDef.displayXMLElement((XMLOutput)_out, (ElementDef)((ElementDef)this.expression));
            _out.endTag("CalculatedColumnDef");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CalculatedColumnDef _cother = (CalculatedColumnDef)_other;
            boolean _diff = CalculatedColumnDef.displayElementDiff((String)"expression", (NodeDef)this.expression, (NodeDef)_cother.expression, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class TimeDomain
    extends ElementDef {
        public String role;
        public String epoch;
        public DOMWrapper _def;

        public TimeDomain() {
        }

        public TimeDomain(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.role = (String)_parser.getAttribute("role", "String", null, null, false);
                this.epoch = (String)_parser.getAttribute("epoch", "String", null, null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "TimeDomain";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            TimeDomain.displayAttribute((PrintWriter)_out, (String)"role", (Object)this.role, (int)(_indent + 1));
            TimeDomain.displayAttribute((PrintWriter)_out, (String)"epoch", (Object)this.epoch, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("TimeDomain", new XMLAttrVector().add("role", (Object)this.role).add("epoch", (Object)this.epoch));
            _out.endTag("TimeDomain");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            TimeDomain _cother = (TimeDomain)_other;
            boolean _diff = TimeDomain.displayAttributeDiff((String)"role", (Object)this.role, (Object)_cother.role, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && TimeDomain.displayAttributeDiff((String)"epoch", (Object)this.epoch, (Object)_cother.epoch, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class ColumnDef
    extends RealOrCalcColumnDef {
        public DOMWrapper _def;
        public TimeDomain timeDomain;

        public ColumnDef() {
        }

        public ColumnDef(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.type = (String)_parser.getAttribute("type", "String", null, _type_values, false);
                this.internalType = (String)_parser.getAttribute("internalType", "String", null, null, false);
                this.timeDomain = (TimeDomain)_parser.getElement(TimeDomain.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "ColumnDef";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            ColumnDef.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            ColumnDef.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
            ColumnDef.displayAttribute((PrintWriter)_out, (String)"internalType", (Object)this.internalType, (int)(_indent + 1));
            ColumnDef.displayElement((PrintWriter)_out, (String)"timeDomain", (ElementDef)this.timeDomain, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("ColumnDef", new XMLAttrVector().add("name", (Object)this.name).add("type", (Object)this.type).add("internalType", (Object)this.internalType));
            ColumnDef.displayXMLElement((XMLOutput)_out, (ElementDef)this.timeDomain);
            _out.endTag("ColumnDef");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            ColumnDef _cother = (ColumnDef)_other;
            boolean _diff = ColumnDef.displayElementDiff((String)"timeDomain", (NodeDef)this.timeDomain, (NodeDef)_cother.timeDomain, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static abstract class RealOrCalcColumnDef
    extends ElementDef {
        public String name;
        public static final String[] _type_values = new String[]{"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp"};
        public String type;
        public String internalType;
        public DOMWrapper _def;

        public RealOrCalcColumnDef() {
        }

        public RealOrCalcColumnDef(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.type = (String)_parser.getAttribute("type", "String", null, _type_values, false);
                this.internalType = (String)_parser.getAttribute("internalType", "String", null, null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "RealOrCalcColumnDef";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            RealOrCalcColumnDef.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            RealOrCalcColumnDef.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
            RealOrCalcColumnDef.displayAttribute((PrintWriter)_out, (String)"internalType", (Object)this.internalType, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("RealOrCalcColumnDef", new XMLAttrVector().add("name", (Object)this.name).add("type", (Object)this.type).add("internalType", (Object)this.internalType));
            _out.endTag("RealOrCalcColumnDef");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            RealOrCalcColumnDef _cother = (RealOrCalcColumnDef)_other;
            boolean _diff = RealOrCalcColumnDef.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && RealOrCalcColumnDef.displayAttributeDiff((String)"type", (Object)this.type, (Object)_cother.type, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && RealOrCalcColumnDef.displayAttributeDiff((String)"internalType", (Object)this.internalType, (Object)_cother.internalType, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnDefs
    extends ElementDef
    implements Holder,
    TableElement,
    InlineTableElement {
        public DOMWrapper _def;
        public RealOrCalcColumnDef[] array;
        private static final ColumnDefs EMPTY = new ColumnDefs();

        public ColumnDefs() {
        }

        public ColumnDefs(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(RealOrCalcColumnDef.class, 0, 0);
                this.array = new RealOrCalcColumnDef[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (RealOrCalcColumnDef)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "ColumnDefs";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            ColumnDefs.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("ColumnDefs", new XMLAttrVector());
            ColumnDefs.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("ColumnDefs");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            ColumnDefs _cother = (ColumnDefs)_other;
            boolean _diff = ColumnDefs.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public ColumnDefs copy() {
            ColumnDefs c = new ColumnDefs();
            c.array = (RealOrCalcColumnDef[])this.array.clone();
            return c;
        }

        public List<RealOrCalcColumnDef> list() {
            return new MutableArrayList<RealOrCalcColumnDef>(){

                protected RealOrCalcColumnDef[] getArray() {
                    return ColumnDefs.this.array == null ? EMPTY.array : ColumnDefs.this.array;
                }

                protected void setArray(RealOrCalcColumnDef[] ts) {
                    ColumnDefs.this.array = ts;
                }
            };
        }

        static {
            ColumnDefs.EMPTY.array = new RealOrCalcColumnDef[0];
        }
    }

    public static class AutoGeneratedDateTable
    extends Table {
        public String startDate;
        public String endDate;
        public DOMWrapper _def;

        public AutoGeneratedDateTable() {
        }

        public AutoGeneratedDateTable(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.startDate = (String)_parser.getAttribute("startDate", "String", null, null, true);
                this.endDate = (String)_parser.getAttribute("endDate", "String", null, null, true);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.schema = (String)_parser.getAttribute("schema", "String", null, null, false);
                this.alias = (String)_parser.getAttribute("alias", "String", null, null, false);
                this.keyColumn = (String)_parser.getAttribute("keyColumn", "String", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(TableElement.class, 0, 0);
                this.childArray = new TableElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (TableElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AutoGeneratedDateTable";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AutoGeneratedDateTable.displayAttribute((PrintWriter)_out, (String)"startDate", (Object)this.startDate, (int)(_indent + 1));
            AutoGeneratedDateTable.displayAttribute((PrintWriter)_out, (String)"endDate", (Object)this.endDate, (int)(_indent + 1));
            AutoGeneratedDateTable.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            AutoGeneratedDateTable.displayAttribute((PrintWriter)_out, (String)"schema", (Object)this.schema, (int)(_indent + 1));
            AutoGeneratedDateTable.displayAttribute((PrintWriter)_out, (String)"alias", (Object)this.alias, (int)(_indent + 1));
            AutoGeneratedDateTable.displayAttribute((PrintWriter)_out, (String)"keyColumn", (Object)this.keyColumn, (int)(_indent + 1));
            AutoGeneratedDateTable.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AutoGeneratedDateTable", new XMLAttrVector().add("startDate", (Object)this.startDate).add("endDate", (Object)this.endDate).add("name", (Object)this.name).add("schema", (Object)this.schema).add("alias", (Object)this.alias).add("keyColumn", (Object)this.keyColumn));
            AutoGeneratedDateTable.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("AutoGeneratedDateTable");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AutoGeneratedDateTable _cother = (AutoGeneratedDateTable)_other;
            boolean _diff = AutoGeneratedDateTable.displayAttributeDiff((String)"startDate", (Object)this.startDate, (Object)_cother.startDate, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AutoGeneratedDateTable.displayAttributeDiff((String)"endDate", (Object)this.endDate, (Object)_cother.endDate, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AutoGeneratedDateTable.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InlineTable
    extends ElementDef
    implements Relation {
        public String alias;
        public DOMWrapper _def;
        public InlineTableElement[] childArray;
        private static final InlineTableElement[] EMPTY = new InlineTableElement[0];
        public final Children<InlineTableElement> children = new Children<InlineTableElement>(InlineTableElement.class, new Class[]{ColumnDefs.class, Rows.class, Key.class}){

            InlineTableElement[] getArray() {
                return InlineTable.this.childArray == null ? EMPTY : InlineTable.this.childArray;
            }

            void setArray(InlineTableElement[] ts) {
                InlineTable.this.childArray = ts;
            }
        };

        public InlineTable() {
        }

        public InlineTable(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.alias = (String)_parser.getAttribute("alias", "String", null, null, true);
                NodeDef[] _tempArray = _parser.getArray(InlineTableElement.class, 0, 0);
                this.childArray = new InlineTableElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (InlineTableElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "InlineTable";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            InlineTable.displayAttribute((PrintWriter)_out, (String)"alias", (Object)this.alias, (int)(_indent + 1));
            InlineTable.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("InlineTable", new XMLAttrVector().add("alias", (Object)this.alias));
            InlineTable.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("InlineTable");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            InlineTable _cother = (InlineTable)_other;
            boolean _diff = InlineTable.displayAttributeDiff((String)"alias", (Object)this.alias, (Object)_cother.alias, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && InlineTable.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        public List<RealOrCalcColumnDef> getColumnDefs() {
            return this.children.only(ColumnDefs.EMPTY).list();
        }

        public List<Row> getRows() {
            return this.children.only(Rows.EMPTY).list();
        }

        public Key getKey() {
            return this.children.singleton(Key.class);
        }
    }

    public static class Hint
    extends ElementDef {
        public String type;
        public DOMWrapper _def;
        public String cdata;

        public Hint() {
        }

        public Hint(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.type = (String)_parser.getAttribute("type", "String", null, null, true);
                this.cdata = _parser.getText();
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Hint";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Hint.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
            Hint.displayString((PrintWriter)_out, (String)"cdata", (String)this.cdata, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Hint", new XMLAttrVector().add("type", (Object)this.type));
            _out.cdata(this.cdata);
            _out.endTag("Hint");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Hint _cother = (Hint)_other;
            boolean _diff = Hint.displayAttributeDiff((String)"type", (Object)this.type, (Object)_cother.type, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hint.displayStringDiff((String)"cdata", (String)this.cdata, (String)_cother.cdata, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Hints
    extends ElementDef
    implements Holder,
    TableElement {
        public DOMWrapper _def;
        public Hint[] array;
        private static final Hints EMPTY = new Hints();

        public Hints() {
        }

        public Hints(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Hint.class, 0, 0);
                this.array = new Hint[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Hint)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Hints";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Hints.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Hints", new XMLAttrVector());
            Hints.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Hints");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Hints _cother = (Hints)_other;
            boolean _diff = Hints.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public Hints copy() {
            Hints c = new Hints();
            c.array = (Hint[])this.array.clone();
            return c;
        }

        public List<Hint> list() {
            return new MutableArrayList<Hint>(){

                protected Hint[] getArray() {
                    return Hints.this.array == null ? EMPTY.array : Hints.this.array;
                }

                protected void setArray(Hint[] ts) {
                    Hints.this.array = ts;
                }
            };
        }

        static {
            Hints.EMPTY.array = new Hint[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Table
    extends ElementDef
    implements Relation {
        public String name;
        public String schema;
        public String alias;
        public String keyColumn;
        public DOMWrapper _def;
        public TableElement[] childArray;
        private static final TableElement[] EMPTY = new TableElement[0];
        public final Children<TableElement> children = new Children<TableElement>(TableElement.class, new Class[]{ColumnDefs.class, Key.class, Hints.class}){

            TableElement[] getArray() {
                return Table.this.childArray == null ? EMPTY : Table.this.childArray;
            }

            void setArray(TableElement[] ts) {
                Table.this.childArray = ts;
            }
        };

        public Table() {
        }

        public Table(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.schema = (String)_parser.getAttribute("schema", "String", null, null, false);
                this.alias = (String)_parser.getAttribute("alias", "String", null, null, false);
                this.keyColumn = (String)_parser.getAttribute("keyColumn", "String", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(TableElement.class, 0, 0);
                this.childArray = new TableElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (TableElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Table";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Table.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Table.displayAttribute((PrintWriter)_out, (String)"schema", (Object)this.schema, (int)(_indent + 1));
            Table.displayAttribute((PrintWriter)_out, (String)"alias", (Object)this.alias, (int)(_indent + 1));
            Table.displayAttribute((PrintWriter)_out, (String)"keyColumn", (Object)this.keyColumn, (int)(_indent + 1));
            Table.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Table", new XMLAttrVector().add("name", (Object)this.name).add("schema", (Object)this.schema).add("alias", (Object)this.alias).add("keyColumn", (Object)this.keyColumn));
            Table.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("Table");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Table _cother = (Table)_other;
            boolean _diff = Table.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Table.displayAttributeDiff((String)"schema", (Object)this.schema, (Object)_cother.schema, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Table.displayAttributeDiff((String)"alias", (Object)this.alias, (Object)_cother.alias, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Table.displayAttributeDiff((String)"keyColumn", (Object)this.keyColumn, (Object)_cother.keyColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Table.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getAlias() {
            return this.alias != null ? this.alias : this.name;
        }

        public List<RealOrCalcColumnDef> getColumnDefs() {
            return this.children.only(ColumnDefs.EMPTY).list();
        }

        public List<Key> getKeys() {
            return this.children.filter(Key.class);
        }

        public List<Hint> getHints() {
            return this.children.only(Hints.EMPTY).list();
        }
    }

    public static class SQL
    extends ElementDef
    implements Any {
        public String dialect;
        public DOMWrapper _def;
        public NodeDef[] children;

        public SQL() {
        }

        public SQL(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.dialect = (String)_parser.getAttribute("dialect", "String", "generic", null, true);
                this.children = SQL.getMixedChildren((DOMWrapper)_def, MondrianDef.class, (String)"");
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public NodeDef[] getChildren() {
            return this.children;
        }

        public void setChildren(NodeDef[] children) {
            this.children = children;
        }

        public String getName() {
            return "SQL";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            SQL.displayAttribute((PrintWriter)_out, (String)"dialect", (Object)this.dialect, (int)(_indent + 1));
            SQL.displayElementArray((PrintWriter)_out, (String)"children", (NodeDef[])this.children, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("SQL", new XMLAttrVector().add("dialect", (Object)this.dialect));
            SQL.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.children);
            _out.endTag("SQL");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            SQL _cother = (SQL)_other;
            boolean _diff = SQL.displayAttributeDiff((String)"dialect", (Object)this.dialect, (Object)_cother.dialect, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && SQL.displayElementArrayDiff((String)"children", (NodeDef[])this.children, (NodeDef[])_cother.children, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public int hashCode() {
            return this.dialect.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SQL)) {
                return false;
            }
            SQL that = (SQL)((Object)obj);
            return this.dialect.equals(that.dialect) && Util.equals(this.getCData(), that.getCData());
        }

        public void setCData(String cdata) {
            this.children = new NodeDef[]{new TextDef(cdata)};
        }

        public String getCData() {
            StringBuilder buf = new StringBuilder();
            for (NodeDef child : this.children) {
                buf.append("x");
            }
            return buf.toString();
        }

        public static SqlQuery.CodeSet toCodeSet(SQL[] sqls) {
            SqlQuery.CodeSet codeSet = new SqlQuery.CodeSet();
            for (SQL sql : sqls) {
                codeSet.put(sql.dialect, sql.getCData());
            }
            return codeSet;
        }

        public static SQL choose(SQL[] sqls, Dialect dialect) {
            String best = SqlQuery.getBestName(dialect);
            SQL genericSql = null;
            for (SQL sql : sqls) {
                if (sql.dialect.equals(best)) {
                    return sql;
                }
                if (!sql.dialect.equals("generic")) continue;
                genericSql = sql;
            }
            if (genericSql == null) {
                throw Util.newError("View has no 'generic' variant");
            }
            return genericSql;
        }
    }

    public static interface QueryElement
    extends NodeDef {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Query
    extends ElementDef
    implements Relation {
        public String alias;
        public String keyColumn;
        public DOMWrapper _def;
        public QueryElement[] childArray;
        private static final QueryElement[] EMPTY = new QueryElement[0];
        public final Children<QueryElement> children = new Children<QueryElement>(QueryElement.class, new Class[]{Key.class, ExpressionView.class, Annotations.class}){

            QueryElement[] getArray() {
                return Query.this.childArray == null ? EMPTY : Query.this.childArray;
            }

            void setArray(QueryElement[] ts) {
                Query.this.childArray = ts;
            }
        };

        public Query() {
        }

        public Query(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.alias = (String)_parser.getAttribute("alias", "String", null, null, true);
                this.keyColumn = (String)_parser.getAttribute("keyColumn", "String", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(QueryElement.class, 0, 0);
                this.childArray = new QueryElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (QueryElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Query";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Query.displayAttribute((PrintWriter)_out, (String)"alias", (Object)this.alias, (int)(_indent + 1));
            Query.displayAttribute((PrintWriter)_out, (String)"keyColumn", (Object)this.keyColumn, (int)(_indent + 1));
            Query.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Query", new XMLAttrVector().add("alias", (Object)this.alias).add("keyColumn", (Object)this.keyColumn));
            Query.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("Query");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Query _cother = (Query)_other;
            boolean _diff = Query.displayAttributeDiff((String)"alias", (Object)this.alias, (Object)_cother.alias, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Query.displayAttributeDiff((String)"keyColumn", (Object)this.keyColumn, (Object)_cother.keyColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Query.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        public List<Key> getKeys() {
            return this.children.filter(Key.class);
        }

        public ExpressionView getExpressionView() throws Missing {
            return this.children.requiredSingleton(this, ExpressionView.class);
        }

        public NamedList<Annotation> getAnnotations() {
            return this.children.only(Annotations.EMPTY).list();
        }
    }

    public static interface Relation
    extends PhysicalSchemaElement {
        public String getAlias();
    }

    public static interface PhysicalSchemaElement
    extends NodeDef {
    }

    public static class Formula
    extends ElementDef
    implements CalculatedMemberElement,
    NamedSetElement {
        public DOMWrapper _def;
        public String cdata;

        public Formula() {
        }

        public Formula(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.cdata = _parser.getText();
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Formula";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Formula.displayString((PrintWriter)_out, (String)"cdata", (String)this.cdata, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Formula", new XMLAttrVector());
            _out.cdata(this.cdata);
            _out.endTag("Formula");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Formula _cother = (Formula)_other;
            boolean _diff = Formula.displayStringDiff((String)"cdata", (String)this.cdata, (String)_cother.cdata, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamedSet
    extends ElementDef
    implements NamedElement,
    SchemaElement {
        public String name;
        public String caption;
        public String description;
        public String formula;
        public DOMWrapper _def;
        public CalculatedMemberElement[] childArray;
        private static final CalculatedMemberElement[] EMPTY = new CalculatedMemberElement[0];
        public final Children<CalculatedMemberElement> children = new Children<CalculatedMemberElement>(CalculatedMemberElement.class, new Class[]{Annotations.class, CalculatedMemberProperty.class, Formula.class}){

            CalculatedMemberElement[] getArray() {
                return NamedSet.this.childArray == null ? EMPTY : NamedSet.this.childArray;
            }

            void setArray(CalculatedMemberElement[] ts) {
                NamedSet.this.childArray = ts;
            }
        };

        public NamedSet() {
        }

        public NamedSet(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.formula = (String)_parser.getAttribute("formula", "String", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(CalculatedMemberElement.class, 0, 0);
                this.childArray = new CalculatedMemberElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (CalculatedMemberElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "NamedSet";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            NamedSet.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            NamedSet.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            NamedSet.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            NamedSet.displayAttribute((PrintWriter)_out, (String)"formula", (Object)this.formula, (int)(_indent + 1));
            NamedSet.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("NamedSet", new XMLAttrVector().add("name", (Object)this.name).add("caption", (Object)this.caption).add("description", (Object)this.description).add("formula", (Object)this.formula));
            NamedSet.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("NamedSet");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            NamedSet _cother = (NamedSet)_other;
            boolean _diff = NamedSet.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && NamedSet.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && NamedSet.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && NamedSet.displayAttributeDiff((String)"formula", (Object)this.formula, (Object)_cother.formula, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && NamedSet.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getNameAttribute() {
            return this.name;
        }

        public Formula getFormula() {
            return this.children.singleton(Formula.class);
        }

        public NamedList<Annotation> getAnnotations() {
            return this.children.only(Annotations.EMPTY).list();
        }

        public NamedList<CalculatedMemberProperty> getCalculatedMemberProperties() {
            return this.children.filterNamed(CalculatedMemberProperty.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamedSets
    extends ElementDef
    implements Holder,
    CubeElement {
        public DOMWrapper _def;
        public NamedSet[] array;
        private static final NamedSets EMPTY = new NamedSets();

        public NamedSets() {
        }

        public NamedSets(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(NamedSet.class, 0, 0);
                this.array = new NamedSet[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (NamedSet)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "NamedSets";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            NamedSets.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("NamedSets", new XMLAttrVector());
            NamedSets.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("NamedSets");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            NamedSets _cother = (NamedSets)_other;
            boolean _diff = NamedSets.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public NamedSets copy() {
            NamedSets c = new NamedSets();
            c.array = (NamedSet[])this.array.clone();
            return c;
        }

        public NamedList<NamedSet> list() {
            return new NamedListImpl<NamedSet>(new MutableArrayList<NamedSet>(){

                protected NamedSet[] getArray() {
                    return NamedSets.this.array == null ? EMPTY.array : NamedSets.this.array;
                }

                protected void setArray(NamedSet[] ts) {
                    NamedSets.this.array = ts;
                }
            });
        }

        static {
            NamedSets.EMPTY.array = new NamedSet[0];
        }
    }

    public static class CalculatedMemberProperty
    extends ElementDef
    implements NamedElement,
    MeasureElement,
    CalculatedMemberElement {
        public String name;
        public String caption;
        public String description;
        public String expression;
        public String value;
        public DOMWrapper _def;

        public CalculatedMemberProperty() {
        }

        public CalculatedMemberProperty(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.expression = (String)_parser.getAttribute("expression", "String", null, null, false);
                this.value = (String)_parser.getAttribute("value", "String", null, null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CalculatedMemberProperty";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CalculatedMemberProperty.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            CalculatedMemberProperty.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            CalculatedMemberProperty.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            CalculatedMemberProperty.displayAttribute((PrintWriter)_out, (String)"expression", (Object)this.expression, (int)(_indent + 1));
            CalculatedMemberProperty.displayAttribute((PrintWriter)_out, (String)"value", (Object)this.value, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CalculatedMemberProperty", new XMLAttrVector().add("name", (Object)this.name).add("caption", (Object)this.caption).add("description", (Object)this.description).add("expression", (Object)this.expression).add("value", (Object)this.value));
            _out.endTag("CalculatedMemberProperty");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CalculatedMemberProperty _cother = (CalculatedMemberProperty)_other;
            boolean _diff = CalculatedMemberProperty.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMemberProperty.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMemberProperty.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMemberProperty.displayAttributeDiff((String)"expression", (Object)this.expression, (Object)_cother.expression, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMemberProperty.displayAttributeDiff((String)"value", (Object)this.value, (Object)_cother.value, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CalculatedMember
    extends ElementDef
    implements NamedElement {
        public String name;
        public String formatString;
        public String caption;
        public String description;
        public String formula;
        public String dimension;
        public String hierarchy;
        public String parent;
        public Boolean visible;
        public DOMWrapper _def;
        public CalculatedMemberElement[] childArray;
        private static final CalculatedMemberElement[] EMPTY = new CalculatedMemberElement[0];
        public final Children<CalculatedMemberElement> children = new Children<CalculatedMemberElement>(CalculatedMemberElement.class, new Class[]{Annotations.class, CalculatedMemberProperty.class, CellFormatter.class, Formula.class}){

            CalculatedMemberElement[] getArray() {
                return CalculatedMember.this.childArray == null ? EMPTY : CalculatedMember.this.childArray;
            }

            void setArray(CalculatedMemberElement[] ts) {
                CalculatedMember.this.childArray = ts;
            }
        };

        public CalculatedMember() {
        }

        public CalculatedMember(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.formatString = (String)_parser.getAttribute("formatString", "String", null, null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.formula = (String)_parser.getAttribute("formula", "String", null, null, false);
                this.dimension = (String)_parser.getAttribute("dimension", "String", null, null, false);
                this.hierarchy = (String)_parser.getAttribute("hierarchy", "String", null, null, false);
                this.parent = (String)_parser.getAttribute("parent", "String", null, null, false);
                this.visible = (Boolean)_parser.getAttribute("visible", "Boolean", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(CalculatedMemberElement.class, 0, 0);
                this.childArray = new CalculatedMemberElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (CalculatedMemberElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "CalculatedMember";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"formatString", (Object)this.formatString, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"formula", (Object)this.formula, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"dimension", (Object)this.dimension, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"hierarchy", (Object)this.hierarchy, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"parent", (Object)this.parent, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"visible", (Object)this.visible, (int)(_indent + 1));
            CalculatedMember.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CalculatedMember", new XMLAttrVector().add("name", (Object)this.name).add("formatString", (Object)this.formatString).add("caption", (Object)this.caption).add("description", (Object)this.description).add("formula", (Object)this.formula).add("dimension", (Object)this.dimension).add("hierarchy", (Object)this.hierarchy).add("parent", (Object)this.parent).add("visible", (Object)this.visible));
            CalculatedMember.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("CalculatedMember");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CalculatedMember _cother = (CalculatedMember)_other;
            boolean _diff = CalculatedMember.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"formatString", (Object)this.formatString, (Object)_cother.formatString, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"formula", (Object)this.formula, (Object)_cother.formula, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"dimension", (Object)this.dimension, (Object)_cother.dimension, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"hierarchy", (Object)this.hierarchy, (Object)_cother.hierarchy, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"parent", (Object)this.parent, (Object)_cother.parent, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"visible", (Object)this.visible, (Object)_cother.visible, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getNameAttribute() {
            return this.name;
        }

        public Formula getFormula() {
            return this.children.singleton(Formula.class);
        }

        public CellFormatter getCellFormatter() {
            return this.children.singleton(CellFormatter.class);
        }

        public NamedList<Annotation> getAnnotations() {
            return this.children.only(Annotations.EMPTY).list();
        }

        public NamedList<CalculatedMemberProperty> getCalculatedMemberProperties() {
            return this.children.filterNamed(CalculatedMemberProperty.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CalculatedMembers
    extends ElementDef
    implements Holder,
    CubeElement {
        public DOMWrapper _def;
        public CalculatedMember[] array;
        private static final CalculatedMembers EMPTY = new CalculatedMembers();

        public CalculatedMembers() {
        }

        public CalculatedMembers(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(CalculatedMember.class, 0, 0);
                this.array = new CalculatedMember[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (CalculatedMember)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CalculatedMembers";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CalculatedMembers.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CalculatedMembers", new XMLAttrVector());
            CalculatedMembers.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("CalculatedMembers");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CalculatedMembers _cother = (CalculatedMembers)_other;
            boolean _diff = CalculatedMembers.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public CalculatedMembers copy() {
            CalculatedMembers c = new CalculatedMembers();
            c.array = (CalculatedMember[])this.array.clone();
            return c;
        }

        public NamedList<CalculatedMember> list() {
            return new NamedListImpl<CalculatedMember>(new MutableArrayList<CalculatedMember>(){

                protected CalculatedMember[] getArray() {
                    return CalculatedMembers.this.array == null ? EMPTY.array : CalculatedMembers.this.array;
                }

                protected void setArray(CalculatedMember[] ts) {
                    CalculatedMembers.this.array = ts;
                }
            });
        }

        static {
            CalculatedMembers.EMPTY.array = new CalculatedMember[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Measure
    extends MeasureOrRef {
        public String name;
        public String column;
        public String table;
        public String formatString;
        public static final String[] _datatype_values = new String[]{"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp"};
        public String datatype;
        public String aggregator;
        public String formatter;
        public String caption;
        public String description;
        public Boolean visible;
        public DOMWrapper _def;
        public MeasureElement[] childArray;
        private static final MeasureElement[] EMPTY = new MeasureElement[0];
        public final Children<MeasureElement> children = new Children<MeasureElement>(MeasureElement.class, new Class[]{Arguments.class, Annotations.class, CalculatedMemberProperty.class, CellFormatter.class}){

            MeasureElement[] getArray() {
                return Measure.this.childArray == null ? EMPTY : Measure.this.childArray;
            }

            void setArray(MeasureElement[] ts) {
                Measure.this.childArray = ts;
            }
        };

        public Measure() {
        }

        public Measure(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.column = (String)_parser.getAttribute("column", "String", null, null, false);
                this.table = (String)_parser.getAttribute("table", "String", null, null, false);
                this.formatString = (String)_parser.getAttribute("formatString", "String", null, null, false);
                this.datatype = (String)_parser.getAttribute("datatype", "String", null, _datatype_values, false);
                this.aggregator = (String)_parser.getAttribute("aggregator", "String", null, null, true);
                this.formatter = (String)_parser.getAttribute("formatter", "String", null, null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.visible = (Boolean)_parser.getAttribute("visible", "Boolean", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(MeasureElement.class, 0, 0);
                this.childArray = new MeasureElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (MeasureElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Measure";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Measure.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"table", (Object)this.table, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"formatString", (Object)this.formatString, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"datatype", (Object)this.datatype, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"aggregator", (Object)this.aggregator, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"formatter", (Object)this.formatter, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"visible", (Object)this.visible, (int)(_indent + 1));
            Measure.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Measure", new XMLAttrVector().add("name", (Object)this.name).add("column", (Object)this.column).add("table", (Object)this.table).add("formatString", (Object)this.formatString).add("datatype", (Object)this.datatype).add("aggregator", (Object)this.aggregator).add("formatter", (Object)this.formatter).add("caption", (Object)this.caption).add("description", (Object)this.description).add("visible", (Object)this.visible));
            Measure.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("Measure");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Measure _cother = (Measure)_other;
            boolean _diff = Measure.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"column", (Object)this.column, (Object)_cother.column, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"table", (Object)this.table, (Object)_cother.table, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"formatString", (Object)this.formatString, (Object)_cother.formatString, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"datatype", (Object)this.datatype, (Object)_cother.datatype, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"aggregator", (Object)this.aggregator, (Object)_cother.aggregator, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"formatter", (Object)this.formatter, (Object)_cother.formatter, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"visible", (Object)this.visible, (Object)_cother.visible, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getNameAttribute() {
            return this.name;
        }

        public NamedList<CalculatedMemberProperty> getCalculatedMemberProperties() {
            return this.children.filterNamed(CalculatedMemberProperty.class);
        }

        public Arguments getArguments() {
            return this.children.singleton(Arguments.class);
        }

        public CellFormatter getCellFormatter() {
            return this.children.singleton(CellFormatter.class);
        }

        public NamedList<Annotation> getAnnotations() {
            return this.children.only(Annotations.EMPTY).list();
        }
    }

    public static class MeasureRef
    extends MeasureOrRef {
        public String name;
        public String aggColumn;
        public DOMWrapper _def;

        public MeasureRef() {
        }

        public MeasureRef(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.aggColumn = (String)_parser.getAttribute("aggColumn", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "MeasureRef";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            MeasureRef.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            MeasureRef.displayAttribute((PrintWriter)_out, (String)"aggColumn", (Object)this.aggColumn, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("MeasureRef", new XMLAttrVector().add("name", (Object)this.name).add("aggColumn", (Object)this.aggColumn));
            _out.endTag("MeasureRef");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            MeasureRef _cother = (MeasureRef)_other;
            boolean _diff = MeasureRef.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && MeasureRef.displayAttributeDiff((String)"aggColumn", (Object)this.aggColumn, (Object)_cother.aggColumn, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }
    }

    public static abstract class MeasureOrRef
    extends ElementDef
    implements NamedElement {
        public DOMWrapper _def;

        public MeasureOrRef() {
        }

        public MeasureOrRef(DOMWrapper _def) throws XOMException {
        }

        public String getName() {
            return "MeasureOrRef";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("MeasureOrRef", new XMLAttrVector());
            _out.endTag("MeasureOrRef");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Property
    extends ElementDef
    implements NamedElement,
    AttributeElement {
        public String name;
        public String attribute;
        public String caption;
        public String description;
        public String formatter;
        public DOMWrapper _def;
        public PropertyElement[] childArray;
        private static final PropertyElement[] EMPTY = new PropertyElement[0];
        public final Children<PropertyElement> children = new Children<PropertyElement>(PropertyElement.class, new Class[]{PropertyFormatter.class, Annotations.class}){

            PropertyElement[] getArray() {
                return Property.this.childArray == null ? EMPTY : Property.this.childArray;
            }

            void setArray(PropertyElement[] ts) {
                Property.this.childArray = ts;
            }
        };

        public Property() {
        }

        public Property(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.attribute = (String)_parser.getAttribute("attribute", "String", null, null, true);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.formatter = (String)_parser.getAttribute("formatter", "String", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(PropertyElement.class, 0, 0);
                this.childArray = new PropertyElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (PropertyElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Property";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Property.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Property.displayAttribute((PrintWriter)_out, (String)"attribute", (Object)this.attribute, (int)(_indent + 1));
            Property.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Property.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Property.displayAttribute((PrintWriter)_out, (String)"formatter", (Object)this.formatter, (int)(_indent + 1));
            Property.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Property", new XMLAttrVector().add("name", (Object)this.name).add("attribute", (Object)this.attribute).add("caption", (Object)this.caption).add("description", (Object)this.description).add("formatter", (Object)this.formatter));
            Property.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("Property");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Property _cother = (Property)_other;
            boolean _diff = Property.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Property.displayAttributeDiff((String)"attribute", (Object)this.attribute, (Object)_cother.attribute, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Property.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Property.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Property.displayAttributeDiff((String)"formatter", (Object)this.formatter, (Object)_cother.formatter, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Property.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getNameAttribute() {
            return MondrianDef.first(this.name, this.attribute);
        }

        public PropertyFormatter getFormatter() {
            return this.children.singleton(PropertyFormatter.class);
        }

        public NamedList<Annotation> getAnnotations() {
            return this.children.only(Annotations.EMPTY).list();
        }
    }

    public static class Closure
    extends ElementDef
    implements LevelElement {
        public String parentColumn;
        public String childColumn;
        public String distanceColumn;
        public String table;
        public DOMWrapper _def;

        public Closure() {
        }

        public Closure(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.parentColumn = (String)_parser.getAttribute("parentColumn", "String", null, null, true);
                this.childColumn = (String)_parser.getAttribute("childColumn", "String", null, null, true);
                this.distanceColumn = (String)_parser.getAttribute("distanceColumn", "String", "distance", null, false);
                this.table = (String)_parser.getAttribute("table", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Closure";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Closure.displayAttribute((PrintWriter)_out, (String)"parentColumn", (Object)this.parentColumn, (int)(_indent + 1));
            Closure.displayAttribute((PrintWriter)_out, (String)"childColumn", (Object)this.childColumn, (int)(_indent + 1));
            Closure.displayAttribute((PrintWriter)_out, (String)"distanceColumn", (Object)this.distanceColumn, (int)(_indent + 1));
            Closure.displayAttribute((PrintWriter)_out, (String)"table", (Object)this.table, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Closure", new XMLAttrVector().add("parentColumn", (Object)this.parentColumn).add("childColumn", (Object)this.childColumn).add("distanceColumn", (Object)this.distanceColumn).add("table", (Object)this.table));
            _out.endTag("Closure");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Closure _cother = (Closure)_other;
            boolean _diff = Closure.displayAttributeDiff((String)"parentColumn", (Object)this.parentColumn, (Object)_cother.parentColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Closure.displayAttributeDiff((String)"childColumn", (Object)this.childColumn, (Object)_cother.childColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Closure.displayAttributeDiff((String)"distanceColumn", (Object)this.distanceColumn, (Object)_cother.distanceColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Closure.displayAttributeDiff((String)"table", (Object)this.table, (Object)_cother.table, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Level
    extends ElementDef
    implements NamedElement,
    HierarchyElement {
        public String name;
        public Boolean visible;
        public String attribute;
        public String parentAttribute;
        public String nullParentValue;
        public static final String[] _hideMemberIf_values = new String[]{"Never", "IfBlankName", "IfParentsName"};
        public String hideMemberIf;
        public String formatter;
        public String caption;
        public String description;
        public DOMWrapper _def;
        public LevelElement[] childArray;
        private static final LevelElement[] EMPTY = new LevelElement[0];
        public final Children<LevelElement> children = new Children<LevelElement>(LevelElement.class, new Class[]{Closure.class, Annotations.class}){

            LevelElement[] getArray() {
                return Level.this.childArray == null ? EMPTY : Level.this.childArray;
            }

            void setArray(LevelElement[] ts) {
                Level.this.childArray = ts;
            }
        };

        public Level() {
        }

        public Level(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
                this.attribute = (String)_parser.getAttribute("attribute", "String", null, null, true);
                this.parentAttribute = (String)_parser.getAttribute("parentAttribute", "String", null, null, false);
                this.nullParentValue = (String)_parser.getAttribute("nullParentValue", "String", null, null, false);
                this.hideMemberIf = (String)_parser.getAttribute("hideMemberIf", "String", "Never", _hideMemberIf_values, false);
                this.formatter = (String)_parser.getAttribute("formatter", "String", null, null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(LevelElement.class, 0, 0);
                this.childArray = new LevelElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (LevelElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Level";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Level.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"visible", (Object)this.visible, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"attribute", (Object)this.attribute, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"parentAttribute", (Object)this.parentAttribute, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"nullParentValue", (Object)this.nullParentValue, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"hideMemberIf", (Object)this.hideMemberIf, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"formatter", (Object)this.formatter, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Level.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Level", new XMLAttrVector().add("name", (Object)this.name).add("visible", (Object)this.visible).add("attribute", (Object)this.attribute).add("parentAttribute", (Object)this.parentAttribute).add("nullParentValue", (Object)this.nullParentValue).add("hideMemberIf", (Object)this.hideMemberIf).add("formatter", (Object)this.formatter).add("caption", (Object)this.caption).add("description", (Object)this.description));
            Level.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("Level");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Level _cother = (Level)_other;
            boolean _diff = Level.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"visible", (Object)this.visible, (Object)_cother.visible, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"attribute", (Object)this.attribute, (Object)_cother.attribute, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"parentAttribute", (Object)this.parentAttribute, (Object)_cother.parentAttribute, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"nullParentValue", (Object)this.nullParentValue, (Object)_cother.nullParentValue, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"hideMemberIf", (Object)this.hideMemberIf, (Object)_cother.hideMemberIf, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"formatter", (Object)this.formatter, (Object)_cother.formatter, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getNameAttribute() {
            return MondrianDef.first(this.name, this.attribute);
        }

        public Closure getClosure() {
            return this.children.singleton(Closure.class);
        }

        public NamedList<Annotation> getAnnotations() {
            return this.children.only(Annotations.EMPTY).list();
        }
    }

    public static interface HierarchyElement
    extends NodeDef {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Hierarchy
    extends ElementDef
    implements NamedElement {
        public String name;
        public Boolean visible;
        public Boolean hasAll;
        public String allMemberName;
        public String allMemberCaption;
        public String allLevelName;
        public String defaultMember;
        public String caption;
        public String description;
        public DOMWrapper _def;
        public HierarchyElement[] childArray;
        private static final HierarchyElement[] EMPTY = new HierarchyElement[0];
        public final Children<HierarchyElement> children = new Children<HierarchyElement>(HierarchyElement.class, new Class[]{Level.class, Annotations.class}){

            HierarchyElement[] getArray() {
                return Hierarchy.this.childArray == null ? EMPTY : Hierarchy.this.childArray;
            }

            void setArray(HierarchyElement[] ts) {
                Hierarchy.this.childArray = ts;
            }
        };

        public Hierarchy() {
        }

        public Hierarchy(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
                this.hasAll = (Boolean)_parser.getAttribute("hasAll", "Boolean", null, null, false);
                this.allMemberName = (String)_parser.getAttribute("allMemberName", "String", null, null, false);
                this.allMemberCaption = (String)_parser.getAttribute("allMemberCaption", "String", null, null, false);
                this.allLevelName = (String)_parser.getAttribute("allLevelName", "String", null, null, false);
                this.defaultMember = (String)_parser.getAttribute("defaultMember", "String", null, null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(HierarchyElement.class, 0, 0);
                this.childArray = new HierarchyElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (HierarchyElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Hierarchy";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"visible", (Object)this.visible, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"hasAll", (Object)this.hasAll, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"allMemberName", (Object)this.allMemberName, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"allMemberCaption", (Object)this.allMemberCaption, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"allLevelName", (Object)this.allLevelName, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"defaultMember", (Object)this.defaultMember, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Hierarchy.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Hierarchy", new XMLAttrVector().add("name", (Object)this.name).add("visible", (Object)this.visible).add("hasAll", (Object)this.hasAll).add("allMemberName", (Object)this.allMemberName).add("allMemberCaption", (Object)this.allMemberCaption).add("allLevelName", (Object)this.allLevelName).add("defaultMember", (Object)this.defaultMember).add("caption", (Object)this.caption).add("description", (Object)this.description));
            Hierarchy.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("Hierarchy");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Hierarchy _cother = (Hierarchy)_other;
            boolean _diff = Hierarchy.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"visible", (Object)this.visible, (Object)_cother.visible, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"hasAll", (Object)this.hasAll, (Object)_cother.hasAll, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"allMemberName", (Object)this.allMemberName, (Object)_cother.allMemberName, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"allMemberCaption", (Object)this.allMemberCaption, (Object)_cother.allMemberCaption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"allLevelName", (Object)this.allLevelName, (Object)_cother.allLevelName, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"defaultMember", (Object)this.defaultMember, (Object)_cother.defaultMember, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getNameAttribute() {
            return this.name;
        }

        public NamedList<Level> getLevels() {
            return this.children.filterNamed(Level.class);
        }

        public NamedList<Annotation> getAnnotations() {
            return this.children.only(Annotations.EMPTY).list();
        }
    }

    public static interface AttributeElement
    extends NodeDef {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Attribute
    extends ElementDef
    implements NamedElement {
        public String name;
        public String caption;
        public String description;
        public Boolean visible;
        public static final String[] _levelType_values = new String[]{"Regular", "TimeYears", "TimeHalfYear", "TimeHalfYears", "TimeQuarters", "TimeMonths", "TimeWeeks", "TimeDays", "TimeHours", "TimeMinutes", "TimeSeconds", "TimeUndefined"};
        public String levelType;
        public String approxRowCount;
        public String table;
        public String keyColumn;
        public String nameColumn;
        public String orderByColumn;
        public String captionColumn;
        public static final String[] _datatype_values = new String[]{"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp"};
        public String datatype;
        public Boolean hasHierarchy;
        public Boolean hierarchyHasAll;
        public String hierarchyCaption;
        public String hierarchyAllMemberName;
        public String hierarchyAllMemberCaption;
        public String hierarchyAllLevelName;
        public String hierarchyDefaultMember;
        public DOMWrapper _def;
        public AttributeElement[] childArray;
        private static final AttributeElement[] EMPTY = new AttributeElement[0];
        public final Children<AttributeElement> children = new Children<AttributeElement>(AttributeElement.class, new Class[]{Key.class, Name.class, OrderBy.class, Caption.class, Property.class, MemberFormatter.class, Annotations.class}){

            AttributeElement[] getArray() {
                return Attribute.this.childArray == null ? EMPTY : Attribute.this.childArray;
            }

            void setArray(AttributeElement[] ts) {
                Attribute.this.childArray = ts;
            }
        };

        public Attribute() {
        }

        public Attribute(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
                this.levelType = (String)_parser.getAttribute("levelType", "String", "Regular", _levelType_values, false);
                this.approxRowCount = (String)_parser.getAttribute("approxRowCount", "String", null, null, false);
                this.table = (String)_parser.getAttribute("table", "String", null, null, false);
                this.keyColumn = (String)_parser.getAttribute("keyColumn", "String", null, null, false);
                this.nameColumn = (String)_parser.getAttribute("nameColumn", "String", null, null, false);
                this.orderByColumn = (String)_parser.getAttribute("orderByColumn", "String", null, null, false);
                this.captionColumn = (String)_parser.getAttribute("captionColumn", "String", null, null, false);
                this.datatype = (String)_parser.getAttribute("datatype", "String", "String", _datatype_values, false);
                this.hasHierarchy = (Boolean)_parser.getAttribute("hasHierarchy", "Boolean", "true", null, false);
                this.hierarchyHasAll = (Boolean)_parser.getAttribute("hierarchyHasAll", "Boolean", "true", null, false);
                this.hierarchyCaption = (String)_parser.getAttribute("hierarchyCaption", "String", null, null, false);
                this.hierarchyAllMemberName = (String)_parser.getAttribute("hierarchyAllMemberName", "String", null, null, false);
                this.hierarchyAllMemberCaption = (String)_parser.getAttribute("hierarchyAllMemberCaption", "String", null, null, false);
                this.hierarchyAllLevelName = (String)_parser.getAttribute("hierarchyAllLevelName", "String", null, null, false);
                this.hierarchyDefaultMember = (String)_parser.getAttribute("hierarchyDefaultMember", "String", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(AttributeElement.class, 0, 0);
                this.childArray = new AttributeElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (AttributeElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Attribute";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Attribute.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"visible", (Object)this.visible, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"levelType", (Object)this.levelType, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"approxRowCount", (Object)this.approxRowCount, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"table", (Object)this.table, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"keyColumn", (Object)this.keyColumn, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"nameColumn", (Object)this.nameColumn, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"orderByColumn", (Object)this.orderByColumn, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"captionColumn", (Object)this.captionColumn, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"datatype", (Object)this.datatype, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"hasHierarchy", (Object)this.hasHierarchy, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"hierarchyHasAll", (Object)this.hierarchyHasAll, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"hierarchyCaption", (Object)this.hierarchyCaption, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"hierarchyAllMemberName", (Object)this.hierarchyAllMemberName, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"hierarchyAllMemberCaption", (Object)this.hierarchyAllMemberCaption, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"hierarchyAllLevelName", (Object)this.hierarchyAllLevelName, (int)(_indent + 1));
            Attribute.displayAttribute((PrintWriter)_out, (String)"hierarchyDefaultMember", (Object)this.hierarchyDefaultMember, (int)(_indent + 1));
            Attribute.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Attribute", new XMLAttrVector().add("name", (Object)this.name).add("caption", (Object)this.caption).add("description", (Object)this.description).add("visible", (Object)this.visible).add("levelType", (Object)this.levelType).add("approxRowCount", (Object)this.approxRowCount).add("table", (Object)this.table).add("keyColumn", (Object)this.keyColumn).add("nameColumn", (Object)this.nameColumn).add("orderByColumn", (Object)this.orderByColumn).add("captionColumn", (Object)this.captionColumn).add("datatype", (Object)this.datatype).add("hasHierarchy", (Object)this.hasHierarchy).add("hierarchyHasAll", (Object)this.hierarchyHasAll).add("hierarchyCaption", (Object)this.hierarchyCaption).add("hierarchyAllMemberName", (Object)this.hierarchyAllMemberName).add("hierarchyAllMemberCaption", (Object)this.hierarchyAllMemberCaption).add("hierarchyAllLevelName", (Object)this.hierarchyAllLevelName).add("hierarchyDefaultMember", (Object)this.hierarchyDefaultMember));
            Attribute.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("Attribute");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Attribute _cother = (Attribute)_other;
            boolean _diff = Attribute.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"visible", (Object)this.visible, (Object)_cother.visible, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"levelType", (Object)this.levelType, (Object)_cother.levelType, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"approxRowCount", (Object)this.approxRowCount, (Object)_cother.approxRowCount, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"table", (Object)this.table, (Object)_cother.table, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"keyColumn", (Object)this.keyColumn, (Object)_cother.keyColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"nameColumn", (Object)this.nameColumn, (Object)_cother.nameColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"orderByColumn", (Object)this.orderByColumn, (Object)_cother.orderByColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"captionColumn", (Object)this.captionColumn, (Object)_cother.captionColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"datatype", (Object)this.datatype, (Object)_cother.datatype, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"hasHierarchy", (Object)this.hasHierarchy, (Object)_cother.hasHierarchy, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"hierarchyHasAll", (Object)this.hierarchyHasAll, (Object)_cother.hierarchyHasAll, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"hierarchyCaption", (Object)this.hierarchyCaption, (Object)_cother.hierarchyCaption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"hierarchyAllMemberName", (Object)this.hierarchyAllMemberName, (Object)_cother.hierarchyAllMemberName, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"hierarchyAllMemberCaption", (Object)this.hierarchyAllMemberCaption, (Object)_cother.hierarchyAllMemberCaption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"hierarchyAllLevelName", (Object)this.hierarchyAllLevelName, (Object)_cother.hierarchyAllLevelName, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayAttributeDiff((String)"hierarchyDefaultMember", (Object)this.hierarchyDefaultMember, (Object)_cother.hierarchyDefaultMember, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Attribute.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getNameAttribute() {
            return this.name;
        }

        public NamedList<Property> getProperties() {
            return this.children.filterNamed(Property.class);
        }

        public Key getKey() {
            return this.children.singleton(Key.class);
        }

        public Name getName_() {
            return this.children.singleton(Name.class);
        }

        public OrderBy getOrderBy() {
            return this.children.singleton(OrderBy.class);
        }

        public Caption getCaption() {
            return this.children.singleton(Caption.class);
        }

        public MemberFormatter getMemberFormatter() {
            return this.children.singleton(MemberFormatter.class);
        }

        public NamedList<Annotation> getAnnotations() {
            return this.children.only(Annotations.EMPTY).list();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Attributes
    extends ElementDef
    implements Holder,
    DimensionElement {
        public DOMWrapper _def;
        public Attribute[] array;
        private static final Attributes EMPTY = new Attributes();

        public Attributes() {
        }

        public Attributes(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Attribute.class, 0, 0);
                this.array = new Attribute[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Attribute)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Attributes";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Attributes.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Attributes", new XMLAttrVector());
            Attributes.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Attributes");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Attributes _cother = (Attributes)_other;
            boolean _diff = Attributes.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public Attributes copy() {
            Attributes c = new Attributes();
            c.array = (Attribute[])this.array.clone();
            return c;
        }

        public NamedList<Attribute> list() {
            return new NamedListImpl<Attribute>(new MutableArrayList<Attribute>(){

                protected Attribute[] getArray() {
                    return Attributes.this.array == null ? EMPTY.array : Attributes.this.array;
                }

                protected void setArray(Attribute[] ts) {
                    Attributes.this.array = ts;
                }
            });
        }

        static {
            Attributes.EMPTY.array = new Attribute[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Hierarchies
    extends ElementDef
    implements Holder,
    DimensionElement {
        public DOMWrapper _def;
        public Hierarchy[] array;
        private static final Hierarchies EMPTY = new Hierarchies();

        public Hierarchies() {
        }

        public Hierarchies(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Hierarchy.class, 0, 0);
                this.array = new Hierarchy[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Hierarchy)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Hierarchies";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Hierarchies.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Hierarchies", new XMLAttrVector());
            Hierarchies.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Hierarchies");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Hierarchies _cother = (Hierarchies)_other;
            boolean _diff = Hierarchies.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public Hierarchies copy() {
            Hierarchies c = new Hierarchies();
            c.array = (Hierarchy[])this.array.clone();
            return c;
        }

        public NamedList<Hierarchy> list() {
            return new NamedListImpl<Hierarchy>(new MutableArrayList<Hierarchy>(){

                protected Hierarchy[] getArray() {
                    return Hierarchies.this.array == null ? EMPTY.array : Hierarchies.this.array;
                }

                protected void setArray(Hierarchy[] ts) {
                    Hierarchies.this.array = ts;
                }
            });
        }

        static {
            Hierarchies.EMPTY.array = new Hierarchy[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Cube
    extends ElementDef
    implements NamedElement,
    SchemaElement {
        public String name;
        public Boolean visible;
        public String caption;
        public String description;
        public String defaultMeasure;
        public Boolean cache;
        public Boolean enabled;
        public Boolean enableScenarios;
        public DOMWrapper _def;
        public CubeElement[] childArray;
        private static final CubeElement[] EMPTY = new CubeElement[0];
        public final Children<CubeElement> children = new Children<CubeElement>(CubeElement.class, new Class[]{Annotations.class, MeasureGroups.class, Dimensions.class, CalculatedMembers.class, NamedSets.class}){

            CubeElement[] getArray() {
                return Cube.this.childArray == null ? EMPTY : Cube.this.childArray;
            }

            void setArray(CubeElement[] ts) {
                Cube.this.childArray = ts;
            }
        };

        public Cube() {
        }

        public Cube(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.defaultMeasure = (String)_parser.getAttribute("defaultMeasure", "String", null, null, false);
                this.cache = (Boolean)_parser.getAttribute("cache", "Boolean", "true", null, false);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
                this.enableScenarios = (Boolean)_parser.getAttribute("enableScenarios", "Boolean", "false", null, false);
                NodeDef[] _tempArray = _parser.getArray(CubeElement.class, 0, 0);
                this.childArray = new CubeElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (CubeElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Cube";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Cube.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Cube.displayAttribute((PrintWriter)_out, (String)"visible", (Object)this.visible, (int)(_indent + 1));
            Cube.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Cube.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Cube.displayAttribute((PrintWriter)_out, (String)"defaultMeasure", (Object)this.defaultMeasure, (int)(_indent + 1));
            Cube.displayAttribute((PrintWriter)_out, (String)"cache", (Object)this.cache, (int)(_indent + 1));
            Cube.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
            Cube.displayAttribute((PrintWriter)_out, (String)"enableScenarios", (Object)this.enableScenarios, (int)(_indent + 1));
            Cube.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Cube", new XMLAttrVector().add("name", (Object)this.name).add("visible", (Object)this.visible).add("caption", (Object)this.caption).add("description", (Object)this.description).add("defaultMeasure", (Object)this.defaultMeasure).add("cache", (Object)this.cache).add("enabled", (Object)this.enabled).add("enableScenarios", (Object)this.enableScenarios));
            Cube.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("Cube");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Cube _cother = (Cube)_other;
            boolean _diff = Cube.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayAttributeDiff((String)"visible", (Object)this.visible, (Object)_cother.visible, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayAttributeDiff((String)"defaultMeasure", (Object)this.defaultMeasure, (Object)_cother.defaultMeasure, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayAttributeDiff((String)"cache", (Object)this.cache, (Object)_cother.cache, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayAttributeDiff((String)"enabled", (Object)this.enabled, (Object)_cother.enabled, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayAttributeDiff((String)"enableScenarios", (Object)this.enableScenarios, (Object)_cother.enableScenarios, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getNameAttribute() {
            return this.name;
        }

        public NamedList<Dimension> getDimensions() {
            return this.children.only(Dimensions.EMPTY).list();
        }

        public NamedList<MeasureGroup> getMeasureGroups() {
            return this.children.only(MeasureGroups.EMPTY).list();
        }

        public NamedList<CalculatedMember> getCalculatedMembers() {
            return this.children.only(CalculatedMembers.EMPTY).list();
        }

        public NamedList<NamedSet> getNamedSets() {
            return this.children.only(NamedSets.EMPTY).list();
        }

        public NamedList<Annotation> getAnnotations() {
            return this.children.only(Annotations.EMPTY).list();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Dimensions
    extends ElementDef
    implements Holder,
    CubeElement {
        public DOMWrapper _def;
        public Dimension[] array;
        private static final Dimensions EMPTY = new Dimensions();

        public Dimensions() {
        }

        public Dimensions(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Dimension.class, 0, 0);
                this.array = new Dimension[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Dimension)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Dimensions";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Dimensions.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Dimensions", new XMLAttrVector());
            Dimensions.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Dimensions");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Dimensions _cother = (Dimensions)_other;
            boolean _diff = Dimensions.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public Dimensions copy() {
            Dimensions c = new Dimensions();
            c.array = (Dimension[])this.array.clone();
            return c;
        }

        public NamedList<Dimension> list() {
            return new NamedListImpl<Dimension>(new MutableArrayList<Dimension>(){

                protected Dimension[] getArray() {
                    return Dimensions.this.array == null ? EMPTY.array : Dimensions.this.array;
                }

                protected void setArray(Dimension[] ts) {
                    Dimensions.this.array = ts;
                }
            });
        }

        static {
            Dimensions.EMPTY.array = new Dimension[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Dimension
    extends ElementDef
    implements NamedElement,
    SchemaElement {
        public String name;
        public String source;
        public Boolean visible;
        public String caption;
        public String description;
        public static final String[] _type_values = new String[]{"ACCOUNTS", "BILL_OF_MATERIALS", "CHANNEL", "CURRENCY", "CUSTOMERS", "GEOGRAPHY", "MEASURE", "ORGANIZATION", "OTHER", "PRODUCTS", "PROMOTION", "QUANTITATIVE", "RATES", "SCENARIO", "TIME", "UNKNOWN", "UTILITY"};
        public String type;
        public String table;
        public String key;
        public Boolean hanger;
        public DOMWrapper _def;
        public DimensionElement[] childArray;
        private static final DimensionElement[] EMPTY = new DimensionElement[0];
        public final Children<DimensionElement> children = new Children<DimensionElement>(DimensionElement.class, new Class[]{Attributes.class, Hierarchies.class, Annotations.class}){

            DimensionElement[] getArray() {
                return Dimension.this.childArray == null ? EMPTY : Dimension.this.childArray;
            }

            void setArray(DimensionElement[] ts) {
                Dimension.this.childArray = ts;
            }
        };

        public Dimension() {
        }

        public Dimension(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.source = (String)_parser.getAttribute("source", "String", null, null, false);
                this.visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.type = (String)_parser.getAttribute("type", "String", "OTHER", _type_values, false);
                this.table = (String)_parser.getAttribute("table", "String", null, null, false);
                this.key = (String)_parser.getAttribute("key", "String", null, null, false);
                this.hanger = (Boolean)_parser.getAttribute("hanger", "Boolean", "false", null, false);
                NodeDef[] _tempArray = _parser.getArray(DimensionElement.class, 0, 0);
                this.childArray = new DimensionElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (DimensionElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Dimension";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Dimension.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"source", (Object)this.source, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"visible", (Object)this.visible, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"table", (Object)this.table, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"key", (Object)this.key, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"hanger", (Object)this.hanger, (int)(_indent + 1));
            Dimension.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Dimension", new XMLAttrVector().add("name", (Object)this.name).add("source", (Object)this.source).add("visible", (Object)this.visible).add("caption", (Object)this.caption).add("description", (Object)this.description).add("type", (Object)this.type).add("table", (Object)this.table).add("key", (Object)this.key).add("hanger", (Object)this.hanger));
            Dimension.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("Dimension");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Dimension _cother = (Dimension)_other;
            boolean _diff = Dimension.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Dimension.displayAttributeDiff((String)"source", (Object)this.source, (Object)_cother.source, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Dimension.displayAttributeDiff((String)"visible", (Object)this.visible, (Object)_cother.visible, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Dimension.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Dimension.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Dimension.displayAttributeDiff((String)"type", (Object)this.type, (Object)_cother.type, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Dimension.displayAttributeDiff((String)"table", (Object)this.table, (Object)_cother.table, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Dimension.displayAttributeDiff((String)"key", (Object)this.key, (Object)_cother.key, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Dimension.displayAttributeDiff((String)"hanger", (Object)this.hanger, (Object)_cother.hanger, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Dimension.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getNameAttribute() {
            return this.name != null ? this.name : this.source;
        }

        public NamedList<Attribute> getAttributes() {
            return this.children.only(Attributes.EMPTY).list();
        }

        public NamedList<Hierarchy> getHierarchies() {
            return this.children.only(Hierarchies.EMPTY).list();
        }

        public NamedList<Annotation> getAnnotations() {
            return this.children.only(Annotations.EMPTY).list();
        }
    }

    private static class _Dummy {
        private _Dummy() {
        }
    }

    public static interface Handler {
        public static final ThreadLocal<Handler> THREAD_LOCAL = new ThreadLocal();

        public void error(String var1, NodeDef var2, String var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamedListImpl<T extends NamedElement>
    extends AbstractList<T>
    implements NamedList<T> {
        private final List<T> list;

        public NamedListImpl(List<T> list) {
            this.list = list;
        }

        @Override
        public T get(int index) {
            return (T)((NamedElement)this.list.get(index));
        }

        @Override
        public int size() {
            return this.list.size();
        }

        public T get(String name) {
            for (NamedElement t : this) {
                if (!t.getNameAttribute().equals(name)) continue;
                return (T)t;
            }
            return null;
        }

        public int indexOfName(String name) {
            for (int i = 0; i < this.list.size(); ++i) {
                NamedElement t = (NamedElement)this.list.get(i);
                if (!t.getNameAttribute().equals(name)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public T set(int index, T element) {
            return (T)((NamedElement)this.list.set(index, element));
        }

        @Override
        public void add(int index, T element) {
            this.list.add(index, element);
        }

        public Map<String, T> asMap() {
            return new AbstractMap<String, T>(){

                @Override
                public Set<Map.Entry<String, T>> entrySet() {
                    return new AbstractSet<Map.Entry<String, T>>(){

                        @Override
                        public Iterator<Map.Entry<String, T>> iterator() {
                            return new Iterator<Map.Entry<String, T>>(){
                                private int index = -1;

                                @Override
                                public boolean hasNext() {
                                    return this.index < NamedListImpl.this.list.size();
                                }

                                @Override
                                public Map.Entry<String, T> next() {
                                    ++this.index;
                                    return new Map.Entry<String, T>(){

                                        @Override
                                        public String getKey() {
                                            return ((NamedElement)NamedListImpl.this.list.get(index)).getNameAttribute();
                                        }

                                        @Override
                                        public T getValue() {
                                            return (NamedElement)NamedListImpl.this.list.get(index);
                                        }

                                        @Override
                                        public T setValue(T value) {
                                            throw new UnsupportedOperationException();
                                        }
                                    };
                                }

                                @Override
                                public void remove() {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }

                        @Override
                        public int size() {
                            return NamedListImpl.this.list.size();
                        }
                    };
                }
            };
        }

        public String getName(Object arg0) {
            return ((NamedElement)arg0).getNameAttribute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class MutableArrayList<T>
    extends AbstractList<T> {
        protected MutableArrayList() {
        }

        protected abstract T[] getArray();

        protected abstract void setArray(T[] var1);

        @Override
        public T get(int index) {
            return this.getArray()[index];
        }

        @Override
        public int size() {
            return this.getArray().length;
        }

        @Override
        public T set(int i, T t) {
            T[] ts = this.getArray();
            T old = ts[i];
            ts[i] = t;
            return old;
        }

        @Override
        public void add(int i, T t) {
            T[] ts = this.getArray();
            T[] t2s = Util.copyOf(ts, ts.length + 1);
            System.arraycopy(t2s, i, t2s, i + 1, t2s.length - 1 - i);
            t2s[i] = t;
            this.setArray(t2s);
        }
    }

    public static class Missing
    extends Exception {
        private static final Missing INSTANCE = new Missing();

        private Missing() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Children<T extends NodeDef>
    implements Iterable<T> {
        private final Class[] classes;

        Children(Class<T> iface, Class<? extends T> ... classes) {
            for (Class<? extends T> clazz : classes) {
                if (iface.isAssignableFrom(clazz)) continue;
                System.out.println(clazz + " should be a " + iface);
            }
            this.classes = classes;
        }

        abstract T[] getArray();

        abstract void setArray(T[] var1);

        @Override
        public Iterator<T> iterator() {
            return MondrianDef.list(this.getArray()).iterator();
        }

        <T2> List<T2> filter(Class<T2> clazz) {
            return MondrianDef.list(this.getArray(), clazz);
        }

        <T2 extends NamedElement> NamedList<T2> filterNamed(Class<T2> clazz) {
            return MondrianDef.namedList(this.getArray(), clazz);
        }

        <T2> T2 singleton(Class<T2> clazz) {
            return (T2)MondrianDef.only(this.getArray(), clazz);
        }

        <T2> T2 requiredSingleton(ElementDef xml, Class<T2> clazz) throws Missing {
            Object t2 = MondrianDef.only(this.getArray(), clazz);
            if (t2 != null) {
                return (T2)t2;
            }
            Handler.THREAD_LOCAL.get().error("Missing required child element " + clazz.getSimpleName(), (NodeDef)xml, null);
            throw Missing.INSTANCE;
        }

        <T2 extends Holder> T2 only(T2 empty) {
            return (T2)MondrianDef.onlyDeflt(this.getArray(), empty.getClass(), empty);
        }

        public void add(T t) {
            NodeDef[] ts = this.getArray();
            NodeDef[] t2s = Util.copyOf(ts, ts.length + 1);
            t2s[t2s.length - 1] = t;
            this.setArray(t2s);
        }

        public void add(int i, T t) {
            NodeDef[] ts = this.getArray();
            NodeDef[] t2s = Util.copyOf(ts, ts.length + 1);
            System.arraycopy(t2s, i, t2s, i + 1, t2s.length - 1 - i);
            t2s[i] = t;
            this.setArray(t2s);
        }

        public void addAll(Iterable<? extends T> ts) {
            for (NodeDef t : ts) {
                this.add(t);
            }
        }

        public <T1 extends Holder> T1 holder(T1 holder) {
            for (NodeDef t : this.getArray()) {
                if (t.getClass() != holder.getClass()) continue;
                return (T1)((Holder)t);
            }
            this.add(holder);
            return holder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Schema
    extends ElementDef
    implements NamedElement {
        public String name;
        public String caption;
        public String description;
        public String measuresCaption;
        public String defaultRole;
        public Boolean quoteSql;
        public static final String[] _missingLink_values = new String[]{"ignore", "warning", "error"};
        public String missingLink;
        public String metamodelVersion;
        public String locales;
        public DOMWrapper _def;
        public SchemaElement[] childArray;
        private static final SchemaElement[] EMPTY = new SchemaElement[0];
        public final Children<SchemaElement> children = new Children<SchemaElement>(SchemaElement.class, new Class[]{Cube.class, Dimension.class, Role.class, NamedSet.class, UserDefinedFunction.class, Parameter.class, PhysicalSchema.class, Annotations.class}){

            SchemaElement[] getArray() {
                return Schema.this.childArray == null ? EMPTY : Schema.this.childArray;
            }

            void setArray(SchemaElement[] ts) {
                Schema.this.childArray = ts;
            }
        };

        public Schema() {
        }

        public Schema(DOMWrapper _def) throws XOMException {
            this._def = _def;
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.measuresCaption = (String)_parser.getAttribute("measuresCaption", "String", null, null, false);
                this.defaultRole = (String)_parser.getAttribute("defaultRole", "String", null, null, false);
                this.quoteSql = (Boolean)_parser.getAttribute("quoteSql", "Boolean", "true", null, false);
                this.missingLink = (String)_parser.getAttribute("missingLink", "String", "warning", _missingLink_values, true);
                this.metamodelVersion = (String)_parser.getAttribute("metamodelVersion", "String", null, null, false);
                this.locales = (String)_parser.getAttribute("locales", "String", null, null, false);
                NodeDef[] _tempArray = _parser.getArray(SchemaElement.class, 0, 0);
                this.childArray = new SchemaElement[_tempArray.length];
                for (int _i = 0; _i < this.childArray.length; ++_i) {
                    this.childArray[_i] = (SchemaElement)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Schema";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Schema.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Schema.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Schema.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Schema.displayAttribute((PrintWriter)_out, (String)"measuresCaption", (Object)this.measuresCaption, (int)(_indent + 1));
            Schema.displayAttribute((PrintWriter)_out, (String)"defaultRole", (Object)this.defaultRole, (int)(_indent + 1));
            Schema.displayAttribute((PrintWriter)_out, (String)"quoteSql", (Object)this.quoteSql, (int)(_indent + 1));
            Schema.displayAttribute((PrintWriter)_out, (String)"missingLink", (Object)this.missingLink, (int)(_indent + 1));
            Schema.displayAttribute((PrintWriter)_out, (String)"metamodelVersion", (Object)this.metamodelVersion, (int)(_indent + 1));
            Schema.displayAttribute((PrintWriter)_out, (String)"locales", (Object)this.locales, (int)(_indent + 1));
            Schema.displayElementArray((PrintWriter)_out, (String)"childArray", (NodeDef[])this.childArray, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Schema", new XMLAttrVector().add("name", (Object)this.name).add("caption", (Object)this.caption).add("description", (Object)this.description).add("measuresCaption", (Object)this.measuresCaption).add("defaultRole", (Object)this.defaultRole).add("quoteSql", (Object)this.quoteSql).add("missingLink", (Object)this.missingLink).add("metamodelVersion", (Object)this.metamodelVersion).add("locales", (Object)this.locales));
            Schema.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.childArray);
            _out.endTag("Schema");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Schema _cother = (Schema)_other;
            boolean _diff = Schema.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayAttributeDiff((String)"measuresCaption", (Object)this.measuresCaption, (Object)_cother.measuresCaption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayAttributeDiff((String)"defaultRole", (Object)this.defaultRole, (Object)_cother.defaultRole, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayAttributeDiff((String)"quoteSql", (Object)this.quoteSql, (Object)_cother.quoteSql, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayAttributeDiff((String)"missingLink", (Object)this.missingLink, (Object)_cother.missingLink, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayAttributeDiff((String)"metamodelVersion", (Object)this.metamodelVersion, (Object)_cother.metamodelVersion, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayAttributeDiff((String)"locales", (Object)this.locales, (Object)_cother.locales, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayElementArrayDiff((String)"childArray", (NodeDef[])this.childArray, (NodeDef[])_cother.childArray, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        @Override
        public String getNameAttribute() {
            return this.name;
        }

        public NamedList<Cube> getCubes() {
            return this.children.filterNamed(Cube.class);
        }

        public NamedList<Dimension> getDimensions() {
            return this.children.filterNamed(Dimension.class);
        }

        public NamedList<Role> getRoles() {
            return this.children.filterNamed(Role.class);
        }

        public NamedList<NamedSet> getNamedSets() {
            return this.children.filterNamed(NamedSet.class);
        }

        public NamedList<UserDefinedFunction> getUserDefinedFunctions() {
            return this.children.filterNamed(UserDefinedFunction.class);
        }

        public NamedList<Parameter> getParameters() {
            return this.children.filterNamed(Parameter.class);
        }

        public PhysicalSchema getPhysicalSchema() {
            return this.children.singleton(PhysicalSchema.class);
        }

        public Localization getLocalization() {
            return this.children.singleton(Localization.class);
        }

        public NamedList<Annotation> getAnnotations() {
            return this.children.only(Annotations.EMPTY).list();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Holder
    extends NodeDef {
        public List<? extends NodeDef> list();

        public Holder copy();
    }

    public static interface RoleElement
    extends NodeDef {
    }

    public static interface InlineTableElement
    extends NodeDef {
    }

    public static interface TableElement
    extends NodeDef {
    }

    public static interface MeasureGroupElement
    extends NodeDef {
    }

    public static interface SchemaElement
    extends NodeDef {
    }

    public static interface NamedElement
    extends NodeDef {
        public String getNameAttribute();

        public String getName();
    }

    public static interface PropertyElement
    extends NodeDef {
    }

    public static interface DimensionElement
    extends NodeDef {
    }

    public static interface NamedSetElement
    extends NodeDef {
    }

    public static interface CalculatedMemberElement
    extends NodeDef {
    }

    public static interface MeasureElement
    extends NodeDef {
    }

    public static interface LevelElement
    extends NodeDef {
    }

    public static interface CubeElement
    extends NodeDef {
    }
}

