/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import mondrian.olap.Annotation;
import mondrian.olap.Larder;
import mondrian.olap.LocalizedProperty;
import mondrian.olap.MondrianDef;
import mondrian.olap.Property;
import mondrian.olap.Util;
import mondrian.util.Pair;
import org.olap4j.impl.Named;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Larders {
    public static final Locale DEFAULT_LOCALE = Locale.getDefault();
    public static final Larder EMPTY = EmptyLarder.INSTANCE;
    private static final LocaleProp DEFAULT_LOCALE_CAPTION = LocaleProp.access$000(DEFAULT_LOCALE.toString(), LocalizedProperty.CAPTION);
    private static final LocaleProp DEFAULT_LOCALE_DESCRIPTION = LocaleProp.access$000(DEFAULT_LOCALE.toString(), LocalizedProperty.DESCRIPTION);

    private Larders() {
        throw new AssertionError((Object)"do not instantiate!");
    }

    public static Larder create(String name, String caption, String description) {
        return Larders.create((NamedList<MondrianDef.Annotation>)Olap4jUtil.emptyNamedList(), name, caption, description, Collections.<Resource>emptyList());
    }

    public static Larder create(NamedList<MondrianDef.Annotation> annotations, String name, String caption, String description) {
        return Larders.create(annotations, name, caption, description, Collections.<Resource>emptyList());
    }

    public static Larder create(NamedList<MondrianDef.Annotation> annotations, String name, String caption, String description, List<Resource> resources) {
        if (annotations == null) {
            annotations = Olap4jUtil.emptyNamedList();
        }
        if (resources == null) {
            resources = Collections.emptyList();
        }
        if (caption != null && caption.equals(name)) {
            caption = null;
        }
        int n = annotations.size() + (caption != null ? 1 : 0) + (description != null ? 1 : 0) + resources.size();
        switch (n) {
            case 0: {
                return EmptyLarder.INSTANCE;
            }
            case 1: {
                if (caption == null) break;
                return Larders.ofCaption(caption);
            }
        }
        LarderBuilder builder = new LarderBuilder();
        builder.addAll((NamedList<MondrianDef.Annotation>)annotations);
        builder.caption(caption);
        builder.description(description);
        builder.addAll(resources);
        return builder.build();
    }

    public static String get(Named named, Larder larder, LocalizedProperty prop, Locale locale) {
        String value = larder.get(prop, locale);
        if (value == null && named != null && prop == LocalizedProperty.CAPTION) {
            return named.getName();
        }
        return value;
    }

    public static Larder ofCaption(String name, String caption) {
        if (caption != null && caption.equals(name)) {
            caption = null;
        }
        return Larders.ofCaption(caption);
    }

    public static Larder ofCaption(String caption) {
        if (caption == null) {
            return EmptyLarder.INSTANCE;
        }
        return new CaptionLarder(caption);
    }

    public static Larder prefix(Larder larder, String source, final String name) {
        if (source == null || name == null || source.equals(name)) {
            return larder;
        }
        return new DelegatingLarder((LarderImpl)larder){

            @Override
            public String get(LocalizedProperty prop, Locale locale) {
                String value = super.get(prop, locale);
                if (value != null) {
                    return name + "." + value;
                }
                return value;
            }

            @Override
            public Map<Pair<Locale, LocalizedProperty>, String> translations() {
                LinkedHashMap<Pair<Locale, LocalizedProperty>, String> map = new LinkedHashMap<Pair<Locale, LocalizedProperty>, String>(super.translations());
                for (Map.Entry entry : map.entrySet()) {
                    entry.setValue(name + "." + (String)entry.getValue());
                }
                return map;
            }

            @Override
            public List<Object> getElements() {
                ArrayList<Object> list = new ArrayList<Object>(this.larder.getElements());
                for (int i = 0; i < list.size(); ++i) {
                    Object o;
                    if (!((o = list.get(i++)) instanceof LocaleProp)) continue;
                    LocaleProp key = (LocaleProp)o;
                    list.set(i, this.get((LocalizedProperty)((Object)key.right), (Locale)key.left));
                }
                return list;
            }
        };
    }

    public static String getCaption(Named named, Larder larder) {
        String caption = larder.get(LocalizedProperty.CAPTION, DEFAULT_LOCALE);
        if (caption != null) {
            return caption;
        }
        return named.getName();
    }

    public static String getDescription(Larder larder) {
        return larder.get(LocalizedProperty.DESCRIPTION, DEFAULT_LOCALE);
    }

    public static Larder set(Larder larder, Property property, Object value) {
        return new LarderBuilder().populate((LarderImpl)larder).add(property, value).build();
    }

    private static boolean isChild(Locale child, Locale parent) {
        return parent.toString().startsWith(child.toString());
    }

    public static Larder ofName(String name) {
        return new LarderBuilder().add(Property.NAME, (Object)name).build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface LarderImpl
    extends Larder {
        public List<Object> getElements();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LarderBuilder {
        final List<Object> elements = new ArrayList<Object>();
        final Set<Object> keys = new HashSet<Object>();

        public static LarderBuilder of(Larder larder) {
            return new LarderBuilder().populate(larder);
        }

        public LarderBuilder add(Resource resource) {
            LocaleProp localeProp = LocaleProp.lookup(resource.locale, resource.prop);
            if (this.keys.add(localeProp)) {
                this.elements.add(localeProp);
                this.elements.add(resource.value);
            }
            return this;
        }

        public LarderBuilder addAll(List<Resource> resources) {
            if (resources != null) {
                for (Resource resource : resources) {
                    this.add(LocaleProp.lookup(resource.locale, resource.prop), resource.value);
                }
            }
            return this;
        }

        public LarderBuilder add(MondrianDef.Annotation xmlAnnotation) {
            if (xmlAnnotation.name.startsWith("caption.")) {
                this.add(LocaleProp.lookup(xmlAnnotation.name.substring("caption.".length()), LocalizedProperty.CAPTION), xmlAnnotation.cdata);
            } else if (xmlAnnotation.name.startsWith("description.")) {
                this.add(LocaleProp.lookup(xmlAnnotation.name.substring("description.".length()), LocalizedProperty.DESCRIPTION), xmlAnnotation.cdata);
            } else {
                this.add(xmlAnnotation.name, (Object)xmlAnnotation.cdata);
            }
            return this;
        }

        public LarderBuilder addAll(NamedList<MondrianDef.Annotation> annotations) {
            for (MondrianDef.Annotation annotation : annotations) {
                this.add(annotation);
            }
            return this;
        }

        void add(String name, Object value) {
            if (this.keys.add(name)) {
                this.elements.add(name);
                this.elements.add(value);
            }
        }

        void add(Annotation annotation) {
            this.add(annotation.getName(), annotation.getValue());
        }

        public Larder build() {
            switch (this.elements.size()) {
                case 0: {
                    return EMPTY;
                }
                case 2: {
                    Object o = this.elements.get(0);
                    if (o != DEFAULT_LOCALE_CAPTION) break;
                    return Larders.ofCaption((String)this.elements.get(1));
                }
            }
            return new ArrayLarder(this.elements.toArray());
        }

        public LarderBuilder caption(String caption) {
            if (caption != null) {
                this.add(DEFAULT_LOCALE_CAPTION, caption);
            }
            return this;
        }

        public LarderBuilder description(String description) {
            if (description != null) {
                this.add(DEFAULT_LOCALE_DESCRIPTION, description);
            }
            return this;
        }

        public LarderBuilder name(String name) {
            assert (name != null);
            this.add(Property.NAME, (Object)name);
            return this;
        }

        public LarderBuilder add(LocaleProp localeProp, String value) {
            if (this.keys.add(localeProp)) {
                this.elements.add(localeProp);
                this.elements.add(value);
            }
            return this;
        }

        public final LarderBuilder populate(Larder larder) {
            return this.populate((LarderImpl)larder);
        }

        LarderBuilder populate(LarderImpl larder) {
            if (this.elements.isEmpty()) {
                this.elements.addAll(larder.getElements());
                for (int i = 0; i < this.elements.size(); i += 2) {
                    this.keys.add(this.elements.get(i));
                }
            } else {
                List<Object> elements1 = larder.getElements();
                for (int i = 0; i < elements1.size(); ++i) {
                    Object key;
                    if (!this.keys.add(key = elements1.get(i++))) continue;
                    this.elements.add(key);
                    this.elements.add(elements1.get(i));
                }
            }
            return this;
        }

        public LarderBuilder add(Property property, Object value) {
            if (this.keys.add(property)) {
                this.elements.add(property);
                this.elements.add(value);
            } else {
                int x = this.find(this.elements, property);
                this.elements.set(x + 1, value);
            }
            return this;
        }

        private int find(List<Object> elements, Object key) {
            for (int i = 0; i < elements.size(); i += 2) {
                if (!elements.get(i).equals(key)) continue;
                return i;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Resource {
        public final LocalizedProperty prop;
        public final Locale locale;
        public final String value;

        public Resource(LocalizedProperty prop, Locale locale, String value) {
            this.prop = prop;
            this.locale = locale;
            this.value = value;
        }

        public static String lookup(LocalizedProperty prop, Locale locale, List<Resource> resources) {
            Locale bestLocale = null;
            String bestValue = null;
            for (Resource resource : resources) {
                String value = resource.value;
                if (resource.prop != prop) continue;
                if (resource.locale.equals(locale)) {
                    return resource.value;
                }
                if (!Larders.isChild(resource.locale, locale) || bestLocale != null && !Larders.isChild(bestLocale, resource.locale)) continue;
                bestLocale = resource.locale;
                bestValue = value;
            }
            return bestValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleProp
    extends Pair<Locale, LocalizedProperty> {
        private static final List<LocaleProp> INSTANCES = new ArrayList<LocaleProp>();

        LocaleProp(Locale left, LocalizedProperty right) {
            super(left, right);
        }

        private static synchronized LocaleProp lookup(String localeName, LocalizedProperty prop) {
            for (LocaleProp localeProp : INSTANCES) {
                if (localeProp.right != prop || !((Locale)localeProp.left).toString().equals(localeName)) continue;
                return localeProp;
            }
            LocaleProp localeProp = new LocaleProp(Util.parseLocale(localeName), prop);
            INSTANCES.add(localeProp);
            return localeProp;
        }

        private static synchronized LocaleProp lookup(Locale locale, LocalizedProperty prop) {
            for (LocaleProp localeProp : INSTANCES) {
                if (localeProp.right != prop || !((Locale)localeProp.left).equals(locale)) continue;
                return localeProp;
            }
            LocaleProp localeProp = new LocaleProp(locale, prop);
            INSTANCES.add(localeProp);
            return localeProp;
        }
    }

    private static class AnnotationImpl
    implements Annotation {
        private final String name;
        private final Object value;

        AnnotationImpl(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingLarder
    implements LarderImpl {
        protected final LarderImpl larder;

        DelegatingLarder(LarderImpl larder) {
            this.larder = larder;
        }

        @Override
        public Map<String, Annotation> getAnnotationMap() {
            return this.larder.getAnnotationMap();
        }

        @Override
        public Map<Pair<Locale, LocalizedProperty>, String> translations() {
            return this.larder.translations();
        }

        @Override
        public String get(LocalizedProperty prop, Locale locale) {
            return this.larder.get(prop, locale);
        }

        @Override
        public Object get(Property property) {
            return this.larder.get(property);
        }

        @Override
        public List<Object> getElements() {
            return this.larder.getElements();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaptionLarder
    implements LarderImpl {
        private final String caption;

        public CaptionLarder(String caption) {
            assert (caption != null);
            this.caption = caption;
        }

        @Override
        public Map<String, Annotation> getAnnotationMap() {
            return Collections.emptyMap();
        }

        @Override
        public Map<Pair<Locale, LocalizedProperty>, String> translations() {
            return Collections.singletonMap(DEFAULT_LOCALE_CAPTION, this.caption);
        }

        @Override
        public String get(LocalizedProperty prop, Locale locale) {
            if (prop == LocalizedProperty.CAPTION && locale.equals(DEFAULT_LOCALE)) {
                return this.caption;
            }
            return null;
        }

        @Override
        public List<Object> getElements() {
            return Util.flatList(DEFAULT_LOCALE_CAPTION, this.caption);
        }

        @Override
        public Object get(Property property) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayLarder
    implements LarderImpl {
        private final Object[] elements;

        private ArrayLarder(Object[] elements) {
            this.elements = elements;
        }

        @Override
        public List<Object> getElements() {
            return Arrays.asList(this.elements);
        }

        @Override
        public Map<String, Annotation> getAnnotationMap() {
            LinkedHashMap<String, Annotation> map = new LinkedHashMap<String, Annotation>();
            int i = 0;
            while (i < this.elements.length) {
                Object element;
                if ((element = this.elements[i++]) instanceof String) {
                    String key = (String)element;
                    Object value = this.elements[i++];
                    map.put(key, new AnnotationImpl(key, value));
                    continue;
                }
                ++i;
            }
            if (map.isEmpty()) {
                return Collections.emptyMap();
            }
            return map;
        }

        @Override
        public Map<Pair<Locale, LocalizedProperty>, String> translations() {
            HashMap<Pair<Locale, LocalizedProperty>, String> map = new HashMap<Pair<Locale, LocalizedProperty>, String>();
            int i = 0;
            while (i < this.elements.length) {
                Object element;
                if ((element = this.elements[i++]) instanceof LocaleProp) {
                    LocaleProp key = (LocaleProp)element;
                    map.put(key, (String)this.elements[i++]);
                    continue;
                }
                ++i;
            }
            if (map.isEmpty()) {
                return Collections.emptyMap();
            }
            return map;
        }

        @Override
        public String get(LocalizedProperty prop, Locale locale) {
            Locale bestLocale = null;
            String bestValue = null;
            int i = 0;
            while (i < this.elements.length) {
                Object element;
                if ((element = this.elements[i++]) instanceof LocaleProp) {
                    LocaleProp key = (LocaleProp)element;
                    String value = (String)this.elements[i++];
                    if (key.right != prop) continue;
                    if (((Locale)key.left).equals(locale)) {
                        return value;
                    }
                    if (!Larders.isChild((Locale)key.left, locale) || bestLocale != null && !Larders.isChild(bestLocale, (Locale)key.left)) continue;
                    bestLocale = (Locale)key.left;
                    bestValue = value;
                    continue;
                }
                ++i;
            }
            return bestValue;
        }

        @Override
        public Object get(Property property) {
            for (int i = 0; i < this.elements.length; ++i) {
                Object element;
                if ((element = this.elements[i++]) != property) continue;
                return this.elements[i];
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EmptyLarder implements LarderImpl
    {
        INSTANCE;


        @Override
        public Map<String, Annotation> getAnnotationMap() {
            return Collections.emptyMap();
        }

        @Override
        public Map<Pair<Locale, LocalizedProperty>, String> translations() {
            return Collections.emptyMap();
        }

        @Override
        public String get(LocalizedProperty prop, Locale locale) {
            return null;
        }

        @Override
        public Object get(Property property) {
            return null;
        }

        @Override
        public List<Object> getElements() {
            return Collections.emptyList();
        }
    }
}

