/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Larders;
import mondrian.olap.MatchType;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.NamedList;

public abstract class DimensionBase
extends OlapElementBase
implements Dimension {
    protected final String name;
    protected final String uniqueName;
    protected final NamedList<Hierarchy> hierarchyList = new NamedListImpl();
    protected final Dimension.Type dimensionType;

    protected DimensionBase(String name, boolean visible, Dimension.Type dimensionType) {
        this.name = name;
        this.visible = visible;
        this.uniqueName = Util.makeFqName(name);
        this.dimensionType = dimensionType;
        assert (dimensionType != null);
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return Larders.getDescription(this.getLarder());
    }

    public Hierarchy getHierarchy() {
        return (Hierarchy)this.hierarchyList.get(0);
    }

    public Dimension getDimension() {
        return this;
    }

    public Dimension.Type getDimensionType() {
        return this.dimensionType;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxDimensionName.str(this.getUniqueName());
    }

    public boolean isMeasures() {
        return this.dimensionType == Dimension.Type.MEASURE;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        OlapElement oe = null;
        if (s instanceof Id.NameSegment) {
            oe = this.lookupHierarchy((Id.NameSegment)s);
        }
        if (oe != null) {
            return oe;
        }
        List<Hierarchy> hierarchyList = schemaReader.getDimensionHierarchies(this);
        for (Hierarchy hierarchy : hierarchyList) {
            oe = hierarchy.lookupChild(schemaReader, s, matchType);
            if (oe == null) continue;
            return oe;
        }
        return null;
    }

    private Hierarchy lookupHierarchy(Id.NameSegment s) {
        for (Hierarchy hierarchy : this.hierarchyList) {
            if (!Util.equalName(hierarchy.getName(), s.getName())) continue;
            return hierarchy;
        }
        return null;
    }
}

