/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.memory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreDependenciesExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementTypeExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreElementType;
import org.pentaho.metastore.util.MetaStoreUtil;

public class MemoryMetaStoreNamespace {
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final String namespace;
    private final Map<String, MemoryMetaStoreElementType> typeMap;

    public MemoryMetaStoreNamespace(String namespace) {
        this.namespace = namespace;
        this.typeMap = new HashMap<String, MemoryMetaStoreElementType>();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, MemoryMetaStoreElementType> getTypeMap() {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<Map<String, MemoryMetaStoreElementType>>(){

            @Override
            public Map<String, MemoryMetaStoreElementType> call() throws Exception {
                return new HashMap<String, MemoryMetaStoreElementType>(MemoryMetaStoreNamespace.this.typeMap);
            }
        });
    }

    private MemoryMetaStoreElementType getElementTypeByNameInternal(String elementTypeName) {
        for (MemoryMetaStoreElementType elementType : this.typeMap.values()) {
            if (!elementType.getName().equalsIgnoreCase(elementTypeName)) continue;
            return elementType;
        }
        return null;
    }

    public MemoryMetaStoreElementType getElementTypeByName(final String elementTypeName) {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<MemoryMetaStoreElementType>(){

            @Override
            public MemoryMetaStoreElementType call() throws Exception {
                return MemoryMetaStoreNamespace.this.getElementTypeByNameInternal(elementTypeName);
            }
        });
    }

    public List<String> getElementTypeIds() {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                ArrayList<String> list = new ArrayList<String>(MemoryMetaStoreNamespace.this.typeMap.size());
                for (MemoryMetaStoreElementType elementType : MemoryMetaStoreNamespace.this.typeMap.values()) {
                    list.add(elementType.getId());
                }
                return list;
            }
        });
    }

    public void createElementType(final String metaStoreName, final IMetaStoreElementType elementType) throws MetaStoreElementTypeExistsException {
        if (elementType.getId() == null) {
            elementType.setId(elementType.getName());
        }
        try {
            MetaStoreUtil.executeLockedOperation(this.writeLock, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MemoryMetaStoreElementType verifyType = (MemoryMetaStoreElementType)MemoryMetaStoreNamespace.this.typeMap.get(elementType.getId());
                    if (verifyType != null) {
                        throw new MetaStoreElementTypeExistsException(new ArrayList<IMetaStoreElementType>(MemoryMetaStoreNamespace.this.typeMap.values()), "Element type with ID '" + elementType.getId() + "' already exists");
                    }
                    MemoryMetaStoreElementType copiedType = new MemoryMetaStoreElementType(elementType);
                    MemoryMetaStoreNamespace.this.typeMap.put(elementType.getId(), copiedType);
                    copiedType.setMetaStoreName(metaStoreName);
                    elementType.setMetaStoreName(metaStoreName);
                    return null;
                }
            });
        }
        catch (MetaStoreException e) {
            if (e instanceof MetaStoreElementTypeExistsException) {
                throw (MetaStoreElementTypeExistsException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void updateElementType(final String metaStoreName, final IMetaStoreElementType elementType) throws MetaStoreElementTypeExistsException {
        try {
            MetaStoreUtil.executeLockedOperation(this.writeLock, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MemoryMetaStoreElementType verifyType = (MemoryMetaStoreElementType)MemoryMetaStoreNamespace.this.typeMap.get(elementType.getId());
                    if (verifyType == null) {
                        throw new MetaStoreElementTypeExistsException(new ArrayList<IMetaStoreElementType>(MemoryMetaStoreNamespace.this.typeMap.values()), "Element type to update, with ID '" + elementType.getId() + "', does not exist");
                    }
                    MemoryMetaStoreElementType copiedType = new MemoryMetaStoreElementType(elementType);
                    MemoryMetaStoreNamespace.this.typeMap.put(elementType.getId(), copiedType);
                    copiedType.setMetaStoreName(metaStoreName);
                    elementType.setMetaStoreName(metaStoreName);
                    return null;
                }
            });
        }
        catch (MetaStoreException e) {
            if (e instanceof MetaStoreElementTypeExistsException) {
                throw (MetaStoreElementTypeExistsException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void deleteElementType(final IMetaStoreElementType elementType) throws MetaStoreElementTypeExistsException, MetaStoreDependenciesExistsException {
        try {
            MetaStoreUtil.executeLockedOperation(this.writeLock, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    final MemoryMetaStoreElementType verifyType = (MemoryMetaStoreElementType)MemoryMetaStoreNamespace.this.typeMap.get(elementType.getId());
                    if (verifyType == null) {
                        throw new MetaStoreElementTypeExistsException(new ArrayList<IMetaStoreElementType>(MemoryMetaStoreNamespace.this.typeMap.values()), "Element type to delete, with ID '" + elementType.getId() + "', does not exist");
                    }
                    MetaStoreUtil.executeLockedOperation(verifyType.getReadLock(), new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            if (!verifyType.isElementMapEmpty()) {
                                MemoryMetaStoreElementType foundElementType = MemoryMetaStoreNamespace.this.getElementTypeByNameInternal(elementType.getName());
                                throw new MetaStoreDependenciesExistsException(foundElementType.getElementIds(), "Element type with ID '" + elementType.getId() + "' could not be deleted as it still contains elements.");
                            }
                            MemoryMetaStoreNamespace.this.typeMap.remove(elementType.getId());
                            return null;
                        }
                    });
                    return null;
                }
            });
        }
        catch (MetaStoreException e) {
            if (e instanceof MetaStoreElementTypeExistsException) {
                throw (MetaStoreElementTypeExistsException)e;
            }
            if (e instanceof MetaStoreDependenciesExistsException) {
                throw (MetaStoreDependenciesExistsException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public IMetaStoreElementType getElementTypeById(final String elementTypeId) {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<IMetaStoreElementType>(){

            @Override
            public IMetaStoreElementType call() throws Exception {
                return (IMetaStoreElementType)MemoryMetaStoreNamespace.this.typeMap.get(elementTypeId);
            }
        });
    }

    protected ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.readLock;
    }

    public List<IMetaStoreElement> getElementsByElementTypeName(final String elementTypeName) {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<List<IMetaStoreElement>>(){

            @Override
            public List<IMetaStoreElement> call() throws Exception {
                MemoryMetaStoreElementType elementType = MemoryMetaStoreNamespace.this.getElementTypeByNameInternal(elementTypeName);
                if (elementType != null) {
                    return elementType.getElements();
                }
                return Collections.emptyList();
            }
        });
    }

    public List<String> getElementIdsByElementTypeName(final String elementTypeName) {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                MemoryMetaStoreElementType elementType = MemoryMetaStoreNamespace.this.getElementTypeByNameInternal(elementTypeName);
                if (elementType != null) {
                    return elementType.getElementIds();
                }
                return Collections.emptyList();
            }
        });
    }

    public IMetaStoreElement getElementByTypeNameId(final String elementTypeName, final String elementId) {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<IMetaStoreElement>(){

            @Override
            public IMetaStoreElement call() throws Exception {
                MemoryMetaStoreElementType elementType = MemoryMetaStoreNamespace.this.getElementTypeByNameInternal(elementTypeName);
                if (elementType != null) {
                    return elementType.getElement(elementId);
                }
                return null;
            }
        });
    }

    public List<IMetaStoreElementType> getElementTypes() {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<List<IMetaStoreElementType>>(){

            @Override
            public List<IMetaStoreElementType> call() throws Exception {
                return new ArrayList<IMetaStoreElementType>(MemoryMetaStoreNamespace.this.typeMap.values());
            }
        });
    }

    public IMetaStoreElement getElementByNameTypeName(final String elementTypeName, final String elementName) {
        return MetaStoreUtil.executeLockedOperationQuietly(this.readLock, new Callable<IMetaStoreElement>(){

            @Override
            public IMetaStoreElement call() throws Exception {
                MemoryMetaStoreElementType elementType = MemoryMetaStoreNamespace.this.getElementTypeByNameInternal(elementTypeName);
                if (elementType != null) {
                    return elementType.getElementByName(elementName);
                }
                return null;
            }
        });
    }

    public void createElement(final IMetaStoreElementType elementType, final IMetaStoreElement element) throws MetaStoreException {
        MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreElementType foundElementType = MemoryMetaStoreNamespace.this.getElementTypeByNameInternal(elementType.getName());
                if (foundElementType == null) {
                    throw new MetaStoreException("Element type '" + elementType.getName() + "' couldn't be found");
                }
                foundElementType.createElement(element);
                return null;
            }
        });
    }

    public void updateElement(final IMetaStoreElementType elementType, final String elementId, final IMetaStoreElement element) throws MetaStoreException {
        MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreElementType foundElementType = MemoryMetaStoreNamespace.this.getElementTypeByNameInternal(elementType.getName());
                if (foundElementType == null) {
                    throw new MetaStoreException("Element type '" + elementType.getName() + "' couldn't be found");
                }
                foundElementType.updateElement(elementId, element);
                return null;
            }
        });
    }

    public void deleteElement(final IMetaStoreElementType elementType, final String elementId) throws MetaStoreException {
        MetaStoreUtil.executeLockedOperation(this.readLock, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MemoryMetaStoreElementType foundElementType = MemoryMetaStoreNamespace.this.getElementTypeByNameInternal(elementType.getName());
                if (foundElementType == null) {
                    throw new MetaStoreException("Element type '" + elementType.getName() + "' couldn't be found");
                }
                foundElementType.deleteElement(elementId);
                return null;
            }
        });
    }
}

