/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq.generator;

import com.bitmechanic.maxq.Action;
import com.bitmechanic.maxq.HttpRequestHeader;
import com.bitmechanic.maxq.HttpTestCase;
import com.bitmechanic.maxq.IScriptAdapter;
import com.bitmechanic.maxq.Param;
import com.bitmechanic.maxq.RequestObserver;
import com.bitmechanic.maxq.Test;
import com.bitmechanic.maxq.Utils;
import com.bitmechanic.maxq.generator.GeneratorFactory;
import com.bitmechanic.maxq.generator.IScriptGenerator;
import java.util.HashMap;
import java.util.StringTokenizer;

public abstract class AbstractCodeGenerator
implements IScriptGenerator,
RequestObserver {
    private static String cpRspTo = System.getProperty("http.cpRspTo");
    private static boolean cpRspToStdout;
    private static boolean cpRspToFile;
    private static final String[] MIME_DEFAULTS;
    private static HashMap mimeTypes;
    private IScriptAdapter scriptAdapter;
    private String testName;
    private String defaultTestName;
    private String testPath;
    protected long assertNumber = 0L;
    protected static final String END_STATEMENT;
    protected static String jtidyConfigFile;

    static {
        cpRspToFile = false;
        MIME_DEFAULTS = new String[]{"text/plain", "text/html"};
        END_STATEMENT = ";" + IScriptGenerator.EOL;
        jtidyConfigFile = System.getProperty("jtidy.config");
        if (cpRspTo != null) {
            if (cpRspTo.toLowerCase().compareTo("stdout") == 0) {
                cpRspToStdout = true;
            } else if (cpRspTo.toLowerCase().compareTo("file") == 0) {
                cpRspToFile = true;
            }
        }
        mimeTypes = new HashMap();
        int i = 0;
        while (i < MIME_DEFAULTS.length) {
            mimeTypes.put(MIME_DEFAULTS[i], MIME_DEFAULTS[i]);
            ++i;
        }
    }

    public static boolean isCpRspToStdout() {
        return cpRspToStdout;
    }

    public static boolean isCpRspToFile() {
        return cpRspToFile;
    }

    public AbstractCodeGenerator(IScriptAdapter adapter) {
        this.scriptAdapter = adapter;
        jtidyConfigFile = GeneratorFactory.generatorProperties.getProperty("jtidy.config");
        this.defaultTestName = this.testName = GeneratorFactory.generatorProperties.getProperty("test.default_testname", "MaxQTest");
    }

    public IScriptAdapter getScriptAdapter() {
        return this.scriptAdapter;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public String getDefaultTestName() {
        return this.defaultTestName;
    }

    public void setDefaultTestName(String defaultTestName) {
        this.defaultTestName = defaultTestName;
    }

    public String getTestPath() {
        return this.testPath;
    }

    public void setTestPath(String testPath) {
        this.testPath = testPath;
    }

    public String getScript() {
        return this.scriptAdapter.getText();
    }

    public void processResponse(HttpRequestHeader header, byte[] response) {
        String respStr = new String(response).toLowerCase();
        String respCode = this.parseResponseCode(respStr);
        String contentType = this.parseContentType(respStr);
        if (contentType != null && mimeTypes.get(contentType) != null && respCode != null) {
            this.doAssertResponse(respCode);
            if (respCode.startsWith("200") && contentType.toLowerCase().compareTo("text/html") == 0) {
                this.doTidyCode(HttpTestCase.staticUrlDecode(header.url));
                if (cpRspToStdout) {
                    this.doResponseForStdOut(HttpTestCase.staticUrlDecode(header.url).trim());
                } else if (cpRspToFile) {
                    this.doResponseForFile();
                }
            }
            this.appendEOL();
        }
    }

    protected void loadScriptAdapter(String script) {
        this.scriptAdapter.setText(script);
    }

    protected void appendEOL() {
        this.scriptAdapter.append(IScriptGenerator.EOL);
    }

    private String parseContentType(String response) {
        String contentType = null;
        int pos = response.indexOf("content-type:");
        if (pos > -1) {
            int end = response.indexOf("\r\n", pos += 14);
            int end2 = response.indexOf(";", pos);
            if (end2 > -1 && end2 < end) {
                end = end2;
            }
            if (end > -1) {
                contentType = response.substring(pos, end).trim();
            }
            if (Test.debug) {
                System.err.println("  content-type: " + contentType);
            }
        } else if (Test.debug) {
            System.err.println("  No content-type header!  First few lines:");
            StringTokenizer st = new StringTokenizer(response, "\n");
            int i = 0;
            while (st.hasMoreTokens() && i < 5) {
                System.err.println(st.nextToken());
                ++i;
            }
        }
        return contentType;
    }

    private String parseResponseCode(String response) {
        String respCode = null;
        int pos = response.indexOf(" ");
        if (pos != -1) {
            int end = response.indexOf(" ", pos + 1);
            int end2 = response.indexOf("\n", pos + 1);
            if (end2 != -1 && end2 < end) {
                end = end2;
            }
            if (end != -1) {
                respCode = response.substring(pos + 1, end).trim();
            }
        }
        if (Test.debug) {
            System.err.println();
            System.err.println("HTTP response code: " + respCode);
        }
        return respCode;
    }

    public void processRequest(HttpRequestHeader header, byte[] requestBody) {
        int pos;
        boolean isMultiPartRequest = false;
        Action action = new Action();
        String url = header.url;
        if (Test.debug) {
            System.err.println("  recording url: " + url);
        }
        if ((pos = url.indexOf("?")) != -1 && url.length() > pos + 1) {
            this.setParams(action, url.substring(pos + 1));
            action.setUrl(url.substring(0, pos));
        } else {
            action.setUrl(url);
        }
        if (requestBody.length > 0) {
            if (isMultiPartRequest) {
                this.setMultiPartData(action, requestBody);
            } else {
                this.setParams(action, new String(requestBody));
            }
        }
        if (action.getParamCount() > 0) {
            this.doCreateList();
            Param[] params = action.getParams();
            int i = 0;
            while (i < params.length) {
                String name = params[i].name;
                String value = params[i].value;
                if (name.indexOf("+") != -1 || name.indexOf("%") != -1) {
                    name = HttpTestCase.staticUrlDecode(name);
                }
                if (value.indexOf("+") != -1 || value.indexOf("%") != -1) {
                    value = HttpTestCase.staticUrlDecode(value);
                }
                this.doAddParameterToList(name, value);
                ++i;
            }
        }
        String url_str = header.url;
        if (requestBody.length > 0) {
            url_str = String.valueOf(url_str) + '?' + new String(requestBody);
        }
        if (!isMultiPartRequest) {
            this.doTestUrlMessage(HttpTestCase.staticUrlDecode(url_str).trim());
        }
        String method = header.method.toLowerCase();
        String list_str = "";
        String data_str = "";
        String cont_len_str = "";
        if (isMultiPartRequest) {
            method = String.valueOf(method) + "MultiPart";
            data_str = ", data";
            cont_len_str = ", " + header.contentLength;
            this.doSetData(action.getMultiPartData());
        }
        if (action.getParamCount() > 0) {
            list_str = ", list";
        }
        this.doCallUrl(action.getUrl(), method, data_str, cont_len_str, list_str);
    }

    private void setMultiPartData(Action action, byte[] strarray) {
        String str = new String(strarray);
        str = str.trim();
        str = Utils.replace(str, "'", "\\'");
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\n') {
                msb.append("\\r\\n'\\\n        '");
            } else if (str.charAt(i) != '\r') {
                msb.append(str.charAt(i));
            }
            ++i;
        }
        action.setMultiPartData(msb.toString());
    }

    private void setParams(Action action, String str) {
        str = str.trim();
        if (Test.debug) {
            System.err.println("  parsing: " + str);
        }
        String[] items = Utils.splitString(str, "&");
        int i = 0;
        while (i < items.length) {
            int pos = items[i].indexOf("=");
            if (pos != -1) {
                Param p = new Param();
                action.addParam(p);
                p.name = items[i].substring(0, pos);
                p.value = pos < items[i].length() - 1 ? items[i].substring(pos + 1) : "";
            }
            ++i;
        }
    }
}

