/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import java.io.Serializable;
import java.text.NumberFormat;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class FixedFunction
implements Function {
    private static final long serialVersionUID = 3505313019941429911L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        Serializable resultDecimals;
        Object valueDecimals;
        Type typeDecimals;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1 || parameterCount > 3) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        Number result = context.getTypeRegistry().convertToNumber(type1, value1);
        if (result == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        NumberFormat currencyInstance = NumberFormat.getNumberInstance(context.getLocalizationContext().getLocale());
        if (parameterCount == 2) {
            typeDecimals = parameters.getType(1);
            valueDecimals = parameters.getValue(1);
            resultDecimals = context.getTypeRegistry().convertToNumber(typeDecimals, valueDecimals);
            currencyInstance.setMaximumFractionDigits(((Number)resultDecimals).intValue());
            currencyInstance.setMinimumFractionDigits(((Number)resultDecimals).intValue());
        }
        if (parameterCount == 3) {
            typeDecimals = parameters.getType(2);
            valueDecimals = parameters.getValue(2);
            resultDecimals = context.getTypeRegistry().convertToLogical(typeDecimals, valueDecimals);
            currencyInstance.setGroupingUsed(Boolean.TRUE.equals(resultDecimals));
        }
        return new TypeValuePair(TextType.TYPE, currencyInstance.format(result));
    }

    @Override
    public String getCanonicalName() {
        return "FIXED";
    }
}

