/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.www.CarteSingleton;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebServer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Carte {
    private static Class<?> PKG = Carte.class;
    private WebServer webServer;
    private SlaveServerConfig config;
    private boolean allOK;
    private static Options options;

    public Carte(SlaveServerConfig config) throws Exception {
        this(config, null);
    }

    public Carte(SlaveServerConfig config, Boolean joinOverride) throws Exception {
        this.config = config;
        this.allOK = true;
        CarteSingleton.setSlaveServerConfig(config);
        LogChannelInterface log = CarteSingleton.getInstance().getLog();
        TransformationMap transformationMap = CarteSingleton.getInstance().getTransformationMap();
        transformationMap.setSlaveServerConfig(config);
        JobMap jobMap = CarteSingleton.getInstance().getJobMap();
        jobMap.setSlaveServerConfig(config);
        CopyOnWriteArrayList<SlaveServerDetection> detections = new CopyOnWriteArrayList<SlaveServerDetection>();
        SocketRepository socketRepository = CarteSingleton.getInstance().getSocketRepository();
        SlaveServer slaveServer = config.getSlaveServer();
        String hostname = slaveServer.getHostname();
        int port = 80;
        if (!Utils.isEmpty((CharSequence)slaveServer.getPort())) {
            try {
                port = Integer.parseInt(slaveServer.getPort());
            }
            catch (Exception e) {
                log.logError(BaseMessages.getString(PKG, (String)"Carte.Error.CanNotPartPort", (String[])new String[]{slaveServer.getHostname(), "" + port}), (Throwable)e);
                this.allOK = false;
            }
        }
        Properties masterProperties = null;
        if (config.isReportingToMasters()) {
            String propertiesMaster = slaveServer.getPropertiesMasterName();
            for (SlaveServer master : config.getMasters()) {
                try {
                    SlaveServerDetection slaveServerDetection = new SlaveServerDetection(slaveServer.getClient());
                    master.sendXML(slaveServerDetection.getXML(), "/kettle/registerSlave/");
                    log.logBasic("Registered this slave server to master slave server [" + master.toString() + "] on address [" + master.getServerAndPort() + "]");
                }
                catch (Exception e) {
                    log.logError("Unable to register to master slave server [" + master.toString() + "] on address [" + master.getServerAndPort() + "]");
                    this.allOK = false;
                }
                try {
                    if (StringUtils.isBlank((String)propertiesMaster) || !propertiesMaster.equalsIgnoreCase(master.getName())) continue;
                    if (masterProperties != null) {
                        log.logError("More than one primary master server. Master name is " + propertiesMaster);
                        continue;
                    }
                    masterProperties = master.getKettleProperties();
                    log.logBasic("Got properties from master server [" + master.toString() + "], address [" + master.getServerAndPort() + "]");
                }
                catch (Exception e) {
                    log.logError("Unable to get properties from master server [" + master.toString() + "], address [" + master.getServerAndPort() + "]");
                    this.allOK = false;
                }
            }
        }
        if (masterProperties != null) {
            EnvUtil.applyKettleProperties(masterProperties, (boolean)slaveServer.isOverrideExistingProperties());
        }
        if (this.allOK) {
            boolean shouldJoin = config.isJoining();
            if (joinOverride != null) {
                shouldJoin = joinOverride;
            }
            this.webServer = new WebServer(log, transformationMap, jobMap, socketRepository, detections, hostname, port, shouldJoin, config.getPasswordFile(), slaveServer.getSslConfig());
        }
    }

    public static void main(String[] args) {
        try {
            Carte.parseAndRunCommand(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void parseAndRunCommand(String[] args) throws Exception {
        options = new Options();
        OptionBuilder.withLongOpt((String)"stop");
        OptionBuilder.withDescription((String)BaseMessages.getString(PKG, (String)"Carte.ParamDescription.stop", (String[])new String[0]));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"userName");
        OptionBuilder.withDescription((String)BaseMessages.getString(PKG, (String)"Carte.ParamDescription.userName", (String[])new String[0]));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'u'));
        OptionBuilder.withLongOpt((String)"password");
        OptionBuilder.withDescription((String)BaseMessages.getString(PKG, (String)"Carte.ParamDescription.password", (String[])new String[0]));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)BaseMessages.getString(PKG, (String)"Carte.ParamDescription.help", (String[])new String[0]));
        options.addOption(OptionBuilder.create((char)'h'));
        BasicParser parser = new BasicParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption('h')) {
            Carte.displayHelpAndAbort();
        }
        String[] arguments = cmd.getArgs();
        boolean usingConfigFile = false;
        SlaveServerConfig config = null;
        if (arguments.length == 1 && !Utils.isEmpty((CharSequence)arguments[0])) {
            if (cmd.hasOption('s')) {
                throw new CarteCommandException(BaseMessages.getString(PKG, (String)"Carte.Error.illegalStop", (String[])new String[0]));
            }
            usingConfigFile = true;
            FileObject file = KettleVFS.getFileObject((String)arguments[0]);
            Document document = XMLHandler.loadXMLFile((FileObject)file);
            Carte.setKettleEnvironment();
            Node configNode = XMLHandler.getSubNode((Node)document, (String)"slave_config");
            config = new SlaveServerConfig((LogChannelInterface)new LogChannel((Object)"Slave server config"), configNode);
            if (config.getAutoSequence() != null) {
                config.readAutoSequences();
            }
            config.setFilename(arguments[0]);
        }
        if (arguments.length == 2 && !Utils.isEmpty((CharSequence)arguments[0]) && !Utils.isEmpty((CharSequence)arguments[1])) {
            String hostname = arguments[0];
            String port = arguments[1];
            if (cmd.hasOption('s')) {
                String user = cmd.getOptionValue('u');
                String password = cmd.getOptionValue('p');
                Carte.shutdown(hostname, port, user, password);
                System.exit(0);
            }
            SlaveServer slaveServer = new SlaveServer(hostname + ":" + port, hostname, port, null, null);
            config = new SlaveServerConfig();
            config.setSlaveServer(slaveServer);
        }
        if (config == null) {
            Carte.displayHelpAndAbort();
        }
        if (!usingConfigFile) {
            Carte.setKettleEnvironment();
        }
        Carte.runCarte(config);
    }

    private static void setKettleEnvironment() throws Exception {
        KettleClientEnvironment.getInstance().setClient(KettleClientEnvironment.ClientType.CARTE);
        KettleEnvironment.init();
    }

    public static void runCarte(SlaveServerConfig config) throws Exception {
        KettleLogStore.init((int)config.getMaxLogLines(), (int)config.getMaxLogTimeoutMinutes());
        config.setJoining(true);
        Carte carte = new Carte(config, false);
        CarteSingleton.setCarte(carte);
        carte.getWebServer().join();
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public void setWebServer(WebServer webServer) {
        this.webServer = webServer;
    }

    public SlaveServerConfig getConfig() {
        return this.config;
    }

    public void setConfig(SlaveServerConfig config) {
        this.config = config;
    }

    private static void displayHelpAndAbort() {
        HelpFormatter formatter = new HelpFormatter();
        String optionsHelp = Carte.getOptionsHelpForUsage();
        String header = BaseMessages.getString(PKG, (String)"Carte.Usage.Text", (String[])new String[0]) + optionsHelp + "\nor\n" + BaseMessages.getString(PKG, (String)"Carte.Usage.Text2", (String[])new String[0]) + "\n\n" + BaseMessages.getString(PKG, (String)"Carte.MainDescription", (String[])new String[0]);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        formatter.printHelp(printWriter, 80, "CarteDummy", header, options, 5, 5, "", false);
        System.err.println(Carte.stripOff(stringWriter.toString(), "usage: CarteDummy"));
        System.err.println(BaseMessages.getString(PKG, (String)"Carte.Usage.Example", (String[])new String[0]) + ": Carte 127.0.0.1 8080");
        System.err.println(BaseMessages.getString(PKG, (String)"Carte.Usage.Example", (String[])new String[0]) + ": Carte 192.168.1.221 8081");
        System.err.println();
        System.err.println(BaseMessages.getString(PKG, (String)"Carte.Usage.Example", (String[])new String[0]) + ": Carte /foo/bar/carte-config.xml");
        System.err.println(BaseMessages.getString(PKG, (String)"Carte.Usage.Example", (String[])new String[0]) + ": Carte http://www.example.com/carte-config.xml");
        System.err.println(BaseMessages.getString(PKG, (String)"Carte.Usage.Example", (String[])new String[0]) + ": Carte 127.0.0.1 8080 -s -u cluster -p cluster");
        System.exit(1);
    }

    private static String getOptionsHelpForUsage() {
        HelpFormatter formatter = new HelpFormatter();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        formatter.printUsage(printWriter, 999, "", options);
        return Carte.stripOff(stringWriter.toString(), "usage: ");
    }

    private static String stripOff(String target, String strip) {
        return target.substring(target.indexOf(strip) + strip.length());
    }

    private static void shutdown(String hostname, String port, String username, String password) {
        try {
            Carte.callStopCarteRestService(hostname, port, username, password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @VisibleForTesting
    static void callStopCarteRestService(String hostname, String port, String username, String password) throws ParseException, CarteCommandException {
        try {
            KettleClientEnvironment.init();
            DefaultClientConfig clientConfig = new DefaultClientConfig();
            clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
            Client client = Client.create((ClientConfig)clientConfig);
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, Encr.decryptPasswordOptionallyEncrypted((String)password)));
            String contextURL = "http://" + hostname + ":" + port + "/kettle";
            WebResource resource = client.resource(contextURL + "/status/?xml=Y");
            String response = (String)resource.get(String.class);
            if (response == null || !response.contains("<serverstatus>")) {
                throw new CarteCommandException(BaseMessages.getString(PKG, (String)"Carte.Error.NoServerFound", (String[])new String[]{hostname, "" + port}));
            }
            resource = client.resource(contextURL + "/stopCarte");
            response = (String)resource.get(String.class);
            if (response == null || !response.contains("Shutting Down")) {
                throw new CarteCommandException(BaseMessages.getString(PKG, (String)"Carte.Error.NoShutdown", (String[])new String[]{hostname, "" + port}));
            }
        }
        catch (Exception e) {
            throw new CarteCommandException(BaseMessages.getString(PKG, (String)"Carte.Error.NoServerFound", (String[])new String[]{hostname, "" + port}), e);
        }
    }

    public static class CarteCommandException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CarteCommandException() {
        }

        public CarteCommandException(String message) {
            super(message);
        }

        public CarteCommandException(String message, Throwable cause) {
            super(message, cause);
        }

        public CarteCommandException(Throwable cause) {
            super(cause);
        }
    }
}

