/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices.wsdl;

import java.util.ArrayList;
import java.util.Map;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOpFault;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlTypes;
import org.w3c.dom.Element;

public final class WsdlOpFaultList
extends ArrayList<WsdlOpFault> {
    private static final long serialVersionUID = 1L;
    private final WsdlTypes _wsdlTypes;

    protected WsdlOpFaultList(WsdlTypes wsdlTypes) {
        this._wsdlTypes = wsdlTypes;
    }

    @Override
    protected boolean add(Fault fault) throws KettleStepException {
        return this.add(this.getFault(fault));
    }

    private WsdlOpFault getFault(Fault fault) throws KettleStepException {
        Message m = fault.getMessage();
        Map partMap = m.getParts();
        if (partMap.size() != 1) {
            throw new IllegalArgumentException("Invalid part count for fault!!");
        }
        Part faultPart = (Part)partMap.values().iterator().next();
        boolean complexType = false;
        QName type = faultPart.getTypeName();
        if (type == null) {
            type = faultPart.getElementName();
            Element schemaElement = this._wsdlTypes.findNamedElement(type);
            type = this._wsdlTypes.getTypeQName(schemaElement.getAttribute("type"));
            complexType = true;
        }
        return new WsdlOpFault(fault.getName(), type, complexType, this._wsdlTypes);
    }
}

