/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.processfiles;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.processfiles.ProcessFilesData;
import org.pentaho.di.trans.steps.processfiles.ProcessFilesMeta;

public class ProcessFiles
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ProcessFilesMeta.class;
    private ProcessFilesMeta meta;
    private ProcessFilesData data;

    public ProcessFiles(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block35: {
            this.meta = (ProcessFilesMeta)smi;
            this.data = (ProcessFilesData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                if (Utils.isEmpty((CharSequence)this.meta.getDynamicSourceFileNameField())) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFilenameFieldMissing", (String[])new String[0]));
                }
                if (this.meta.getOperationType() != 2 && Utils.isEmpty((CharSequence)this.meta.getDynamicTargetFileNameField())) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.TargetFilenameFieldMissing", (String[])new String[0]));
                }
                if (this.data.indexOfSourceFilename < 0) {
                    this.data.indexOfSourceFilename = this.getInputRowMeta().indexOfValue(this.meta.getDynamicSourceFileNameField());
                    if (this.data.indexOfSourceFilename < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"ProcessFiles.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicSourceFileNameField()}));
                    }
                }
                if (this.meta.getOperationType() != 2 && this.data.indexOfTargetFilename < 0) {
                    this.data.indexOfTargetFilename = this.getInputRowMeta().indexOfValue(this.meta.getDynamicTargetFileNameField());
                    if (this.data.indexOfTargetFilename < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"ProcessFiles.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicTargetFileNameField()}));
                    }
                }
                if (this.meta.simulate && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.SimulationModeON", (String[])new String[0]));
                }
            }
            try {
                String sourceFilename = this.getInputRowMeta().getString(r, this.data.indexOfSourceFilename);
                if (Utils.isEmpty((CharSequence)sourceFilename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFileEmpty", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFileEmpty", (String[])new String[0]));
                }
                this.data.sourceFile = KettleVFS.getFileObject((String)sourceFilename, (VariableSpace)this.getTransMeta());
                if (!this.data.sourceFile.exists()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFileNotExist", (String[])new String[]{sourceFilename}));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFileNotExist", (String[])new String[]{sourceFilename}));
                }
                if (this.data.sourceFile.getType() != FileType.FILE) {
                    this.logError(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFileNotFile", (String[])new String[]{sourceFilename}));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.SourceFileNotFile", (String[])new String[]{sourceFilename}));
                }
                String targetFilename = null;
                if (this.meta.getOperationType() != 2) {
                    targetFilename = this.getInputRowMeta().getString(r, this.data.indexOfTargetFilename);
                    if (Utils.isEmpty((CharSequence)targetFilename)) {
                        this.logError(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.TargetFileEmpty", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.TargetFileEmpty", (String[])new String[0]));
                    }
                    this.data.targetFile = KettleVFS.getFileObject((String)targetFilename, (VariableSpace)this.getTransMeta());
                    if (this.data.targetFile.exists()) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.TargetFileExists", (String[])new String[]{targetFilename}));
                        }
                        if (this.data.targetFile.getType() != FileType.FILE) {
                            this.logError(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.TargetFileNotFile", (String[])new String[]{targetFilename}));
                            throw new KettleException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.TargetFileNotFile", (String[])new String[]{targetFilename}));
                        }
                    } else {
                        FileObject parentFolder = this.data.targetFile.getParent();
                        if (!parentFolder.exists()) {
                            if (!this.meta.isCreateParentFolder()) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.TargetParentFolderNotExists", (String[])new String[]{parentFolder.toString()}));
                            }
                            parentFolder.createFolder();
                        }
                        if (parentFolder != null) {
                            parentFolder.close();
                        }
                    }
                }
                switch (this.meta.getOperationType()) {
                    case 0: {
                        if ((this.meta.isOverwriteTargetFile() && this.data.targetFile.exists() || !this.data.targetFile.exists()) && !this.meta.simulate) {
                            this.data.targetFile.copyFrom(this.data.sourceFile, (FileSelector)new TextOneToOneFileSelector());
                            if (!this.log.isDetailed()) break;
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.SourceFileCopied", (String[])new String[]{sourceFilename, targetFilename}));
                            break;
                        }
                        if (!this.log.isDetailed()) break;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.TargetNotOverwritten", (String[])new String[]{sourceFilename, targetFilename}));
                        break;
                    }
                    case 1: {
                        if ((this.meta.isOverwriteTargetFile() && this.data.targetFile.exists() || !this.data.targetFile.exists()) && !this.meta.simulate) {
                            this.data.sourceFile.moveTo(KettleVFS.getFileObject((String)targetFilename, (VariableSpace)this.getTransMeta()));
                            if (!this.log.isDetailed()) break;
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.SourceFileMoved", (String[])new String[]{sourceFilename, targetFilename}));
                            break;
                        }
                        if (!this.log.isDetailed()) break;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.TargetNotOverwritten", (String[])new String[]{sourceFilename, targetFilename}));
                        break;
                    }
                    case 2: {
                        if (!this.meta.simulate && !this.data.sourceFile.delete()) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"ProcessFiles.Error.CanNotDeleteFile", (String[])new String[]{this.data.sourceFile.toString()}));
                        }
                        if (!this.log.isDetailed()) break;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.SourceFileDeleted", (String[])new String[]{sourceFilename}));
                        break;
                    }
                }
                if (this.meta.isaddTargetFileNametoResult() && this.meta.getOperationType() != 2 && this.data.sourceFile.getType() == FileType.FILE) {
                    ResultFile resultFile = new ResultFile(0, this.data.targetFile, this.getTransMeta().getName(), this.getStepname());
                    resultFile.setComment(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.FileAddedResult", (String[])new String[0]));
                    this.addResultFile(resultFile);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ProcessFiles.Log.FilenameAddResult", (String[])new String[]{this.data.sourceFile.toString()}));
                    }
                }
                this.putRow(this.getInputRowMeta(), r);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ProcessFiles.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ProcessFiles.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block35;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "ProcessFiles001");
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ProcessFilesMeta)smi;
        this.data = (ProcessFilesData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ProcessFilesMeta)smi;
        this.data = (ProcessFilesData)sdi;
        if (this.data.sourceFile != null) {
            try {
                this.data.sourceFile.close();
                this.data.sourceFile = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.data.targetFile != null) {
            try {
                this.data.targetFile.close();
                this.data.targetFile = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }

    private class TextOneToOneFileSelector
    implements FileSelector {
        private TextOneToOneFileSelector() {
        }

        public boolean includeFile(FileSelectInfo info) throws Exception {
            return true;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return false;
        }
    }
}

