/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.normaliser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.normaliser.Normaliser;
import org.pentaho.di.trans.steps.normaliser.NormaliserData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="NormaliserMeta.Injection.", groups={"FIELDS"})
public class NormaliserMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = NormaliserMeta.class;
    private String typeField;
    @InjectionDeep
    private NormaliserField[] normaliserFields = new NormaliserField[0];

    public String getTypeField() {
        return this.typeField;
    }

    public void setTypeField(String typeField) {
        this.typeField = typeField;
    }

    public NormaliserField[] getNormaliserFields() {
        return this.normaliserFields;
    }

    public void setNormaliserFields(NormaliserField[] normaliserFields) {
        this.normaliserFields = normaliserFields;
    }

    public Set<String> getFieldNames() {
        HashSet<String> fieldNames = new HashSet<String>();
        for (int i = 0; i < this.normaliserFields.length; ++i) {
            String s = this.normaliserFields[i].getName();
            if (s == null) continue;
            fieldNames.add(s.toLowerCase());
        }
        return fieldNames;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.normaliserFields = new NormaliserField[nrfields];
        for (int i = 0; i < nrfields; ++i) {
            this.normaliserFields[i] = new NormaliserField();
        }
    }

    @Override
    public Object clone() {
        NormaliserMeta retval = (NormaliserMeta)super.clone();
        int nrfields = this.normaliserFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.normaliserFields[i] = (NormaliserField)this.normaliserFields[i].clone();
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.typeField = XMLHandler.getTagValue((Node)stepnode, (String)"typefield");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.normaliserFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.normaliserFields[i].setValue(XMLHandler.getTagValue((Node)fnode, (String)"value"));
                this.normaliserFields[i].setNorm(XMLHandler.getTagValue((Node)fnode, (String)"norm"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"NormaliserMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.typeField = "typefield";
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.normaliserFields[i].setName("field" + i);
            this.normaliserFields[i].setValue("value" + i);
            this.normaliserFields[i].setNorm("value" + i);
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        int i;
        ArrayList<String> norm_occ = new ArrayList<String>();
        ArrayList<String> field_occ = new ArrayList<String>();
        int maxlen = 0;
        for (int i2 = 0; i2 < this.normaliserFields.length; ++i2) {
            if (!norm_occ.contains(this.normaliserFields[i2].getNorm())) {
                norm_occ.add(this.normaliserFields[i2].getNorm());
                field_occ.add(this.normaliserFields[i2].getName());
            }
            if (this.normaliserFields[i2].getValue().length() <= maxlen) continue;
            maxlen = this.normaliserFields[i2].getValue().length();
        }
        ValueMetaString typefield_value = new ValueMetaString(this.typeField);
        typefield_value.setOrigin(name);
        typefield_value.setLength(maxlen);
        row.addValueMeta((ValueMetaInterface)typefield_value);
        for (i = 0; i < norm_occ.size(); ++i) {
            String normname = (String)norm_occ.get(i);
            String fieldname = (String)field_occ.get(i);
            ValueMetaInterface v = row.searchValueMeta(fieldname);
            if (v == null) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"NormaliserMeta.Exception.UnableToFindField", (String[])new String[]{fieldname}));
            }
            v = v.clone();
            v.setName(normname);
            v.setOrigin(name);
            row.addValueMeta(v);
        }
        for (i = 0; i < this.normaliserFields.length; ++i) {
            int idx = row.indexOfValue(this.normaliserFields[i].getName());
            if (idx < 0) continue;
            row.removeValueMeta(idx);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("   " + XMLHandler.addTagValue((String)"typefield", (String)this.typeField));
        retval.append("    <fields>");
        for (int i = 0; i < this.normaliserFields.length; ++i) {
            retval.append("      <field>");
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.normaliserFields[i].getName()));
            retval.append("        " + XMLHandler.addTagValue((String)"value", (String)this.normaliserFields[i].getValue()));
            retval.append("        " + XMLHandler.addTagValue((String)"norm", (String)this.normaliserFields[i].getNorm()));
            retval.append("        </field>");
        }
        retval.append("      </fields>");
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.typeField = rep.getStepAttributeString(id_step, "typefield");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.normaliserFields[i].setName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.normaliserFields[i].setValue(rep.getStepAttributeString(id_step, i, "field_value"));
                this.normaliserFields[i].setNorm(rep.getStepAttributeString(id_step, i, "field_norm"));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"NormaliserMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "typefield", this.typeField);
            for (int i = 0; i < this.normaliserFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.normaliserFields[i].getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_value", this.normaliserFields[i].getValue());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_norm", this.normaliserFields[i].getNorm());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"NormaliserMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.StepReceivingFieldsOK", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            boolean first = true;
            error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.normaliserFields.length; ++i) {
                String lufield = this.normaliserFields[i].getName();
                ValueMetaInterface v = prev.searchValueMeta(lufield);
                if (v != null) continue;
                if (first) {
                    first = false;
                    error_message = error_message + BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.FieldsNotFound", (String[])new String[0]) + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + lufield + Const.CR;
            }
            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.CouldNotReadFieldsFromPreviousStep", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.StepReceivingInfoOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Normaliser(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new NormaliserData();
    }

    public static class NormaliserField
    implements Cloneable {
        @Injection(name="NAME", group="FIELDS")
        private String name;
        @Injection(name="VALUE", group="FIELDS")
        private String value;
        @Injection(name="NORMALISED", group="FIELDS")
        private String norm;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getNorm() {
            return this.norm;
        }

        public void setNorm(String norm) {
            this.norm = norm;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.norm == null ? 0 : this.norm.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NormaliserField other = (NormaliserField)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.norm == null ? other.norm != null : !this.norm.equals(other.norm)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public Object clone() {
            try {
                NormaliserField retval = (NormaliserField)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

