/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput.store;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputMeta;

public class KettleTrustManager
implements X509TrustManager {
    private static Class<?> PKG = LDAPInputMeta.class;
    private X509TrustManager tm;

    public KettleTrustManager(KeyStore keyStore, String certFilename, String certPassword) throws KettleException {
        try {
            InputStream inputStream = null;
            try {
                inputStream = KettleVFS.getInputStream((String)certFilename);
                keyStore.load(inputStream, Const.NVL((String)certPassword, (String)"").toCharArray());
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"KettleTrustManager.Exception.CouldNotOpenCertStore", (String[])new String[0]), (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"KettleTrustManager.Exception.CouldNotOpenCertStore", (String[])new String[0]), (Throwable)e);
                    }
                }
            }
            try {
                TrustManagerFactory tmf = null;
                tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(keyStore);
                TrustManager[] tms = tmf.getTrustManagers();
                this.tm = (X509TrustManager)tms[0];
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"KettleTrustManager.Exception.CouldNotInitializeTrustManager", (String[])new String[0]), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"KettleTrustManager.Exception.CouldNotInitializeKettleTrustManager", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this.tm == null) {
            return null;
        }
        return this.tm.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.tm == null) {
            return;
        }
        this.tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.tm == null) {
            return;
        }
        this.tm.checkServerTrusted(chain, authType);
    }
}

