/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.staxpoi;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KCellType;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.trans.steps.excelinput.staxpoi.StaxPoiCell;
import org.pentaho.di.trans.steps.excelinput.staxpoi.StaxUtil;

public class StaxPoiSheet
implements KSheet {
    private static final TimeZone DATE_TZ = TimeZone.getTimeZone("UTC");
    private static final String ATTRIBUTE_T = "t";
    private static final String TAG_C = "c";
    private static final String TAG_IS = "is";
    private static final String TAG_ROW = "row";
    private static final String TAG_SHEET_DATA = "sheetData";
    private static final String TAG_T = "t";
    private static final String TAG_V = "v";
    private final String sheetName;
    private final String sheetId;
    private final XSSFReader xssfReader;
    private InputStream sheetStream;
    private XMLStreamReader sheetReader;
    private int currentRow;
    private List<String> headerRow;
    private int numRows;
    private int numCols;
    private boolean maxColsNumberDefined = true;
    private int firstRow;
    private KCell[] currentRowCells;
    private SharedStringsTable sst;
    private StylesTable styles;

    public StaxPoiSheet(XSSFReader reader, String sheetName, String sheetID) throws InvalidFormatException, IOException, XMLStreamException {
        this.sheetName = sheetName;
        this.xssfReader = reader;
        this.sheetId = sheetID;
        this.sst = reader.getSharedStringsTable();
        this.styles = reader.getStylesTable();
        this.sheetStream = reader.getSheet(sheetID);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        this.sheetReader = factory.createXMLStreamReader(this.sheetStream);
        this.headerRow = new ArrayList<String>();
        block0: while (this.sheetReader.hasNext()) {
            int event = this.sheetReader.next();
            if (event != 1) continue;
            if (this.sheetReader.getLocalName().equals("dimension")) {
                String dim = this.sheetReader.getAttributeValue(null, "ref");
                if (StringUtils.contains((String)dim, (char)':')) {
                    dim = dim.split(":")[1];
                    this.numRows = StaxUtil.extractRowNumber(dim);
                    this.numCols = StaxUtil.extractColumnNumber(dim);
                    continue;
                }
                this.maxColsNumberDefined = false;
                this.numCols = StaxUtil.MAX_COLUMNS;
                this.numRows = StaxUtil.MAX_ROWS;
                continue;
            }
            if (!this.sheetReader.getLocalName().equals(TAG_ROW)) continue;
            this.firstRow = this.currentRow = Integer.parseInt(this.sheetReader.getAttributeValue(null, "r"));
            block1: while (this.sheetReader.hasNext() && ((event = this.sheetReader.next()) != 2 || !this.sheetReader.getLocalName().equals(TAG_ROW))) {
                if (event != 1 || !this.sheetReader.getLocalName().equals(TAG_C)) continue;
                String attributeValue = this.sheetReader.getAttributeValue(null, "t");
                if (attributeValue != null) {
                    if (attributeValue.equals("s")) {
                        while (this.sheetReader.hasNext()) {
                            event = this.sheetReader.next();
                            if (event != 1 || !this.sheetReader.getLocalName().equals(TAG_V)) continue;
                            int idx = Integer.parseInt(this.sheetReader.getElementText());
                            String content = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
                            this.headerRow.add(content);
                            continue block1;
                        }
                        continue;
                    }
                    if (!attributeValue.equals("inlineStr")) continue;
                    while (this.sheetReader.hasNext()) {
                        event = this.sheetReader.next();
                        if (event != 1 || !this.sheetReader.getLocalName().equals(TAG_IS)) continue;
                        while (this.sheetReader.hasNext()) {
                            event = this.sheetReader.next();
                            if (event == 4) {
                                String content = new XSSFRichTextString(this.sheetReader.getText()).toString();
                                this.headerRow.add(content);
                                continue block1;
                            }
                            if (event != 2) continue;
                            if (this.sheetReader.getLocalName().equals("t")) {
                                this.headerRow.add("");
                                continue block1;
                            }
                            if (!this.sheetReader.getLocalName().equals(TAG_IS)) continue;
                            this.headerRow.add(null);
                            continue block1;
                        }
                        continue block1;
                    }
                    continue;
                }
                if (!this.sheetReader.hasNext() || (event = this.sheetReader.next()) != 2 || !this.sheetReader.getLocalName().equals(TAG_C)) break block0;
                this.headerRow.add(null);
            }
            break block0;
        }
    }

    boolean isMaxColsNumberDefined() {
        return this.maxColsNumberDefined;
    }

    public KCell[] getRow(int rownr) {
        if (rownr < 0) {
            throw new ArrayIndexOutOfBoundsException(rownr);
        }
        if (rownr + 1 < this.firstRow) {
            return new KCell[0];
        }
        if (rownr > 0 && this.currentRow == rownr + 1) {
            if (this.currentRowCells != null) {
                return this.currentRowCells;
            }
            return new KCell[0];
        }
        try {
            if (this.currentRow >= rownr + 1) {
                this.resetSheetReader();
            }
            while (this.sheetReader.hasNext()) {
                int event = this.sheetReader.next();
                if (event == 1 && this.sheetReader.getLocalName().equals(TAG_ROW)) {
                    String rowIndicator = this.sheetReader.getAttributeValue(null, "r");
                    this.currentRow = Integer.parseInt(rowIndicator);
                    if (this.currentRow < rownr + 1) continue;
                    this.currentRowCells = this.parseRow();
                    return this.currentRowCells;
                }
                if (event != 2 || !this.sheetReader.getLocalName().equals(TAG_SHEET_DATA)) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.numRows = this.currentRow;
        throw new ArrayIndexOutOfBoundsException(rownr);
    }

    private KCell[] parseRow() throws XMLStreamException {
        ArrayList<StaxPoiCell> cells = this.isMaxColsNumberDefined() ? new ArrayList(this.numCols) : new ArrayList<StaxPoiCell>();
        int undefinedColIndex = 0;
        for (int i = 0; i < this.numCols; ++i) {
            int event;
            while (this.sheetReader.hasNext() && ((event = this.sheetReader.next()) != 1 || !this.sheetReader.getLocalName().equals(TAG_C))) {
                if (event != 2 || !this.sheetReader.getLocalName().equals(TAG_ROW)) continue;
                return cells.toArray(new StaxPoiCell[cells.size()]);
            }
            String cellLocation = this.sheetReader.getAttributeValue(null, "r");
            int columnIndex = StaxUtil.extractColumnNumber(cellLocation) - 1;
            String cellType = this.sheetReader.getAttributeValue(null, "t");
            String cellStyle = this.sheetReader.getAttributeValue(null, "s");
            boolean isFormula = false;
            String content = null;
            while (this.sheetReader.hasNext()) {
                int event2 = this.sheetReader.next();
                if (event2 == 1) {
                    if (this.sheetReader.getLocalName().equals(TAG_V)) {
                        if (cellType != null && cellType.equals("s")) {
                            int idx = Integer.parseInt(this.sheetReader.getElementText());
                            content = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
                        } else {
                            content = this.sheetReader.getElementText();
                        }
                    } else if (this.sheetReader.getLocalName().equals(TAG_IS)) {
                        while (this.sheetReader.hasNext()) {
                            event2 = this.sheetReader.next();
                            if (event2 == 4) {
                                content = new XSSFRichTextString(this.sheetReader.getText()).toString();
                            } else {
                                if (event2 != 2) continue;
                                if (this.sheetReader.getLocalName().equals("t")) {
                                    content = "";
                                } else {
                                    if (!this.sheetReader.getLocalName().equals(TAG_IS)) continue;
                                    content = null;
                                }
                            }
                            break;
                        }
                    } else if (this.sheetReader.getLocalName().equals("f")) {
                        isFormula = true;
                    }
                }
                if (event2 != 2 || !this.sheetReader.getLocalName().equals(TAG_C)) continue;
                break;
            }
            if (content != null) {
                KCellType kcType = this.getCellType(cellType, cellStyle, isFormula);
                StaxPoiSheet.setCells(cells, undefinedColIndex, columnIndex, new StaxPoiCell(this.parseValue(kcType, content), kcType, this.currentRow));
            } else {
                StaxPoiSheet.setCells(cells, undefinedColIndex, columnIndex, null);
            }
            undefinedColIndex = columnIndex + 1;
        }
        return cells.toArray(new StaxPoiCell[cells.size()]);
    }

    private static void setCells(List<StaxPoiCell> cellsArray, int firstUndefinedColIndex, int foundColIndex, StaxPoiCell cell) {
        for (int index = firstUndefinedColIndex; index < foundColIndex; ++index) {
            cellsArray.add(null);
        }
        cellsArray.add(cell);
    }

    public String getName() {
        return this.sheetName;
    }

    public int getRows() {
        return this.numRows;
    }

    public KCell getCell(int colnr, int rownr) {
        if (rownr == 0 && colnr < this.headerRow.size()) {
            return new StaxPoiCell(this.headerRow.get(colnr), rownr);
        }
        KCell[] row = this.getRow(rownr);
        if (row != null && rownr < row.length) {
            return row[colnr];
        }
        return null;
    }

    private KCellType getCellType(String cellType, String cellStyle, boolean isFormula) {
        if (cellType == null || cellType.equals("n")) {
            if (this.isDateCell(cellStyle)) {
                return isFormula ? KCellType.DATE_FORMULA : KCellType.DATE;
            }
            return isFormula ? KCellType.NUMBER_FORMULA : KCellType.NUMBER;
        }
        switch (cellType) {
            case "s": {
                return KCellType.LABEL;
            }
            case "b": {
                return isFormula ? KCellType.BOOLEAN_FORMULA : KCellType.BOOLEAN;
            }
            case "e": {
                return KCellType.EMPTY;
            }
        }
        return KCellType.STRING_FORMULA;
    }

    @VisibleForTesting
    protected boolean isDateCell(String cellStyle) {
        int styleIdx;
        CTXf cellXf;
        if (cellStyle != null && (cellXf = this.styles.getCellXfAt(styleIdx = Integer.parseInt(cellStyle))) != null) {
            short formatId = (short)cellXf.getNumFmtId();
            String format = this.styles.getNumberFormatAt(formatId);
            return DateUtil.isADateFormat((int)formatId, (String)format);
        }
        return false;
    }

    private Object parseValue(KCellType type, String vContent) {
        if (vContent == null) {
            return null;
        }
        try {
            switch (type) {
                case NUMBER: 
                case NUMBER_FORMULA: {
                    return Double.parseDouble(vContent);
                }
                case BOOLEAN: 
                case BOOLEAN_FORMULA: {
                    return vContent.equals("1");
                }
                case DATE: 
                case DATE_FORMULA: {
                    Double xlDate = Double.parseDouble(vContent);
                    return DateUtil.getJavaDate((double)xlDate, (TimeZone)DATE_TZ);
                }
            }
            return vContent;
        }
        catch (Exception e) {
            return vContent;
        }
    }

    private void resetSheetReader() throws IOException, XMLStreamException, InvalidFormatException {
        this.sheetReader.close();
        this.sheetStream.close();
        this.sheetStream = this.xssfReader.getSheet(this.sheetId);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        this.sheetReader = factory.createXMLStreamReader(this.sheetStream);
    }

    public void close() throws IOException, XMLStreamException {
        this.sheetReader.close();
        this.sheetStream.close();
    }
}

