/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.datagrid;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.datagrid.DataGridMeta;

public class DataGridMetaInjection
implements StepMetaInjectionInterface {
    private DataGridMeta meta;

    public DataGridMetaInjection(DataGridMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry(Entry.FIELDS.name(), Entry.FIELDS.getValueType(), Entry.FIELDS.getDescription());
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry(Entry.FIELD.name(), Entry.FIELD.getValueType(), Entry.FIELD.getDescription());
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : Entry.values()) {
            if (entry.getParent() != Entry.FIELD) continue;
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        StepInjectionMetaEntry sheetsEntry = new StepInjectionMetaEntry(Entry.DATA_LINES.name(), Entry.DATA_LINES.getValueType(), Entry.DATA_LINES.getDescription());
        all.add(sheetsEntry);
        StepInjectionMetaEntry sheetEntry = new StepInjectionMetaEntry(Entry.DATA_LINE.name(), Entry.DATA_LINE.getValueType(), Entry.DATA_LINE.getDescription());
        sheetsEntry.getDetails().add(sheetEntry);
        for (Entry entry : Entry.values()) {
            if (entry.getParent() != Entry.DATA_LINE) continue;
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            sheetEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        String value;
        Entry metaEntry;
        List<StepInjectionMetaEntry> entries;
        ArrayList<GridMetaEntry> gridMetaEntries = new ArrayList<GridMetaEntry>();
        ArrayList<List<String>> dataLines = new ArrayList<List<String>>();
        for (StepInjectionMetaEntry stepInjectionMetaEntry : all) {
            Entry fieldsEntry = Entry.findEntry(stepInjectionMetaEntry.getKey());
            if (fieldsEntry == null || fieldsEntry != Entry.FIELDS) continue;
            for (StepInjectionMetaEntry lookField : stepInjectionMetaEntry.getDetails()) {
                Entry fieldEntry = Entry.findEntry(lookField.getKey());
                if (fieldEntry == null || fieldEntry != Entry.FIELD) continue;
                GridMetaEntry gridMetaEntry = new GridMetaEntry();
                entries = lookField.getDetails();
                for (StepInjectionMetaEntry entry : entries) {
                    metaEntry = Entry.findEntry(entry.getKey());
                    if (metaEntry == null) continue;
                    value = (String)entry.getValue();
                    switch (metaEntry) {
                        case NAME: {
                            gridMetaEntry.fieldName = value;
                            break;
                        }
                        case TYPE: {
                            gridMetaEntry.fieldType = value;
                            break;
                        }
                        case LENGTH: {
                            gridMetaEntry.fieldLength = Const.toInt((String)value, (int)-1);
                            break;
                        }
                        case PRECISION: {
                            gridMetaEntry.fieldPrecision = Const.toInt((String)value, (int)-1);
                            break;
                        }
                        case CURRENCY: {
                            gridMetaEntry.currency = value;
                            break;
                        }
                        case GROUP: {
                            gridMetaEntry.group = value;
                            break;
                        }
                        case DECIMAL: {
                            gridMetaEntry.decimal = value;
                            break;
                        }
                        case FORMAT: {
                            gridMetaEntry.fieldFormat = value;
                            break;
                        }
                        case EMPTY_STRING: {
                            gridMetaEntry.setEmptyString = "Y".equalsIgnoreCase(value) || "TRUE".equalsIgnoreCase(value);
                            break;
                        }
                    }
                }
                gridMetaEntries.add(gridMetaEntry);
            }
        }
        ArrayList<String> line = new ArrayList<String>();
        for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null || fieldsEntry != Entry.DATA_LINES) continue;
            for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                Entry fieldEntry = Entry.findEntry(lookField.getKey());
                if (fieldEntry == null || fieldEntry != Entry.DATA_LINE) continue;
                entries = lookField.getDetails();
                for (StepInjectionMetaEntry entry : entries) {
                    metaEntry = Entry.findEntry(entry.getKey());
                    if (metaEntry == null) continue;
                    value = (String)entry.getValue();
                    switch (metaEntry) {
                        case DATA_VALUE: {
                            line.add(value);
                            if (line.size() < gridMetaEntries.size()) break;
                            dataLines.add(line);
                            line = new ArrayList();
                            break;
                        }
                    }
                }
            }
        }
        if (gridMetaEntries.size() > 0) {
            void var5_8;
            this.meta.allocate(gridMetaEntries.size());
            boolean bl = false;
            while (var5_8 < gridMetaEntries.size()) {
                GridMetaEntry entry = (GridMetaEntry)gridMetaEntries.get((int)var5_8);
                this.meta.getFieldName()[var5_8] = entry.fieldName;
                this.meta.getFieldType()[var5_8] = entry.fieldType;
                this.meta.getFieldFormat()[var5_8] = entry.fieldFormat;
                this.meta.getFieldLength()[var5_8] = entry.fieldLength;
                this.meta.getFieldPrecision()[var5_8] = entry.fieldPrecision;
                this.meta.getCurrency()[var5_8] = entry.currency;
                this.meta.getGroup()[var5_8] = entry.group;
                this.meta.getDecimal()[var5_8] = entry.decimal;
                this.meta.isSetEmptyString()[var5_8] = entry.setEmptyString;
                ++var5_8;
            }
        }
        if (dataLines.size() > 0) {
            this.meta.setDataLines(dataLines);
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }

    public DataGridMeta getMeta() {
        return this.meta;
    }

    public class ExcelInputSheet {
        public String sheetName;
        public int startCol;
        public int startRow;

        private ExcelInputSheet(String sheetName, int startCol, int startRow) {
            this.sheetName = sheetName;
            this.startCol = startCol;
            this.startRow = startRow;
        }
    }

    private static enum Entry {
        FIELDS(0, "All the fields"),
        FIELD(0, "One field"),
        NAME(FIELD, 2, "Field name"),
        TYPE(FIELD, 2, "Field data type"),
        FORMAT(FIELD, 2, "Field conversion format"),
        CURRENCY(FIELD, 2, "Field currency symbol"),
        DECIMAL(FIELD, 2, "Field decimal symbol"),
        GROUP(FIELD, 2, "Field group symbol"),
        LENGTH(FIELD, 2, "Field length"),
        PRECISION(FIELD, 2, "Field precision"),
        EMPTY_STRING(FIELD, 2, "Set field to empty string?"),
        DATA_LINES(0, "Nr Rows x Nr Columns values"),
        DATA_LINE(DATA_LINES, 0, "One data value"),
        DATA_VALUE(DATA_LINE, 2, "One value");

        private int valueType;
        private String description;
        private Entry parent;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        private Entry(Entry parent, int valueType, String description) {
            this.parent = parent;
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }

        public Entry getParent() {
            return this.parent;
        }
    }

    private class GridMetaEntry {
        String fieldName;
        String fieldType;
        String fieldFormat;
        String currency;
        String decimal;
        String group;
        int fieldLength;
        int fieldPrecision;
        boolean setEmptyString;

        private GridMetaEntry() {
        }
    }
}

