/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.Arrays;
import java.util.Comparator;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.readallcache.SearchingContext;

abstract class Index {
    final int column;
    final ValueMetaInterface valueMeta;
    final IndexedValue[] values;

    Index(int column, ValueMetaInterface valueMeta, int rowsAmount) {
        this.column = column;
        this.valueMeta = valueMeta;
        this.values = new IndexedValue[rowsAmount];
    }

    Comparator<IndexedValue> createComparator() {
        return new IndexValueComparator(this.valueMeta);
    }

    void performIndexingOf(Object[][] rows) {
        int len = rows.length;
        for (int i = 0; i < len; ++i) {
            this.values[i] = new IndexedValue(rows[i][this.column], i);
        }
        Arrays.sort(this.values, this.createComparator());
    }

    int findInsertionPointOf(IndexedValue value) {
        int index = Arrays.binarySearch(this.values, value, this.createComparator());
        return -(index + 1);
    }

    public int getColumn() {
        return this.column;
    }

    public void applyRestrictionsTo(SearchingContext context, ValueMetaInterface lookupMeta, Object lookupValue) {
        try {
            this.doApply(context, lookupMeta, lookupValue);
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    abstract void doApply(SearchingContext var1, ValueMetaInterface var2, Object var3) throws KettleException;

    abstract int getRestrictionPower();

    static Comparator<Index> restrictionComparator() {
        return new Comparator<Index>(){

            @Override
            public int compare(Index o1, Index o2) {
                return Integer.compare(o1.getRestrictionPower(), o2.getRestrictionPower());
            }
        };
    }

    static class IndexValueComparator
    implements Comparator<IndexedValue> {
        private final ValueMetaInterface meta;

        public IndexValueComparator(ValueMetaInterface meta) {
            this.meta = meta;
        }

        @Override
        public int compare(IndexedValue o1, IndexedValue o2) {
            int c;
            try {
                c = this.meta.compare(o1.key, o2.key);
            }
            catch (KettleValueException e) {
                throw new RuntimeException(e);
            }
            return c == 0 ? Integer.compare(o1.row, o2.row) : c;
        }
    }

    static class IndexedValue {
        final Object key;
        final int row;

        public IndexedValue(Object key, int row) {
            this.key = key;
            this.row = row;
        }
    }
}

