/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr;

import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;

public class KettleDatabaseRepositoryCreationHelper {
    private final KettleDatabaseRepository repository;
    private final LogChannelInterface log;
    private final DatabaseMeta databaseMeta;
    private final Database database;
    private final PluginRegistry pluginRegistry;

    public KettleDatabaseRepositoryCreationHelper(KettleDatabaseRepository repository) {
        this.repository = repository;
        this.databaseMeta = this.repository.getDatabaseMeta();
        this.database = this.repository.getDatabase();
        this.log = repository.getLog();
        this.pluginRegistry = PluginRegistry.getInstance();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void createRepositorySchema(ProgressMonitorListener monitor, boolean upgrade, List<String> statements, boolean dryrun) throws KettleException {
        block475: {
            block472: {
                block471: {
                    block470: {
                        block469: {
                            block468: {
                                KEY = 9;
                                this.log.logBasic("Starting to create or modify the repository tables...");
                                message = (upgrade != false ? "Upgrading " : "Creating") + " the Kettle repository...";
                                if (monitor != null) {
                                    monitor.beginTask(message, 31);
                                }
                                this.repository.connectionDelegate.setAutoCommit(true);
                                table = new RowMeta();
                                tablename = "R_REPOSITORY_LOG";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_REPOSITORY_LOG", KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("REP_VERSION", 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaDate("LOG_DATE"));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("LOG_USER", 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("OPERATION_DESC", 2000000, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_REPOSITORY_LOG", false);
                                if (!Utils.isEmpty((CharSequence)sql)) {
                                    statements.add(sql);
                                    if (!dryrun) {
                                        try {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                            }
                                            this.database.execStatements(sql);
                                            if (!this.log.isDetailed()) ** GOTO lbl35
                                            this.log.logDetailed("Created/altered table " + schemaTable);
                                        }
                                        catch (KettleException dbe) {
                                            throw new KettleException("Unable to create or modify table " + schemaTable, (Throwable)dbe);
                                        }
                                    }
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
lbl35:
                                // 6 sources

                                if (!dryrun) {
                                    this.repository.insertLogEntry((upgrade != false ? "Upgrade" : "Creation") + " of the Kettle repository");
                                }
                                table = new RowMeta();
                                tablename = "R_VERSION";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_VERSION", KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("MAJOR_VERSION", 3, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("MINOR_VERSION", 3, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaDate("UPGRADE_DATE", 0, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("IS_UPGRADE", 1, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_VERSION", false);
                                create = false;
                                if (!Utils.isEmpty((CharSequence)sql)) {
                                    create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                                    statements.add(sql);
                                    if (!dryrun) {
                                        try {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                            }
                                            this.database.execStatements(sql);
                                            if (!this.log.isDetailed()) ** GOTO lbl68
                                            this.log.logDetailed("Created/altered table " + schemaTable);
                                        }
                                        catch (KettleException dbe) {
                                            throw new KettleException("Unable to create or modify table " + schemaTable, (Throwable)dbe);
                                        }
                                    }
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
lbl68:
                                // 6 sources

                                try {
                                    nextId = sql.toUpperCase().indexOf("CREATE TABLE") < 0 ? this.repository.connectionDelegate.getNextID(schemaTable, "ID_VERSION") : new LongObjectId(1L);
                                    data = new Object[]{nextId.longValue(), 5L, 0L, new Date(), upgrade};
                                    if (dryrun) {
                                        sql = this.database.getSQLOutput(null, "R_VERSION", (RowMetaInterface)table, data, null);
                                        statements.add(sql);
                                    } else {
                                        this.database.execStatement("INSERT INTO " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_VERSION") + " VALUES(?, ?, ?, ?, ?)", (RowMetaInterface)table, data);
                                    }
                                }
                                catch (KettleException e) {
                                    throw new KettleException("Unable to insert new version log record into " + schemaTable, (Throwable)e);
                                }
                                ok_database_type = true;
                                table = new RowMeta();
                                tablename = "R_DATABASE_TYPE";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE_TYPE", KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("CODE", 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("DESCRIPTION", 255, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DATABASE_TYPE", false);
                                create = false;
                                if (!Utils.isEmpty((CharSequence)sql)) {
                                    create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                                    statements.add(sql);
                                    if (!dryrun) {
                                        try {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                            }
                                            this.database.execStatements(sql);
                                            if (!this.log.isDetailed()) ** GOTO lbl110
                                            this.log.logDetailed("Created/altered table " + schemaTable);
                                        }
                                        catch (KettleException dbe) {
                                            throw new KettleException("Unable to create or modify table " + schemaTable, (Throwable)dbe);
                                        }
                                    }
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
lbl110:
                                // 6 sources

                                if (ok_database_type) {
                                    this.updateDatabaseTypes(statements, dryrun, create);
                                }
                                if (monitor != null) {
                                    monitor.worked(1);
                                }
                                ok_database_contype = true;
                                table = new RowMeta();
                                tablename = "R_DATABASE_CONTYPE";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE_CONTYPE", KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("CODE", 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("DESCRIPTION", 255, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DATABASE_CONTYPE", false);
                                if (!Utils.isEmpty((CharSequence)sql)) {
                                    statements.add(sql);
                                    if (!dryrun) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                        }
                                        this.database.execStatements(sql);
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("Created or altered table " + schemaTable);
                                        }
                                    }
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
                                if (ok_database_contype = sql.toUpperCase().contains("CREATE TABLE")) {
                                    code = DatabaseMeta.dbAccessTypeCode;
                                    desc = DatabaseMeta.dbAccessTypeDesc;
                                    if (!dryrun) {
                                        this.database.prepareInsert((RowMetaInterface)table, null, tablename);
                                    }
                                    for (i = 0; i < code.length; ++i) {
                                        lookup = null;
                                        if (upgrade) {
                                            lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_DATABASE_CONTYPE") + " FROM " + schemaTable + " WHERE " + this.repository.quote("CODE") + " = '" + code[i] + "'");
                                        }
                                        if (lookup != null) continue;
                                        nextid = new LongObjectId((long)(i + 1));
                                        if (!create) {
                                            nextid = this.repository.connectionDelegate.getNextDatabaseConnectionTypeID();
                                        }
                                        tableData = new Object[]{new LongObjectId((ObjectId)nextid).longValue(), code[i], desc[i]};
                                        if (dryrun) {
                                            sql = this.database.getSQLOutput(null, tablename, (RowMetaInterface)table, tableData, null);
                                            statements.add(sql);
                                            continue;
                                        }
                                        this.database.setValuesInsert((RowMetaInterface)table, tableData);
                                        this.database.insertRow();
                                    }
                                    try {
                                        if (!dryrun) {
                                            this.database.closeInsert();
                                        }
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("Populated table " + schemaTable);
                                        }
                                    }
                                    catch (KettleException dbe) {
                                        throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
                                    }
                                }
                                if (monitor != null) {
                                    monitor.worked(1);
                                }
                                table = new RowMeta();
                                tablename = "R_NOTE";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_NOTE", KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("VALUE_STR", 2000000, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("GUI_LOCATION_X", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("GUI_LOCATION_Y", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("GUI_LOCATION_WIDTH", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("GUI_LOCATION_HEIGHT", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("FONT_NAME", 2000000, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("FONT_SIZE", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("FONT_BOLD", 1, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("FONT_ITALIC", 1, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("FONT_COLOR_RED", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("FONT_COLOR_GREEN", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("FONT_COLOR_BLUE", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("FONT_BACK_GROUND_COLOR_RED", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("FONT_BACK_GROUND_COLOR_GREEN", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("FONT_BACK_GROUND_COLOR_BLUE", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("FONT_BORDER_COLOR_RED", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("FONT_BORDER_COLOR_GREEN", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("FONT_BORDER_COLOR_BLUE", 6, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("DRAW_SHADOW", 1, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_NOTE", false);
                                if (!Utils.isEmpty((CharSequence)sql)) {
                                    statements.add(sql);
                                    if (!dryrun) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                        }
                                        this.database.execStatements(sql);
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("Created or altered table " + schemaTable);
                                        }
                                    }
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
                                if (monitor != null) {
                                    monitor.worked(1);
                                }
                                table = new RowMeta();
                                tablename = "R_DATABASE";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE", KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE_TYPE", KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE_CONTYPE", KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("HOST_NAME", 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("DATABASE_NAME", 2000000, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("PORT", 7, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("USERNAME", 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("PASSWORD", 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("SERVERNAME", 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("DATA_TBS", 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("INDEX_TBS", 255, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DATABASE", false);
                                if (!Utils.isEmpty((CharSequence)sql)) {
                                    statements.add(sql);
                                    if (!dryrun) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                        }
                                        this.database.execStatements(sql);
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("Created or altered table " + schemaTable);
                                        }
                                    }
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
                                if (monitor != null) {
                                    monitor.worked(1);
                                }
                                table = new RowMeta();
                                tablename = "R_DATABASE_ATTRIBUTE";
                                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                                if (monitor != null) {
                                    monitor.subTask("Checking table " + schemaTable);
                                }
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE_ATTRIBUTE", KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE", KEY, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("CODE", 255, 0));
                                table.addValueMeta((ValueMetaInterface)new ValueMetaString("VALUE_STR", 2000000, 0));
                                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DATABASE_ATTRIBUTE", false);
                                if (!Utils.isEmpty((CharSequence)sql)) {
                                    statements.add(sql);
                                    if (!dryrun) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                        }
                                        this.database.execStatements(sql);
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("Created or altered table " + schemaTable);
                                        }
                                    }
                                    try {
                                        indexname = "IDX_RDAT";
                                        keyfield = new String[]{"ID_DATABASE", "CODE"};
                                        if (this.database.checkIndexExists(schemaTable, keyfield)) break block468;
                                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                                        statements.add(sql);
                                        if (!dryrun) {
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                            }
                                            this.database.execStatements(sql);
                                            if (this.log.isDetailed()) {
                                                this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                                            }
                                        }
                                    }
                                    catch (KettleException dbe) {}
                                } else if (this.log.isDetailed()) {
                                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                                }
                            }
                            if (monitor != null) {
                                monitor.worked(1);
                            }
                            table = new RowMeta();
                            tablename = "R_DIRECTORY";
                            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                            if (monitor != null) {
                                monitor.subTask("Checking table " + schemaTable);
                            }
                            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DIRECTORY", KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DIRECTORY_PARENT", KEY, 0));
                            table.addValueMeta((ValueMetaInterface)new ValueMetaString("DIRECTORY_NAME", 255, 0));
                            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DIRECTORY", false);
                            if (!Utils.isEmpty((CharSequence)sql)) {
                                statements.add(sql);
                                if (!dryrun) {
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                    }
                                    this.database.execStatements(sql);
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed("Created or altered table " + schemaTable);
                                    }
                                }
                                try {
                                    indexname = "IDX_RDIR";
                                    keyfield = new String[]{"ID_DIRECTORY_PARENT", "DIRECTORY_NAME"};
                                    if (this.database.checkIndexExists(schemaTable, keyfield)) break block469;
                                    sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                                    statements.add(sql);
                                    if (!dryrun) {
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                        }
                                        this.database.execStatements(sql);
                                        if (this.log.isDetailed()) {
                                            this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                                        }
                                    }
                                }
                                catch (KettleException dbe) {}
                            } else if (this.log.isDetailed()) {
                                this.log.logDetailed("Table " + schemaTable + " is OK.");
                            }
                        }
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                        table = new RowMeta();
                        tablename = "R_TRANSFORMATION";
                        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                        if (monitor != null) {
                            monitor.subTask("Checking table " + schemaTable);
                        }
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DIRECTORY", KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaString("DESCRIPTION", 2000000, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaString("EXTENDED_DESCRIPTION", 2000000, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaString("TRANS_VERSION", 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("TRANS_STATUS", KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP_READ", KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP_WRITE", KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP_INPUT", KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP_OUTPUT", KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP_UPDATE", KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE_LOG", KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaString("TABLE_NAME_LOG", 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("USE_BATCHID", 1, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("USE_LOGFIELD", 1, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE_MAXDATE", KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaString("TABLE_NAME_MAXDATE", 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaString("FIELD_NAME_MAXDATE", 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaNumber("OFFSET_MAXDATE", 12, 2));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaNumber("DIFF_MAXDATE", 12, 2));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaString("CREATED_USER", 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaDate("CREATED_DATE", 20, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaString("MODIFIED_USER", 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaDate("MODIFIED_DATE", 20, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("SIZE_ROWSET", KEY, 0));
                        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANSFORMATION", false);
                        if (!Utils.isEmpty((CharSequence)sql)) {
                            statements.add(sql);
                            if (!dryrun) {
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                }
                                this.database.execStatements(sql);
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("Created or altered table " + schemaTable);
                                }
                            }
                        } else if (this.log.isDetailed()) {
                            this.log.logDetailed("Table " + schemaTable + " is OK.");
                        }
                        if (this.database.checkTableExists(schemaTable) && (rows = this.database.getRows(sql = "SELECT * FROM " + schemaTable + " WHERE " + this.repository.quote("ID_DIRECTORY") + " IS NULL", 1)) != null && rows.size() > 0) {
                            sql = "UPDATE " + schemaTable + " SET " + this.repository.quote("ID_DIRECTORY") + "=0 WHERE " + this.repository.quote("ID_DIRECTORY") + " IS NULL";
                            statements.add(sql);
                            if (!dryrun) {
                                this.database.execStatement(sql);
                            }
                        }
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                        table = new RowMeta();
                        tablename = "R_TRANS_ATTRIBUTE";
                        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                        if (monitor != null) {
                            monitor.subTask("Checking table " + schemaTable);
                        }
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANS_ATTRIBUTE", KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("NR", 6, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaString("CODE", 255, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("VALUE_NUM", 18, 0));
                        table.addValueMeta((ValueMetaInterface)new ValueMetaString("VALUE_STR", 2000000, 0));
                        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_ATTRIBUTE", false);
                        if (!Utils.isEmpty((CharSequence)sql)) {
                            statements.add(sql);
                            if (!dryrun) {
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                }
                                this.database.execStatements(sql);
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("Created or altered table " + schemaTable);
                                }
                            }
                            try {
                                indexname = "IDX_TATT";
                                keyfield = new String[]{"ID_TRANSFORMATION", "CODE", "NR"};
                                if (this.database.checkIndexExists(schemaTable, keyfield)) break block470;
                                sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                                statements.add(sql);
                                if (!dryrun) {
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                    }
                                    this.database.execStatements(sql);
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                                    }
                                }
                            }
                            catch (KettleException rows) {}
                        } else if (this.log.isDetailed()) {
                            this.log.logDetailed("Table " + schemaTable + " is OK.");
                        }
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    table = new RowMeta();
                    tablename = "R_JOB_ATTRIBUTE";
                    schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                    if (monitor != null) {
                        monitor.subTask("Checking table " + schemaTable);
                    }
                    table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOB_ATTRIBUTE", KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOB", KEY, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("NR", 6, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMetaString("CODE", 255, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("VALUE_NUM", 18, 0));
                    table.addValueMeta((ValueMetaInterface)new ValueMetaString("VALUE_STR", 2000000, 0));
                    sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB_ATTRIBUTE", false);
                    if (!Utils.isEmpty((CharSequence)sql)) {
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("Created or altered table " + schemaTable);
                            }
                        }
                        try {
                            indexname = "IDX_JATT";
                            keyfield = new String[]{"ID_JOB", "CODE", "NR"};
                            if (this.database.checkIndexExists(schemaTable, keyfield)) break block471;
                            sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                            statements.add(sql);
                            if (!dryrun) {
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                                }
                                this.database.execStatements(sql);
                                if (this.log.isDetailed()) {
                                    this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                                }
                            }
                        }
                        catch (KettleException rows) {}
                    } else if (this.log.isDetailed()) {
                        this.log.logDetailed("Table " + schemaTable + " is OK.");
                    }
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_DEPENDENCY";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DEPENDENCY", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("TABLE_NAME", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("FIELD_NAME", 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_DEPENDENCY", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_PARTITION_SCHEMA";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_PARTITION_SCHEMA", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("DYNAMIC_DEFINITION", 1, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("PARTITIONS_PER_SLAVE", 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_PARTITION_SCHEMA", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_PARTITION";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_PARTITION", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_PARTITION_SCHEMA", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("PARTITION_ID", 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_PARTITION", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_TRANS_PARTITION_SCHEMA";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANS_PARTITION_SCHEMA", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_PARTITION_SCHEMA", KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_PARTITION_SCHEMA", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_CLUSTER";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_CLUSTER", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("BASE_PORT", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("SOCKETS_BUFFER_SIZE", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("SOCKETS_FLUSH_INTERVAL", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("SOCKETS_COMPRESSED", 0, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("DYNAMIC_CLUSTER", 0, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_CLUSTER", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_SLAVE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_SLAVE", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("HOST_NAME", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("PORT", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("WEB_APP_NAME", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("USERNAME", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("PASSWORD", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("PROXY_HOST_NAME", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("PROXY_PORT", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("NON_PROXY_HOSTS", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("MASTER"));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_SLAVE", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_CLUSTER_SLAVE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_CLUSTER_SLAVE", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_CLUSTER", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_SLAVE", KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_CLUSTER_SLAVE", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_TRANS_SLAVE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANS_SLAVE", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_SLAVE", KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_SLAVE", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_TRANS_CLUSTER";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANS_CLUSTER", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_CLUSTER", KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_CLUSTER", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_TRANS_HOP";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANS_HOP", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP_FROM", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP_TO", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("ENABLED", 1, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_HOP", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_TRANS_STEP_CONDITION";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_CONDITION", KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_CONDITION";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_CONDITION", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_CONDITION_PARENT", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("NEGATED", 1, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("OPERATOR", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("LEFT_NAME", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("CONDITION_FUNCTION", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("RIGHT_NAME", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_VALUE_RIGHT", KEY, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_CONDITION", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                tablename = "R_VALUE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table = new RowMeta();
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_VALUE", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("VALUE_TYPE", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("VALUE_STR", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("IS_NULL", 1, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_VALUE", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                ok_step_type = true;
                table = new RowMeta();
                tablename = "R_STEP_TYPE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP_TYPE", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("CODE", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("DESCRIPTION", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("HELPTEXT", 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_STEP_TYPE", false);
                create = false;
                if (!Utils.isEmpty((CharSequence)sql)) {
                    create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (ok_step_type) {
                    this.updateStepTypes(statements, dryrun, create);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Populated table " + schemaTable);
                    }
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                table = new RowMeta();
                tablename = "R_STEP";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("DESCRIPTION", 2000000, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP_TYPE", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("DISTRIBUTE", 1, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("COPIES", 3, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("GUI_LOCATION_X", 6, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("GUI_LOCATION_Y", 6, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("GUI_DRAW", 1, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("COPIES_STRING", 255, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_STEP", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                tablename = "R_STEP_ATTRIBUTE";
                schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
                if (monitor != null) {
                    monitor.subTask("Checking table " + schemaTable);
                }
                table = new RowMeta();
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP_ATTRIBUTE", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP", KEY, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("NR", 6, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("CODE", 255, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("VALUE_NUM", 18, 0));
                table.addValueMeta((ValueMetaInterface)new ValueMetaString("VALUE_STR", 2000000, 0));
                sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_STEP_ATTRIBUTE", false);
                if (!Utils.isEmpty((CharSequence)sql)) {
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created or altered table " + schemaTable);
                        }
                    }
                    try {
                        indexname = "IDX_RSAT";
                        keyfield = new String[]{"ID_STEP", "CODE", "NR"};
                        if (this.database.checkIndexExists(schemaTable, keyfield)) break block472;
                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                            }
                        }
                    }
                    catch (KettleException lookup) {}
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("Table " + schemaTable + " is OK.");
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            tablename = "R_STEP_DATABASE";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table = new RowMeta();
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_STEP", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE", KEY, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
            if (!Utils.isEmpty((CharSequence)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
                try {
                    indexname = "IDX_RSD1";
                    keyfield = new String[]{"ID_TRANSFORMATION"};
                    if (!this.database.checkIndexExists(schemaTable, keyfield)) {
                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, false, false, false);
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                            }
                        }
                    }
                }
                catch (KettleException lookup) {
                    // empty catch block
                }
                try {
                    indexname = "IDX_RSD2";
                    keyfield = new String[]{"ID_DATABASE"};
                    if (!this.database.checkIndexExists(schemaTable, keyfield)) {
                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, false, false, false);
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                            }
                        }
                    }
                }
                catch (KettleException lookup) {}
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_TRANS_NOTE";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_NOTE", KEY, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
            if (!Utils.isEmpty((CharSequence)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            ok_loglevel = true;
            tablename = "R_LOGLEVEL";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table = new RowMeta();
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_LOGLEVEL", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("CODE", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("DESCRIPTION", 255, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_LOGLEVEL", false);
            create = false;
            if (!Utils.isEmpty((CharSequence)sql)) {
                create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (ok_loglevel) {
                code = LogLevel.logLogLevelCodes();
                desc = LogLevel.getLogLevelDescriptions();
                if (!dryrun) {
                    this.database.prepareInsert((RowMetaInterface)table, null, tablename);
                }
                for (i = 1; i < code.length; ++i) {
                    lookup = null;
                    if (upgrade) {
                        lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_LOGLEVEL") + " FROM " + schemaTable + " WHERE " + this.database.getDatabaseMeta().quoteField("CODE") + " = '" + code[i] + "'");
                    }
                    if (lookup != null) continue;
                    nextid = new LongObjectId((long)i);
                    if (!create) {
                        nextid = this.repository.connectionDelegate.getNextLoglevelID();
                    }
                    tableData = new RowMetaAndData();
                    tableData.addValue((ValueMetaInterface)new ValueMetaInteger("ID_LOGLEVEL"), (Object)nextid);
                    tableData.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code[i]);
                    tableData.addValue((ValueMetaInterface)new ValueMetaString("DESCRIPTION"), (Object)desc[i]);
                    if (dryrun) {
                        sql = this.database.getSQLOutput(null, tablename, tableData.getRowMeta(), tableData.getData(), null);
                        statements.add(sql);
                        continue;
                    }
                    this.database.setValuesInsert(tableData.getRowMeta(), tableData.getData());
                    this.database.insertRow();
                }
                try {
                    if (!dryrun) {
                        this.database.closeInsert();
                    }
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Populated table " + schemaTable);
                    }
                }
                catch (KettleException dbe) {
                    throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_LOG";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_LOG", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_LOGLEVEL", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("LOGTYPE", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("FILENAME", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("FILEEXTENTION", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("ADD_DATE", 1, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("ADD_TIME", 1, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE_LOG", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("TABLE_NAME_LOG", 255, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_LOG", false);
            if (!Utils.isEmpty((CharSequence)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_JOB";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOB", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DIRECTORY", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("DESCRIPTION", 2000000, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("EXTENDED_DESCRIPTION", 2000000, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("JOB_VERSION", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("JOB_STATUS", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE_LOG", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("TABLE_NAME_LOG", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("CREATED_USER", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaDate("CREATED_DATE", 20, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("MODIFIED_USER", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaDate("MODIFIED_DATE", 20, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("USE_BATCH_ID", 0, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("PASS_BATCH_ID", 0, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("USE_LOGFIELD", 0, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("SHARED_FILE", 255, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB", false);
            if (!Utils.isEmpty((CharSequence)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_JOBENTRY_DATABASE";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOB", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE", KEY, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB", false);
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
            if (!Utils.isEmpty((CharSequence)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
                try {
                    indexname = "IDX_RJD1";
                    keyfield = new String[]{"ID_JOB"};
                    if (!this.database.checkIndexExists(schemaTable, keyfield)) {
                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, false, false, false);
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                            }
                        }
                    }
                }
                catch (KettleException dbe) {
                    // empty catch block
                }
                try {
                    indexname = "IDX_RJD2";
                    keyfield = new String[]{"ID_DATABASE"};
                    if (!this.database.checkIndexExists(schemaTable, keyfield)) {
                        sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, false, false, false);
                        statements.add(sql);
                        if (!dryrun) {
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                            }
                            this.database.execStatements(sql);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                            }
                        }
                    }
                }
                catch (KettleException dbe) {}
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            ok_jobentry_type = true;
            table = new RowMeta();
            tablename = "R_JOBENTRY_TYPE";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY_TYPE", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("CODE", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("DESCRIPTION", 255, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOBENTRY_TYPE", false);
            create = false;
            if (!Utils.isEmpty((CharSequence)sql)) {
                create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (ok_jobentry_type) {
                this.updateJobEntryTypes(statements, dryrun, create);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Populated table " + schemaTable);
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_JOBENTRY";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOB", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY_TYPE", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("DESCRIPTION", 2000000, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOBENTRY", false);
            if (!Utils.isEmpty((CharSequence)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_JOBENTRY_COPY";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY_COPY", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOB", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY_TYPE", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("NR", 4, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("GUI_LOCATION_X", 6, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("GUI_LOCATION_Y", 6, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("GUI_DRAW", 1, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("PARALLEL", 1, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOBENTRY_COPY", false);
            if (!Utils.isEmpty((CharSequence)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            table = new RowMeta();
            tablename = "R_JOBENTRY_ATTRIBUTE";
            schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
            if (monitor != null) {
                monitor.subTask("Checking table " + schemaTable);
            }
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY_ATTRIBUTE", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOB", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY", KEY, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("NR", 6, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("CODE", 255, 0));
            table.addValueMeta((ValueMetaInterface)new ValueMetaNumber("VALUE_NUM", 13, 2));
            table.addValueMeta((ValueMetaInterface)new ValueMetaString("VALUE_STR", 2000000, 0));
            sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOBENTRY_ATTRIBUTE", false);
            if (!Utils.isEmpty((CharSequence)sql)) {
                statements.add(sql);
                if (!dryrun) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                    }
                    this.database.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Created or altered table " + schemaTable);
                    }
                }
                try {
                    indexname = "IDX_RJEA";
                    keyfield = new String[]{"ID_JOBENTRY_ATTRIBUTE", "CODE", "NR"};
                    if (this.database.checkIndexExists(schemaTable, keyfield)) break block475;
                    sql = this.database.getCreateIndexStatement(schemaTable, indexname, keyfield, false, true, false, false);
                    statements.add(sql);
                    if (!dryrun) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                        }
                        this.database.execStatements(sql);
                        if (this.log.isDetailed()) {
                            this.log.logDetailed("Created lookup index " + indexname + " on " + schemaTable);
                        }
                    }
                }
                catch (KettleException lookup) {}
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("Table " + schemaTable + " is OK.");
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_JOB_HOP";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOB_HOP", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOB", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY_COPY_FROM", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY_COPY_TO", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("ENABLED", 1, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("EVALUATION", 1, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("UNCONDITIONAL", 1, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB_HOP", false);
        if (!Utils.isEmpty((CharSequence)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_JOB_NOTE";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOB", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_NOTE", KEY, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, null, false);
        if (!Utils.isEmpty((CharSequence)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_TRANS_LOCK";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANS_LOCK", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_USER", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaString("LOCK_MESSAGE", 2000000, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaDate("LOCK_DATE", 0, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_TRANS_LOCK", false);
        if (!Utils.isEmpty((CharSequence)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_JOB_LOCK";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOB_LOCK", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_JOB", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_USER", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaString("LOCK_MESSAGE", 2000000, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaDate("LOCK_DATE", 0, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_JOB_LOCK", false);
        if (!Utils.isEmpty((CharSequence)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_NAMESPACE";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_NAMESPACE", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", this.database.getDatabaseMeta().getDatabaseInterface().getMaxVARCHARLength() - 1 > 0 ? this.database.getDatabaseMeta().getDatabaseInterface().getMaxVARCHARLength() - 1 : 2000, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_NAMESPACE", false);
        if (!Utils.isEmpty((CharSequence)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_ELEMENT_TYPE";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_ELEMENT_TYPE", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_NAMESPACE", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", this.getRepoStringLength(), 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaString("DESCRIPTION", 2000000, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_ELEMENT_TYPE", false);
        if (!Utils.isEmpty((CharSequence)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_ELEMENT";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_ELEMENT", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_ELEMENT_TYPE", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", this.getRepoStringLength(), 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_ELEMENT", false);
        if (!Utils.isEmpty((CharSequence)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        table = new RowMeta();
        tablename = "R_ELEMENT_ATTRIBUTE";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_ELEMENT_ATTRIBUTE", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_ELEMENT", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_ELEMENT_ATTRIBUTE_PARENT", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaString("ATTR_KEY", 255, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaString("ATTR_VALUE", 2000000, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_ELEMENT_ATTRIBUTE", false);
        if (!Utils.isEmpty((CharSequence)sql)) {
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        users = new Hashtable<String, LongObjectId>();
        ok_user = true;
        table = new RowMeta();
        tablename = "R_USER";
        schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, tablename);
        if (monitor != null) {
            monitor.subTask("Checking table " + schemaTable);
        }
        table.addValueMeta((ValueMetaInterface)new ValueMetaInteger("ID_USER", KEY, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaString("LOGIN", 255, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaString("PASSWORD", 255, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaString("NAME", 255, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaString("DESCRIPTION", 255, 0));
        table.addValueMeta((ValueMetaInterface)new ValueMetaBoolean("ENABLED", 1, 0));
        sql = this.database.getDDL(schemaTable, (RowMetaInterface)table, null, false, "ID_USER", false);
        create = false;
        if (!Utils.isEmpty((CharSequence)sql)) {
            create = sql.toUpperCase().indexOf("CREATE TABLE") >= 0;
            statements.add(sql);
            if (!dryrun) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("executing SQL statements: " + Const.CR + sql);
                }
                this.database.execStatements(sql);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Created or altered table " + schemaTable);
                }
            }
        } else if (this.log.isDetailed()) {
            this.log.logDetailed("Table " + schemaTable + " is OK.");
        }
        if (ok_user) {
            user = new String[]{"admin", "guest"};
            pass = new String[]{"admin", "guest"};
            code = new String[]{"Administrator", "Guest account"};
            desc = new String[]{"User manager", "Read-only guest account"};
            if (!dryrun) {
                this.database.prepareInsert((RowMetaInterface)table, null, tablename);
            }
            for (i = 0; i < user.length; ++i) {
                lookup = null;
                if (upgrade) {
                    lookup = this.database.getOneRow("SELECT " + this.repository.quote("ID_USER") + " FROM " + schemaTable + " WHERE " + this.repository.quote("LOGIN") + " = '" + user[i] + "'");
                }
                if (lookup != null) continue;
                nextid = new LongObjectId((long)(i + 1));
                if (!create) {
                    nextid = this.repository.connectionDelegate.getNextUserID();
                }
                password = Encr.encryptPassword((String)pass[i]);
                tableData = new RowMetaAndData();
                tableData.addValue((ValueMetaInterface)new ValueMetaInteger("ID_USER"), (Object)nextid);
                tableData.addValue((ValueMetaInterface)new ValueMetaString("LOGIN"), (Object)user[i]);
                tableData.addValue((ValueMetaInterface)new ValueMetaString("PASSWORD"), (Object)password);
                tableData.addValue((ValueMetaInterface)new ValueMetaString("NAME"), (Object)code[i]);
                tableData.addValue((ValueMetaInterface)new ValueMetaString("DESCRIPTION"), (Object)desc[i]);
                tableData.addValue((ValueMetaInterface)new ValueMetaBoolean("ENABLED"), (Object)Boolean.TRUE);
                if (dryrun) {
                    sql = this.database.getSQLOutput(null, tablename, tableData.getRowMeta(), tableData.getData(), null);
                    statements.add(sql);
                } else {
                    this.database.setValuesInsert(tableData);
                    this.database.insertRow();
                }
                users.put(user[i], nextid);
            }
            try {
                if (!dryrun) {
                    this.database.closeInsert();
                }
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Populated table " + schemaTable);
                }
            }
            catch (KettleException dbe) {
                throw new KettleException("Unable to close insert after populating table " + schemaTable, (Throwable)dbe);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        this.log.logBasic((upgrade != false ? "Upgraded" : "Created") + " " + KettleDatabaseRepository.repositoryTableNames.length + " repository tables.");
    }

    protected int getRepoStringLength() {
        return this.database.getDatabaseMeta().getDatabaseInterface().getMaxVARCHARLength() - 1 > 0 ? this.database.getDatabaseMeta().getDatabaseInterface().getMaxVARCHARLength() - 1 : 2000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> updateStepTypes(List<String> statements, boolean dryrun, boolean create) throws KettleException {
        KettleDatabaseRepository kettleDatabaseRepository = this.repository;
        synchronized (kettleDatabaseRepository) {
            List plugins = this.pluginRegistry.getPlugins(StepPluginType.class);
            ObjectId[] ids = this.loadPluginsIds(plugins, create);
            int idsLength = ids.length;
            for (int i = 0; i < idsLength; ++i) {
                Object id = ids[i];
                if (id != null) continue;
                id = !create ? this.repository.connectionDelegate.getNextStepTypeID() : new LongObjectId((long)(i + 1));
                PluginInterface sp = (PluginInterface)plugins.get(i);
                RowMetaAndData table = new RowMetaAndData();
                table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_STEP_TYPE"), id);
                table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)sp.getIds()[0]);
                table.addValue((ValueMetaInterface)new ValueMetaString("DESCRIPTION"), (Object)sp.getName());
                table.addValue((ValueMetaInterface)new ValueMetaString("HELPTEXT"), (Object)sp.getDescription());
                if (dryrun) {
                    String sql = this.database.getSQLOutput(null, "R_STEP_TYPE", table.getRowMeta(), table.getData(), null);
                    statements.add(sql);
                    continue;
                }
                this.database.prepareInsert(table.getRowMeta(), null, "R_STEP_TYPE");
                this.database.setValuesInsert(table);
                this.database.insertRow();
                this.database.closeInsert();
            }
        }
        return statements;
    }

    private ObjectId[] loadPluginsIds(List<PluginInterface> plugins, boolean create) throws KettleException {
        ObjectId[] ids = new ObjectId[plugins.size()];
        if (create) {
            return ids;
        }
        Map<String, LongObjectId> stepTypeCodeToIdMap = this.repository.stepDelegate.getStepTypeCodeToIdMap();
        int index = 0;
        for (PluginInterface sp : plugins) {
            ids[index++] = (ObjectId)stepTypeCodeToIdMap.get(sp.getIds()[0]);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> updateDatabaseTypes(List<String> statements, boolean dryrun, boolean create) throws KettleException {
        KettleDatabaseRepository kettleDatabaseRepository = this.repository;
        synchronized (kettleDatabaseRepository) {
            List plugins = this.pluginRegistry.getPlugins(DatabasePluginType.class);
            for (int i = 0; i < plugins.size(); ++i) {
                PluginInterface plugin = (PluginInterface)plugins.get(i);
                ObjectId id = null;
                if (!create) {
                    id = this.repository.databaseDelegate.getDatabaseTypeID(plugin.getIds()[0]);
                }
                if (id != null) continue;
                id = new LongObjectId((long)(i + 1));
                if (!create) {
                    id = this.repository.connectionDelegate.getNextDatabaseTypeID();
                }
                RowMetaAndData table = new RowMetaAndData();
                table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_DATABASE_TYPE"), (Object)id);
                table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)plugin.getIds()[0]);
                table.addValue((ValueMetaInterface)new ValueMetaString("DESCRIPTION"), (Object)plugin.getName());
                if (dryrun) {
                    String sql = this.database.getSQLOutput(null, "R_DATABASE_TYPE", table.getRowMeta(), table.getData(), null);
                    statements.add(sql);
                    continue;
                }
                this.database.prepareInsert(table.getRowMeta(), null, "R_DATABASE_TYPE");
                this.database.setValuesInsert(table);
                this.database.insertRow();
                this.database.closeInsert();
            }
        }
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobEntryTypes(List<String> statements, boolean dryrun, boolean create) throws KettleException {
        KettleDatabaseRepository kettleDatabaseRepository = this.repository;
        synchronized (kettleDatabaseRepository) {
            PluginRegistry registry = PluginRegistry.getInstance();
            List jobPlugins = registry.getPlugins(JobEntryPluginType.class);
            for (int i = 0; i < jobPlugins.size(); ++i) {
                PluginInterface jobPlugin = (PluginInterface)jobPlugins.get(i);
                String type_desc = jobPlugin.getIds()[0];
                String type_desc_long = jobPlugin.getName();
                ObjectId id = null;
                if (!create) {
                    id = this.repository.jobEntryDelegate.getJobEntryTypeID(type_desc);
                }
                if (id != null) continue;
                id = new LongObjectId((long)(i + 1));
                if (!create) {
                    id = this.repository.connectionDelegate.getNextJobEntryTypeID();
                }
                RowMetaAndData table = new RowMetaAndData();
                table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY_TYPE"), (Object)id);
                table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)type_desc);
                table.addValue((ValueMetaInterface)new ValueMetaString("DESCRIPTION"), (Object)type_desc_long);
                if (dryrun) {
                    String sql = this.database.getSQLOutput(null, "R_JOBENTRY_TYPE", table.getRowMeta(), table.getData(), null);
                    statements.add(sql);
                    continue;
                }
                this.database.prepareInsert(table.getRowMeta(), null, "R_JOBENTRY_TYPE");
                this.database.setValuesInsert(table);
                this.database.insertRow();
                this.database.closeInsert();
            }
        }
    }
}

